C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine MctApply ( tri, work, map_trace, nsamp, samps )

#include <f77/lhdrsz.h>

      integer nsamp, iz(8*SZLNHD), icinit
      real tri(SZLNHD), work(2*SZLNHD), map_trace(2*SZLNHD)
      real samps(2*SZLNHD), zz(8*SZLNHD)

c initialize data

      icinit = 1

c using cubic spline interpolation fill work() with the
c interpolated amplitudes from tri() as requested by
c the indices in map_trace().

      call fcuint ( samps, tri, nsamp, map_trace, work, nsamp, iz, zz, 
     :     icinit )

c react to map_trace times going off the end of the record which could happen since
c in this application [unlike in psdm] there is a static shift after the event
c time instead of a stretch

      do i = 1, nsamp
         if ( map_trace(i) .gt. float(nsamp) ) work(i) = 0.0
      enddo

      return
      end
