C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform, ptap,
     :     ntap, otap, protap1, protap2, fmax, IKP )
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*120   input file name
c     otap  - C*120   output file name
c-----
#include <f77/iounit.h>
      integer * 4 nsamp, nsi, ntrc, nrec
      real fmax
      character ntap*(*), otap*(*), ptap*(*)
      character protap1*(*), protap2*(*)
      logical IKP
 
            write(LERR,*)' '
            if (.not. IKP)
     1           write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            if (.not. IKP)
     1           write(LERR,*) ' output dataset name=  ', otap
            write(LERR,*)' '
            if( ptap .ne. ' ' ) then
               le1 = lenth(ptap)
               write(LERR,*) ' Time Shift from ', ptap(1:le1)
            endif
            if( protap1 .ne. ' ' ) then
               le1 = lenth(protap1)
               write(LERR,*) ' ProMAX fast shear pick from ', 
     :              protap1(1:le1)
               le1 = lenth(protap2)
               write(LERR,*) ' ProMAX slow shear pick from ', 
     :              protap2(1:le1)
            endif
            if(fmax.gt.0.) 
     :           write(LERR,*) ' Maximum Frequency of interest = '
     :           ,fmax,' hz'

            
      return
      end
