C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine help()

#include <f77/iounit.h>

      write(LERR,15)
      write(LER,15)
 15   format(
     1'**************************************************************'//
     2' sps_aps - augments sps aquisition geometry files by adding'/
     3'           concisely specified orientation info to each record,'/
     4'           & generates corresponding plotfiles for input into '/
     5'           program aqplot.')

      write(LERR,25)
      write(LER,25)
 25   format(/
     1'Execute by typing sps_aps, followed by the program parameters.' /
     2'Note that each parameter is preceded by -x where "x" is'/
     3'the character(s) corresponding to the parameter.'/
     4'Users can enter the following parameters or let them default.')

      write(LERR,35)
      write(LER,35)
 35   format(/
     1' -S     [deflt: none]      input sps source file '/
     2' -R     [deflt: none]      input sps rcvr file '/
     2' -X     [deflt: none]      input sps relation file '/
     4' -A     [deflt: 90.]       azimuth of +x AXIS (sps coords)'/
     5'        (all azimuths in + degs E of N)'/
     6' -s1    [deflt:0.]         absolute azimuth of source 1-axis'/
     7' -s2    [deflt:0.]         absolute azimuth of source 2-axis'/
     8' -r1    [deflt:0.]         absolute azimuth of rcvr 1-axis'/
     9' -r2    [deflt:0.]         absolute azimuth of rcvr 2-axis')

      write(LERR,45)
      write(LER,45)
 45   format(/
     1' -SIp   include if ALL sources are polarized in-line +'/
     2'        (The in-line + direction has INcreasing indices.)'/
     3' -SIn   include if ALL sources are polarized in-line -'/
     4' -SIa   [deflt:0]         source-lines alternate:'/
     5'                          1 => odd lines polarized in-line +'/
     6'                          0 => disabled'/
     7'                         -1 => odd lines polarized in-line -')

      write(LERR,55)
      write(LER,55)
 55   format(
     1' -SXp   include if ALL sources are polarized x-line +'/
     2'        (The x-line + direction has a LARGER azimuth (without'/
     3'         unwrapping) than the in-line + direction.)'/
     4' -SXn   include if ALL sources are polarized x-line -'/
     5' -SXa   [deflt:0]         source-lines alternate:'/
     6'                          1 => odd lines polarized x-line +'/
     7'                          0 => disabled'/
     8'                         -1 => odd lines polarized x-line -')

      write(LERR,65)
      write(LER,65)
 65   format(/
     1' -RIp   include if ALL receivers are polarized in-line +'/
     2'        (The in-line + direction has INcreasing indices.)'/
     3' -RIn   include if ALL receivers are polarized in-line -'/
     4' -RIa   [deflt:0]         receiver-lines alternate:'/
     5'                          1 => odd lines polarized in-line +'/
     6'                          0 => disabled'/
     7'                         -1 => odd lines polarized in-line -')

      write(LERR,75)
      write(LER,75)
 75   format(

     1' -RXp   include if ALL receivers are polarized x-line +'/
     2'        (The x-line + direction has a LARGER azimuth (without'/
     3'         unwrapping) than the in-line + direction.)'/
     4' -RXn   include if ALL receivers are polarized x-line -'/
     5' -RXa   [deflt:0]         receiver-lines alternate:'/
     6'                          1 => odd lines polarized x-line +'/
     7'                          0 => disabled'/
     8'                         -1 => odd lines polarized x-line -')

      write(LERR,85)
      write(LER,85)
 85   format(/
     1' The mnemonics above may be entered in any combination'/
     2' (allowing multiple polarizations at each point).  If ALL'/
     3' polarization mnemonics are omitted, the point is assumed to be'/
     4' polarized vertical (down).')

      write(LERR,87)
      write(LER,87)
 87   format(/
     1' The relation (-X) file uses:'/
     2' -MCL             the order of the source/receiver pairs,'/
     3'                  eg 11,21,12,22 separated only by commas'/
     4' -1ns             the recording channel start-number for comp 1'/
     5' -1ne             the recording channel end-number for comp 1'/
     6' -2ns             the recording channel start-number for comp 2'/
     7' -2ne             the recording channel end-number for comp 2'/
     8' -3ns             the recording channel start-number for comp 3'/
     9' -3ne             the recording channel end-number for comp 3')

      write(LERR,95)
      write(LER,95)
 95   format(/
     1' -V        include on the command line for verbose printout'/
     2' -? or -h  include on the command line for program help'//
     3' Usage: '/
     4' sps_aps [ -S[] -R[] -X[] -A[] -MCL[] -V -h'/
     5'          -s1[] -s2[] -SIp -SIn -SIa[] -SXp -SXn -SXa[]'/
     6'          -r1[] -r2[] -RIp -RIn -RIa[] -RXp -RXn -RXa[]'/
     7'          -ns1[] -ne1[] -ns2[] -ne2[] -ns3[] -ne3[] ]')

      write(LERR,105)
      write(LER,105)
 105  format(/
     1' sps_aps writes: output file(s) corresponding to the input sps'/
     2'                 file(s), with ".aps" appended to the filename;'/
     3'                 these have, appended to each sps record,'/
     4'                 three fields of polarization information:'/
     5'                 cols 81-82 (component index: 1, 2, or 3);'/
     &'                 cols 83-90 (polarization azimuth or "Z");'/
     6'                 cols 91-100 (array azimuth (assumed in-line));'/
     7' and two plotfiles (one for S & one for R) which serve as'/
     8' input to module aqplot, which plots this information for your'/
     9' visual confirmation and quality control.'//
     &' This help is now written in a file in your directory, named'/
     &' SPS_APS.prcid.'//
     &' **************************************************************')

      return
      end
