C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----------------------Routine TOOLORT--------------------------
c
c This program use linear regression algorithm to calculate the
c downhole tool orientation and rotate the data according.
c It takes 3 files (one source), or 6 files (two sources) as input, 
c with Amoco Source-Receiver filename extension convention.
c It has 3 or 6 output files containing rotated data.
c It is meant to orientate three component data in the
c x,y plane.  If multiple sources are present, common receiver locations
c are rotated by the same angle.  The polarity is estimated form the 
c z component if possible.
c The program also has some enhanced features over the wrot program.
c It can generate window length versus rotation angle relationship,
c and xgraph files of hodograms and rotation direction.
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

c
c     declare variables
c

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c -----
c basic usp variables
c -----

      integer     lhed1(SZLNHD),lhed2(SZLNHD),lhed3(SZLNHD)
      integer     lhed4(SZLNHD),lhed5(SZLNHD),lhed6(SZLNHD)
      integer     nsamp,nsampo,nsi,ntrc,nrec,nreco,iform
      integer     luin1,luin2,luin3,luout1,luout2,luout3
      integer     luin4,luin5,luin6,luout4,luout5,luout6
      integer	  lbytes,nbytes,obytes
      integer     argis,irs,ire,JJ,KK

      character   name*7,ntap*500,otap*500

      logical     verbos

c
c ----- dimension program specific variables -----
c

      integer     lupick,le1,NumPicks
      integer     luang,luxgraph(1000)
      integer     l_RecNum,l_StaCor,l_NumSmp,l_NumRec
      integer     DeadTraces1(SZLNHD), DeadTraces2(SZLNHD)
      integer     DeadTraces3(SZLNHD)
      integer     DeadTraces4(SZLNHD), DeadTraces5(SZLNHD)
      integer     DeadTraces6(SZLNHD)
      integer     ii, isrc, isrc2, angopt
      integer     ixs,ixe,ixd
      integer	  pipei(6),pipeo(6)
      integer     leNtap, leOtap, leNtap2, leOtap2, leTtap,leNttap

      real        AngleToAdd,AngleConstant
      real        x,y,z,Record,StartTime,EndTime,PickOverride
      real        x2,y2,z2
      real        xorig,yorig,xtmp,ytmp
      real        xorig2,yorig2,xtmp2,ytmp2

      character   ptap*500, ttap*500, nttap*500
      character   n1tap*500, n2tap*500, n3tap*500
      character   n4tap*500, n5tap*500, n6tap*500
      character   o1tap*500, o2tap*500, o3tap*500
      character   o4tap*500, o5tap*500, o6tap*500

      logical     pick, flat, IKP
      logical     analy

c
c ----- dynamic memory variables -----
c

      integer   errcd1,errcd2,errcd3,errcd4,errcd5,errcd6,errcd7,errcd8
      integer   errcd9,errcda,errcdb,errcdc,errcdd,errcde,errcdf,errcdg
      integer   errcdh,errcdi,errcdj,errcdk,errcdl,errcdm,errcdn
      integer   abort
      integer   TraceHeaders1, TraceHeaders2, TraceHeaders3
      integer   TraceHeaders4, TraceHeaders5, TraceHeaders6

      pointer     (memadr_x, x(2000000))
      pointer     (memadr_y, y(2000000))
      pointer     (memadr_xorig, xorig(2000000))
      pointer     (memadr_yorig, yorig(2000000))
      pointer     (memadr_xtmp, xtmp(2000000))
      pointer     (memadr_ytmp, ytmp(2000000))
      pointer     (memadr_z, z(2000000))
      pointer     (memadr_x2, x2(2000000))
      pointer     (memadr_y2, y2(2000000))
      pointer     (memadr_xorig2, xorig2(2000000))
      pointer     (memadr_yorig2, yorig2(2000000))
      pointer     (memadr_xtmp2, xtmp2(2000000))
      pointer     (memadr_ytmp2, ytmp2(2000000))
      pointer     (memadr_z2, z2(2000000))
      pointer     (memadr_r, Record(2000000))
      pointer     (memadr_s, StartTime(2000000))
      pointer     (memadr_e, EndTime(2000000))
      pointer     (memadr_h1, TraceHeaders1(200000))
      pointer     (memadr_h2, TraceHeaders2(200000))
      pointer     (memadr_h3, TraceHeaders3(200000))
      pointer     (memadr_h4, TraceHeaders4(200000))
      pointer     (memadr_h5, TraceHeaders5(200000))
      pointer     (memadr_h6, TraceHeaders6(200000))

c ----- integer program variables -----
c
c     lupick     : logical unit for pickfile/flatfile
c     le1        : length of pickfile/flatfile name
c     errcd1-n   : used with galloc
c     abort      : used with galloc
c     TraceHeaders1-6 : array to hold trace headers
c     luang	 : output unit for window length-angle analysis
c     luxgraph	 : output unit for hodogram and rotation coordinate
c     isrc	 : type of the first source
c     isrc2	 : type of the second optional source
c     ixs	 : start record for hodogram xgraph output
c     ixe	 : end record for hodogram xgraph output
c     ixd	 : record increment for hodogram xgraph output
c     le*tap	 : length of input/output file names
c     angopt       : 0(default) for 0-360 angle display
c                  : other for -180-180 angle display
c
c ----- real program variables -----
c
c     x(),y(),z()     : component traces
c     x2(),y2(),z2()  : same for the 2nd source
c     xorig, xtmp     : pass to subroutine to store temporary data
c     yorig, ytmp     : pass to subroutine to store temporary data
c     Record()        : record number from pickfile/flatfile
c     StartTime()     : start times from pickfile/flatfile
c     EndTime()       : end times from pickfile/flatfile
c
c ----- pointer program variables -----
c
c     memadr_     : points to location of 1st element of array
c
c ----- logical program variables -----
c
c     pick         : flag to indicate pick file input
c     flat         : flag to indicate flat file input
c     analy	   : flag to indicate window length-angle analysis
c
c ----- initialize necessary variables -----
c

      data name/'TOOLORT'/,abort/0/,luin1/1/,luin2/1/,luin3/1/
      data pipei /0, 3, 5, 7, 9, 11/
      data pipeo /1, 4, 6, 8, 10, 12/

c ----the following line should be commented out if IKP here works
      data IKP / .false. /

      verbos = .false.
      analy = .false.
      pick = .false.
      flat = .false.

c
c ----- get online help if necessary -----
c

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help ()
         stop
      endif

c debug ----- ieee exception handler to find those mysterious bugs
c       
c       ieeer = ieee_handler ('set','overflow',killit)
c -----

c
c ----- open printout files -----
c

#include <f77/open.h>

c
c ----- get command line parameters -----
c

      call cmdln(ntap,ttap,otap,ptap,le1,irs,ire,isrc,isrc2,
     :    pick,flat,PickOverride,AngleToAdd,AngleConstant,
     :    angopt,ixs,ixe,ixd,verbos,analy, IKP)

c
c ----- get logical units for input,output files-----
c

c watch for ikp execution

      IF (IKP) then
        luin1 = 0
        call sisfdfit(luin2,pipei(2))
        call sisfdfit(luin3,pipei(3))

        luout1 = 1
        call sisfdfit(luout2,pipeo(2))
        call sisfdfit(luout3,pipeo(3))

        if (isrc2.ne.0)then
          call sisfdfit(luin4,pipei(4))
          call sisfdfit(luin5,pipei(5))
          call sisfdfit(luin6,pipei(6))
          call sisfdfit(luout4,pipeo(4))
          call sisfdfit(luout5,pipeo(5))
          call sisfdfit(luout6,pipeo(6))
        endif

      ELSE
        leNtap = lenth (ntap)
        leNtap2 = leNtap + 3
        leOtap = lenth (otap)
        leOtap2 = leOtap + 3
        leTtap = lenth (ttap)
        if (isrc .eq. 1) then
          n1tap = ntap(1:leNtap)//'.11'
          n2tap = ntap(1:leNtap)//'.12'
          n3tap = ntap(1:leNtap)//'.13'
          o1tap = otap(1:leOtap)//'.11'
          o2tap = otap(1:leOtap)//'.12'
          o3tap = otap(1:leOtap)//'.13'
        elseif (isrc .eq. 2) then
          n1tap = ntap(1:leNtap)//'.21'
          n2tap = ntap(1:leNtap)//'.22'
          n3tap = ntap(1:leNtap)//'.23'
          o1tap = otap(1:leOtap)//'.21'
          o2tap = otap(1:leOtap)//'.22'
          o3tap = otap(1:leOtap)//'.23'
        elseif (isrc .eq. 3) then
          n1tap = ntap(1:leNtap)//'.31'
          n2tap = ntap(1:leNtap)//'.32'
          n3tap = ntap(1:leNtap)//'.33'
          o1tap = otap(1:leOtap)//'.31'
          o2tap = otap(1:leOtap)//'.32'
          o3tap = otap(1:leOtap)//'.33'
        else
          write(LOT,*) 'TOOLORT invalid source type'
          write(LOT,*) 'FATAL'
          stop
        endif
       
        if (isrc2 .ne. 0) then
          if (isrc2.eq.isrc) then
            write(LOT,*) 'TOOLORT duplicated sources'
            write(LOT,*) 'FATAL'
            stop
          elseif (isrc2 .eq. 1) then
            n4tap = ntap(1:leNtap)//'.11'
            n5tap = ntap(1:leNtap)//'.12'
            n6tap = ntap(1:leNtap)//'.13'
            o4tap = otap(1:leOtap)//'.11'
            o5tap = otap(1:leOtap)//'.12'
            o6tap = otap(1:leOtap)//'.13'
          elseif (isrc2 .eq. 2) then
            n4tap = ntap(1:leNtap)//'.21'
            n5tap = ntap(1:leNtap)//'.22'
            n6tap = ntap(1:leNtap)//'.23'
            o4tap = otap(1:leOtap)//'.21'
            o5tap = otap(1:leOtap)//'.22'
            o6tap = otap(1:leOtap)//'.23'
          elseif (isrc2 .eq. 3) then
            n4tap = ntap(1:leNtap)//'.31'
            n5tap = ntap(1:leNtap)//'.32'
            n6tap = ntap(1:leNtap)//'.33'
            o4tap = otap(1:leOtap)//'.31'
            o5tap = otap(1:leOtap)//'.32'
            o6tap = otap(1:leOtap)//'.33'
          else
            write(LOT,*) 'TOOLORT invalid source type'
            write(LOT,*) 'FATAL'
            stop
          endif
        endif

c
c ---- tail (suffix) of the input file names ----
c

        if ( ttap .ne. ' ' ) then
          n1tap = n1tap(1:leNtap2)//ttap(1:leTtap)
          n2tap = n2tap(1:leNtap2)//ttap(1:leTtap)
          n3tap = n3tap(1:leNtap2)//ttap(1:leTtap)
          if (isrc2.ne.0) then
            n4tap = n4tap(1:leNtap2)//ttap(1:leTtap)
            n5tap = n5tap(1:leNtap2)//ttap(1:leTtap)
            n6tap = n6tap(1:leNtap2)//ttap(1:leTtap)
          endif
        endif


c open all datasets
        call getln(luin1,n1tap,'r',0)
        call getln(luin2,n2tap,'r',0)
        call getln(luin3,n3tap,'r',0)
        write(LERR,*)'Input unit # is ',luin1,' for DSN= ',n1tap
        write(LERR,*)'Input unit # is ',luin2,' for DSN= ',n2tap
        write(LERR,*)'Input unit # is ',luin3,' for DSN= ',n3tap

        if (isrc2 .ne. 0) then
          call getln(luin4,n4tap,'r',0)
          call getln(luin5,n5tap,'r',0)
          call getln(luin6,n6tap,'r',0)
          write(LERR,*)'Input unit # is ',luin4,' for DSN= ',n4tap
          write(LERR,*)'Input unit # is ',luin5,' for DSN= ',n5tap
          write(LERR,*)'Input unit # is ',luin6,' for DSN= ',n6tap
        endif

        call getln(luout1,o1tap,'w',1)
        call getln(luout2,o2tap,'w',1)
        call getln(luout3,o3tap,'w',1)
        write(LERR,*)'Output unit # is ',luout1,' for DSN= ',o1tap
        write(LERR,*)'Output unit # is ',luout2,' for DSN= ',o2tap
        write(LERR,*)'Output unit # is ',luout3,' for DSN= ',o3tap

        if (isrc2 .ne. 0) then
          call getln(luout4,o4tap,'w',1)
          call getln(luout5,o5tap,'w',1)
          call getln(luout6,o6tap,'w',1)
          write(LERR,*)'Output unit # is ',luout4,' for DSN= ',o4tap
          write(LERR,*)'Output unit # is ',luout5,' for DSN= ',o5tap
          write(LERR,*)'Output unit # is ',luout6,' for DSN= ',o6tap
        endif

      ENDIF

c
c ---- get logic units for pick/flat files ----
c

      if(pick)then
         call alloclun(lupick)
         open(unit=lupick,file=ptap(1:le1),status='unknown',iostat=ierr)
         write(LERR,*)'Pickfile unit # is ',lupick,' for ',ptap

         if(ierr.ne.0)then

            write(LERR,*)'FATAL: Error opening pick file ',ptap
            write(LERR,*)'       Check existance.'
            write(LERR,*)' '
            stop
            
         endif
      endif

      if(flat)then
         call alloclun(lupick)
         open(unit=lupick,file=ptap(1:le1),status='unknown',iostat=ierr)
         write(LERR,*)'Flatfile unit # is ',lupick,' for ',ptap

         if(ierr .ne. 0) then

            write(LERR,*)'FATAL: Error opening flat file ',ptap(1:le1)
            write(LERR,*)'       Check existance.'
            write(LERR,*)' '
            stop
            
         endif
      endif

c
c ----- read line header, check to see if input empty -----
c

      lbytes = 0
      call rtape(luin1,lhed1,lbytes)
      write(LERR,*)'lbytes= ',lbytes

      if(lbytes .eq. 0) then
         write(LERR,*)'TOOLORT: no header read on unit ',n1tap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

c
c ----- save certain parameters -----
c

      call saver(lhed1, 'NumSmp', nsamp , LINHED)
      call saver(lhed1, 'SmpInt', nsi   , LINHED)
      call saver(lhed1, 'NumTrc', ntrc  , LINHED)
      call saver(lhed1, 'NumRec', nrec  , LINHED)
      call saver(lhed1, 'Format', iform , LINHED)


      call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('NumSmp',ifmt,l_NumSmp,length,LINEHEADER)
      call savelu('NumRec',ifmt,l_NumRec,length,LINEHEADER)

c
c ----- set record start and end defaults -----
c

      if(irs .eq. 0) irs=1
      if(ire .eq. 0) ire=nrec

c
c ----- determine number of records to process -----
c

      nreco=ire-irs+1

c
c ---- set xgraph record start and end defaults ----
c

      if(ixs .eq. 0) ixs=irs
      if(ixe .eq. 0) ixe=ire
      if(ixd .eq. 0) ixd=1

c
c ---- create xgraph and analysis file names based on input file names ----
c

      leNtap = lenth (ntap)
      leTtap = lenth (ttap)

      nttap = ntap(1:leNtap)
      leNttap = leNtap
      if ( ttap .ne. ' ' ) then
        nttap = nttap(1:leNtap)//ttap(1:leTtap)
        leNttap = leNtap + leTtap
      endif

      nttap = nttap(1:leNttap)//'.s'
      write(nttap(leNttap+3:leNttap+3),'(i1)')isrc
      leNttap = leNttap + 3

      if (isrc2.ne.0)then
        nttap = nttap(1:leNttap)//'+'
        write(nttap(leNttap+2:leNttap+2),'(i1)')isrc2
        leNttap = leNttap + 2
      endif

c
c ---- file name of the window length analysis output ----
c

      if(analy) then
        call alloclun(luang)
        open(unit=luang,file=nttap(1:leNttap)//'.ang',
     :       status='unknown',err=991)
        write(luang,*)'"Record	window-length  rot-angle  angle-stddev'
      endif

c
c ---- file names of the xgraph (hodogram and rotation coord) output ----
c

      nttap = nttap(1:leNttap)//'.xgr'
      leNttap = leNttap + 4
          
      do ii=irs,ire
        if (ii.ge.ixs .and. ii.le.ixe 
     :      .and. mod(ii-ixs,ixd).eq.0) then

          if (ii .lt. 10) then
            write(nttap(leNttap+1:leNttap+1),'(i1)')ii
          elseif (ii .lt. 100) then
            write(nttap(leNttap+1:leNttap+2),'(i2)')ii
          elseif (ii .lt. 1000) then
            write(nttap(leNttap+1:leNttap+3),'(i3)')ii
          else
            write(LERR,*)'FATAL'
            write(LERR,*)'cannot handle the xgraph file names'
            stop
          endif

          call alloclun(luxgraph(ii))
          open(unit=luxgraph(ii),file=nttap,
     :         status='unknown',err=991)
        endif
      enddo


c
c ---- determine number of output samples ----
c

      nsampo=nsamp

c
c ----- modify output lineheader -----
c

      call savew2(lhed1,ifmt,l_NumSmp,length,nsampo,LINEHEADER)
      call savew2(lhed1,ifmt,l_NumRec,length,nreco,LINEHEADER)

c
c ----- change output bytes to reflect change -----
c       from time to # traces
c

      obytes = SZTRHD + SZSMPD * nsampo

c
c ----- adjust historical line header & write header -----
c

      call savhlh(lhed1,lbytes,lbyout)

      call wrtape(luout1,lhed1,lbyout)
      call wrtape(luout2,lhed1,lbyout)
      call wrtape(luout3,lhed1,lbyout)
      if (isrc2.ne.0) then
        call wrtape(luout4,lhed1,lbyout)
        call wrtape(luout5,lhed1,lbyout)
        call wrtape(luout6,lhed1,lbyout)
      endif

c ===============================================================
c open the remaining datasets to give a total of 3/6 opened datasets
c ===============================================================

      call rtape(luin2,lhed2,lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'TOOLORT: no header read on unit ',n2tap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

      call rtape(luin3,lhed3,lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'TOOLORT: no header read on unit ',n3tap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

      if (isrc2 .ne. 0) then
        call rtape(luin4,lhed4,lbytes)
        if(lbytes .eq. 0) then
           write(LERR,*)'TOOLORT: no header read on unit ',n4tap
           write(LERR,*)'FATAL'
           write(LERR,*)'Check existence of file & rerun'
           stop
        endif
  
        call rtape(luin5,lhed5,lbytes)
        if(lbytes .eq. 0) then
           write(LERR,*)'TOOLORT: no header read on unit ',n5tap
           write(LERR,*)'FATAL'
           write(LERR,*)'Check existence of file & rerun'
           stop
        endif
  
        call rtape(luin6,lhed6,lbytes)
        if(lbytes .eq. 0) then
           write(LERR,*)'TOOLORT: no header read on unit ',n6tap
           write(LERR,*)'FATAL'
           write(LERR,*)'Check existence of file & rerun'
           stop
        endif
      endif

c
c ----- printout -----
c

      call verbal(nsamp,nsampo,nsi,ntrc,nrec,nreco,iform,
     :     irs,ire,isrc,isrc2,PickOverride,AngleToAdd,
     :     AngleConstant)

c
c ----- malloc only space we're going to use -----
c

      itemRecord = ntrc * nsamp * SZSMPD
      itemTrace = nsamp 
      itemHeader =  ntrc * ITRWRD * SZSMPD

      call galloc(memadr_x,itemTrace* SZSMPD,errcd1,abort)
      call galloc(memadr_y,itemTrace* SZSMPD,errcd2,abort)
      call galloc(memadr_xorig,itemTrace* SZSMPD,errcd3,abort)
      call galloc(memadr_yorig,itemTrace* SZSMPD,errcd4,abort)
      call galloc(memadr_xtmp,itemTrace* SZSMPD,errcd5,abort)
      call galloc(memadr_ytmp,itemTrace* SZSMPD,errcd6,abort)
      call galloc(memadr_z,itemTrace* SZSMPD,errcd7,abort)
      call galloc(memadr_h1,itemHeader,errcd8,abort)
      call galloc(memadr_h2,itemHeader,errcd9,abort)
      call galloc(memadr_h3,itemHeader,errcda,abort)

      if (isrc2.ne.0) then
        call galloc(memadr_x2,itemTrace* SZSMPD,errcdb,abort)
        call galloc(memadr_y2,itemTrace* SZSMPD,errcdc,abort)
        call galloc(memadr_xorig2,itemTrace* SZSMPD,errcdd,abort)
        call galloc(memadr_yorig2,itemTrace* SZSMPD,errcde,abort)
        call galloc(memadr_xtmp2,itemTrace* SZSMPD,errcdf,abort)
        call galloc(memadr_ytmp2,itemTrace* SZSMPD,errcdg,abort)
        call galloc(memadr_z2,itemTrace* SZSMPD,errcdh,abort)
        call galloc(memadr_h4,itemHeader,errcdi,abort)
        call galloc(memadr_h5,itemHeader,errcdj,abort)
        call galloc(memadr_h6,itemHeader,errcdk,abort)
      endif

      if (errcd1 .ne. 0 .or. errcd2 .ne. 0 .or. errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 .or. errcd5 .ne. 0 .or. errcd6 .ne. 0 .or. 
     :     errcd7 .ne. 0 .or. errcd8 .ne. 0 .or. errcd9 .ne. 0 .or.
     :     errcda .ne. 0)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemRecord+3*itemTrace* SZSMPD+itemHeader,
     :        '  bytes'
         write(LERR,*)' '
         go to 999
      elseif (isrc2.ne.0)then
        if (errcdb .ne. 0 .or. errcdc .ne. 0 .or. errcdd .ne. 0 .or.
     :     errcde .ne. 0 .or. errcdf .ne. 0 .or. errcdg .ne. 0 .or.
     :     errcdh .ne. 0 .or. errcdi .ne. 0 .or. errcdj .ne. 0 .or. 
     :     errcdk .ne. 0)then 
          write(LERR,*)' '
          write(LERR,*)'Unable to allocate workspace:'
          write(LERR,*) itemRecord+3*itemTrace* SZSMPD+itemHeader,
     :         '  bytes'
          write(LERR,*)' '
          go to 999
        else
          write(LERR,*)' '
          write(LERR,*)'Allocating workspace:'
          write(LERR,*) itemRecord+3*itemTrace* SZSMPD+itemHeader,
     :         '  bytes'
          write(LERR,*)' '
        endif
      else
        write(LERR,*)' '
        write(LERR,*)'Allocating workspace:'
        write(LERR,*) itemRecord+3*itemTrace* SZSMPD+itemHeader,
     :       '  bytes'
        write(LERR,*)' '
      endif

c
c ----- counts picks and galloc required space -----
c

      if(pick)call PickCount(lupick,NumPicks)
      if(flat)call FlatCount(lupick,NumPicks)

      itemPicks = NumPicks*SZSAMP+1
      if(nreco.gt.NumPicks)itemPicks = nreco*SZSAMP+1

      call galloc(memadr_r,itemPicks,errcdl,abort)
      call galloc(memadr_s,itemPicks,errcdm,abort)
      call galloc(memadr_e,itemPicks,errcdn,abort)

      if (errcdl .ne. 0 .or. errcdm .ne. 0 .or. errcdn .ne. 0)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemPicks*3,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemPicks*3,'  bytes'
         write(LERR,*)' '
      endif

c
c ----- read and store pick/flat file -----
c

      if(pick)call ReadPicks(lupick,Record,StartTime,EndTime,irs,
     :     ire,PickOverride,NumPicks, verbos)

      if(flat)call ReadFlatFile(lupick,Record,StartTime,EndTime,
     :     irs,ire,PickOverride,verbos)

      if(verbos.and.AngleConstant.lt.1.e-30)then

c
c ----- header for printout file -----
c

         write(LERR,*)' '
         write(LERR,*)'Statistics for linear regression resultant'
         write(LERR,*)'  record   angle  standard_deviation'

      endif


c
c ----- skip to start record -----
c

      call recskp(1,irs-1,luin1,ntrc,lhed1)
      call recskp(1,irs-1,luin2,ntrc,lhed2)
      call recskp(1,irs-1,luin3,ntrc,lhed3)
      if (isrc2.ne.0) then
        call recskp(1,irs-1,luin4,ntrc,lhed4)
        call recskp(1,irs-1,luin5,ntrc,lhed5)
        call recskp(1,irs-1,luin6,ntrc,lhed6)
      endif

      DO JJ = irs, ire

c
c -----  read record & store to array -----
c
         IndexHeader = 1 - ITRWRD
         IndexTrace = 1 - nsampo

         DO KK = 1, ntrc

            nbytes = 0
            call rtape(luin1,lhed1,nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',KK
               go to 999
            endif

            nbytes = 0
            call rtape(luin2,lhed2,nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',KK
               go to 999
            endif

            nbytes = 0
            call rtape(luin3,lhed3,nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',KK
               go to 999
            endif

           if(isrc2.ne.0)then
            nbytes = 0
            call rtape(luin4,lhed4,nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',KK
               go to 999
            endif

            nbytes = 0
            call rtape(luin5,lhed5,nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',KK
               go to 999
            endif

            nbytes = 0
            call rtape(luin6,lhed6,nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',KK
               go to 999
            endif
           endif

c -----
c     reset array indices for this trace
c -----

            IndexHeader = IndexHeader + ITRWRD
            IndexTrace = IndexTrace + nsampo
            
            call saver2(lhed1,ifmt_StaCor,l_StaCor,ln_StaCor,
     :           DeadTraces1(KK),TRACEHEADER)
            call saver2(lhed2,ifmt_StaCor,l_StaCor,ln_StaCor,
     :           DeadTraces2(KK),TRACEHEADER)
            call saver2(lhed3,ifmt_StaCor,l_StaCor,ln_StaCor,
     :           DeadTraces3(KK),TRACEHEADER)

           if (isrc2.ne.0) then
             call saver2(lhed4,ifmt_StaCor,l_StaCor,ln_StaCor,
     :           DeadTraces4(KK),TRACEHEADER)
             call saver2(lhed5,ifmt_StaCor,l_StaCor,ln_StaCor,
     :           DeadTraces5(KK),TRACEHEADER)
             call saver2(lhed6,ifmt_StaCor,l_StaCor,ln_StaCor,
     :           DeadTraces6(KK),TRACEHEADER)
           endif


c -----
c     load headers for safekeeping
c -----

            call vmov (lhed1,1,TraceHeaders1(IndexHeader),1,ITRWRD)
            call vmov (lhed2,1,TraceHeaders2(IndexHeader),1,ITRWRD)
            call vmov (lhed3,1,TraceHeaders3(IndexHeader),1,ITRWRD)
            if(isrc2.ne.0)then
             call vmov (lhed4,1,TraceHeaders4(IndexHeader),1,ITRWRD)
             call vmov (lhed5,1,TraceHeaders5(IndexHeader),1,ITRWRD)
             call vmov (lhed6,1,TraceHeaders6(IndexHeader),1,ITRWRD)
            endif


c -----
c     load time series
c -----

            call vmov(lhed1(ITHWP1),1,x(IndexTrace),1,nsampo)
            call vmov(lhed2(ITHWP1),1,y(IndexTrace),1,nsampo)
            call vmov(lhed3(ITHWP1),1,z(IndexTrace),1,nsampo)
            if(isrc2.ne.0)then
             call vmov(lhed4(ITHWP1),1,x2(IndexTrace),1,nsampo)
             call vmov(lhed5(ITHWP1),1,y2(IndexTrace),1,nsampo)
             call vmov(lhed6(ITHWP1),1,z2(IndexTrace),1,nsampo)
            endif

         ENDDO

c
c ----- now that data is loaded rotate data -----
c       call different subroutine to handle single/double src cases
c

        if(isrc2.eq.0)then
         call rotorls(DeadTraces1,DeadTraces2,DeadTraces3,
     :        ntrc,nsampo,nsi,x,y,z,StartTime,EndTime,JJ,
     :        AngleToAdd,AngleConstant,angopt,isrc,
     :        ixs,ixe,ixd,verbos,analy,luang,
     :        luxgraph(JJ),xorig,yorig,xtmp,ytmp)
        else
         call rotorls2(DeadTraces1,DeadTraces2,DeadTraces3,
     :        DeadTraces4,DeadTraces5,DeadTraces6,
     :        ntrc,nsampo,nsi,x,y,z,x2,y2,z2,StartTime,
     :        EndTime,JJ,AngleToAdd,AngleConstant,angopt,
     :        isrc,isrc2,ixs,ixe,ixd,verbos,analy,luang,
     :        luxgraph(JJ),xorig,yorig,
     :        xorig2,yorig2,xtmp,ytmp,xtmp2,ytmp2)
        endif


c
c ----- output rotated data ----
c

c -----
c     Time for output, Loop over Traces
c -----

         IndexTrace = 1 - nsampo
         IndexHeader = 1 - ITRWRD

         DO KK = 1,ntrc

            IndexTrace = IndexTrace + nsampo
            IndexHeader = IndexHeader + ITRWRD

c
c ----- reassign trace headers -----
c

            call vmov (TraceHeaders1(IndexHeader),1,lhed1,1,ITRWRD)
            call vmov (TraceHeaders2(IndexHeader),1,lhed2,1,ITRWRD)
            call vmov (TraceHeaders3(IndexHeader),1,lhed3,1,ITRWRD)
            if(isrc2.ne.0)then
             call vmov (TraceHeaders4(IndexHeader),1,lhed4,1,ITRWRD)
             call vmov (TraceHeaders5(IndexHeader),1,lhed5,1,ITRWRD)
             call vmov (TraceHeaders6(IndexHeader),1,lhed6,1,ITRWRD)
            endif

c
c ----- load the output trace from x, y, z to lhed -----
c

            call vclr(lhed1(ITHWP1),1,nsamp)
            call vclr(lhed2(ITHWP1),1,nsamp)
            call vclr(lhed3(ITHWP1),1,nsamp)
            call vmov(x(IndexTrace),1,lhed1(ITHWP1),1,nsampo)
            call vmov(y(IndexTrace),1,lhed2(ITHWP1),1,nsampo)
            call vmov(z(IndexTrace),1,lhed3(ITHWP1),1,nsampo)
            if(isrc2.ne.0)then
              call vclr(lhed4(ITHWP1),1,nsamp)
              call vclr(lhed5(ITHWP1),1,nsamp)
              call vclr(lhed6(ITHWP1),1,nsamp)
              call vmov(x2(IndexTrace),1,lhed4(ITHWP1),1,nsampo)
              call vmov(y2(IndexTrace),1,lhed5(ITHWP1),1,nsampo)
              call vmov(z2(IndexTrace),1,lhed6(ITHWP1),1,nsampo)
            endif
                    
c
c ----- write out trace -----
c

            call wrtape(luout1,lhed1,obytes)
            call wrtape(luout2,lhed2,obytes)
            call wrtape(luout3,lhed3,obytes)
           if(isrc2.ne.0)then
            call wrtape(luout4,lhed4,obytes)
            call wrtape(luout5,lhed5,obytes)
            call wrtape(luout6,lhed6,obytes)
           endif

         ENDDO

      ENDDO

      goto 999

 991  continue
      write(LERR,*)'TOOLORT: Unable to open _Xgraph file'
      write(LERR,*)'     Check permissions and rerun '
      write(LERR,*)'FATAL'
      stop


c
c ----- cleanup prior to normal termination -----
c

 999  continue

      write(LERR,*)' '
      write(LERR,*)'Normal Completion'
      write(LERR,*)'processed ',nreco,' records'


      call lbclos(luin1)
      call lbclos(luin2)
      call lbclos(luin3)
      call lbclos(luout1)
      call lbclos(luout2)
      call lbclos(luout3)
      if(isrc2.ne.0)then
       call lbclos(luin4)
       call lbclos(luin5)
       call lbclos(luin6)
       call lbclos(luout4)
       call lbclos(luout5)
       call lbclos(luout6)
      endif
      if(pick.or.flat)close(lupick)

      do ii=irs,ire
        if (ii.ge.ixs .and. ii.le.ixe 
     :      .and. mod(ii-ixs,ixd).eq.0) then
          close(luxgraph(ii)) 
        endif
      enddo

      if(analy) then
        close(luang)
      endif

      stop
      end

