C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C
C |                                                                    |
C |  MODULE TO PERFORM ANALYSIS AND/OR VELOCITY PICKING FOR TP         |
C |  STACK PROCEDURE AS DESCRIBE BY DEBAZELAIRE IN FEB 1988 GEOPHYSICS.|
C |                                                                    |
C |   CODED BY R. CRIDER  2/90  HDC                                    |
C |                                                                    |
C ******************************************************************** C
c
c changed declarations for ntap and otap to be char*256 in all
c subroutines as well as main  -  jev - 4/9/97
c
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/pid.h>
#include <f77/iounit.h>

      integer maxsmp
      parameter (maxsmp = SZLNHD)
      REAL          dhold,v,maxcrv,pi,po
      REAL          pick,sembndx
      REAL          vloc(SZLNHD),vpick(SZLNHD)

      POINTER       (pdhold, dhold(1))
      POINTER       (pv,v(1))
      POINTER       (ppi,pi(1))
      POINTER       (ppo,po(1))
      POINTER       (pxc,maxcrv(1))
      POINTER       (ppk,pick(1))
      POINTER       (psm,sembndx(1))
      POINTER       (psh,shold(1))
    
C
      INTEGER   ITR (2*SZLNHD), ITRHD(SZLNHD)
      INTEGER   ITR2(2*SZLNHD)
      REAL      HEAD(2*SZLNHD)
      INTEGER   argis
      integer   lpick(SZLNHD)
      integer   rs, re

      real        zz(4*SZLNHD)
      integer     iz(SZLNHD)

      character PARR*34
      character NAME*6,TITLE(66)*1
      character ntap*256, otap*256,pkfile*256,segline*20
C
      LOGICAL   OPEN, there,pik, log_opt

      equivalence (itr(1), itr2(1), head(1))
C
      DATA NAME/'OPSTCV'/,OPEN/.FALSE./
      DATA PARR/'OPTICAL STACK TO CONSTANT VELOCITY'/
      DATA LUIN/7/,LUOUT/8/
      DATA TITLE/66*' '/

      ipr = LERR
      wrknt = 0
      lum = 24
      lupik=27
C +=========================+
c | Check for the HELP flag |
C +=========================+
      if (argis ('-?').gt.0 .OR. (argis('-H').gt.0)) then
         call help()
         call ccexit(0)
      endif
      lupar = 34
      J=33 - (lupar/2)
      DO I=1,lupar
         J=J+1
         TITLE(J)=PARR(I:I)
      END DO
#include <f77/open.h>
C +============================================+
c | Note that parameters and code for handling |
c | sliding window (lsw, pcnt, method) left in |
c | in anticipation of later investigating     |
c | desirability of that option.               |
C +============================================+
      call gcmdln(ntap,otap,pkfile,lupik,
     :lum,rs,re,thresh,vmin,vmax,nvel,mixt)
C
      if(rs.eq.0)rs=1
      if(re.eq.0)re=32767

      if(nvel.eq.0)then
        write(LERR,*)' Number of velocities must be supplied.'
        call ccexit(100)
      endif
      pik =(pkfile.ne.' ')
      if(ntap.ne.' ')then
       there = .false.
       inquire(file = ntap, exist = there)
       if(.not.there) then
        write(LER,*)'Requested input data set does not exist.',
     &'  Try again.'
        call ccexit(100)
       endif
      endif
      CALL GAMOCO(TITLE,1,IPR)
C
C +====================+
C |OPEN INPUT DATA SET |
C +====================+
C
      CALL openr(LUIN,ITR,LBYTES, NSAMP,NSR,NTRC,NRCD,NAME,ntap,
     : delp,pmin,pmax,v0,log_opt,unitsc)

c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)

C +============================+
c | ALLOCATE SPACE FOR STORAGE |
C +============================+
      ierror = 0
      iabort = 0
      iget = nsamp*ISZBYT
      call galloc(pxc,iget,ierror,iabort)
      call galloc(psm,iget,ierror,iabort)
      iget = nvel*ISZBYT
      call galloc(pv,iget,ierror,iabort)
      iget = ntrc*ISZBYT
      call galloc(ppi,iget,ierror,iabort)
      iget = ntrc*ISZBYT
      call galloc(ppo,iget,ierror,iabort)
      iget = ntrc*nsamp*ISZBYT
      call galloc(pdhold,iget,ierror,iabort)
      iget = nvel*nsamp*ISZBYT
      call galloc(psh,iget,ierror,iabort)
      iget = 4*nsamp*ISZBYT+ISZBYT
      call galloc(ppk,iget,ierror,iabort)
      if(ierror.ne.0)then
          write(ipr,*)' Unable to allocate memory.  Reduce data set',
     *       ' size and try again.'
          call ccexit(100)
      endif

C +============================+
C | Convert p's in msec to sec |
C +============================+
      pmin = pmin/1000.
      pmax = pmax/1000.

      IF (log_opt) THEN
 
           if(pmin.eq.0.0.or.pmax.eq.0.0)then
              write(LERR,*)'opstcv: pmin= ',pmin,' pmax= ',pmax
              write(LERR,*)'Neither can be zero - FATAL'
              write(LER ,*)'opstcv: pmin= ',pmin,' pmax= ',pmax
              write(LER ,*)'Neither can be zero - FATAL'
              stop
           endif
 
           if(pmin.gt.0.0 .and. pmax.gt.0.0)then
              ppmin = log(pmin)
              ppmax = log(pmax)
              np    = (ppmax - ppmin)/delp + 1
              pinc  = delp
              do  i = 1, np
                  pi(i) = ppmin + float(i-1) * pinc
                  pi(i) = exp( pi(i) )
                  inv   = 0
              end do
           elseif (pmin.lt.0.0.and.pmax.gt.0.0)then
              ppmin = -log(abs(pmin))
              ppmax = log(pmax)
              np    = (ppmax - ppmin)/delp + 1
              pinc  = delp
              do  i = 1, np
                  pi(i) = ppmin + float(i-1) * pinc
                  if (pi(i) .gt. 0.0) then
                     pi(i) = exp( pi(i) )
                  else
                     pi(i) = -exp( abs(pi(i)) )
                  endif
                  if (pi(i) .lt. 0) inv = i
              end do
           elseif (pmin.lt.0.0 .and. pmax.lt.0.0) then
              ppmin = -log(abs(pmin))
              ppmax = -log(abs(pmax))
              np    = (ppmax - ppmin)/delp + 1
              pinc  = delp
              do  i = 1, np
                  pi(i) = ppmin + float(i-1) * pinc
                  if (pi(i) .gt. 0.0) then
                     pi(i) = exp( pi(i) )
                  else
                     pi(i) = -exp( abs(pi(i)) )
                  endif
                  if (pi(i) .lt. 0) inv = i
              end do
           endif

      ELSE

           np = (pmax - pmin)/delp + 1
           pinc  = delp
           do  i = 1, np
               pi(i) = pmin + float(i-1)*pinc
           enddo

      ENDIF
      vinc = (vmax - vmin)/float(nvel-1)
      ns4 = nsamp*4
      SR=FLOAT(NSR) * unitsc
C +=====================================================+
c | GET PROGRAM PARAMETERS, SAVE VALUES IN LINE HEADER, |
c | WRITE LINE HEADER                                   |
C +=====================================================+
      CALL prparm(NP,re,rs,V0,pmax,pmin,delp,nvel,
     : vmin,vmax,ntap,otap)
c
C
      MBYTES = (nsamp + itrwrd)*ISZBYT
      nrecc = nrcd
      if(re.ne.32767.and.rs.gt.0)NRECC = re - rs + 1
C      +----------------------+
c      |   WRITE LINE HEADER  |
C      +----------------------+
      lby = lbytes
      call savhlh(itr,lby,lbytes)
      call savew(itr2,'MnLnIn',0,LINHED)
      call savew(itr2,'MxLnIn', nvel,LINHED)
      vv = vmin
      call savew(itr2,'ILClIn', vv, LINHED)
      vv = vinc
      call savew(itr2,'CLClIn', vv, LINHED)
      CALL openw(LUOUT,ITR,LBYTES,NRECC,nvel,OPEN,otap)
      if(.not.open)then
         write(LER,*)'Error opening output data set'
         call ccexit(100)
      endif

      do  j = 1, nvel
          v(j) = vmin + float(j-1)*vinc
      enddo

C +-------------------------------------------+
C | FIND AND READ FIRST TRACE OF FIRST RECORD |
C +-------------------------------------------+
      IREAD=0
  306 CONTINUE

      NBYTES = 0
      CALL RTAPE(LUIN,ITR,NBYTES)
      IF(NBYTES.EQ.0)then
        write(LERR, *)'EOF on input data set.  OPST ending'
        go to 999
      endif

c     call saver(itr,'RecNum',irec,TRCHED)
c     irec = itr2(l_RecNum)
      call saver2(itr2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            irec , TRACEHEADER)
      IF(irec.ge.rs) THEN
        IREAD=1
      ELSE
        GO TO 306
      ENDIF
      inknt  = 0
      icinit = 0

      DO 101 NX = 1,NTRC
        IF(IREAD.EQ.0)THEN
          NBYTES = 0
          CALL RTAPE(LUIN,ITR,NBYTES)
        ENDIF
        IREAD=0
        IF(NBYTES .EQ. 0) THEN
        WRITE(IPR,'(5X,A)')'END OF FILE ON INPUT:'
        WRITE(IPR,'(5X,A,1X,I4,A,1X,I4)')'  REC= ',IREC,'TRACE= ',NX
        GO TO 999
        ENDIF
        inknt = inknt + 1
c       call saver(itr,'RecNum', irec, TRCHED)
c       irec = itr2(l_RecNum)
        call saver2(itr2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1              irec , TRACEHEADER)
C +--------------------+
C | SAVE TRACE HEADERS |
C +--------------------+
        if(inknt.eq.1)call vmov(itr,1,itrhd,1,ITRWRD)
C           +------------------+
C           |   SAVE THE DATA  |
C           +------------------+
        index = (inknt-1)*nsamp + 1
c       call move(1,Dhold(index),itr(ITHWP1),ns4)
        call vmov (itr(ITHWP1), 1, Dhold(index), 1, nsamp)
  101 CONTINUE
    
      call velsmp (nsamp,ntrc,nvel,pi,po,dhold,shold,sr,
     1             vmin,vinc,V0, zz, iz, icinit)

c     do  nx = 1, nvel
c        vel = v(nx)
c        ndx = (nx-1) * nsamp + 1
c        call gettrc(dhold,nsamp,ntrc,v0,delp,vel,sr,shold(ndx))
c     end do

      if(pik)then
C +===============+
C | Pick the data |
C +===============+
         recu = 1
c        trcu = 1
         trcu = vinc
         trcoff = vmin - vinc
         timeu = nsr
         ntrcp = np
         call vclr(maxcrv,1,nsamp)
         call vclr(sembndx,1,nsamp)
         call vgetmax(shold,nsamp,nvel,maxcrv,sembndx)
         call vpikmax(shold,maxcrv,sembndx,nsamp,sr,nvel,
     :   thresh,vmin,vinc,pick,npicks,lpick,vpick)
         wrknt = wrknt + 1
         if(wrknt.eq.1)then
           write(lupik,35)'Units',recu,trcu,timeu,nrecc,nvel,nsamp,
     1                     'Offset',recoff,trcoff,timoff
         endif
         write(segline,'(a)')'Segment = 1'
         write(lupik,'(a)')segline
         one = irec
         do kk=1,npicks
           kki = lpick(kk)
           call locinc(kki,nsamp,iloc1,iloc2,iloc3,iloc4)
           itime = pick(iloc1)
           ti = itime
c          write(lupik,36)one,pick(iloc4),ti,pick(iloc2)
           write(lupik,36)one,pick(iloc2),ti,pick(iloc4)
           vloc(kk)=pick(iloc2)
         end do
      endif
c  35 format(a,t10,f9.6,t23,f9.6,t36,f9.6,t50,i4,t56,i5,t64,i4)
   35 format(a5,3f13.6,3i6,1x,a6,3f13.6)
c  36 format(f12.6,1x,f12.6,1x,f12.6,1x,f12.6)
   36 format(f12.6,1x,f12.6,1x,f12.6,1x,f12.6)
C +=================+
C | Output the data |
C +=================+
      do nx=1,nvel
         call vmov(itrhd,1,itr,1,ITRWRD)
c        call savew(itr,'StaCor', 0, TRCHED)
c        call savew(itr,'TrcNum',nx,TRCHED)
c        itr2(l_StaCor) = 0
c        itr2(l_TrcNum) = nx
         call savew2(itr2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               0    , TRACEHEADER)
         call savew2(itr2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               nx   , TRACEHEADER)
         ioff = v(nx)
c        call savew(itr,'DstUsg',ioff,TRCHED)
c        call savew(itr,'DstSgn',ioff,TRCHED)
c        itr2(l_DstSgn) = ioff
c        itr2(l_DstUsg) = ioff
         call savew2(itr2,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1               ioff , TRACEHEADER)
         call savew2(itr2,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1               ioff , TRACEHEADER)
         ndx=(nx-1)*nsamp+1
         call vmov(shold(ndx),1,itr(ITHWP1),1,nsamp)
         call wrtape(luout,itr,mbytes)
      end do
      rs=rs+1
      IF (rs.LE.re) GOTO 306
  999 CONTINUE
      CALL LBCLOS( LUIN)
      CALL LBCLOS(LUOUT)
      call ccexit(0)
      END
C***********************************************************************

      SUBROUTINE prparm(NP,re,rs,V0,pmax,pmin,delp,noff,
     :vmin,vmax,ntap,otap)
C
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
      INTEGER     rs,re
C
      character ntap*256, otap*256,pipe*50
C
      LOGICAL verbose
C
      pipe = 'pipe'
      verbose = .true.
  420 CONTINUE
      WRITE(LERR,'(10X,A     )')' '
      WRITE(LERR,'(10X,A     )')'  INPUT PARAMETERS AFTER DEFAULTS'
      if(ntap.ne.' ')then
      WRITE(LERR,'(10X,2A)')    'Input data set............',
     :ntap(1:50)
      else
      WRITE(LERR,'(10X,2A)')    'Input data set............',pipe
      endif
      if(otap.ne.' ')then
      WRITE(LERR,'(10X,2a)')    'Output data...............',otap
      else
      WRITE(LERR,'(10X,2A)')    'Output data...............',pipe
      endif
      WRITE(LERR,'(10X,A,I6  )')'Start Record .............',rs
      WRITE(LERR,'(10X,A,I6  )')'End Record ...............',re
      WRITE(LERR,'(10X,A,e12.5)')'Minimum Tp................',pmin
      WRITE(LERR,'(10X,A,e12.5)')'Maximum Tp................',pmax
      WRITE(LERR,'(10X,A,I6  )')'Number of TPs ............',NP
      WRITE(LERR,'(10X,A,I6)')  'Number of Velocities......',noff
      WRITE(LERR,'(10X,A,F7.1)')'Minimum Velocity..........',vmin
      WRITE(LERR,'(10X,A,F7.1)')'Maximum Velocity..........',vmax
      RETURN
      END
C

      subroutine openr(luin,itr,lbytes,nsamp,
     &nsr,ntrc,nrcd,name,ntap,delp,pmin,pmax,v0,log_opt,unitsc)
c ******************************************************************** *
c                                                                      *
c  SUBROUTINE TO OPEN THE INPUT DATA SET AND EXTRACT NECESSARY         *
c  HEADER INFORMATION.  HLH IS CALLED TO UPDATE THE PROGRAM NAME       *
c  ONLY.                                                               *
c  INPUT:                                                              *
c    LUIN  - I*4  -  LOGICAL UNIT FOR INPUT                            *
c    ITR   - I*4  -  INPUT BUFFER                                      *
c  OUTPUT:                                                             *
c   NSAMP  - I*4  -  NUMBER OF SAMPLES IN DATA TRACE                   *
c    NSR   - I*4  -  SAMPLE INTERVAL OF DATA                           *
c    NTRC  - I*4  -  NUMBER OF TRACES PER RECORD                       *
c    NRCD  - I*4  -  NUMBER OF RECORDS IN DATA SET (*NOT USED*)        *
c    V0    - R*4  -  Velocity of the medium                            *
c    NP    - I*4  -  Number of Tp's                                    *
c    PMIN  - R*4  -  Minimum Tp                                        *
c    PMAX  - R*4  -  MAXIMUM Tp                                        *
c                                                                      *
c ******************************************************************** *
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
      integer maxsmp
      parameter (maxsmp = 3000)
      INTEGER   ITR(*)
      CHARACTER NAME*5, ntap*256
      logical   log_opt

      IPR=LERR
       if(ntap.ne.' ')then
           call lbopen(luin, ntap, 'r')
       else
           luin = 0
       endif
C +----------------------------------------+
C | GET LINE HEADER, CHECK TO SEE IF EMPTY |
C +----------------------------------------+
      LBYTES = 0
      CALL RTAPE(LUIN, ITR, LBYTES)
      IF(LBYTES .EQ. 0) THEN
         WRITE(IPR,'(5X,A,1X,I3)')'OPST: NO HEADER READ ON UNIT ',LUIN
         WRITE(IPR,'(5X,A)')'FATAL ERROR.'
         WRITE(IPR,'(5X,A)')'CHECK EXISTENCE OF FILE & RERUN'
         CALL CCEXIT(100)
      ENDIF
      IFOUR=4
      call hlhprt(itr,lbytes,name,ifour,LERR)
      call saver(itr, 'NumSmp', NSAMP, LINHED)
      call saver(itr, 'SmpInt', nsr  , LINHED)
      call saver(itr, 'NumRec', NRCD , LINHED)
      call saver(itr, 'NumTrc', ntrc,   LINHED)
      call saver(itr, 'MutVel', V0,   LINHED)
      call saver(itr, 'MnLnIn', ithree, LINHED)
      call saver(itr, 'ILClIn', pmin, LINHED)
      call saver(itr, 'CLClIn', pmax, LINHED)
      call saver(itr, 'NmSpMi', delp, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(IPR,*)'********************************************'
          write(IPR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(IPR,*)'         will set to .001 (millisec default)'
          write(IPR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
      if(iabs(ithree).ne.2)then
        write(IPR,*)'Data is NOT optical stack data.'
        write(IPR,*)' Unable to inverse it.'
        call ccexit(100)
      endif
      log_opt = .false.
      if (ithree .eq. -2) log_opt = .true.
      if (NSAMP.GE.3000) then
        WRITE(IPR,175)NSAMP, maxsmp
  175 FORMAT(/,14X,' ** M0175 ** ERROR IN PROGRAM OPST.',
     &/,14X,'Number of samples per trace ('I5') > ',i5,'.',
     &/,14X,'JOB ABENDED.')
         call ccexit(0)
         endif
      RETURN
      END

      SUBROUTINE openw(LUOUT,ITR,LBYTES,NRECC,NP,OPEN,otap)
c ******************************************************************** *
c                                                                      *
c  SUBROUTINE TO OPEN THE OUTPUT DATA SET                              *
c  LINE HEADER IS UPDATED FOR NUMBER OF TRACES PER RECORD ONLY.        *
c  INPUT:                                                              *
c   LUOUT  - I*4  -  LOGICAL UNIT FOR OUTPUT                           *
c    ITR   - I*4  -  INPUT BUFFER                                      *
c   LBYTES - I*4  -  LINE HEADER LENGTH IN BYTES                       *
c    NRECC - I*4  -  NUMBER OF RECORDS TO OUTPUT (*NOT USED*)          *
c    NP    - I*4  -  NUMBER OF TRACES PER RECORD OUTPUT.               *
c  OUTPUT:                                                             *
c    OPEN  - L*4  -  FLAG TO SIGNIFY DATA SET OPENED                   *
c                                                                      *
c ******************************************************************** *
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
      INTEGER   ITR(*)
      character otap*256
      LOGICAL OPEN
      if(otap.ne.' ')then
        call lbopen(luout,otap, 'w')
      else
        luout = 1
      endif
      if(luout.gt.0)open=.true.
      lby = 0
      ithree = 2
      call savew(itr, 'NumTrc', np, linhed)
      call savew(itr,'NumRec',nrecc,linhed)
      lby = lbytes
      CALL WRTAPE(LUOUT, ITR, LBY)
      RETURN
      END

      subroutine gcmdln (ntap,otap,pkfile,lupik,
     :lum,rs,re,thresh,vmin,vmax,nvel,mixt)
c                                     
c     this routine processes the command line arguments for use in
c     program STKOP.
c                                                               
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
      real thresh
      integer rs, re

      character ntap*256, otap*256
      character pkfile*256

      logical there,error

      error = .false.
	  ntap = ' '
      call argstr ('-N',ntap,' ',' ')          
      otap = ' '
      call argstr ('-O',otap,' ',' ')            
      pkfile = ' '
      call argstr ('-pk',pkfile,' ',' ')
      if(pkfile.ne.' ')then
        inquire(file = pkfile, exist = there)
        if(there) then
          open(unit=LUPIK, file=pkfile, status='old')
          close(unit=LUPIK, status = 'DELETE') 
          open(unit=LUPIK, file=pkfile, status='new',
     :         form='formatted',access='sequential')
        else
          open(unit=LUPIK, file=pkfile, status='new',
     :         form='formatted',access='sequential')
        endif
      endif

      call argi4('-rs',rs,0,0)
      call argi4('-re',re,0,0)
      call argr4('-th',thresh,0.,0.)
      if(thresh.eq.0.0)thresh = 0.35
      call argr4('-vm',vmin,0.0,0.0)
      call argr4('-vx',vmax,0.0,0.0)
      call argi4('-nv',nvel,0,0)
c     call argi4('-mix',mixt,0,0)
c     if(mixt.le.0)mixt=1
      mixt = 1
      return                                                  
      end
      subroutine help
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
          write(LER,*)  
     :'***************************************************************'
         write(LER,*)'Program OPSTCV..........Optical Stack Conversion'
         write(LER,*)' '                                             
         write(LER,*)                                               
     :' -N [ntap]      (May be pipe)     : Input scan data file name'   
         write(LER,*)                                               
     :' -O [otap]      (May be pipe)     : Output stacked data file'
         write(LER,*)                                           
     :' -pk [pkfile]   (optional)        : Output Pick file name'
         write(LER,*)                                               
     :' -rs [rs]       (default=first)   : First record to process'
         write(LER,*)                                             
     :' -re [re]       (default=last)    : Last record to process'
         write(LER,*)                                           
     :' -th [thresh]   (default = .35    : Semblance Picking threshold'
         write(LER,*)                                           
     :' -vm [vmin]     (optional)        : Minimum Velocity in scans'
         write(LER,*)                                               
     :' -vx [vmax]     (default=first)   : Maximum Velocity in scans'
         write(LER,*)        
     :' -nv [nvel]     (No default)      : Number of velocity traces'
       write(LER,*)                                        
     :'Usage:  ',                                         
     :' opstcv -N[ntap] -O[otap] -pk[pkfile]',
     :' -rs[first record] -re[last record] -th[thresh]',
     :' -vm[vmin] -vx[vmax] -nv[nvel]'
       write(LER,*)                                     
     :'***************************************************************'
      return                                                          
      end                                                            

      subroutine locinc(iroot,incr,iloc1,iloc2,iloc3,iloc4)
      integer iroot,incr,iloc1,iloc2,iloc3,iloc4

      iloc1 = iroot
      iloc2 = iloc1 + incr
      iloc3 = iloc2 + incr
      iloc4 = iloc3 + incr
      return
      end
