C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine get_tp(pmin,pmax,np,log_opt,pinc,p,inv,ierr)

#include <f77/iounit.h>

C ******************************************************************** C
C *   Subroutine get_tp                                              * C
C *                                                                  * C
C *   Subroutine to compute the Tp (P) and the Tp**2 (p2) vectors.   * C
C *                                                                  * C
C *   Parameters:                                                    * C
C *     Input:                                                       * C
C *       pmin    - Real     - Minimum Tp value.                     * C
C *       pmax    - Real     - Maximum Tp value.                     * C
C *       np      - Integer  - Minimum Tp value.                     * C
C *       log_opt - Logical  - Log sampling option                   * C
C *     Output:                                                      * C
C *       pinc    - Real     - Tp increment.                         * C
C *       p       - Real(*)  - Vector of Tp values.                  * C
C *       inv     - Integer  - Location of last negative value       * C
C *                            in the p() vector.                    * C
C *       ierr    - Integer  - Error flag.                           * C
C ******************************************************************** C
      real pmin,pmax,pinc,p(*)
      integer np,inv,ierr
      logical log_opt

      ierr = 0
      if(log_opt)then
       if(pmin.eq.0.0.or.pmax.eq.0.0)then
          write(LERR,*)' For the log-linear option, neither pmin ',
     :' nor pmax can be zero'
        ierr = 1
        return
       endif
       if(pmin.gt.0.0.and.pmax.gt.0.0)then
          ppmin = log(pmin)
          ppmax = log(pmax)
          pinc = (ppmax-ppmin)/float(np-1)
          do i=1,np
           p(i)=ppmin + float(i-1)*pinc
           p(i)=exp(p(i))
           inv=0
          end do
       elseif (pmin.lt.0.0.and.pmax.gt.0.0)then
          ppmin = -log(abs(pmin))
          ppmax = log(pmax)
          pinc = (ppmax - ppmin)/float(np-1)
          do i=1,np
           p(i)=ppmin + float(i-1)*pinc
           if(p(i).gt.0.0)then
             p(i)=exp(p(i))
           else
             p(i)=-exp(abs(p(i)))
           endif
           if(p(i).lt.0)inv=i
          end do
       elseif (pmin.lt.0.0.and.pmax.lt.0.0)then
          ppmin = -log(abs(pmin))
          ppmax = -log(abs(pmax))
          pinc = (ppmax - ppmin)/float(np-1)
          do i=1,np
           p(i)=ppmin + float(i-1)*pinc
           if(p(i).gt.0.0)then
             p(i)=exp(p(i))
           else
             p(i)=-exp(abs(p(i)))
           endif
           if(p(i).lt.0)inv=i
          end do
       endif
      else
        pinc = (pmax-pmin)/float(np-1)
        do i=1,np
         p(i)=pmin + float(i-1)*pinc
         if(p(i).lt.0)inv=i
        end do
      endif
      return
      end
