C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine openr(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,name,ntap,
     :np,pmin,pmax,v0,log_opt,ITHWP2,noff,IPR,unitsc)
* ******************************************************************** *
*                                                                      *
*  SUBROUTINE TO OPEN THE INPUT DATA SET AND EXTRACT NECESSARY         *
*  HEADER INFORMATION.  HLH IS CALLED TO UPDATE THE PROGRAM NAME       *
*  ONLY.                                                               *
*  INPUT:                                                              *
*    LUIN  - I*4  -  LOGICAL UNIT FOR INPUT                            *
*    ITR   - I*4  -  INPUT BUFFER                                      *
*  OUTPUT:                                                             *
*   NSAMP  - I*4  -  NUMBER OF SAMPLES IN DATA TRACE                   *
*    NSR   - I*4  -  SAMPLE INTERVAL OF DATA                           *
*    NTRC  - I*4  -  NUMBER OF TRACES PER RECORD                       *
*    NRCD  - I*4  -  NUMBER OF RECORDS IN DATA SET (*NOT USED*)        *
*    V0    - R*4  -  Velocity of the medium                            *
*    NP    - I*4  -  Number of Tp's                                    *
*    PMIN  - R*4  -  Minimum Tp                                        *
*    PMAX  - R*4  -  MAXIMUM Tp                                        *
*                                                                      *
* ******************************************************************** *

#include <f77/lhdrsz.h>

      INTEGER   ITR(*)
c
c changed declarations for ntap and otap to be char*256 in all
c subroutines as well as main  -  jev - 4/9/97
c
      CHARACTER NAME*5, ntap*256
      logical log_opt

      if(ntap.ne.' ')then
        call lbopen(luin, ntap, 'r')
      else
        luin = 0
      endif
      LINHED=0
C +----------------------------------------+
C | GET LINE HEADER, CHECK TO SEE IF EMPTY |
C +----------------------------------------+
      LBYTES = 0
      CALL RTAPE(LUIN, ITR, LBYTES)
      IF(LBYTES .EQ. 0) THEN
         WRITE(IPR,'(5X,A,1X,I3)')'OPST: NO HEADER READ ON UNIT ',LUIN
         WRITE(IPR,'(5X,A)')'FATAL ERROR.'
         WRITE(IPR,'(5X,A)')'CHECK EXISTENCE OF FILE & RERUN'
         CALL CCEXIT(100)
      ENDIF
      IFOUR=5
      call hlhprt(itr,lbytes,name,ifour,IPR)
      call saver(itr, 'NumSmp', NSAMP, LINHED)
      call saver(itr, 'SmpInt', nsr  , LINHED)
      call saver(itr, 'NumRec', NRCD , LINHED)
      call saver(itr, 'NumTrc', NP,    LINHED)
      call saver(itr, 'MutVel', V0,    LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(IPR,*)'********************************************'
          write(IPR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(IPR,*)'         will set to .001 (millisec default)'
          write(IPR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
      log_opt = .false.
      if(V0.lt.0.0)then
        V0 = abs(V0)
        call savew(itr, 'MutVel', V0,  LINHED)
        log_opt = .true.
      endif
      call saver(itr, 'MnLnIn', ithree, LINHED)
      call saver(itr, 'ILClIn', pmin,   LINHED)
      call saver(itr, 'CLClIn', pmax,   LINHED)
      call saver(itr, 'NmSpMi', delp,   LINHED)
      ntrc = np
      np = np/2
      if(ithree.lt.0)then
c        noff = -1
c        ITHWP2 = ITHWP1 + 1
         ITHWP2 = ITHWP1
         ithree = -ithree
         call savew(itr, 'MnLnIn', ithree, LINHED)
      else
         ITHWP2 = ITHWP1
c        noff = 0
      endif
      if(ithree.ne.2)then
        write(IPR,*)'Data is NOT optical stack data.'
        write(IPR,*)' Unable to use it.'
        call ccexit(100)
      endif
      if (NSAMP.GE.3000) then
        WRITE(IPR,175)NSAMP, SZLNHD
  175 FORMAT(/,14X,' ** M0175 ** ERROR IN PROGRAM OPST.',
     &/,14X,'Number of samples per trace ('I5') > ',i5,'.',
     &/,14X,'JOB ABENDED.')
         call ccexit(0)
         endif
C
      RETURN
      END

      subroutine open2(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,ntap,
     :IPR,pipe,IKP)
c ******************************************************************** *
c                                                                      *
c  SUBROUTINE TO OPEN THE INPUT DATA SET AND EXTRACT NECESSARY         *
c  HEADER INFORMATION.  HLH IS CALLED TO UPDATE THE PROGRAM NAME       *
c  ONLY.                                                               *
c  INPUT:                                                              *
c    LUIN  - I*4  -  LOGICAL UNIT FOR INPUT                            *
c    ITR   - I*4  -  INPUT BUFFER                                      *
c  OUTPUT:                                                             *
c   NSAMP  - I*4  -  NUMBER OF SAMPLES IN DATA TRACE                   *
c    NSR   - I*4  -  SAMPLE INTERVAL OF DATA                           *
c    NTRC  - I*4  -  NUMBER OF TRACES PER RECORD                       *
c    NRCD  - I*4  -  NUMBER OF RECORDS IN DATA SET (*NOT USED*)        *
c ******************************************************************** *

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      INTEGER   ITR(*)
      CHARACTER ntap*256
      integer   pipe
      logical   IKP

      if(ntap(1:1) .ne.' ' .and. .not.IKP) then
        call lbopen(luin, ntap, 'r')
      elseif (ntap(1:1)  .eq. ' ' .and. IKP) then
        call sisfdfit (luin, pipe)
      else
        luin = -1
      endif
      if (luin .lt. 0) then
         write(LERR,*)'Cannot open original input data set. Will'
         write(LERR,*)'assume original data set not needed'
         write(LERR,*)'This is a DANGEROUS assumption.  You should'
         write(LERR,*)'rerun with original data set specified'
         luin = -1
         return
      endif
C +----------------------------------------+
C | GET LINE HEADER, CHECK TO SEE IF EMPTY |
C +----------------------------------------+
      LINHED=0
      LBYTES = 0
      CALL RTAPE(LUIN, ITR, LBYTES)
      IF(LBYTES .EQ. 0) THEN
         WRITE(IPR,'(5X,A,1X,I3)')'OPSTR: NO HEADER READ ON UNIT ',LUIN
         WRITE(IPR,'(5X,A)')'FATAL ERROR.'
         WRITE(IPR,'(5X,A)')'CHECK EXISTENCE OF FILE & RERUN'
c        CALL CCEXIT(100)
         luin = -1
         return
      ENDIF
      call saver(itr, 'NumSmp', NSAMP, LINHED)
      call saver(itr, 'SmpInt', nsr  , LINHED)
      call saver(itr, 'NumRec', NRCD , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      if (NSAMP.GE.3000) then
        WRITE(IPR,175)NSAMP, SZLNHD
  175 FORMAT(/,14X,' ** M0175 ** ERROR IN PROGRAM OPST.',
     &/,14X,'Number of samples per trace ('I5') > ',i5,'.',
     &/,14X,'JOB ABENDED.')
         call ccexit(0)
         endif
      RETURN
      END

      SUBROUTINE openw(LUOUT,ITR,LBYTES,NRECC,noff,OPEN,otap,IPR)
* ******************************************************************** *
*                                                                      *
*  SUBROUTINE TO OPEN THE OUTPUT DATA SET                              *
*  LINE HEADER IS UPDATED FOR NUMBER OF TRACES PER RECORD ONLY.        *
*  INPUT:                                                              *
*   LUOUT  - I*4  -  LOGICAL UNIT FOR OUTPUT                           *
*    ITR   - I*4  -  INPUT BUFFER                                      *
*   LBYTES - I*4  -  LINE HEADER LENGTH IN BYTES                       *
*    NRECC - I*4  -  NUMBER OF RECORDS TO OUTPUT (*NOT USED*)          *
*    NP    - I*4  -  NUMBER OF TRACES PER RECORD OUTPUT.               *
*  OUTPUT:                                                             *
*    OPEN  - L*4  -  FLAG TO SIGNIFY DATA SET OPENED                   *
*                                                                      *
* ******************************************************************** *
      INTEGER*2   ITR(*)
      character otap*256
      LOGICAL OPEN

      LINHED = 0
      if(otap.ne.' ')then
        call lbopen(luout,otap, 'w')
      else
        luout = 1
      endif
      if(luout.gt.0)open=.true.
      lby = 0
      ithree = 2
      call savew(itr, 'NumTrc', noff, linhed)
      call savew(itr,'NumRec',nrecc,linhed)
      lby = lbytes
      CALL WRTAPE(LUOUT, ITR, LBY)
      RETURN
      END
