C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C
C |                                                                    |
C |  MODULE TO PERFORM ANALYSIS AND/OR VELOCITY PICKING FOR TP         |
C |  STACK PROCEDURE AS DESCRIBE BY DEBAZELAIRE IN FEB 1988 GEOPHYSICS.|
C |                                                                    |
C |   CODED BY R. CRIDER  2/90  HDC                                    |
C |                                                                    |
C ******************************************************************** C
c
c changed declarations for ntap and otap to be char*256 in all
c subroutines as well as main  -  jev - 4/9/97
c
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>

      integer maxsmp,nerrflg
      parameter (maxsmp = 3000)
      parameter (nerrflg=6)
      CHARACTER PARR*28
      CHARACTER NAME*5,TITLE(66)*1
      REAL          Live
      REAL          P(550), xoff(SZLNHD), xoffv2(SZLNHD),P2(550)
      REAL          dhold,dhold2,hs
      real          data(SZLNHD)
      real          fwork(SZLNHD),hwork(SZLNHD)
      REAL          sumbuf,cmute(SZLNHD),mutes
      real          ritr(2*SZLNHD)

      POINTER       (pdhold, dhold(1))
      POINTER       (pm,mutes(1))
      POINTER       (plive, Live(1))
      POINTER       (psum,sumbuf(1))
      POINTER       (phs,hs(1))
      POINTER       (ph2,dhold2(1))
    
C
      INTEGER   ITR(2*SZLNHD), lhead(2*SZLNHD)
      integer   itrhd, itrhd2
      pointer   (pth , itrhd (1))
      pointer   (pth2, itrhd2(1))
      INTEGER       argis, pipe

      integer       rs, re, jr(70)

      integer   trhdi2(2*SZLNHD)
      integer   trhdi4(2*SZLNHD)

C
      character ntap*256, otap*256,mutef*256,ntap2*256
C
      LOGICAL OPEN, there,mute,log_opt,error,IKP
      logical errflg(nerrflg),fw
C
      EQUIVALENCE (itr(1),trhdi4(1),lhead(1),trhdi2(1),ritr(1))
c     EQUIVALENCE (itr(1),ritr(1))
c     EQUIVALENCE (itr(1),trhdi2(1))
c     EQUIVALENCE (itr(1),trhdi4(1))
c
      DATA NAME/'OPSTR'/,OPEN/.FALSE./
      DATA PARR/'OPTICAL STACK RECONSTRUCTION'/
      DATA LUIN/7/,LUOUT/8/
      DATA TITLE/66*' '/, pipe/3/

      wrknt = 0
C +=========================+
c | Check for the HELP flag |
C +=========================+
      if (argis ('-?').gt.0 .OR. (argis('-H').gt.0)) then
         call help(LER)
         call ccexit(0)
      endif
      J=19
      DO I=1,28
         J=J+1
         TITLE(J)=PARR(I:I)
      END DO
#include <f77/open.h>
       ntap = ' '
       ntap2 = ' '
       otap = ' '
       lum = 27
C +============================================+
c | Note that parameters and code for handling |
c | sliding window (lsw, pcnt, method) left in |
c | in anticipation of later investigating     |
c | desirability of that option.               |
C +============================================+
      call gcmdln(ntap,ntap2,otap, rs, re,vmin,vmax,mutef,
     :fw,vf1,tf1,vf2,tf2,vf3,tf3,vf4,tf4,IKP,fl,fh)
C
      tff1 = tf1
      tff2 = tf2
      tff3 = tf3
      tff4 = tf4
      tf1 = tf1/1000.
      tf2 = tf2/1000.
      tf3 = tf3/1000.
      tf4 = tf4/1000.

      if(mutef.eq.' ')then
       lum=0
       mute = .false.
      else
       mute = .true.
      endif
      if(ntap.ne.' ')then
       there = .false.
       inquire(file = ntap, exist = there)
       if(.not.there) then
        write(LER,*)'Requested input data set does not exist.',
     &'  Try again.'
        call ccexit(100)
       endif
      endif
      if(ntap2.ne.' ')then
       there = .false.
       inquire(file = ntap2, exist = there)
       if(.not.there) then
        write(LER,*)'Requested secondary input data set does not ',
     :'exist.  Try again.'
        call ccexit(100)
       endif
      endif
      if(mute)then
        call noblnk(mutef, L)
        inquire(file = mutef, exist = there)
        if(there) then
          open(unit=LUM, file=mutef)
        else
          write(LERR,*)' Requested mute file ', mutef,
     :' not found.  Job aborted.'
        call ccexit(100)
        endif
      endif
      CALL GAMOCO(TITLE,1,lerr)
C
C +====================+
C |OPEN INPUT DATA SET |
C +====================+
C
      noff = 0

      call open2(lui2,itr,lbytes,nsamp2,nsr2,ntrc2,nrcd2,ntap2,lerr,
     1           pipe,IKP)

      if (lui2 .gt. 0) noff = ntrc2

      call openr(luin,lhead,lbytes,nsamp,nsr,ntrc,nrcd,name,ntap,
     :np,pmin,pmax,v0,log_opt,ITHWP2,noff,lerr,unitsc)

      if (noff .eq. 0) then
          noff = ntrc/2
      endif

c     noff = ntrc2

c------
c     save certain parameters

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)


C +============================+
C | Convert p's in msec to sec |
C +============================+
      pmin = pmin/1000.
      pmax = pmax/1000.
      delp = 0.
      sr=float(nsr) * unitsc
C +=====================================================+
c | GET PROGRAM PARAMETERS, SAVE VALUES IN LINE HEADER, |
c | WRITE LINE HEADER                                   |
C +=====================================================+
      CALL prparm(ntap,ntap2,otap,re,rs,vf1,tff1,vf2,tff2,
     :vf3,tff3,vf4,tff4,fw)
 
      nrecc = nrcd
      if(rs.eq.0)rs = 1
      if(re.eq.0)re=32767
      if(re.ne.32767.and.rs.gt.0)NRECC = re - rs + 1
      call savew(lhead,'NumRec',nrecc,LINHED)
C      +----------------------+
c      |   WRITE LINE HEADER  |
C      +----------------------+
      lby = lbytes
      call savhlh(lhead,lby,lbytes)
      CALL openw(LUOUT,trhdi2,LBYTES,NRECC,noff,OPEN,otap,LERR)
      if(.not.open)then
         write(LER,*)'Error opening output data set'
         call ccexit(100)
      endif
C +============================+
c | ALLOCATE SPACE FOR STORAGE |
C +============================+
      do i=1,nerrflg
        errflg(i)=.false.
      end do
      nit=0
      ierror = 0
      iabort = 0
      error = .false.
      iget = ntrc*(1+ITRWRD)*ISZBYT
      call galloc(pth,iget,ierror,iabort)
      nit=nit+1
      if(ierror.ne.0)then
        errflg(nit) = .true.
        ierror = 0
      endif
      iget = ntrc2*(1+ITRWRD)*ISZBYT
      call galloc(pth2,iget,ierror,iabort)
      nit=nit+1
      if(ierror.ne.0)then
        errflg(nit) = .true.
        ierror = 0
      endif

      ierror = 0
      iabort = 0
      iget = nsamp*ISZBYT
      call galloc(psum,iget,ierror,iabort)
      nit=nit+1
      if(ierror.ne.0)then
        errflg(nit) = .true.
        ierror = 0
      endif
      call galloc(plive,iget,ierror,iabort)
      nit=nit+1
      if(ierror.ne.0)then
        errflg(nit) = .true.
        ierror = 0
      endif
      iget = np*nsamp*ISZBYT
      call galloc(pdhold,iget,ierror,iabort)
      nit=nit+1
      if(ierror.ne.0)then
        errflg(nit) = .true.
        ierror = 0
      endif
      call galloc(phs   ,iget,ierror,iabort)
      nit=nit+1
      if(ierror.ne.0)then
        errflg(nit) = .true.
        ierror = 0
      endif
      iget = ntrc2 * nsamp2*ISZBYT
      call galloc(ph2   ,iget,ierror,iabort)
      nit=nit+1
      if(ierror.ne.0)then
        errflg(nit) = .true.
        ierror = 0
      endif
      if(mute)then
       iget = 70*nsamp*ISZBYT
       call galloc(pm,iget,ierror,iabort)
       nit=nit+1
       if(ierror.ne.0)then
        errflg(nit) = .true.
        ierror = 0
       endif
      endif
      do i=1,nerrflg
       if(errflg(i))then
          write(lerr,*)' Unable to allocate memory.  Reduce data set',
     *       ' size and try again.'
          call ccexit(100)
       endif
      end do
      if(mute)then
        call rdmute(mutef,lum,nsamp,mutes,jr,nsets)
        call sortmute(mutes,jr,nsamp,nsets)
      endif
      xmul = 1./v0
C +-------------------------------------------+
C | Find and read first trace of first record |
C | of the transformed data set               |
C +-------------------------------------------+
      mbytes = (nsamp+ITRWRD)*ISZBYT
      IREAD=0
  306 CONTINUE
      NBYTES = 0
      CALL rtape(LUIN,ITR,NBYTES)
      IF(NBYTES.EQ.0)then
        write(LERR, *)'EOF on input data set.  OPSTR ending'
        go to 999
      endif
c     irec = trhdi2(l_RecNum)
      call saver2(trhdi2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            irec , TRACEHEADER)
      IF(irec.ge.rs) THEN
        IREAD=1
      ELSE
        GO TO 306
      ENDIF
      inknt = 0
      DO 101 NX = 1,ntrc
        IF(IREAD.EQ.0)THEN
          NBYTES = 0
          CALL rtape(LUIN,ITR,NBYTES)
        ENDIF
        IREAD=0
        IF(NBYTES .EQ. 0) THEN
        WRITE(lerr,'(5X,A)')'END OF FILE ON INPUT:'
        WRITE(lerr,'(5X,A,1X,I4,A,1X,I4)')'  REC= ',IREC,'TRACE= ',NX
        GO TO 999
        ENDIF
        if(mod(nx,2).eq.1)then
C +--------------------+
C | SAVE TRACE HEADERS |
C +--------------------+
         inknt = inknt + 1
         ntx   = (inknt-1)*ITRWRD + 1
         call vmov(trhdi4,1,itrhd(ntx),1,ITRWRD)
c        call vmov(itr,1,itrhd(1,inknt),1,ITRWRD)
c        call saver(itr,'RcPtXC',IDX,TRCHED)
c        idx = trhdi4 (l_RcPtXC)
         call saver2(trhdi2,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1               idx  , TRACEHEADER)

         if (lui2 .lt. 1) then
            ioff = trhdi2 (l_DstSgn)
            call saver2(trhdi2,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                  ioff , TRACEHEADER)
            off=float(iabs(ioff))
            xoff(inknt)=off
            xoffv2(inknt) = off*xmul
            xoffv2(inknt) = xoffv2(inknt)*xoffv2(inknt)
        endif

         p(inknt)=float(idx)/1000.
         p2(inknt)=p(inknt)*p(inknt)
C +------------------+
C |   SAVE THE DATA  |
C +------------------+
         ndx = (inknt-1)*nsamp
         if(.not.fw)then
          do i=1,nsamp
           dhold(ndx+i)=ritr(ITRWRD+i)
          end do
         else
          call rho(ritr(ITRWRD+1),nsamp,dhold(ndx+1),sr,fl,fh,ierr)
          if(ierr.ne.0)then
           write(lerr,*)'----->  Memory allocation error!!'
           go to 999
          endif
         endif
        endif
  101 CONTINUE
C +-------------------------------------------+
C | Find and read first trace of first record |
C | of the secondary data set                 |
C +-------------------------------------------+
      iread=0
  307 continue

      IF (lui2 .gt. 1) THEN

      nbytes = 0
      call rtape(lui2,itr,nbytes)
      IF(nbytes.eq.0)then
        write(LERR, *)'EOF on secondarey input data set.  OPSTR ending'
        go to 999
      endif
c     irec = trhdi2(l_RecNum)
      call saver2(trhdi2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            irec , TRACEHEADER)
      IF(irec.ge.rs) THEN
        IREAD=1
      ELSE
        GO TO 307
      ENDIF

      inknt2 = 0
      do nx = 1,ntrc2
        if(iread.eq.0)then
          nbytes = 0
          call rtape(lui2,itr,nbytes)
        endif
        iread = 0
        if(nbytes .eq. 0) then
         write(lerr,'(5x,a)')'End of file on secondary input:'
         write(lerr,'(5x,a,1x,i4,a,1x,i4)')' Rec = ',irec,' Trace= ',nx
        go to 999
        endif
        inknt2 = inknt2 + 1
c       call saver(itr,'DstSgn',ioff,TRCHED)
c       ioff = trhdi2 (l_DstSgn)
        call saver2(trhdi2,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1              ioff , TRACEHEADER)
        off=float(iabs(ioff))
        xoff(nx)=off
        xoffv2(nx) = off*xmul
        xoffv2(nx) = xoffv2(nx)*xoffv2(nx)
        ndx = (inknt2-1)*nsamp2
        k=ITHWP1-1
        do i=1,nsamp
          dhold2(ndx+i)=ritr(k+i)
        end do
C +--------------------+
C | SAVE TRACE HEADERS |
C +--------------------+
c       call vmov(itr,1,itrhd2(1,inknt2),1,ITRWRD)
           ntx   = (inknt2-1)*ITRWRD + 1
           call vmov(trhdi4,1,itrhd2(ntx),1,ITRWRD)

      end do

      ENDIF
C +=================================+
C |   Apply a mute to the scan data |
C +=================================+
      if(vmin.ne.0.0.or.vmax.ne.0.0)then
        call velmute(dhold,nsamp,np,vmin,vmax,v0,sr,p)
      endif
      if(mute)then
        call getmute(iirec,jr,mutes,nsets,nsamp,cmute)
        call appmute(dhold,nsamp,ntrc,cmute)
      endif
      if(vf1.ne.0.0.and.(vf3.ne.0.0.or.vf2.ne.0.0))then
       if(vf2.ne.0.0.and.vf3.eq.0.0)then
         vf3=vf2
         vf2=0.0
         tf3 =tf2
         tf2=0.0
       endif
       if(vf2.eq.0.0)vf2=vf1
       if(vf2.lt.vf1)vf2=vf1
       if(tf2.eq.0.0)tf2=tf1
       if(vf4.eq.0.0)vf4=vf3
       if(tf4.eq.0.0)tf4=tf3
       call vfilt(dhold,nsamp,p,np,vf1,tf1,vf2,tf2,vf3,tf3,vf4,tf4,
     :   v0,sr,ier)
       if(ier.ne.0)go to 999
      end if
      xnp = float(np)
      do 202 nx = 1,noff
        ioff = xoff(nx)
        xx = xoffv2(nx)
        do i=1,nsamp
          sumbuf(i)=0.
          Live(i)=0.
        end do
C +==============================================+
C |   For each input trace compute the shift and |
C |   sum the shifted trace into the sum buffer  |
C +==============================================+
        do 201 jp = 1,np
          ld  = (jp-1)*nsamp
          do j=1,nsamp
           hs(ld+j)=0.
          end do
          shft = sqrt(p2(jp) + xx) - p(jp)
          shft = -shft/sr
          if(abs(shft).le.nsamp)then
            call statapp(dhold(ld+1),nsamp,hs(ld+1),shft)
          endif
  201   CONTINUE
C   +=====================================+
C   | Compute and Normalize the stack for |
C   | the number of live samples summed   |
C   +=====================================+
         do jp=1,np
          ndx=(jp-1)*nsamp
          do j=1,nsamp
           sumbuf(j)=sumbuf(j)+hs(ndx+j)
          end do
         end do

         do i=1,nsamp
          data(i)=sumbuf(i)/xnp
         end do
c        if(fw)then
c          call rho(data,nsamp,data,sr,ierr)
c        endif
C +=================+
C | Output the data |
C +=================+
         if(lui2 .gt. 1)then
          ndx2 = (nx-1)*nsamp2
          call hilbertx(dhold2(ndx2+1),nsamp2,fwork,ierr)
          call hilbertx(data,nsamp,hwork,ierr)
          do i=1,nsamp2
           dh2 = dhold2(ndx2+i)
           fwork(i)=sqrt(fwork(i)*fwork(i)+dh2*dh2)
          end do
          do i=1,nsamp
           hwork(i)=sqrt(hwork(i)*hwork(i)+data(i)*data(i))
           if(hwork(i).ne.0)then
             data(i)=data(i)*fwork(i)/hwork(i)
           else
             data(i)=0.
           endif
           if(dhold2(ndx2+i).eq.0.0)data(i)=0.
          end do
         endif

         call vmov(data,1,itr(ITHWP1),1,nsamp)

         if(lui2 .le. 1)then
            ntx = (nx-1)*ITRWRD + 1
            call vmov(itrhd (ntx),1,trhdi4,1,ITRWRD)
c           trhdi2(l_StaCor) = 0
c           trhdi2(l_TrcNum) = nx
c           trhdi2(l_DstSgn) = ioff
c           trhdi2(l_DstUsg) = iabs(ioff)
            call savew2(trhdi2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                  0    , TRACEHEADER)
            call savew2(trhdi2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                  nx   , TRACEHEADER)
            call savew2(trhdi2,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                  ioff , TRACEHEADER)
            ioffa = iabs (ioff)
            call savew2(trhdi2,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                  ioffa, TRACEHEADER)
         else
            ntx = (nx-1)*ITRWRD + 1
            call vmov(itrhd2(ntx),1,trhdi4,1,ITRWRD)
         endif

         call wrtape(luout,itr,mbytes)
  202 CONTINUE
      rs=rs+1
      IF (rs.LE.re) GOTO 306
  999 CONTINUE
      CALL LBCLOS( LUIN)
      CALL LBCLOS(LUOUT)
      if (lui2 .gt. 1) call lbclos (lui2)
      call ccexit(0)
      END
C***********************************************************************
      SUBROUTINE prparm(ntap,ntap2,otap,re,rs,v1,t1,v2,t2,v3,t3,
     :v4,t4,rho)
C
#include <f77/iounit.h>
      INTEGER     rs,re
C
      character ntap*256, otap*256,pipe*50,ntap2*256
      logical   rho
C
      pipe = 'pipe'
  420 CONTINUE
      WRITE(LERR,'(10X,A     )')' '
      WRITE(LERR,'(10X,A     )')'  INPUT PARAMETERS AFTER DEFAULTS'
      if(ntap.ne.' ')then
      WRITE(LERR,'(10X,2A)')    'Input data set............',
     :ntap(1:50)
      else
      WRITE(LERR,'(10X,2A)')    'Input data set............',pipe
      endif
      WRITE(LERR,'(10X,2A)')    'Secondary input data set..',ntap2(1:50)
      if(otap.ne.' ')then
      WRITE(LERR,'(10X,2a)')    'Output data...............',otap(1:50)
      else
      WRITE(LERR,'(10X,2A)')    'Output data...............',pipe
      endif
      WRITE(LERR,'(10X,A,I6  )')'Start Record .............',rs
      WRITE(LERR,'(10X,A,I6  )')'End Record ...............',re
      WRITE(LERR,'(10X,A     )')'Velocity mute parameters:'
      WRITE(LERR,'(10X,A,F7.1)')'V1........................',v1
      WRITE(LERR,'(10X,A,F7.1)')'T1........................',t1
      WRITE(LERR,'(10X,A,F7.1)')'V2........................',v2
      WRITE(LERR,'(10X,A,F7.1)')'T2........................',t2
      WRITE(LERR,'(10X,A,F7.1)')'V3........................',v3
      WRITE(LERR,'(10X,A,F7.1)')'T3........................',t3
      WRITE(LERR,'(10X,A,F7.1)')'V4........................',v4
      WRITE(LERR,'(10X,A,F7.1)')'T4........................',t4
      if(rho)then
        write(lerr,*)' rho filter to be applied'
      endif
      RETURN
      END
C
      subroutine gcmdln(ntap,ntap2,otap, rs, re,vmin,vmax,mutef,
     :fw,vf1,tf1,vf2,tf2,vf3,tf3,vf4,tf4,IKP,fl,fh)
c     Modified by R. L. Crider 4-27-90
c                                     
c     this routine processes the command line arguments for use in
c     the program.
c                                                               
      logical fw, IKP

      integer rs, re,argis

      character ntap*256, otap*256, mutef*256,ntap2*256
      character ttap*256


      IKP = .false.
	  ntap = ' '
      call argstr ('-N1',ntap,' ',' ')          
      if(ntap.eq.' ')then
        call argstr ('-N',ttap,' ',' ')
        if(ttap(1:1).ne.'2')then
         call argstr ('-N2',ntap2,' ',' ')
         ntap=ttap
        else
         ntap=' '
         j=2
         do i=1,99
         ntap2(i:i)=ttap(j:j)
         j=j+1
         end do
        endif
      else
       call argstr ('-N2',ntap2,' ',' ')
      endif
      otap = ' '
      call argstr ('-O',otap,' ',' ')            
      mutef = ' '
      call argstr('-mf',mutef,' ',' ')
      call argi4('-rs',rs,0,0)
      call argi4('-re',re,0,0)
      call argr4('-vm',vmin,0.0,0.0)
      call argr4('-vx',vmax,0.0,0.0)
      fw      = (argis('-W').gt.0)
      IKP     = (argis('-IKP').gt.0)
      if(.not.fw)then
        fw = (argis('-rho').gt.0)
      endif
      call argr4('-v1',vf1,0.0,0.0)
      call argr4('-t1',tf1,0.0,0.0)
      call argr4('-v2',vf2,0.0,0.0)
      call argr4('-t2',tf2,0.0,0.0)
      call argr4('-v3',vf3,0.0,0.0)
      call argr4('-t3',tf3,0.0,0.0)
      call argr4('-v4',vf4,0.0,0.0)
      call argr4('-t4',tf4,0.0,0.0)
      call argr4('-fl',fl,0.0,0.0)
      call argr4('-fh',fh,0.0,0.0)
      return                                                  
      end
      subroutine help(ler)
          write(LER,*)  
     :'***************************************************************'
         write(LER,*)'PROGRAM OPSTR.........Offset Data Reconstruction'
         write(LER,*)' '                                             
         write(LER,*)                                               
     :' -N1 [ntap]     (default = stdin) : Input data file name'   
         write(LER,*)                                               
     :' -N2 [ntap2]    (default = none)  : Original data set'      
         write(LER,*)                                             
     :' -O [otap]      (default = stdout): Output data file name'
         write(LER,*)                                             
     :' -mf [mutefile] (optional)        : Mute function to be applied'
         write(LER,*)                                        
     :' -rs [rs]   (default = first)     : First record to process'
         write(LER,*)                                             
     :' -re [re]   (default = last)      : Last record to process'
c        write(LER,*)                                           
c    :' -vm [vmin]   (default = no mute) : Minimum Mute Velocity'
c        write(LER,*)                                           
c    :' -vx [vmax]   (default = no mute) : Maximum Mute Velocity'
         write(LER,*)                                        
     :' -v1 [v1]   (default = no mute)   : Start surgical mute velocity'
         write(LER,*)                                             
     :' -t1 [t1]   (default = 0)         : Start surgical mute time'
         write(LER,*)                                           
     :' -v2 [v2]     (default = v1)      : Start/end mute velocity'
         write(LER,*)                                           
     :' -t2 [t2]     (default = t1)      : Start/end mute time'
         write(LER,*)                                        
     :' -v3 [v3]   (default = no mute)   : End surgical mute velocity'
         write(LER,*)                                             
     :' -t3 [t3]   (default = 0)         : End surgical mute time'
         write(LER,*)                                           
     :' -v4 [v4]     (default = v3)      : End surgical mute velocity'
         write(LER,*)                                           
     :' -t4 [t4]     (default = t3)      : End surgical mute time'
         write(LER,*)                                           
     :' -rho [rho]   (default = no)      : If present, apply rho filter'
         write(LER,*)                                           
     :'                                    to compensate for low-pass'
         write(LER,*)                                           
     :'                                    filtering of transform'
         write(LER,*)                                        
     :' -fl [fl]   (default = 0)         : Minimum frequency for rho'
         write(LER,*)                                             
     :' -fh [t3]   (default = Nyquist)   : Maximum frequency for rho'
          write(LER,*)  
     :'***************************************************************'
       write(LER,*)                                        
     :'Usage:  ',                                         
     :' opstr -N1[] -N2[] -O[] -mf[] -rs[] -re[] -v1[] -t1[] -v2[]',
     :' -t2[] -v3[] -t3[] -v4[] -t4[] -rho -fl[] -fh[]'
       write(LER,*)                                     
     :'***************************************************************'
      return                                                          
      end                                                            
      subroutine vfilt(x,lx,tp,np,v1,t1,v2,t2,v3,t3,v4,t4,v0,sr,ier)

#include <f77/lhdrsz.h>

      real x(*), v1,t1,v2,t2,tp(*),v3,t3,v4,t4
      integer lx,np
      real v(1),time(1),t,vedg1,vedg2
      POINTER (pv,v),(pt,time)

      iword = SZSMPD
      ierr = 0
      ier = 0
      iab = 0
      iget = iword*np*lx
      call galloc(pv,iget,ierr,iab)
      if(ierr.ne.0)then
        ier = ierr
        return
      endif
      iget = iword*lx
      call galloc(pt,iget,ierr,iab)
      if(ierr.ne.0)then
        ier = ierr
        return
      endif
      do i=1,lx
       time(i)=(i-1)*sr
      end do
      do j=1,np
       ndx=(j-1)*lx
       v(ndx+1)=v0
       do i=2,lx
        v(ndx+i)=v0*sqrt(tp(j)/time(i))
       end do
      end do
      if(v2.ne.v1.and.v3.ne.v4)then
       do j=1,np
        ndx=(j-1)*lx
        do i=1,lx
         vv = v(ndx+i)
         t = time(i)
         if((t.ge.t1.or.t.ge.t2).and.
     :     (t.le.t3.or.t.le.t4))then
          vedg1 = (v3-v1)/(t3-t1)*(t-t1)+v1
          vedg2 = (v4-v2)/(t4-t2)*(t-t2)+v2
          if(vv.ge.vedg1.and.vv.le.vedg2)then
            x(ndx+i)=0.
          endif
         endif
        end do
       end do
      else
       do j=1,np
        ndx=(j-1)*lx
        do i=1,lx
         vv = v(ndx+i)
         t = time(i)
         if(t.ge.t1.and.t.le.t3)then
          vedg1 = (v3-v1)/(t3-t1)*(t-t1)+v1
          if(vv.le.vedg1)then
            x(ndx+i)=0.
          endif
         endif
        end do
       end do
      endif
      call gfree(pv)
      call gfree(pt)
      return
      end
