C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE POL2 - adaptive polarization filter for 2 components
C
C**********************************************************************C
C
C POL2 reads 2-component trace data from input tape,
C then for each specified frequency band
C computes a time varying ground roll filter & applies it,
C then dagc's the results for each band, vertically stacks a' la' DAFD
C then writes the filtered traces to output tape
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, polfil2,polfilr2,polstat2,
C                   eigen2, DAGC, DAGR, VMULT
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

      parameter (pi=3.14159265)

      INTEGER     ITR( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN, LUOUT,LBYTES,NBYTES,lbyout,obytes
      integer     argis,lw,rs,re,ist,iend,npad,ordfft

      complex     datas(SZLNHD),datat(SZLNHD)
      complex     data1(SZLNHD),data2(SZLNHD)

      REAL        xtr1(SZLNHD), vtrin(SZLNHD), x11(SZLNHD)
      REAL        rtrin(SZLNHD),vtrout(SZLNHD),x22(SZLNHD)
      real        rtrout(SZLNHD),xtr2(SZLNHD),x1(SZLNHD)
      real        x2(SZLNHD),amp,wn(100), x3(SZLNHD)
      real        agcsav(SZLNHD)
      real        xtr(SZLNHD),pstate(3),alfa(100),filtf(SZLNHD,100)
      CHARACTER   NAME * 4,  card * 80, ntap * 256, otap * 256
#include <f77/pid.h>
      logical     verbos,query,rot,agc,pol,surf
 
c     EQUIVALENCE ( ITR(129), xtr(1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      EQUIVALENCE ( x1(1), datas(1) )
      EQUIVALENCE ( x2(1), datat(1) )
      EQUIVALENCE ( x11(1), data1(1) )
      EQUIVALENCE ( x22(1), data2(1) )
      DATA NAME     /'POL2'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /,lw/500/,amp/307.05/
      DATA  x3/SZLNHD*0.0/
      data verbos/.false./

c--------------------------------
c  get online help if necessary

      query = (argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if(query) then
            call help()
            stop
      endif


c--------------------------------
c  open printout file
#include <f77/open.h>


C**********************************************************************C
C     RREAD PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln(ntap,otap,iwnd,npad,ist,iend,theta,nrect,ndir,
     1           isrc,ns,ne,rs,re,fl,fh,nf,lw,
     2           aa,bb,cc,alfa1,alfa2,th,agc,rot,pol,verbos)

C**********************************************************************C
C     open I/O units, save key line header values, adjust line, write
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      lbytes = 0
      CALL RTAPE  ( LUIN, ITR, lbytes           )
      if(lbytes .eq. 0) then
         write(LERR,*)'POL2: no header read on input for ',ntap
         write(LERR,*)'Check to see if it exists'
         stop 911
      endif

      call saver(itr, 'NumSmp', nsamp , LINHED)
      call saver(itr, 'SmpInt', nsi   , LINHED)
      call saver(itr, 'NumTrc', ntrc  , LINHED)
      call saver(itr, 'NumRec', nrec  , LINHED)
      call saver(itr, 'Format', iform , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('ToStUn',ifmt_ToStUn,l_ToStUn,ln_ToStUn,TRACEHEADER)
      call savelu('ToTmAU',ifmt_ToTmAU,l_ToTmAU,ln_ToTmAU,TRACEHEADER)

c----------------------------------------------
c  check for # components, set output line hdr
      call saver(itr, 'RATTrc', ntuple, LINHED)
c     call savew(itr, 'RATTrc',   2   , LINHED)
     
      CALL HLHprt ( ITR, LBYTES, NAME, 4, LERR)
      call savhlh( itr, lbytes, lbyout)

c-----------------------------
c  check command line entries

      call cmdchk( ns, ne, rs, re, ntrc, nrec)
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      nrecc=re-rs+1
      thet=theta
      theta=theta*pi/180.
      pstate(1)=cos(theta)
      pstate(2)=sin(theta)

c----------------------------------------------------
c  figure out number of 2-compt groups in each ntuple
c----------------------------------------------------
      npass = ntuple/2
      if(mod(ntuple,2) .ne. 0) then
         write(LERR,*)'Number of components not a multiple of 2'
         write(LERR,*)'Check input data set & recreate if necessary'
         write(LERR,*)'It also might be possible to use postsort to'
         write(LERR,*)'select out the required components'
         write(LERR,*)'Check the manual & seek assistance'
         stop
      endif
      ns1 = ns/ntuple
      ne1 = ne/ntuple
      if(ns1 .lt. 1) ns1 = 1
      if(ne1 .lt. 1) ne1 = 1


c----------------------------
c  print out header vealues

c     if( verbos ) then
	write(LERR,*)' '
	write(LERR,*)'Values read from input data set line header'
	write(LERR,*)
	write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Start/End records  =  ', rs,re
        write(LERR,*) ' Start/End traces   =  ', ns1,ne1
        write(LERR,*) ' Number Components  =  ', ntuple,' (ntuple)'
        write(LERR,*) ' Number 2-compts in each ntuple =  ',npass
        write(LERR,*) ' Polarzn. angle     =  ',thet
        write(LERR,*) ' pstate(1)          =  ',pstate(1)
        write(LERR,*) ' pstate(2)          =  ',pstate(2)
c     endif

C**********************************************************************C
C     CHECK CARD DEFAULTS AND SET PARAMETERS
C**********************************************************************C
      iwind=iwnd/nsi
      iwinda=0
      iflg=1
      if(iwind .lt. 0) then
        iwinda=-2*iwind
        iflg=-1
      endif
      if(iwind .eq. 0) iflg=0
      llw=lw/nsi
      iend=iend/nsi + .5
      ist=ist/nsi
      if(ist .le. 1) ist=1
      if(iend .eq. 0) iend=nsamp
      if(iend .gt. nsamp) iend=nsamp
      jtrc=ne-ns+1
      nsampo=iend-ist+1

c-------------------------------------
c  reset header vealues


       call savew( itr, 'NumTrc', jtrc   , LINHED)
       call savew( itr, 'NumRec', nrecc  , LINHED)
       call savew( itr, 'NumSmp', nsampo , LINHED)

      obytes = SZTRHD + SZSMPD * nsampo
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

       dt = float(nsi) * unitsc

      if( verbos ) then
	write(LERR,*)
	write(LERR,*)' Line header values after default check '
	write(LERR,*)
	write(LERR,*) ' # of Samples/Trace =  ', nsampo
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', jtrc 
        write(LERR,*) ' Records per Line   =  ', nrecc
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Source type =  ',isrc
        if(pol) then
           write(LERR,*)' Polar & Azmth ang  = ',thet,phit	
        endif
        write(LERR,*) ' Rectilinearity pwr = ',nrect
        write(LERR,*) ' Direction filt pwr = ',ndir
        write(LERR,*) 'ROT = ',rot
        write(LERR,*) 'AGC = ',agc
        write(LERR,*) 'POL = ',pol
      endif

c---------------------------------------------------------
c   compute powers of 2
c   compute gaussian center frequencies
c   ... and set up alpha parameter for gaussian filters
c
c     call pwrof2(nsamp+npad,ipwr2)
      ipwr2 = ordfft (nsamp+1)
      nspad = 2**ipwr2
      n21 = nspad/2 + 1
      df = 0.5/(dt*float(n21))
      if(alfa2 .ne. 0.) alfa1=0.
      fnyq = 1./(2.*dt)
      nper = 0
      do 5 ii=1,nf
         ww = fmap(real(ii),aa,bb,cc)
         if(ww.ge.fl .and. ww.le.fh) then
            nper=nper+1
            wn(nper)=ww
	    alfa(nper) = alfa1 + alfa2 * ww*ww
         endif
    5 continue
      nf=nper
      xsc = 1./float(nf)
      write(LERR,*)'nspad= ',nspad,' nsampo= ',nsampo
      write(LERR,*)'nper= ',nper,' df= ',df,' fft length= ',n21

c----------------------------------------------------------
c  compute gaussian filters & store in a matrix

      DO  10   jf =  1, nper
          fup = 1.25 * wn(jf)
          flo = 0.75 * wn(jf)
          do 11 i = 1, n21
                f = df * float(i-1)
                if(f.ge.flo .and. f.le.fup) then
                    filtf(i,jf) = exp( -alfa(jf) *
     1                                 ( (f-wn(jf))/wn(jf) )**2 )
                else
                    filtf(i,jf) = 0.
                endif
   11     continue
   10 CONTINUE


C**********************************************************************C
C     read traces (2-comp), chop into freq bands, compute rect function,
C**********************************************************************C

      istart=0
c-------------------------
c  skip records
      call recskp(1,rs-1,luin,ntrc,itr)

c----------------------------------------------------------------
c   main processing loop
c----------------------------------------------------------------

      DO 100 JJ = rs, re

c--------------------------------------------------
c  skip traces: each trace here is actually a
c  group of ntuple traces (components)
            call trcskp(jj,1,(ns-1)*ntuple,luin,ntrc,itr)
c--------------------------------------------------

c--------------------
c  loop over ntuples
c  or groups
c--------------------
           DO 99 KK = ns1, ne1

c-------------------
c  clear agc storage
c  array
              call vclr (agcsav, 1, nsamp)

c------------------
c  loop over number
c  of 2-compts in
c  ntuple
c------------------
             do 98  LL = 1, npass

c-----------------
c read first compt
c-----------------
              CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input1:'
                  write(LERR,*)'lpass= ',ll,'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)
               call saver2(lhed,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                     i115   , TRACEHEADER)
               call saver2(lhed,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                     i116   , TRACEHEADER)
               call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     irec1  , TRACEHEADER)
               call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     itrc1  , TRACEHEADER)
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istat1 , TRACEHEADER)

               call vmov(xtr(ist),1,xtr1,1,nsampo)
c------------------
c read second compt
c------------------
              CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input2:'
                  write(LERR,*)'lpass= ',ll,'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)
               call saver2(lhed,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                     i215   , TRACEHEADER)
               call saver2(lhed,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                     i216   , TRACEHEADER)
               call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     irec2  , TRACEHEADER)
               call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     itrc2  , TRACEHEADER)
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istat2 , TRACEHEADER)

               if( verbos ) then
                  write(LERR,*)'JJ= ',jj,'  KK= ',kk,'  LL= ',ll
                  write(LERR,*)'Component 1 = ',i115,i116,'  rec= ',
     1                           irec1,' trc= ',itrc1
                  write(LERR,*)'Component 2 = ',i215,i216,'  rec= ',
     1                           irec2,' trc= ',itrc2
               endif

               call vmov(xtr(ist),1,xtr2,1,nsampo)
c------------------------------
c  zero out output vectors
               call vclr(vtrout,1,nsamp)
               call vclr(rtrout,1,nsamp)

c-----------------------------
c check for dead component
c              IF(istat1 .ne. 30000 .and. istat2 .ne. 30000) then
 
               do 1009 jf=1,nf

c  option to successively 1/2 each freq band window
                   if(iflg .lt. 0) then
                      if(jf .eq. 1) iwind=iwinda
                      iwind=iwind/2
                      if(iwind .lt. 10) iwind=10
                   endif

c  option to allow mid point of current freq band to deterimine window
                   if(iflg .eq. 0) then
                     tm=1000/wn(jf)
                     iwind=tm/nsi
                     if(iwind .lt. 5) iwind=5
                   endif
                   if(jf .eq. 1) lwagc=iabs(llw)
                   if(lw .eq. 0) lwagc=4*iwind+1
                   if(lw .lt. 0) then
                      if(jf .gt. 1) lwagc=lwagc/2
                      if(lwagc .lt. 2*iwind) lwagc=2*iwind
                   endif
c  ... otherwise use constant window lenght ...

                   if(jj .eq. rs .and. kk .eq. ns) then
                       write(LERR,*)'f0= ',wn(jf),' iwind= ',iwind,' th=
     &                              ',th,'  LW= ',lwagc
                   endif

c   apply current freq coefficients

c-------------------------------------------------------
c   filter each input component with current freq band
c   by fft'ing the original data (once for each ntuple)
c   then multiplying by the gaussian filter, then 
c   fft'ing back to time
c-----
                   if(jf .eq. 1) then
                        call cvfill(cmplx(0.,0.),datas,1,nspad)
                        call cvfill(cmplx(0.,0.),datat,1,nspad)
                        call vmov(xtr1,1,x1,1,nsampo)
                        call vmov(xtr2,1,x2,1,nsampo)
                        call RFFT(x1,nspad,1)
                        call RFFT(x2,nspad,1)
c                       call RFFTSC(datas,nspad,0,1)
c                       call RFFTSC(datat,nspad,0,1)
                   endif

                   do 1001  i = 1, n21
                         data1(i) = cmplx(filtf(i,jf),0.)*datas(i)
                         data2(i) = cmplx(filtf(i,jf),0.)*datat(i)
 1001              continue
                   call RFFT(data1,nspad,-1)
                   call RFFT(data2,nspad,-1)
 
c------------------------------------------------
c   do dagc before on component isrc
c   then accumulate sqrt(agc) curve

                  if(isrc .eq. 0) then
                      call dagr(nsampo,lwagc,amp,x11,x22,x3,xtr)
                      call vmul (x11, 1, xtr, 1, x11,  1, nsampo)
                      call vmul (x22, 1, xtr, 1, x22,  1, nsampo)
                  endif
                  if(isrc .eq. 1) then
                      call dagc(nsampo,lwagc,amp,x11,xtr)
                      call vmul (x11, 1, xtr, 1, x11,  1, nsampo)
                      call vmul (x22, 1, xtr, 1, x22,  1, nsampo)
                  endif
                  if(isrc .eq. 2) then
                      call dagc(nsampo,lwagc,amp,x22,xtr)
                      call vmul (x11, 1, xtr, 1, x11,  1, nsampo)
                      call vmul (x22, 1, xtr, 1, x22,  1, nsampo)
                  endif

                  call vsqrt (xtr, 1, xtr, 1, nsampo)
                  call vadd  (xtr, 1, agcsav, 1, agcsav, 1, nsampo)

c---------------------------------------------
c  do polarization filtering on narrow bands
                 if    ( ROT ) then
                     call polfilr2(nsampo,x11,x22,vtrin,rtrin,iwind,th,
     &                               nrect,ndir)
                 elseif( AGC ) then
                     call polfil2(nsampo,x11,x22,vtrin,rtrin,iwind,th,
     &                             nrect)  
                 elseif( POL) then
                     call polstat2(nsampo,x11,x22,vtrin,rtrin,iwind,
     &                             pstate, th,nrect,ndir) 
                 else
                     call vmov(x11,1,vtrin,1,nsampo)
                     call vmov(x22,1,rtrin,1,nsampo)
                 endif
 
c---------------------------------------------------------
c   vertical stack current freq result with previous ones

                 call vadd (vtrin, 1, vtrout, 1, vtrout, 1, nsampo)
                 call vadd (rtrin, 1, rtrout, 1, rtrout, 1, nsampo)

c-----------------------
c  end freq loop
 1009          continue

c---------------------------------
c   output results
c  and end of dead component check
c              ENDIF

c---------------
c  compute inv
c  agc curve
               call vsmul (agcsav, 1, 1./float(nf), agcsav, 1, nsampo)
               call vsq   (agcsav, 1, agcsav, 1, nsampo)

               call vmov  (vtrout, 1, xtr, 1, nsampo)
               call vsmul (xtr, 1, xsc, xtr, 1, nsampo)
c---------------
c  unapply agc
               call vdiv  (xtr, 1, agcsav, 1, lhed(ITHWP1), 1, nsampo)
               call savew2(lhed,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                     i115   , TRACEHEADER)
               call savew2(lhed,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                     i116   , TRACEHEADER)
               call wrtape (luout,itr,obytes)
               call vmov  (rtrout, 1, xtr, 1, nsampo)
               call vsmul (xtr, 1, xsc, xtr, 1, nsampo)
c---------------
c  unapply agc
               call vdiv  (xtr, 1, agcsav, 1, lhed(ITHWP1), 1, nsampo)
               call savew2(lhed,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                     i215   , TRACEHEADER)
               call savew2(lhed,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                     i216   , TRACEHEADER)
               call wrtape (luout,itr,obytes)

c----------------
c  end npass loop
c----------------
   98       continue

c------------------
c  end group loop
c------------------
   99      CONTINUE

c--------------------------------------------------
c  skip traces: each trace here is actually a
c  group of ntuple traces (components)
            call trcskp(jj,ne*ntuple+1,ntrc,luin,ntrc,itr)
c--------------------------------------------------

c-----------------
c  end record loop
c-----------------
  100 CONTINUE

c----------------
c  end of data
c----------------
  999 continue
	call lbclos(luin)
        call lbclos(luout)
      END

	function fmap(x,aa,bb,cc)
		real*4 fmap
		real*4 x
		real*4 aa,bb,cc
c-----
c	this general function defines the mapping between 
c	array index I and the center frequency of the 
c gaussian filter
c
c	changing this routine will change the frequency sampling
c	throughout the program
c-----
        fmap = aa + bb*x + cc*alog10(x)
	return
	end

c----------------------------------------------
c  online help

      subroutine help
#include <f77/iounit.h>

        write(LER,*)'Here Are the Command Line Parameters for POL2'
        write(LER,*)'               -- 2-compnt ground roll filter'
        write(LER,*)' '
        write(LER,*)'Input........................................(def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap] -- input data set name'
        write(LER,*)'-O[otap] -- output data set name'
        write(LER,*)'-s[ist]  -- start time                      (0 ms)'
        write(LER,*)'-e[iend] -- end time                   (last samp)'
c       write(LER,*)'-pd[np2] -- number points to pad trace  ( 1024 )'
        write(LER,*)'-ns[nstr]-- start trace #               (first tr)'
        write(LER,*)'-ne[netr]-- end trace #                  (last tr)'
        write(LER,*)'-rs[nrst]-- start record               (first rec)'
        write(LER,*)'-re[nred]-- end record                  (last rec)'
        write(LER,*)'-w[iwnd] -- adaptive window: '
        write(LER,*)'         if 0, freq band picks window length'
        write(LER,*)'         if (-iwnd), window 1/2 ed each higher frq'
        write(LER,*)'         if (+iwnd), window constant with freq'
        write(LER,*)'-theta[] -- polar scan angle with resp to vertical'
        write(LER,*)'-NR[nrec]-- power of rectilinearity filter   ( 2 )'
        write(LER,*)'-DR[ndir]-- power of direction filter        ( 2 )'
        write(LER,*)'-fl[fl]  -- lo-cut filter freq'
        write(LER,*)'-fh[fh]  -- hi-cut filter freq'
        write(LER,*)'-nf[nf]  -- # filter bands to divide fh - fl ( 2 )'
        write(LER,*)'-lw[lw]  -- length of dafd window          ( 500 )'
        write(LER,*)'-T[th]   -- threshold below which rect filter is 0'
        write(LER,*)'-S[isrc] --source type specifies on which comp agc'
        write(LER,*)'          is done: 1=V; 2=R; 3=T; 0=V+R+T resltant'
        write(LER,*)'-E       -- enhance motion along orig. coords axes'
        write(LER,*)'-G         -- do rectilinearity filter only'
        write(LER,*)'-P       -- scan in direction given by theta & phi'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)' '
        write(LER,*)' pol2 -N[] -O[] -w[] -s[] -e[] -ns[] -ne[] -rs[]'
        write(LER,*)'       -re[] -fl[] -fh[] -nf[] -lw[] -t[] -V '
        write(LER,*)' '

      return
      end

      subroutine cmdln(ntap,otap,iwnd,np2,ist,iend,theta,nrect,ndir,
     1           isrc,ns,ne,rs,re,fl,fh,nf,lw,
     2           aa,bb,cc,alfa1,alfa2,th,agc,rot,pol,verbos)

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     np2   - I      trace pad (samples)
c    iwnd   - I      polarization window
c     ist   - I      start time
c    iend   - I      end time
c      ns   - I      start trace
c      ne   - I      stop end trace
c      rs   - I      start record
c      re   - I      stop end record
c   theta   - R      direction angle
c    dmax   - R      max distance to stack
c     th    - I      threshold for rectilinearity
c     fl    - R      lo-cut frequency
c     fh    - R      hi-cut frequency
c     nf    - I      number frequency bands
c     lw    - I      agc window
c   nrect   - I      exponent for rect function
c    ndir   - I      exponent for direction function
c    isrc   - I      compute agc on this comp
c     aa    - R      factors governing shape of gaussian filters
c     bb    - R      
c     cc    - R      
c   alfa1   - R      
c   alfa2   - R      
c    norm   - L      normalize stacked trace by # live traces
c     agc   - L      rect function only
c     rot   - L      rect + enhance principle comps
c     pol   - L      rect + enhance along specified direction
c    verbos - L      verbose output or not
c-----
#include <f77/iounit.h>

      character      ntap*(*), otap*(*)
      integer        iwnd,lw,nf,ist,iend,ns,ne,rs,re, argis
      integer        isrc,nrect,ndir,np2
      real           theta,fl,fh,aa,bb,cc,alfa1,alfa2
      logical        verbos, agc, rot, pol

          call argstr('-N',ntap,' ',' ')
          call argstr('-O',otap,' ',' ')
          call argi4('-w',iwnd,0,0)
          call argr4('-T',th,.95,.95)
          call argi4('-pd',np2,1024,1024)
          call argi4('-s',ist,1,1) 
          call argi4('-e',iend,0,0) 
          call argr4('-theta',theta,0.,0.)
          call argi4('-NR',nrect,2,2)
          call argi4('-DR',ndir,1,1)
          call argi4('-S',isrc,0,0)
          call argi4('-ns',ns,1,1)
          call argi4('-ne',ne,0,0)
          call argi4('-rs',rs,1,1)
          call argi4('-re',re,0,0)
          call argr4('-fl',fl,1.,1.)
          call argr4('-fh',fh,0.,0.)
          call argi4('-nf',nf,50,50)
          call argi4('-lw',lw,500,500)
          call argr4('-aa',aa,5.,5.)
          call argr4('-bb',bb,2.,2.)
          call argr4('-cc',cc,0.,0.)
          call argr4('-A',alfa1,50.27,50.27)
          call argr4('-B',alfa2,.01,.01)
          verbos = ( argis( '-V' ) .gt. 0 )
          rot   = ( argis('-E') .gt. 0)
          agc   = ( argis('-G') .gt. 0)
          pol   = ( argis('-P') .gt. 0)
          write(LERR,*)'agc,rot,pol= ',agc,rot,pol

      return
      end
