C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine polfilr3(n,x1,x2,x3,vtrin,rtrin,ttrin,iwin,th,nrect,
     1                   ndir)
c
c  subroutine to compute & apply ground roll filter to 3 components
c
c  input:
c        n -- number of input data points
c   x1,2,3 -- 3 input channels, vert, radl, trans
c      thr -- threshold, determines zeroing of rect function
c      ist -- sample at which to start processing
c     iwin -- sliding window length
c    nrect -- power to raise rect function
c     ndir -- power to raise direction function
c
c  output:
c   vtrin  -- vertical filtered output (ditto for rtrin & ttrin)
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
      dimension x1(*),x2(*),x3(*),vtrin(*),rtrin(*),ttrin(*)
      real      q11(SZSMPM),q12(SZSMPM),q22(SZSMPM)
      real      q13(SZSMPM),q23(SZSMPM),q33(SZSMPM)
      real      eig(3),quad(9),eigv(9),work1(9),work2(9)
      real      lmda1,lmda2,sum11,sum12,sum22,sum13,sum23,sum33
c
      icomp = 3
      ist=1
      iwin2=iwin/2
      ist0=ist
c   don't start pocessing unless we're at least 1/2 window length into trace
      if(iwin2 .gt. ist) ist0=iwin2
      ist1=ist0+1
c   stop processing when we're within 1/2 window length of end of trace
      nw=n-iwin2
 
c   Loop to calculate 0-lag cross correlation coefficients of  V, R, T
c
c   q11 = V * V; q22 = R * R; q33 = T * T; 
c   q12 = V * R; q13 = V * T; q23 = R * T
c
         call vmul (x1,1,x1,1,q11,1,n)
         call vmul (x1,1,x2,1,q12,1,n)
         call vmul (x1,1,x3,1,q13,1,n)
         call vmul (x2,1,x2,1,q22,1,n)
         call vmul (x2,1,x3,1,q23,1,n)
         call vmul (x3,1,x3,1,q33,1,n)
c
c   Main DO LOOP for calculating filter
      DO 100  i=ist1,nw
c    start & end of current window position
         istart=i-iwin2+1
         iend  =i+iwin2
c    for first window position we need to compute complete correlation...
         IF(i .eq. ist1) THEN
             sum11=0.
             sum12=0.
             sum22=0.
             sum23=0.
             sum13=0.
             sum33=0.
c     ... i.e. sum over all values in window
             do 10  j=istart,iend
                    sum11=sum11+q11(j)
                    sum12=sum12+q12(j)
                    sum22=sum22+q22(j)
                    sum23=sum23+q23(j)
                    sum13=sum13+q13(j)
                    sum33=sum33+q33(j)
   10        continue
c    BUT for all remaining window positions on trace NEW correlation value is
c    found by subtracting first value of previous position and adding last value
c    of new window position, since these are the only values to change for a 
c    shift of one sample
         ELSE
             sum11=sum11-q11(istart-1)+q11(iend)
             sum12=sum12-q12(istart-1)+q12(iend)
             sum22=sum22-q22(istart-1)+q22(iend)
             sum23=sum23-q23(istart-1)+q23(iend)
             sum13=sum13-q13(istart-1)+q13(iend)
             sum33=sum33-q33(istart-1)+q33(iend)
         ENDIF
c    fill up 9-entry EIGEN matrix
             quad(1)=sum11
             quad(2)=sum12
             quad(3)=sum13
             quad(4)=sum12
             quad(5)=sum22
             quad(6)=sum23
             quad(7)=sum13
             quad(8)=sum23
             quad(9)=sum33

c   get eigenvalues only
c            call rs (3,3,quad,eig,1,eigv,work1,work2,ierr)
c            call rseaa (3,3,quad,eig,eigv,work1,ierr)

           CALL EIGEN(quad,eigv,icomp,1)

           lmda1= quad(1)
           lmda2= quad(5)
           lmda3= quad(9)

c   test for degenerate case, and fill up filter vector
           if(lmda1 .ne. 0.) then
              rsubi = 1. - lmda2/lmda1
              if(rsubi .gt. th) rsubi=1.
              vtrin(i) = ( x1(i) * eigv(1)
     1                    +x2(i) * eigv(2)
     2                    +x3(i) * eigv(3) )
     3                                                * rsubi ** nrect
              rtrin(i) = ( x1(i) * eigv(4)
     1                    +x2(i) * eigv(5)
     2                    +x3(i) * eigv(6) )
     3                                                * rsubi ** nrect
              ttrin(i) = ( x1(i) * eigv(7)
     1                    +x2(i) * eigv(8)
     2                    +x3(i) * eigv(9) )
     3                                                * rsubi ** nrect
           else
              vtrin(i) = 0.
              rtrin(i) = 0.
              ttrin(i) = 0.
           endif
  100 CONTINUE
c   End of Main DO LOOP
 
      return
      end
