C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM UPOLF(POLARIZATION FILTER PERFORM IN COMPLEX TIME DOMAIN)
C
C**********************************************************************C
C
C  UPOLF READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C
C SUBROUTINE CALLS: RTAPE, WRTAPE, HLH, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     itr1 (SZLNHD), itr2 (SZLNHD)
      integer     lhed1(SZLNHD), lhed2(SZLNHD)
      integer     luin1, luout1, lbyts1, nbyts1, lbyot1
      integer     lbyt1
      integer     statc1, statc2
      real        tri1 (SZLNHD), tri2 (SZLNHD)
      real        trifl1(SZLNHD), trifl2(SZLNHD)
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     nb,nc,ny,ni
      character   name * 5
#include <f77/pid.h>
      integer     ns, ne, rs, re
      character   ntap1*256,  otap1*256
      logical     verbos
      logical     query
      integer     argis
 
c     equivalence ( itr1(129), tri1 (1) )
      equivalence ( itr1(  1), lhed1(1) )
c     equivalence ( itr2(129), tri2 (1) )
      equivalence ( itr2(  1), lhed2(1) )

      data name /'UPOLF'/, nbyts1 / 0 /, lbyts1  / 0 / 
      data verbos/.true./
c-----
c      read program parameters from command line
c-----
      query = (argis('-?') .gt. 0)
      if(query) then
            call help()
            stop
      endif
c-----
c      open printout file
c-----
#include <f77/open.h>
c-----
c      parse command line arguments
c-----
      call gcmdln(ns,ne,rs,re,ntap1,otap1,nb,nc,ny,ni,
     1            verbos,fl,fh)
c-----
c      get logical unit numbers for input
c-----
      call getln(luin1 , ntap1,'r', 0)
      call getln(luout1, otap1,'w', 1)
      if(luin1.lt.0 .or. luout1.lt.0)stop
c-----
c     read line header of input
c     save certain parameters
c-----
      
      call rtape (luin1, itr1, lbyts1)
      if(lbyts1 .eq. 0) then
         write(LERR,*)'UPOLF: no header read from unit ',luin1,ntap1
         write(LERR,*)'FATAL'
         stop
      endif

c-----
c     get line header information from file 2
c-----
      call saver(itr1, 'NumSmp', nsamp, LINHED)
      call saver(itr1, 'SmpInt', nsi  , LINHED)
      call saver(itr1, 'NumTrc', ntrc , LINHED)
      call saver(itr1, 'NumRec', nrec , LINHED)
      call saver(itr1, 'Format', iform, LINHED)
      call saver(itr1, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr1, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('ToStUn',ifmt_ToStUn,l_ToStUn,ln_ToStUn,TRACEHEADER)
      call savelu('ToStAu',ifmt_ToStAu,l_ToStAu,ln_ToStAu,TRACEHEADER)

      call hlhprt (itr1, lbyts1, name, 5, LERR)

c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,rs,re,ntrc,nrec)
c-----
c     modify line header to reflect actual number of traces output
c-----
      jtr   = ne - ns + 1
      nrecc = re - rs + 1

c----------------------------------------------------
c  figure out number of 2-compt groups in each ntuple
c----------------------------------------------------
      call saver(itr1, 'RATTrc', ntuple, LINHED)
      npass = ntuple/2
      if(mod(ntuple,2) .ne. 0) then
         write(LERR,*)'Number of components not a multiple of 2'
         write(LERR,*)'Check input data set & recreate if necessary'
         write(LERR,*)'RATTrc entry in line header also must = 2 (utop)'
         write(LERR,*)'It also might be possible to use postsort to'
         write(LERR,*)'select out the required components'
         write(LERR,*)'Check the manual & seek assistance'
         stop
      endif
      ns1 = ns/ntuple
      ne1 = ne/ntuple
      if(ns1 .lt. 1) ns1 = 1
      if(ne1 .lt. 1) ne1 = 1

c-----
c     update line header for output file 1
c-----
      call savew(itr1, 'NumRec', nrecc, LINHED)
      call savew(itr1, 'NumTrc', jtr  , LINHED)
      call savhlh(itr1,lbyts1,lbyot1)
c-----
c      ensure that command line values are compatible with data set
c-----
            call wrtape(luout1, itr1, lbyot1)
c-----
c      verbose output of all pertinent information before
c      processing begins
c-----
      if(verbos )then
            call verbal(lbyts1,nsamp,nsi,ntrc,nrec,iform,
     1           ntuple,npass,ntap1,otap1,luin1,luout1,
     2           fl,fh,nb,nc,ny,ni,ns,ne,rs,re,verbos)
      endif
c-----
c      BEGIN PROCESSING
c      read trace
c----
c-----
c     skip unwanted records
c-----
	call recskp(1,rs-1,luin1,ntrc,itr1)
c-----
c     process desired trace records
c-----
      do 1000 jj = rs, re

c-----------------
c  skip to start
c  trace in rec
		call trcskp(jj,1,ns-1,luin1,ntrc,itr1)
c-----------------

c+++++++++++++++ process traces in record ++++++++++++++++++++
            do 1001 kk = ns1, ne1

c------------------
c  loop over number
c  of 2-compts in
c  ntuple
c------------------
             do 98  LL = 1, npass

c-----------------
c read first compt
c-----------------
                  call rtape(luin1, itr1,nbyts1)
                  if(nbyts1 .eq. 0) go to 999
c------------------
c read second compt
c------------------
                  call rtape(luin1, itr2,nbyts1)
                  if(nbyts1 .eq. 0) go to 999

                  call vmov (lhed1(ITHWP1), 1, tri1, 1, nsamp)
                  call vmov (lhed2(ITHWP1), 1, tri2, 1, nsamp)

                  call saver2(lhed1,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                        i115   , TRACEHEADER)
                  call saver2(lhed1,ifmt_ToStAu,l_ToStAu, ln_ToStAu,
     1                        i116   , TRACEHEADER)
                  call saver2(lhed1,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        irec1  , TRACEHEADER)
                  call saver2(lhed1,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        itrc1  , TRACEHEADER)
                  call saver2(lhed1,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        statc1 , TRACEHEADER)
                  call saver2(lhed2,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                        i215   , TRACEHEADER)
                  call saver2(lhed2,ifmt_ToStAu,l_ToStAu, ln_ToStAu,
     1                        i216   , TRACEHEADER)
                  call saver2(lhed2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        irec2  , TRACEHEADER)
                  call saver2(lhed2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        itrc2  , TRACEHEADER)
                  call saver2(lhed2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        statc2 , TRACEHEADER)

                  IF(statc1 .ne. 30000 .OR. statc2.ne.30000) THEN

                        call filt2c(tri1,tri2,trifl1,trifl2,
     1                              nsamp,nsi,nb,nc,ny,ni,fl,fh)
                  ELSE
                        call savew2(lhed1,ifmt_StaCor,l_StaCor,
     1                              ln_StaCor, 30000  , TRACEHEADER)
                        call savew2(lhed2,ifmt_StaCor,l_StaCor,
     1                              ln_StaCor, 30000  , TRACEHEADER)

                        call vfill (0.0, trifl1, 1, nsamp)
                        call vfill (0.0, trifl2, 1, nsamp)

                  ENDIF

                  call vmov (trifl1, 1, lhed1(ITHWP1), 1, nsamp)
                  call vmov (trifl2, 1, lhed2(ITHWP1), 1, nsamp)
                  call wrtape(luout1, itr1, nbyts1)
                  call wrtape(luout1, itr2, nbyts1)

98           continue

 1001       continue
c+++++++++++++++ process traces in record ++++++++++++++++++++

c-----------------
c  skip to end of
c  current rec
		call trcskp(jj,ne+1,ntrc,luin1,ntrc,itr1)
c-----------------

 1000 continue
  999 continue
      call lbclos(luin1)
      call lbclos(luout1)
      stop
      end

      subroutine help
#include <f77/iounit.h>
      write(LER,*)
     1'***************************************************************'
      write(LER,*)
      write(LER,*)
     1'Execute upolf  by typing upolf  with the following arguments'
      write(LER,*)' '
      write(LER,*)
     1'Data set names:'
      write(LER,*)
     1' -N  [ntap1] (no stdin)       : Input 2-component data file name'
      write(LER,*)
     1' -O  [otap1] (default stdout) : Output 2-component data file'
      write(LER,*)' '
      write(LER,*)
     1'Data editting:'
      write(LER,*)
     1' -rs [ir],   (default=1)      : beginning record number'
      write(LER,*)
     1' -re [re],   (default=last)   : ending record number'
      write(LER,*)
     1' -ns [ns],   (default=1)      : beginning trace number'
      write(LER,*)
     1' -ne [ne],   (default=last)   : ending trace number'
      write(LER,*)' '
      write(LER,*)
     1'Global processing parameters:'
      write(LER,*)
     1' -fl [fl]    (default=10)     : Reject f < fl for ny=1,2'
      write(LER,*)
     1' -fh [fh]    (default=100)    : Process frequency < fh'
      write(LER,*)
     1' -nb [nb]    (default=10)     : passband frequency=df*nb   '
      write(LER,*)
     1' -nc  [nc]   (default=2)      : cycles  window length (2 to 4) '
c----- window length is multiple of filter period
      write(LER,*)
     1' -ny [ny]    (default=0)      : reject wave type 0: no-reject',
     2'  1:P-, 2:SV-wave  '
      write(LER,*)
     1' -ni [ni]      (default=6)    : rectilinearity control (2 to 8)'
      write(LER,*)
     1' -V          (default=false)  : verbose output'
      write(LER,*)' '
      write(LER,*)
     1'Usage: upolf -N[ntap1] -O[otap1]'
      write(LER,*)
     1 '            -ns[ns] -ne[ne] -rs[rs] -re[re] '
      write(LER,*)
     1 '            -V -nb[nb] -nc[nc] -ny[ny] -ni[ni] -fl[fl] -fh[fh] '
      write(LER,*)
     1'***************************************************************'
      return
      end

      subroutine gcmdln(ns,ne,rs,re,ntap1,otap1,nb,nc,ny,ni,
     1         verbos,fl,fh)
      integer   ns, ne, rs, re
      integer   nb,nc,ny,ni
      character ntap1*(*), otap1*(*)
      integer   argis
      logical   verbos
            call argstr('-N', ntap1, ' ', ' ' )
            call argstr('-O', otap1, ' ', ' ')
            call argi4 ('-ns' , ns, 0, 0)
            call argi4 ('-ne' , ne, 0, 0)
            call argi4 ('-rs',rs,1,1)
            call argi4 ('-re',re,0,0)
            call argi4 ('-nb', nb, 10, 10 )
            call argi4 ('-nc', nc, 2, 2 )
            call argi4 ('-ny', ny, 0, 0 )
            call argi4 ('-ni', ni, 6, 6 )
            call argr4('-fl', fl, 10.0, 10.0)
            call argr4('-fh', fh, 100.0, 100.0)
            verbos = ( argis ('-V') .gt. 0 )
      return
      end

      subroutine verbal(lbyts1, nsamp, nsi, ntrc, nrec, iform, 
     1 ntuple,npass,ntap1, otap1, luin1, luout1, 
     2 fl,fh,nb,nc,ny,ni,ns, ne, rs, re, verbos)
c-----
c     verbose output of processing parameters
c
c     lbyts1- I*4 number of bytes in line header 1
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap1 - C*100     input file name
c     otap1 - C*100     instantaneous frequency output file name
c     luin1 - I*4 input file unit number
c     luout1- I*4 vertical output unit number
c     ntuple- I*4 Number of compnents
c     npass - I*4 Number of two compnent groups (1 or 2)
c     nb    - I*4 Number freq bands
c     nc    - I*4 Number cycles / window length
c     ny    - I*4 wave rejection type
c     ni    - I*4 wave rejection power
c     fl    - R*4 lo-cut wave rejection freq (ny = 1,2)
c     fh    - R*4 hi-cut freq to process
c     ns    - I*4 starting trace
c     ne    - I*4 ending trace in each record
c     rs    - I*4 starting record
c     re    - I*4 ending record
c     verbos- L   verbose information
c-----
#include <f77/iounit.h>
      integer    lbyts1, nsamp, nsi, ntrc, nrec, iform
      integer    luin1, luout1
      character  ntap1*(*), otap1*(*)
      real       fl, fh
      integer    nb,nc,ny,ni
      integer    ns, ne, rs, re
      logical    verbos
      integer    lenstr

            ln1 = lenstr(ntap1)
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of bytes in line header 1=',lbyts1
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' luin1              =  ', luin1
            write(LERR,*) ' luout1             =  ', luout1
            write(LERR,*) ' input 1 data set name = ',ntap1(1:ln1)
            write(LERR,*) ' ns (starting trace)    =  ',ns
            write(LERR,*) ' ne (ending trace  )    =  ',ne
            write(LERR,*) ' rs (starting record)   =  ',rs
            write(LERR,*) ' re (ending record)     =  ',re
            write(LERR,*) ' verbose output         =  ',verbos
            write(LERR,*) ' Number components      =  ',ntuple
            write(LERR,*) ' Number 2-component grps=  ',npass
            write(LERR,*)' '
            write(LERR,*) ' Number freq bands      =  ',nb
            write(LERR,*) ' Number cycles/wind length = ',nc
            write(LERR,*) ' Wave rejection type    =  ', ny
            write(LERR,*) ' Wave rejection power   =  ', ni
            write(LERR,*) ' lo-cut wave rejection freq   =  ', fl
            write(LERR,*) ' hi-cut processing freq =  ', fh
            write(LERR,*)' '
      return
      end

      function lenstr(str)
c-----
c     determine length of a string. Note f77 len gives declaration
c     we want length up to last non blank
c-----
      integer*4 lenstr
      character str*(*)
      l = len(str)
      do 100 i=l,1,-1
            lenstr = i
            if(str(i:i) .ne. ' ')return
  100 continue
      return
      end

	subroutine npow2(nsamp,npts,npts21)
c-----
c	Given nsamp, find npts >= nsamp such that npts is a power of 2
c-----	
	integer*4 nsamp, npts, npts21
	npts = 1
 1000	continue
	npts = 2*npts
	if(npts.lt.nsamp)goto 1000
	npts21 = npts/2 + 1
	return
	end


cc	******************************************************
	subroutine filt2c(xz,xr,wz,wr,np,nsi,nb,nc,my,n,fu,fh)
c-----
c	This subroutine is written by Chiou-Fen Shieh, Feb 1988
c	For detailed theory and algorithm, refer to Shieh's
c	dissertation Chapter 5 and 6
c
c	xz	R*4	input trace, vertical or radial component
c	xr	R*4	input trace, radial or vertical component
c	wz	R*4	filtered output trace, vertical or radial
c	wr	R*4	filtered output trace, radial or vertical
c	np	I*4	number of data points for each trace
c	nsi	I*4	sampling interval milliseconds
c	nb	I*4	width of passband in Hz (df*nb)
c	nc	I*4	cycles of cosine window (length=period*nc)
c	n	I*4	power control of ellipticity (1-e)**n (5.42)
c	fu	R*4	frequency bound of unwanted linear motion (P or SV)
c	my	I*4	unwanted linear motion
c				0 - normal
c					reject elliptical motion
c				1 - P-wave
c					reject elliptical and P-wave
c				2 - S-wave
c					reject elliptical and S-wave
c	fh	R*4	process only frequencies less than fh (Hz)
c-----
c	polarization analysis in time domain
c	decrease noise and determine polarization properties
c	by calling -noipol-
c	inver FFT to time domain
c-----
#include <f77/lhdrsz.h>
	real * 4 xz(*),xr(*)
	real * 4 wz(*),wr(*)
	complex z(4096),r(4096)
	dimension uz(SZLNHD),ur(SZLNHD),
     1		yz(SZLNHD),yr(SZLNHD)
	integer * 4 nb,nc,my,n
	data nbut,m /2,2 /
c-----
c	nbut - order of butterworth bandpass filter
c	m noise power control, P**m (5.42)
c-----

        dt = real(nsi) * unitsc
c-----
c	dt is the sample interval in seconds)
c	convert number of points to a power of two
c-----
	call npow2(np,nn,n2)
	n2=nn/2+1
	df=1./(nn*dt)
	fny = 1./(2.*dt)
c-----
c	f0 is the lower limit of the processing band
c-----
	f0 = 0.5
	if(fh.gt.fny)then
		ms = (fny - f0)/(nb*df)
	else
		ms = (fh  - f0) /(nb*df)
	endif
	do 180 i=1,np
		wz(i)=0.
		wr(i)=0.
		uz(i)=0.
		ur(i)=0.
180	continue
c-----
c	initial arrays are stored in complex arrays
c	together with their Hilbert transforms in order
c	to preserve them
c-----
	do 191 i=1,nn
		if(i .le.np) then
			z(i)=cmplx(xz(i),0.)
			r(i)=cmplx(xr(i),0.)
		else
			z(i)=cmplx(0.,0.)
			r(i)=cmplx(0.,0.)
		endif
191	continue
c-----
c	take the Hilbert transform of each component
c-----
	call hilbt(z,nn,dt)
	call hilbt(r,nn,dt)
c-----
c	set the lower and upper limits of the passband frequency
c	f0 - lower limit
c	f2 - upper limit
c-----
	do 300 jj=1,ms
		f2=f0+(df*nb)
		do 301 ll=1,np
			xz(ll)=real(z(ll))
			xr(ll)=aimag(z(ll))
			yz(ll)=real(r(ll))
			yr(ll)=aimag(r(ll))
  301		continue
		call digfil(xz,dt,np,f0,f2,nbut)
		call digfil(xr,dt,np,f0,f2,nbut)
		call digfil(yr,dt,np,f0,f2,nbut)
		call digfil(yz,dt,np,f0,f2,nbut)
c-----
c	determine window length
c-----
		fc=(f0+f2)/2.
		per=1./fc
		no=per/(2*dt)
		nf=nc*no
		nw=2*nf+1
		if(nw.lt.1)nw=1
		if(nw .ge. np) nw=np-1
		call noipol(my,xz,xr,yz,yr,fc,fu,np,nw,m,n,uz,ur)
		do 206 ki=1,np
			wz(ki)=wz(ki)+uz(ki)
			wr(ki)=wr(ki)+ur(ki)
  206		continue
		f0=f2
300	continue
	return
	end

	subroutine hilbt(z,nn,dt)
c-----
c	Hilbert transform by calling FFT and inverse FFT
c
c	z	C*8	complex trace
c	nn	I*4	number of points (power of two)
c	dt	R*4	sampling interval (sec)
c-----
	complex z(*)
		n2=nn/2+1
		call four(z,nn,-1,dt,df)
		do 101 i=1,nn
			if(i.eq.1 .or. i.eq.n2) then
				z(i)=z(i)
			elseif(i.gt.n2) then
				z(i)=cmplx(0.,0.)
			else
				z(i)=2.*z(i)
			endif
101		continue
		call four(z,nn,+1,dt,df)
	return
	end

	subroutine noipol(my,zr,zi,rr,ri,fc,fu,nn,nw,m,n,uz,ur)
c-----
c	my	I*4	- rejection control (see filt2c)
c	zr,zi	R*4	- Z component input data
c	rr,ri	R*4	- R component input data
c	fc	R*4	- upper bound for my=1,2
c	fu	R*4	- upper bound of polarization processing
c	nn	I*4	- number of data point 
c	nw	I*4	- window length
c	m	I*4	- gain control of noise
c	n	I*4	- gain control of ellipticity
c	uz	R*4	- filtered vertical trace
c	ur	R*4	- filtered radial trace
c-----
c	subroutine for polarization filter
c	this program is designed to reject unpolarized noise and
c	elliptical motion
c	the algorithm is performed in complex domain by using
c	vertical and radial component data
c-----
#include <f77/lhdrsz.h>
	real*4 zr(*), zi(*), rr(*), ri(*)
	complex u(2,1),szr,x2
	real*4 zw(SZLNHD),rw(SZLNHD)
	real*4 w(SZLNHD)
	dimension uz(*),ur(*)
c-----
c	introduce a parameter to indicate if the window
c	needs recomputing
c-----
	data err /0.00001 /
	n2=(nw-1)/2
	do 198 i=1,nn
		uz(i)=0.
		ur(i)=0.
198	continue
c-----
c	start to taper the time series
c-----
	is=1
   	call wind(nw,w)
c-----
c	Hanning window apply to Z- and R- band limit time series
c-----
199     continue
	szz = 0.0
	srr = 0.0
	szr = cmplx(0.0,0.0)
c-----
c	window and construct the spectral matrix
c-----
	do 200 i=1,nw
		k=n2*(is-1)+i
		if(k .gt. nn) then
			zw(i)=0.0
			rw(i)=0.0
		else
			zw(i)=zr(k)*w(i)
			rw(i)=rr(k)*w(i)
			ww = w(i)**2
			szz=szz+(zr(k)**2 + zi(k)**2)*ww
			srr=srr+(rr(k)**2 + ri(k)**2)*ww
			szr=szr+cmplx(zr(k),zi(k))*
     1				conjg(cmplx(rr(k),ri(k)))*ww
		endif
200	continue
	szz=szz/nw
	srr=srr/nw
	szr=szr/nw
c-----
c	check the off-diagonal element. If it is zero, there is no
c	need for eigenanalysis. Otherwise go to 222 to perform the
c	eigenanalysis
c-----
	if(cabs(szr) .gt. err) go to 222
	amx=0.
	amp=1.
	go to 205
c-----
c	compute the determinant of the spectral matrix and then
c	compute the polarization properties
c-----
222	det=abs(szz*srr-cabs(szr)*cabs(szr))
c-----
c	compute the total energy (5.9)
c-----
	trace=szz+srr
c-----
c	compute the degree of polarization (5.31)
c-----
	ro=1.-(4.*det/(trace*trace))
	amp=abs(ro)**0.5
c-----
c	eigenvalue corresponding to signal (5.30)
c-----
	dc=abs(trace*trace-4.*det)
	d1=dc**0.5
	ds=(trace+d1)/2.
c-----
c	eigenvector correspond to signal u=[x1,x2*EXP(j*phi)]
c	refer to Appendix B for the whole procedure
c-----
	x1=1.
	x2=(ds-szz)/szr
	x2r=real(x2)
	x2i=aimag(x2)
c	arg=(2.*x2r*x2i)/(1.+x2r*x2r+x2i*x2i)
        xnum = (2.*x2r*x2i)
        xden = (1.+x2r*x2r-x2i*x2i)
c       ang=atan(arg)/2.
        ang = -atan2( xnum,xden )/2.0
	u(1,1)=cmplx(x1*cos(ang),x1*sin(ang))
	u(2,1)=x2*cmplx(cos(ang),sin(ang))
c-----
c	determine the ellipticity (5.39)
c-----
	uper=sqrt(real(u(1,1))**2+real(u(2,1))**2)
	den=sqrt(aimag(u(1,1))**2+aimag(u(2,1))**2)
	if(uper.ge.den) then
		amx=den/uper
	else
		amx=uper/den
	endif

c-----
c	determine which wave type to reject
c	my = 0 - only elliptical
c	my = 1 - elliptical and P-motion
c	my = 2 - elliptical and SV-motion
c-----
205	continue
c-----
c	compute rectilinearity ep
c-----
c-----
c	identify wave type (page 61) and reject according to the
c	frequency range
c-----
	if(my.eq.0)then
		ep=1.-amx
	elseif(my.eq.1)then
c-----
c	reject low frequency P-waves
c-----
		if(real(szr).gt.0 .and. fc.le.fu) then
			ep=0.02*(1.-amx)
		else
			ep=1.-amx
		endif
	elseif(my.eq.2)then
c-----
c	reject low frequency S-waves
c-----
		if(real(szr).lt.0 .and. fc.le.fu) then
			ep=0.02*(1.-amx)
		else
			ep=1.-amx
		endif
	endif
c-----
c	define filter function (5.42)
c-----
	filp=(amp**m)*(ep**n)
	if(filp.lt. 1.0e-05)filp=0.0
c-----
c	multiply the real part of each trace by the filter function
c	and add the effects of the overlapping windows
c-----
	do 206 i=1,nw
		k=n2*(is-1)+i
		if(k .gt. nn) go to 207
   		uz(k)=uz(k)+zw(i)*filp
        	ur(k)=ur(k)+rw(i)*filp
206	continue
207	continue
	is=is+1
	mm=n2*(is-1)+1
	if(mm .lt. nn) goto 199
	return
	end
c--------------------------------------------
cc	digital filter (bandpass only)
cc	this subroutine is modified from David Russell's zpass.f
cc	x	: input and output array
cc	dt	: sampling rate
cc	nn	: sample point of input array
cc	f1,f	: lowpass cutoff (f1) and highpass cutoff (f) frequency
cc	nbut	: order of the Butterworth filter
	subroutine digfil(x,dt,nn,f1,f,nbut)
	dimension x(6000)
	iflag=0
	znyq=1./(2.*dt)
	tupi=2.*3.141592654
    	a=1.
	w0=tupi*f
	w1=tupi*(znyq-f1)
	iflag=1
  25	continue
	nd=int(nbut/(tupi*f1*dt))
	n=nn+nd
	if(n.gt.6000) n=6000
	do 30 i=nn+1,n
  30	x(i)=x(nn)
	iq=(1+(-1)**nbut)/2
	n2b=nbut/2
	do 35 i=1,n2b
	ct=2.*w0*cos(float(2*i-iq)*tupi/float(4*nbut))
	ict=i
	call butter(x,a,ct,w0,ict,dt,n)
  35	continue
	if(iq.eq.1) go to 40
    	call bttr2(x,a,w0,dt,n)
40	call rvrs(x,n)
	do 45 i=1,n2b
	ct=2.*w0*cos(float(2*i-iq)*tupi/float(4*nbut))
	ict=i
    	call butter(x,a,ct,w0,ict,dt,n)
  45	continue
	if(iq.eq.1) go to 50
    	call bttr2(x,a,w0,dt,n)
50	call rvrs(x,n)
55	continue
	if(iflag.eq.0) go to 60
	a=-1.
	w0=w1
	iflag=0
	go to 25
  60	continue
	return
	end
	subroutine butter(x,a,b,w,ict,dt,n)
	dimension x(n)
	za=2.*a
	call set(w,wp,ak,dt,n)
	wp2=wp*wp
	b0=wp2
	b1=1.+b*ak+wp2
	b2=za*(wp2-1.)
	b3=1.-b*ak+wp2
	if(a.gt.0.) go to 7
	yt1=0.0
	yt2=0.0
	if(ict.gt.1) go to 5
	xt1=x(1)
	xt2=x(1)
	go to 9
   5	xt1=0.0
	xt2=0.0
	go to 9
   7	yt1=x(1)
	yt2=x(1)
	xt1=x(1)
	xt2=x(1)
   9	continue
	do 10 i=1,n
	yt3=(b0*(x(i)+za*xt2+xt1)-b2*yt2-b3*yt1)/b1
	xt1=xt2
	xt2=x(i)
	x(i)=yt3
	yt1=yt2
  10	yt2=yt3
	return
	end
	subroutine bttr2(x,a,w0,dt,n)
	dimension x(n)
	call set(w0,wp,ak,dt,n)
	b0=wp+1
	b1=a*(wp-1)
	if(a.gt.0.) go to 5
	yt=0.
	xt=0.
	go to 7
   5	yt=x(1)
	xt=x(1)
   7	continue
	do 10 i=1,n
	yt=(wp*(x(i)+a*xt)-b1*yt)/b0
	xt=x(i)
  10	x(i)=yt
	return
	end
	subroutine set(w,wp,ak,dt,n)
	wp=tan(w*dt/2.)
	ak=wp/w
	return
	end
	subroutine rvrs(x,n)
	dimension x(n),y(500)
	m=500
	nn=n
	k=n/m
	mr=n-k*m
	jj=1
	do 40 i=1,k+1
	if(i.eq.k+1) m=mr
	if(m.eq.0) go to 40
	do 10 j=1,m
  10	y(j)=x(n-m+j)
	if(n.eq.m) go to 25
	nn=nn-m
	if(nn.eq.0) go to 25
	do 20 j=1,nn
  20	x(n-j+1)=x(n-m-j+1)
  25	do 30 j=1,m
	x(jj)=y(m-j+1)
  30	jj=jj+1
  40	continue
	return
	end
cc	---- end of digital filter subroutine ---

	subroutine wind(nw,w)
c-----
c	Hanning window
c
c	nw	I*4	Length of window in samples (odd)
c	w	R*4	Window function
c-----
	integer*4 nw
	real*4 w(*)
		pi=3.141592654
		nn=nw-1
		n=nw/2
		n2=n+1
		do 700 i=1,nw
			if(i.le.n2) then
				ang=(real(n2-i)*pi/real(nn))
				w(i)=cos(ang)**2
			else
				w(i)=w(nw-i+1)
			endif
700		continue
		w(1) = 0.0
		w(nw) = 0.0
	return
	end

