c	program hspec91
c---------------------------------------------------------------------c
c                                                                     c
c      COMPUTER PROGRAMS IN SEISMOLOGY                                c
c      VOLUME VI                                                      c
c                                                                     c
c      PROGRAM: HSPEC91                                               c
c      This program is a merge of HSPEC8 and RHWVINTA which
c      does away with the intermediate file
c                                                                     c
c      COPYRIGHT 1991                                                 c
c      R. B. Herrmann                                                 c
c      Department of Earth and Atmospheric Sciences                   c
c      Saint Louis University                                         c
c      221 North Grand Boulevard                                      c
c      St. Louis, Missouri 63013                                      c
c      U. S. A.                                                       c
c                                                                     c
c---------------------------------------------------------------------c

#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c	parameter(LER=0, LIN=5, LOT=6)
	parameter(NL=100)
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	common/bound/vmin,vamin,vamax,vbmin,vbmax
	common/damp/alpha,ieqex
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/modelt/dt(NL),at(NL),bt(NL),rhot(NL),mmaxt,
     1                qat(NL),qbt(NL)
	common/jout/jsrc(16) , jbdrys, jbdryh
c-----
c	matrix components in layers and boundaries saved
c-----
	double complex har(NL,4,4), dar(NL,5,5), hsr(2,5), gbr(2,5), 
     1		hal(NL,2,2), hsl(2,2), gbl(2,2)
	real*8 hex(NL), lex(NL), dex(NL), hexw(NL)
	common/hamat/har
 	common/damat/dar
	common/hsrfr/hsr
	common/gbrfr/gbr
	common/hlmat/hal
	common/hsrfl/hsl
	common/gbrfl/gbl
	common/hexex/hex
	common/hexexw/hexw
	common/dexex/dex
	common/lexex/lex 
	common/water/iwater(NL),iwats(2),iwatb(2)
	common/updnsm/equalu(NL), equald(NL)
	logical equalu, equald
	common/lyrctl/lyrins
	logical lyrins
	common/rlimit/rlim
	real*4 rlim

#include <f77/pid.h>
c-----c
	character*3 istat3
	logical ixst3
	real*4 ffreq(8)
	parameter(NDST=100)
	real*4 r(NDST), t0(NDST)
	complex smm(NSR,16)
	complex ztmp, zdata
	character*4 icchar(16)
	common/c/cmax,c1,c2,cmin
	character name4*50, name*17
c-----
c	lsrc maps jsrc to output Green's functions. e.g., if
c	jsrc(8) = radial explosion term, but in final output it
c	occupies position 10, or jsrc(lsrc(10)) = computed
c-----
	integer*4 lsrc(16)
	data lsrc/1,2,3,4,13,5,6,14,7,8,9,10,11,12,15,16/
	data icchar/' ZDD',' RDD',' ZDS',' RDS',' TDS',' ZSS',' RSS',
     1		' TSS',' ZEP',' REP',' ZVF',' RVF',' ZHF',' RHF',' THF',
     2          ' PEP'/
        data      name/'OFFSET_MOD_HSPEC9'/
       
c-----
c	open printout file
c-----
#include <f77/open.h>

c-----
c	set up tolerances
c		rlim is the distance which is effectively zero
c-----
		rlim = 0.0001
c-----
c	read name of hspec91 data file
c-----
	call gethsp(name4,fl,fu,delt,n,n1,n2,xleng,xfac,
     1		ndist,r,t0)
c-----
c	process
c-----
	df = 1./(n*delt)
	nyq = n/2 + 1
	nyq2 = 2*nyq
        write(LERR,*)'nyq= ',nyq,'  nyq2= ',nyq2
	write(LERR,2)  fl,fu,df,n1,n2,n,
     2		vmin,vamin,vamax,vbmin,vbmax
    2	format('fl =',f10.5,5x,'fu =',f10.5,5x,'df =',f10.5,/
     1		4x,'n1 =',i4,5x,'n2 =',i4,5x, ' n =',i5/
     2	'vmin =',f10.5,' vamin =',f10.5,' vamax =',f10.5/
     3	'vbmin =',f10.5,' vbmax =',f10.5)
	write(LERR,*)'SOURCE DEPTH (',mdpths,')'
	do 2020 i=1,mdpths
		write(LERR,2021)depths(i),lmaxs(i)
 2020	continue
	write(LERR,*)'RECEIVER DEPTH (',mdpthr,')'
	do 2030 i=1,mdpthr
		write(LERR,2031)depthr(i),lmaxr(i)
 2030	continue
	write(LERR,*)'RECEIVER DISTANCES (',ndist,')'
	do 2040 i=1,ndist
		write(LERR,2041)r(i), t0(i)
 2040	continue
 2021	format('depths =',f14.2,' lmaxs =',i5)
 2031	format('depthr =',f14.6,' lmaxr =',i5)
 2041	format('     r =',f14.6,' t0    =',f10.2)
	write(LERR,5)alpha,delt
    5	format('alpha =',f10.5,5x,'dt =',f10.3)
	write(LERR,4)
    4	format('frequencies for which response computed     ')
c-----
c     open output file for hspec8
c-----
      open(unit=2,file='hspec91.tmp',status='unknown',form=
     1            'unformatted',access='sequential')
      rewind 2
c-----
c     open temporary distance multiplexed file which
c     will be examined in case it exists already for
c     work already done
c-----
      inquire(file='hspec91.bin',exist=ixst3)
      if(ixst3)then
            istat3 = 'old'
      else
            istat3 = 'new'
      endif
      open(unit=3,file='hspec91.bin',status=istat3,form=
     1            'unformatted',access='sequential')
      rewind 3
      ifreq = 0
      if(ixst3)then
            call reset3(ifreq,jsrc,lsrc,ndist,n1,n2)
      endif
c-----
c	process the frequencies
c-----
	do 101 i=1,8
  101	ffreq(i)=-1.0
	n11 = n1
	if(ifreq.gt.n1)n11 = ifreq + 1
	do 100 ii = n11,n2
		freq=(ii-1)*df
		if(freq.lt.df) freq = 0.01*df
		call excit(freq,xleng,xfac,dk)
		do 200 jd=1,ndist
			call setup(r(jd))
			call wvint(r(jd),smm,dk)
			fac = 6.2831853*freq*t0(jd)
			ztmp = cmplx(cos(fac), sin(fac) )
			k = 0
			do 303 is=1,mdpths
				do 304 ir=1,mdpthr
					k = k + 1

					do 301 jj=1,16
					zdata = ztmp*smm(k,jj)
					if(jsrc(lsrc(jj)).eq.1)then
						datar= real(zdata)
						datai=aimag(zdata)
						write(3)datar,datai
					endif
  301					continue

  304				continue
  303			continue
  200		continue
		index=mod(ii,8)
		if(index.eq.0)index=8
		ffreq(index)=freq
		if (index.eq.8) then
				write(LERR,3)ffreq
				do 102 ij=1,8
					ffreq(ij)=-1.
  102				continue
		endif
    3	format(8f10.5)
  100	continue
	write(LERR,3)ffreq
c-----
c	output the final spectrum as a function of distance
c-----
	open(unit=4,file=name4,status='unknown',form='unformatted',
     1		access='sequential')
	rewind 4
	write(4) alpha,fl,fu,delt,n,n1,n2,df,nyq2
	write(4)jsrc
c-----write out lsrc indexing since rhwvinta changes order
	write(4)lsrc
	write(4)d,a,b,rho,mmax,qa,qb
c-----
c	now output the spectrum for each distance
c
c	The order in the temporary file 'hspec91.tmp' is
c		FREQ
c			DIST
c				SOURCE_DEPTH
c					RECEIVER_DEPTH
c	This must be rearranged to form
c		DIST
c			SOURCE_DEPTH
c				RECEIVER_DEPTH
c					FREQ
c
c-----
	do 5000 jd=1,ndist
	k = 0
	do 5005 js=1,mdpths
	do 5010 jr=1,mdpthr
		k = k + 1
		rewind 3
		write(4)r(jd),t0(jd),depths(js),depthr(jr)
		do 5100 jj=1,16
			write(4)icchar(jj)
 5100		continue
		do 5200 i=n1,n2
			do 5300 jjd=1,ndist
			kk = 0
			do 5301 jjs=1,mdpths
			do 5302 jjr=1,mdpthr
				kk = kk + 1
				do 5400 jj=1,16
					if(jsrc(lsrc(jj)).eq.1)then
					read(3)datar,datai
					if(jjd.eq.jd .and. k.eq.kk)then
						write(4)datar,datai
					endif
					endif
 5400				continue
 5302			continue
 5301			continue
 5300			continue
 5200		continue
 5010	continue
 5005	continue
 5000	continue
	rr = -1.0
	tt0 = 0.0
	write(4)rr,tt0
	close (4)
	close(2,status='delete')
	close(3,status='delete')
	end

	subroutine gethsp(name4,fl,fu,delt,n,n1,n2,xleng,xfac,
     1		ndist,r,t0)
c-----
c	read in data file of hspec8 commands
c-----
#include <f77/iounit.h>

c	parameter(LER=0, LIN=5, LOT=6)
	parameter(NL=100)
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	common/bound/vmin,vamin,vamax,vbmin,vbmax
	common/damp/alpha,ieqex
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/jout/jsrc(16) , jbdrys, jbdryh
	parameter(NDST=100)
	real*4 r(NDST), t0(NDST)
	common/c/cmax,c1,c2,cmin
	character*50 name4
	character ostr*80
        character*3  istat2
	common/lyrctl/lyrins
	logical lyrins
c-----
	read(LIN,18)name4
	write(LERR,18)name4
   18	format(a)
   19	format(3i5)
        read(LIN,18)istat2
c-----
c-----
c       ieqex = 0 earthquake - double couples
c             = 1 exploration - explosion, point forces
        read(LIN,19)ierr,ifreq, ieqex
        write(LERR,19)ierr,ifreq, ieqex
c-----

c-----
c	read in time domain damping, sampling interval
c	read in number of time samples, frequency limits
        read(LIN,20) alpha,depths(1),fl,fu,delt,n,n1,n2,df,nyq2 ,mmax,
     1               depthr(1)
   20   format(5e15.7/3i10,e15.7,i10,i10,5x,f10.5)
c  20   format(5e15.7/3i10,e15.7,i10,i10,e15.7)
c-----
	write(LERR,20) alpha,depths(1),fl,fu,delt,n,n1,n2,df,nyq2 ,mmax,
     1               depthr(1)
c  20	format(2e15.7/3i10)
	cmax = -1.0
	c1 = -1.0
	c2 = -1.0
	cmin = -1.0
c-----
c	Specify desired output Green's functions
c-----
c	if(ieqex.gt.5 .or. ieqex.lt.0)ieqex = 2
c	if(ieqex .eq. 0)then
c		write(LERR,*)'ieqex= ',ieqex,' EARTHQUAKE + EXPLOSION'
c	else if(ieqex.eq.1)then
c		write(LERR,*)'ieqex= ',ieqex,' POINT FORCES + EXPLOSION'
c	else if(ieqex.eq.2)then
c		write(LERR,*)'ieqex= ',ieqex,' ALL GREEN'
c	else if(ieqex.eq.3)then
c		write(LERR,*)'ieqex= ',ieqex,' EXPLOSION ONLY'
c	else if(ieqex.eq.4)then
c		write(LERR,*)'ieqex= ',ieqex,' EARTHQUAKE ONLY'
c	else if(ieqex.eq.5)then
c		write(LERR,*)'ieqex= ',ieqex,' POINT FORCES ONLY'
c	endif
c-----
c	provide names for output Green's functions in order of output
c-----
        read(LIN,21)jsrc , jbdrys, jbdryh
        write(LERR,21)jsrc , jbdrys, jbdryh

c-----
c	jsrc - array giving Green's functions to be evaluated
c		this controls computations, gives far field terms
c		or course true solution for radial may involve transverse
c	jsrc(lsrc) maps into Green,s functions, e.g.,
c		For REP=10, lsrc(10) = 8, and if jsrc(8) = 1
c		P-SV contribution to explosion radial time history is computed
c
c	ieqex = 0 
c	Earthquake + Explosion
c	1-ZDD	2-RDD	3-ZDS	4-RDS	5-TDS	6-ZSS
c	7-RSS	8-TSS	9-ZEP	10-REP
c
c	ieqex = 1 
c	Point Forces + Explosion
c	11-ZVF	12-RVF	13-ZHF	14-RHF	15-THF	16-PEP
c	9-ZEP   10-REP (others have no meaning)
c
c	ieqex = 2
c	All Green's functions
c	1-ZDD	2-RDD	3-ZDS	4-RDS	5-TDS	6-ZSS
c	7-RSS	8-TSS	9-ZEP	10-REP
c	11-ZVF	12-RVF	13-ZHF	14-RHF	15-THF	16-PEP
c
c	ieqex = 3
c	Explosion Only
c	9-ZEP	10-REP
c
c	ieqex = 4 
c	Earthquake
c	1-ZDD	2-RDD	3-ZDS	4-RDS	5-TDS	6-ZSS
c	7-RSS	8-TSS
c
c	ieqex = 5 
c	Point Forces Only
c	11-ZVF	12-RVF	13-ZHF	14-RHF	15-THF	
c
c	If fluid layer for receiver, 16 is forced to be fluid 
c		stress due to explosion
c-----
c	input jbdry = 10*surface + halfspace
c	surface   = 0 - elastic
c	            1 - free
c                   2 - rigid
c	halfspace = 0 - elastic
c	            1 - free
c                   2 - rigid
c-----
c-----
c	jbdrys 	=  surface boundary condition
c		= -1 top surface is rigid
c		=  0 really a halfspace with parameters of top layer	
c		=  1 free surface
c	jbdryh	= halfspace boundary condition
c		= -1  RIGID
c		=  0  ELASTIC
c		= +1  FREE SURFACE
c-----
	if(jbdrys.eq.1)then
		write(LERR,*)' TOP  OF MODEL IS FREE SURFACE  '
	else if(jbdrys.eq.0)then
		write(LERR,*)' TOP  OF MODEL IS HALFSPACE WITH',
     1			' PROPERTIES OF FIRST LAYER'
	else if(jbdrys.eq.-1)then
		write(LERR,*)' TOP  OF MODEL IS RIGID'
	endif
	if(jbdryh.eq.0)then
		write(LERR,*)' BASE OF MODEL IS HALFSPACE WITH',
     1			' PROPERTIES OF BOTTOM LAYER'
	else if(jbdryh.eq.-1)then
		write(LERR,*)' BASE OF MODEL IS RIGID'
	else if(jbdryh.eq.1)then
		write(LERR,*)' BASE OF MODEL IS FREE'
	endif

   21	format(18i5)
c-----
c	read in the earth model
c-----
	read(LIN,*) (d(i),a(i),b(i),rho(i),qa(i),qb(i),i=1,mmax)
	write(LERR,22)(d(i),a(i),b(i),rho(i),qa(i),qb(i),i=1,mmax)
   22	format(6e11.4)
	call modcpy(.true.)
	call velbnd()
   23	format(i10,6e11.4)
c-----
c	check model for inconsistencies
c-----
	call chkmod()
c-----
c	read in controls for wavenumber integration
c-----
	read(LIN,*) xleng, xfac
	write(LERR,24)xleng, xfac
   24	format(2e15.7)
c-----
c	read in the  source depth
c-----
c	read(LIN,*)mdpths
        call argi4('-ms', mdpths, 1, 1)
	mtmp = NSOURCE
	if(mdpths .gt. NSOURCE)then
		write(ostr,3008)mdtphs,mtmp
 3008	format('NUMBER OF SOURCE DEPTHS',i5,' EXCEEDS DIMENSION ',i5)
		call werror(ostr)
	endif
c-----
c	get source depth incrment
c-----
        call argr4('-ds', dsinc, 0., 0.)
	do 2008 i=1,mdpths
		depths(i) = depths(1) + float(i-1) * dsinc
 2008	continue
c-----
c	read in the receiver depth
c-----
        call argi4('-mr', mdpthr, 1, 1)
c	read(LIN,*)mdpthr
	mtmp = NRECEIVER
	if(mdpthr .gt. NRECEIVER)then
		write(ostr,3009)mdtphr,mtmp
 3009	format('NUMBER OF RECEIVER DEPTHS',i5,' EXCEEDS DIMENSION ',i5)
		call werror(ostr)
	endif
        call argr4('-dr', drinc, 0., 0.)
	do 2009 i=1,mdpthr
		depthr(i) = depthr(1) + float(i-1) * drinc
 2009	continue
c-----
c	check for filling the final depth array
c-----
	mtmp = mdtphs * mdtphr
	ntmp = NSR
	if(mtmp .gt. ntmp)then
		write(ostr,3011)mtmp,ntmp
 3011	format('NUMBER SOURCE-RECEIVER COMB',i5,
     1         ' EXCEEDS DIMENSION ',i5)
		call werror(ostr)
	endif
c-----
c	read in the distances
c-----
    1	format(4f10.5)
	call argi4('-nr', ndist, 1, 1)
        call argr4('-x0', xmin, 0., 0.)
        call argr4('-gi',   dx, 0., 0.)
        call argr4('-vred', vred, 0., 0.)
        call argr4('-ts', tshift, 0., 0.)
        write(LERR,*)' '
        write(LERR,*)'Number groups= ',ndist
        write(LERR,*)'Near offset= ',xmin
        write(LERR,*)'Group interval= ',dx
        write(LERR,*)'Number source depths= ',mdpths
        write(LERR,*)'Source depth increment= ',dsinc
        write(LERR,*)'Number receiver depths= ',mdpthr
        write(LERR,*)'Receiver depth increment= ',drinc
        write(LERR,*)' '
	mtmp = NDST
	if(mdpthr .gt. NDST)then
		write(ostr,3010)ndist,mtmp
 3010	format('NUMBER OF DISTANCES',i5,' EXCEEDS DIMENSION ',i5)
		call werror(ostr)
	endif
	do 2010 i=1,ndist
c		read(LIN,*)rr,tshift,vred
                r(i) = xmin + float(i-1)*dx
                write(LERR,*)'Offset = ',r(i),vred,tshift
			if(vred.eq.0.0)then
				t0(i) = tshift 
			else
				t0(i) = tshift + r(i)/vred
			endif
 2010	continue
c-----
c	For reasons of efficiency, decide whether to
c	add all layers at once, to the model
c	or to evaluate each layer source-receiver
c	combination separately. 
c
c	Roughly if the number of unique source and receiver depths
c	are mdpths+mdpthr if we insert layers, then we
c	end up with roughly mmax+mdpths+mdpthr layers, and
c	hence layer multiplication of this many matrices
c	for each source-receiver combination. Of course, for
c	equally spaced depth points, some economy arises
c	in avoiding matrix recomputation.
c
c	So if mdpths+mdpthr > 2*mmax we do not make a big model
c	other wise we do
c-----
c	adjust the model so that additional layers are added
c	to permit source and receiver at top of a give layer
c-----
c	lyrins = .true.
c	if(mdpths+mdpthr .gt. 2.0*mmax .and. lyrins.eq. .false.)then
	if(mdpths+mdpthr .gt. 2.0*mmax )then
		lyrins = .false.
		write(LERR,*)' LAYER INSERTION NOT DONE'
	else
		lyrins = .true.	
		write(LERR,*)' LAYER INSERTION DONE'
		do 2108 i=1,mdpths
			call insert(depths(i))
 2108		continue
		do 2109 i=1,mdpthr
			call insert(depthr(i))
 2109		continue
		call dezero()
c-----
c		check whether neighboring layers are identical
c		to avoid redundant evaluation
c----
		call equlck()
	endif
c-----
c	verify the new model parameters
c-----
	write(LERR,*)'mmax=',mmax
	write(LERR,22)(d(i),a(i),b(i),rho(i),qa(i),qb(i),i=1,mmax)
c-----
c	Guarantee that no time wasted if any source in in the water
c-----
	do 2019 i=1,mdpths
		call srclay(depths(i), lmaxs(i), dphs)
		if(b(lmaxs(i)).le.1.0e-04)then
			do 2091 ii=1,16
			  if(ii.ne.7 .and. ii.ne.8 .and. ii.ne.16)then
			    jsrc(ii) = 0
			  endif
 2091			continue
		endif
 2019	continue
c-----
c	determine position of source and receive in new layers
c-----
	if(lyrins)then
		do 2020 i=1,mdpths
			call srclyr(depths(i), lmaxs(i), dphs)
 2020		continue
		do 2021 i=1,mdpthr
			call srclyr(depthr(i), lmaxr(i), dphs)
 2021		continue
	endif
	return
	end

	subroutine equlck()
	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/updnsm/equalu(NL), equald(NL)
	logical equalu, equald
c-----
c	To avoid repeated computation, check to see if neighboring layers
c	are identical, once for going up and another for going down
c-----
c	First check top down
c-----
	do 100 m=1,mmax
		if(m.eq.1)then
			equald(m) = .false.
		else if(m.gt.1
     1			.and. a(m).eq.a(m-1) 
     2			.and. b(m).eq.b(m-1)
     3			.and. d(m).eq.d(m-1) 
     4			.and. rho(m).eq.rho(m-1)
     5			.and. qa(m).eq.qa(m-1)
     6			.and. qb(m).eq.qb(m-1) )then
			equald(m) = .true.
		else
			equald(m) = .false.
		endif
  100	continue
c-----
c	check bottom up
c-----
	do 200 m=1,mmax
		if(m.eq.mmax)then
			equalu(m) = .false.
		else if(m.lt.mmax
     1			.and. a(m).eq.a(m+1) 
     2			.and. b(m).eq.b(m+1)
     3			.and. d(m).eq.d(m+1) 
     4			.and. rho(m).eq.rho(m+1)
     5			.and. qa(m).eq.qa(m+1)
     6			.and. qb(m).eq.qb(m+1) )then
			equalu(m) = .true.
		else
			equalu(m) = .false.
		endif
  200	continue
	return
	end

	subroutine insert(dph)
c	parameter (LER=0, LIN=5, LOT=6)
#include <f77/iounit.h>

	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
c-----
c	Insert a depth point into the model by splitting a layer
c	so that the point appears at the top boundary of the layer
c	dph = depth of interest
c-----
c	determine the layer in which the depth dph lies.
c	if necessary, adjust  layer thickness at the base
c-----
c	Here determine layer corresponding to specific depth dph
c	If the bottom layer is not thick enough, extend it
c
c	dep	- depth to bottom of layer
c	dphh	- height of specific depth above bottom of the layer
c-----
	dep = 0.0 
	dp = 0.0 
	dphh = -1.0
	do 100 m = 1,mmax 
		dp = dp + d(m) 
		dphh = dp - dph 
		if(m.eq.mmax)then
			if(d(mmax).le.0.0 .or. dphh.lt.0.0)then
				d(mmax) = (dph - dp)
			endif
		endif
		dep = dep + d(m) 
		dphh = dep - dph 
		ls = m 
		if(dphh.ge.0.0) go to 101 
  100	continue 
  101	continue 
c-----
c	In the current model, the depth point is in the ls layer
c	with a distance dphh to the bottom of the layer
c
c	Do not create unnecessary layers, e.g., at surface and internally
c	However do put in a zero thickness layer at the base if necessary
c-----
	if(dph .eq. 0.0)then
		ls = 1
		return
	else if(dphh .eq. 0.0 .and. ls.ne.mmax)then
		return
	else
c-----
c		adjust layering
c-----
		 do 102 m = mmax,ls,-1
			d(m+1) = d(m)
			a(m+1) = a(m)
			b(m+1) = b(m)
			rho(m+1) = rho(m)
			qa(m+1) = qa(m)
			qb(m+1) = qb(m)
  102		continue
		hsave = d(ls)
		d(ls) = hsave - dphh
		d(ls+1) = dphh
		ls = ls + 1
		mmax = mmax + 1
	endif
	return
	end

	subroutine dezero()
c	parameter (LER=0, LIN=5, LOT=6)
#include <f77/iounit.h>

	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
c-----
c	ultimately get rid of zero thickness layers - this
c	will require readjusting the model from top down, and
c	also readjusting the source and receiver indices.
c----
c	Here just guarantee that the halfspace is not of zero thickness
c-----
	dmin = 1.0e+30
	do 100 i=1,mmax-1
		if(d(i) .lt. dmin .and. d(i).gt.0.0)dmin = d(i)
  100	continue
c	if(d(mmax).le.0.0)then
c		d(mmax) = 0.1*dmin
c	endif
	return
	end

	subroutine srclyr(depth,lmax,dph)
c	parameter (LER=0, LIN=5, LOT=6)
#include <f77/iounit.h>

	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
c-----
c	Find source/receiver boundary. It is assumed that
c	it will lie upon a boundary
c
c	lmax = source layer 
c	     = 0 is the free surface 
c	depth = source depth 
c	dph = height of  source above lmax + 1 interface 
c	lmax = 0 is the free surface 
c-----
	if(depth.eq.0.0)then
		lmax = 1
		dph = 0.0
	else
		dep = 0.0 
		do 100 m = 2,mmax
			dep = dep + d(m-1) 
			dph = dep - depth 
			lmax = m 
			if(abs(dph).lt. 0.0001*d(m-1) .or.
     1				abs(dph).lt.1.0e-6)go to 101
  100		continue 
  101	continue 
	endif
	return 
	end 

	subroutine srclay(depth,lmax,dph)
c	parameter (LER=0, LIN=5, LOT=6)
#include <f77/iounit.h>

	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/lyrctl/lyrins
	logical lyrins
	if(.not.lyrins)then
        	call modcpy(.false.)
        	call insert(depth)
	endif
	call srclyr(depth,lmax,dph)
	return
	end

	subroutine velbnd() 
c	parameter (LER=0, LIN=5, LOT=6)
#include <f77/iounit.h>

c-----
c	get bounds on earth model 
c-----
	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/bound/vmin,vamin,vamax,vbmin,vbmax
c-----
c	initialize bound search
c-----
	vamin = 1.0e+30
	vbmin = 1.0e+30
	vmin  = 1.0e+30
	vamax = 0.0
	vbmax = 0.0
	write(LERR,2) 
    2	format(1h ,7x,'d',9x,'a',9x,'b',9x,'rho',6x,'1/qa',6x,'1/qb')
    3	format(1h ,4f10.2,2f10.6,5x,i5) 
	do 20 i = 1,mmax 
		if(a(i).gt.vamax)vamax=a(i)
		if(b(i).gt.vbmax)vbmax=b(i)
		if(a(i).lt.vamin)vamin=a(i)
		if(b(i).lt.vbmin .and. b(i).gt.0.0)vbmin=b(i)
		if(b(i).gt.0.1)then
			if(b(i).lt.vmin)vmin=b(i)
		else
			if(a(i).lt.vmin)vmin=a(i)
		endif
		if(qa(i).eq.0.0) qa(i) = 0.5*qb(i) 
		if(i.lt.mmax)then
		write(LERR,3)d(i),a(i),b(i),rho(i),qa(i),qb(i)
		endif
   20	continue 
    5	format(1h ,10x,3f10.2,2f10.6/1h ) 
	write(LERR,5)a(mmax),b(mmax),rho(mmax),qa(mmax),qb(mmax) 
c-----
c     obtain extreme velocity limits
c-----
      return 
      end 


	subroutine reset3(ifreq,jsrc,lsrc,ndist,n1,n2)
c-----
c	routine to reset temporary output file on unit 3
c	if it already exists due to an aborted run
c
c	the file is read until an error is found, which
c	indicates the total number of correct frequencies on the
c	output file. The file is rewound and the correct frequencies
c	are read in to reposition the output file. The
c	parameter ifreq indicates the number of complete frequency sets
c-----
	integer*4 lsrc(*), jsrc(16)
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
c-----
c	find the correct number by duplicating the writes of the main program
c-----
	ifreq = 0
	rewind 3
	do 2000 i = n1, n2
		do 2100 jd=1,ndist
		k = 0
		do 1000 js=1,mdpths
		do 1010 jr=1,mdpthr
			k = k + 1
			do 2200 jj=1,16
			if(jsrc(lsrc(jj)).eq.1)then
				read(3,err=9998,end=9999)xx,yy
			endif
 2200			continue
 1010		continue
 1000		continue
 2100		continue
		ifreq = ifreq + 1
 2000	continue
 9998	continue
 9999	continue
c-----
c	there are now ifreq known data sets out there
c	position write pointer on the output file
c-----
	rewind 3
	do 5000 i = 1,ifreq
		do 5100 jd=1,ndist
		k = 0
		do 4000 js=1,mdpths
		do 4010 jr=1,mdpthr
			k = k + 1
			do 5200 jj=1,16
			if(jsrc(lsrc(jj)).eq.1)then
				read(3,err=9998,end=9999)xx,yy
			endif
 5200			continue
 4010		continue
 4000		continue
 5100		continue
 5000	continue
	ifreq = ifreq -1 + n1
	return
	end

	subroutine aten(omega,qa,qb,xka,xkb,alpha,a,b,atna,atnb,iwat)
c-----
c	make velocities complex, using Futterman causality operator
c-----
	real*4 qa,qb,alpha,a,b
#ifdef CRAYSYSTEM
        complex omega,at,atna,atnb,xka,xkb
#else
	double complex omega,at,atna,atnb,xka,xkb
#endif
	real*8 pi, om1, oml, fac
c-----
c	reference frequency is 1.0 hz
c-----
	om1=6.2831853d+00
c-----
c	low frequency cutoff is 0.01 hz
c-----
#ifdef CRAYSYSTEM
        oml=0.062831853
        pi=3.1415927
        at=cmplx(0.0,0.0)
        if(cabs(omega).gt.oml) at=clog(omega/om1)/pi
        if(cabs(omega).le.oml) then
        fac=sqrt(oml*oml + (alpha*alpha))/oml
        at=clog(cmplx((oml),-(alpha))/(om1*fac))/pi
        endif
        atna=cmplx(1.0,0.0)
        atnb=cmplx(1.0,0.0)
        if(qa.gt.0.0) atna=(1.+(qa)*at+cmplx(0.0,(qa/2.)))
        if(qb.gt.0.0) atnb=(1.+(qb)*at+cmplx(0.0,(qb/2.)))
        xka=omega/((a)*atna)
        if(b.eq.0.0)then
                iwat = 1
                xkb = cmplx(0.0,0.0)
        else
                iwat = 0
                xkb=omega/((b)*atnb)
        endif
#else

	oml=0.062831853d+00
	pi=3.1415927d+00
	at=dcmplx(0.0d+00,0.0d+00)
c - changed to generic function names - joe m. wade - 10/20/00 
c	if(zabs(omega).gt.oml) at=zlog(omega/om1)/pi
c	if(zabs(omega).le.oml) then
 	if(abs(omega).gt.oml) at=log(omega/om1)/pi
	if(abs(omega).le.oml) then
c	fac=dsqrt(oml*oml + dble(alpha*alpha))/oml
	fac=sqrt(oml*oml + dble(alpha*alpha))/oml
c	at=zlog(dcmplx(dble(oml),-dble(alpha))/(om1*fac))/pi
	at=log(dcmplx(dble(oml),-dble(alpha))/(om1*fac))/pi
	endif
	atna=dcmplx(1.0d+00,0.0d+00)
	atnb=dcmplx(1.0d+00,0.0d+00)
	if(qa.gt.0.0) atna=(1.+dble(qa)*at+dcmplx(0.0d+00,dble(qa/2.)))
	if(qb.gt.0.0) atnb=(1.+dble(qb)*at+dcmplx(0.0d+00,dble(qb/2.)))
	xka=omega/(dble(a)*atna)
	if(b.le.1.0e-04)then
		iwat = 1
		xkb = dcmplx(0.0d+00,0.0d+00)
	else
		iwat = 0
		xkb=omega/(dble(b)*atnb)
	endif
#endif
	return
	end

	subroutine cmult(e,ca,exa,exe)
c-----
c	FORM EC where e(1x5) c(5x5)
#ifdef CRAYSYSTEM
        complex ca(5,5)
        complex e(5)
        complex c, ee(5)
#else
	double complex ca(5,5)
	real*8 exa,exe,eval
	real *8 xnorm
	double complex e(5)
	double complex c, ee(5)
#endif
	do 1350 i=1,5
#ifdef CRAYSYSTEM
                c = cmplx(0.0,0.0)
#else
		c = dcmplx(0.0d+00,0.0d+00)
#endif
		do 1349 j=1,5
			c=c+ e(j) * ca(j,i)
 1349		continue
		ee(i)=c
 1350	continue
	exe = exe + exa
	call normc(ee,eval,xnorm)
	do 1351 i=1,5
		e(i) = ee(i)*xnorm
 1351	continue
	exe = exe + eval
	return
	end

	subroutine rcmult(y,c,exa,exe)
c-----
c	FORM YC where y(5x5) c(5x5) RETURN Y
c-----
#ifdef CRAYSYSTEM
        complex c(5,5)
        complex y(5,5)
        complex ztmp, ee(5,5)
#else
	double complex c(5,5)
	double complex y(5,5)
	double complex ztmp, ee(5,5)
#endif
	real*8 exa,exe,eval
	real *8 xnorm

	do 1350 i=1,5
		do 1351 j=1,5
#ifdef CRAYSYSTEM
                        ztmp = cmplx(0.0,0.0)
#else
			ztmp = dcmplx(0.0d+00,0.0d+00)
#endif
			do 1349 k=1,5
				ztmp=ztmp+ y(i,k) * c(k,j)
 1349			continue
			ee(i,j)=ztmp
 1351		continue
 1350	continue
	exe = exe + exa
	call rnormc(ee,eval,xnorm)
	do 1353 j=1,5
		do 1352 i=1,5
			y(i,j) = ee(i,j)*xnorm
 1352		continue
 1353	continue
	exe = exe + eval
	return
	end

	subroutine dmult(da,aa)
c-----
c	propagator up
c	FORM D = DA
c-----
#ifdef CRAYSYSTEM
        complex aa(4,4)
        complex sumd,ea(4,4),da(4,4)
#else
	double complex aa(4,4)
	double complex sumd,ea(4,4),da(4,4)
#endif
	do 1360 i=1,4
		do 1361 j=1,4
#ifdef CRAYSYSTEM
                        sumd = cmplx(0.0,0.0)
#else
			sumd = dcmplx(0.0d+00,0.0d+00)
#endif
			do 1362 jj=1,4
			sumd=sumd+da(i,jj) * aa(jj,j)
 1362			continue
      			ea(i,j)=sumd
 1361		continue
 1360	continue
	do 1363 j=1,4
		do 1364 i=1,4
			da(i,j)=ea(i,j)
 1364		continue
 1363	continue
	return
	end

	subroutine dnka(ca,wvno2,gam,rho,iwat,w,x,cosp)
#ifdef CRAYSYSTEM
        complex w,x,cosp
        complex gam,ca,cpcq,cpy,cpz,cqw,cqx,xy,xz,wy,wz,gam2,
     1  gamm1,gamm2,a0c,xz2,wy2,temp
        complex wvno2
        complex cqww2, cqxw2, g1wy2, gxz2, g2wy2, g2xz2
        complex gg1, a0cgg1
        complex zrho, zrho2
#else
	double complex w,x,cosp
	double complex gam,ca,cpcq,cpy,cpz,cqw,cqx,xy,xz,wy,wz,gam2,
     1	gamm1,gamm2,a0c,xz2,wy2,temp
	common/ ovrflw / a0,cpcq,cpy,cpz,cqw,cqx,xy,xz,wy,wz
	double complex wvno2
	double complex cqww2, cqxw2, g1wy2, gxz2, g2wy2, g2xz2
	double complex gg1, a0cgg1
	double complex zrho, zrho2
#endif
	dimension ca(5,5)
	real *8 a0
c-----
c	The compound matrix of a 4x4 matrix, a(i,j), is 6x6 c(k,l) in dimension
c	However, certain structure simplifies things, e.g.,
c	c(3,j) = -c(4,j)/(wvno*wvno), j != 3,4
c	c(i,3) = -wvno*wvno*c(i,4),   i != 3,4
c	c(3,3) = c(4,4)
c	c(3,4) = -(c(4,4) -1 ) / (wvno*wvno)
c
c	In addition the F vector, is such that f(3) = -wvno*wvno*f(4)
c
c	If we wish to form F(transpose)C, we note that the resulting
c	structure is as the original F, and because of the relations
c	given above, the 6x6 c(k,l) can be reduced to a 5x5 c'(i,j)
c	and the f to a f' by the operation
c
c	Drop the third element of f
c	Drop the third row and column of c(k,l) to make a 5x5 c'
c	(the third row of c' is the fourth row of c, the fourth is the fifth,
c	and the fifth is the sixth)
c	Multiply the off diagonal elements of the third row of c' by two
c	e.g., c'(3,i) = 2c(4,j), i = { 1, 2, 4, 5} and j = { 1, 2, 5, 6}
c	Define the diagonal as c'(3,3) = 2 c(4,4) -1
c	
c	Since the product F(transpose)C is a row vector, and F'(transpose)C'
c	is computed, then f(3) = -wvno*wvno*f'(3)
c	f(1) = -wvno*wvno*f'(1), f(2) = -wvno*wvno*f'(2)
c	f(4) = -wvno*wvno*f'(3), f(5) = -wvno*wvno*f'(4)
c	f(6) = -wvno*wvno*f'(5)
c-----
#ifdef CRAYSYSTEM
        zrho = cmplx(rho,0.0e+00)
#else
	zrho = dcmplx(dble(rho),0.0d+00)
#endif
	if(iwat.eq.1)then
c-----
c	fluid layer
c-----
		do 100 j=1,5
			do 101 i=1,5
#ifdef CRAYSYSTEM
                                ca(i,j) = cmplx(0.0, 0.0)
  101                   continue
                        ca(j,j) = cmplx(1.0, 0.0)
#else
				ca(i,j) = dcmplx(0.0d+00, 0.0d+00)
  101			continue
			ca(j,j) = dcmplx(1.0d+00, 0.0d+00)
#endif
  100		continue
		ca(1,1) = cosp
		ca(5,5) = cosp
		ca(1,2) = - x/ zrho
		ca(2,1) = - zrho*w
		ca(2,2) = cosp
		ca(4,4) = cosp
		ca(4,5) = ca(1,2)
		ca(5,4) = ca(2,1)
	else
c-----
c	elastic layer
c-----
#ifdef CRAYSYSTEM
                zrho2= cmplx((rho*rho),0.0)
#else
		zrho2= dcmplx(dble(rho*rho),0.0d+00)
#endif
		gam2  = gam*gam
		gamm1 = gam-1.
		gamm2 = gamm1*gamm1
		cqww2 = cqw * wvno2
		cqxw2 = cqx / wvno2
		gg1 = gam*gamm1
#ifdef CRAYSYSTEM
                a0c  = cmplx(2.0,0.0)*
     1                  (cmplx(a0,0.0)-cpcq)
#else
		a0c  = dcmplx(2.0d+00,0.0d+00)*
     1			(dcmplx(a0,0.0d+00)-cpcq)
#endif
		xz2  = xz/wvno2
		gxz2 = gam*xz2
		g2xz2 = gam2 * xz2
		a0cgg1 = a0c*(gam+gamm1)
		wy2  = wy*wvno2
		g2wy2 = gamm2 * wy2
		g1wy2 = gamm1 * wy2
		temp = wvno2*(a0c + wy2) + xz
		ca(1,5) = -temp/zrho2
#ifdef CRAYSYSTEM
                temp = cmplx(0.5,0.0)*a0cgg1 + gxz2 + g1wy2
#else
		temp = dcmplx(0.5d+00,0.0d+00)*a0cgg1 + gxz2 + g1wy2
#endif
		ca(1,3) = -temp/zrho
		temp = a0c*gg1 + g2xz2 + g2wy2
		ca(3,3) = a0 + temp + temp
		ca(1,1) = cpcq-temp
#ifdef CRAYSYSTEM
                temp =cmplx(0.5,0.0)*a0cgg1*gg1
     1                  + gam2*gxz2 + gamm2*g1wy2
                ca(3,1) = cmplx(2.0,0.0)*temp*zrho
#else
		temp =dcmplx(0.5d+00,0.0d+00)*a0cgg1*gg1 
     1			+ gam2*gxz2 + gamm2*g1wy2
		ca(3,1) = dcmplx(2.0d+00,0.0d+00)*temp*zrho
#endif
		temp = gamm2*(a0c*gam2 + g2wy2) + gam2*g2xz2
		ca(5,1) = -zrho2*temp/wvno2
		ca(1,4) = (-cqww2+cpz)/zrho
		ca(2,1) = (-gamm2*cqw + gam2*cpz/wvno2)*zrho
		ca(2,3) = -(gamm1*cqww2 - gam*cpz)/wvno2
		ca(1,2) = (-cqx + wvno2*cpy)/zrho
#ifdef CRAYSYSTEM
		ca(3,2) = wvno2*(gam*cqxw2 - gamm1*cpy)*
     1                  cmplx(2.0,0.0)
#else
		ca(3,2) = wvno2*(gam*cqxw2 - gamm1*cpy)*
     1			dcmplx(2.0d+00,0.0d+00)
#endif
		ca(4,1) = (-gam2*cqxw2 + gamm2*cpy)*zrho
		ca(2,2) = cpcq
		ca(2,4) = -wz
		ca(4,2) = -xy
		ca(2,5)=ca(1,4)
		ca(5,5)=ca(1,1)
		ca(5,4)=ca(2,1)
#ifdef CRAYSYSTEM
                ca(5,3)=-ca(3,1)/(cmplx(2.0,0.0)*wvno2)
                ca(5,2)=ca(4,1)
                ca(4,3)= -ca(3,2)/(cmplx(2.0,0.0)*wvno2)
                ca(4,5)=ca(1,2)
                ca(4,4)=ca(2,2)
                ca(3,4)=-cmplx(2.0,0.0)*wvno2*ca(2,3)
                ca(3,5)=-cmplx(2.0,0.0)*wvno2*ca(1,3)
#else
		ca(5,3)=-ca(3,1)/(dcmplx(2.0d+00,00d+00)*wvno2)
		ca(5,2)=ca(4,1)
		ca(4,3)= -ca(3,2)/(dcmplx(2.0d+00,00d+00)*wvno2)
		ca(4,5)=ca(1,2)
		ca(4,4)=ca(2,2)
		ca(3,4)=-dcmplx(2.0d+00,00d+00)*wvno2*ca(2,3)
		ca(3,5)=-dcmplx(2.0d+00,00d+00)*wvno2*ca(1,3)
#endif
	endif
	return
	end

	subroutine excit(freq,xleng,xfac,dk)
c-----
c     sample response for all wavenumbers at a given frequency
c     using Bouchon equal wavenumber sampling = dk
c     with offset of 0.218dk
c-----
c	parameter(LER=0,LIN=5,LOT=6)
#include <f77/iounit.h>

	parameter(NL=100)
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	common/bound/vmin,vamin,vamax,vbmin,vbmax
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/jout/jsrc(16) , jbdrys, jbdryh
	common/damp/alpha,ieqex
c-----
c	set up common blocks for wavenumber sampling at
c	suitable depths. This is necessary since the matrix
c	evaluation is done here for all source-receiver pairs
c	The source-receiver distance is important for the
c	wavenumber sampling at low frequencies
c-----
	common/kint1/gasymp
		logical gasymp(NSR)
	common/kint2/mkup
		integer mkup(NSR)
	common/kint3/wave
		real*4 wave(NSR,2)
	common/kint4/aa,bb,cc
		complex aa(NSR,16),bb(NSR,16),cc(NSR,16)


#ifdef CRAYSYSTEM
	complex wvn,om, wvn2
#else
	double complex wvn,om, wvn2
#endif
	complex gg(16)
c-----
c	matrix components in layers and boundaries saved
c-----
#ifdef CRAYSYSTEM
	complex har(NL,4,4), dar(NL,5,5), hsr(2,5), gbr(2,5), 
     1		hal(NL,2,2), hsl(2,2), gbl(2,2)
#else
	double complex har(NL,4,4), dar(NL,5,5), hsr(2,5), gbr(2,5), 
     1		hal(NL,2,2), hsl(2,2), gbl(2,2)
#endif
	real*8 hex(NL), lex(NL), dex(NL), hexw(NL)
	common/hamat/har
 	common/damat/dar
	common/hsrfr/hsr
	common/gbrfr/gbr
	common/hlmat/hal
	common/hsrfl/hsl
	common/gbrfl/gbl
	common/hexex/hex
	common/hexexw/hexw
	common/dexex/dex
	common/lexex/lex 
	common/water/iwater(NL),iwats(2),iwatb(2)
	common/lyrctl/lyrins
	logical lyrins
c-----
c	determine the wavenumber limits
c-----
	omega=6.2831853*freq
c-----
c	evaluate wavenumber integration limits
c	and asymptotic coefficients
c-----
	call wvlimit(nk,omega,dk,xfac,xleng)
	rewind 2
	write(2)omega,nk
c-----
c	output wavenumber in reverse order
c-----
	call bufini(1,ierr)
	do 3998 ii=nk,1,-1
		wv = (ii-1)*dk + 0.218*dk
#ifdef CRAYSYSTEM
		wvn=cmplx(wv,0.0e+00)
#else
		wvn=dcmplx(dble(wv),0.0d+00)
#endif
		wvn2 = wvn*wvn
#ifdef CRAYSYSTEM
		om=cmplx(omega,-alpha)
#else
		om=dcmplx(dble(omega),-dble(alpha))
#endif
c-----
c	evaluate matrices first
c-----
		if(lyrins)then
			call evlmat(om,wvn,jbdrys,jbdryh,wvn2)
		endif
c-----
c	now evaluate for a specific source, receiver position
c-----
		call bufwr(wv)
		k = 0
		do 4000 js=1,mdpths
			do 4010 jr=1,mdpthr
				k = k + 1
				if(.not.lyrins)then
c-----
c				evaluate matrices first
c				for currently defined layering
c-----
				call modcpy(.false.)
				call insert(depths(js))
				call insert(depthr(jr))
				call srclyr(depths(js), lmaxs(js), dphs)
				call srclyr(depthr(jr), lmaxr(jr), dphr)
				call dezero()
				call equlck()
				call evlmat(om,wvn,jbdrys,jbdryh,wvn2)
				endif
				if(ii.le.mkup(k))then
				call rshof(gg,om,wvn,lmaxs(js),
     1					lmaxr(jr),wvn2)
c-----
c	if asymptotic is invoked, modify the integrand here
c-----
				if(gasymp(k))then
				  depth = abs(depths(js)-depthr(jr))
				  call gasym(gg,k,wv,depth,jsrc)
				endif
				else
					do 3997 j=1,16
						gg(j) = cmplx(0.0,0.0)
 3997					continue
				endif
				do 3999 j=1,16
					if(jsrc(j).eq.1)then
					  call bufwr(real(gg(j)))
					  call bufwr(aimag(gg(j)))
					endif
 3999				continue
 4010			continue
 4000		continue
 3998	continue
	call buflsh()
	return
	end

	subroutine wvlimit(nk,omega,dk,xfac,xleng)
	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/jout/jsrc(16) , jbdrys, jbdryh
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	common/bound/vmin,vamin,vamax,vbmin,vbmax
	common/damp/alpha,ieqex
	common/lyrctl/lyrins
	logical lyrins
c-----
c	set up common blocks for wavenumber sampling at
c	suitable depths. This is necessary since the matrix
c	evaluation is done here for all source-receiver pairs
c	The source-receiver distance is important for the
c	wavenumber sampling at low frequencies
c-----
	common/kint1/gasymp
		logical gasymp(NSR)
	common/kint2/mkup
		integer mkup(NSR)
	common/kint3/wave
		real*4 wave(NSR,2)
	common/kint4/aa,bb,cc
		complex aa(NSR,16),bb(NSR,16),cc(NSR,16)
#ifdef CRAYSYSTEM
	complex wvn,om, wvn2
#else
	double complex wvn,om, wvn2
#endif
	complex g1(16), g2(16)

c-----
c	get average  layer thickness
c-----
	deep = 0.0
	do 10 i=mmax,1,-1
		deep = deep + d(i)
   10	continue
	deep = deep/mmax
	k = 0
	nk = 0
	wvbm = omega/vmin
	dk = 6.2831853/xleng
#ifdef CRAYSYSTEM
	om=cmplx(omega,-alpha)
#else
	om=dcmplx(dble(omega),-dble(alpha))
#endif
	do 1000 js=1,mdpths
		do 1010 jr=1,mdpthr
			k = k + 1
			depth = abs(depths(js) - depthr(jr))
			if(depth.lt. deep)then
				dpth = deep
			else
				dpth = depth
			endif
			wvmm = (5.0/dpth) + xfac*wvbm
			mk = wvmm / dk
			mkup(k) = mk
			if(mk.gt.nk)nk = mk
			wvzmx = wvmm * depth
			if(wvzmx.gt.5.0)then
				wave(k,1) = 6.0/depth
				wave(k,2) = 2.5/depth
			else
				wave(k,1) = wvmm + 10.0*dk
				wave(k,2) = wvmm + 5.0*dk
			endif
			wv = (mk-1)*dk + 0.218*dk
			if(wv.gt.wave(k,1))then
				gasymp(k) = .false.
			else
				gasymp(k) = .true.
			endif
c-----
c	now evaluate asymptotic coefficients, if appropriate
c-----
			if(gasymp(k))then
			  if(.not. lyrins)then
			    call modcpy(.false.)
			    call insert(depths(js))
			    call insert(depthr(jr))
			    call srclyr(depths(js), lmaxs(js), dphs)
			    call srclyr(depthr(jr), lmaxr(jr), dphr)
			    call dezero()
			    call equlck()
			  endif
#ifdef CRAYSYSTEM
			  wvn=cmplx(wv,0.0e+00)
#else
			  wvn=dcmplx(dble(wv),0.0d+00)
#endif
			  wvn2 = wvn*wvn
			  call evlmat(om,wvn,jbdrys,jbdryh,wvn2)
#ifdef CRAYSYSTEM
			  wvn=cmplx(wave(k,1),0.0e+00)
#else
			  wvn=dcmplx(dble(wave(k,1)),0.0d+00)
#endif
			  wvn2 = wvn*wvn
#ifdef CRAYSYSTEM
			  om=cmplx(omega,-alpha)
#else
			  om=dcmplx(dble(omega),-dble(alpha))
#endif
			  call evlmat(om,wvn,jbdrys,jbdryh,wvn2)
			  call rshof(g1,om,wvn,lmaxs(js),lmaxr(jr),wvn2)
			  wvn=dcmplx(dble(wave(k,2)),0.0d+00)
			  wvn2 = wvn*wvn
#ifdef CRAYSYSTEM
			  om=cmplx(omega,-alpha)
#else
			  om=dcmplx(dble(omega),-dble(alpha))
#endif
			  call evlmat(om,wvn,jbdrys,jbdryh,wvn2)
			  call rshof(g2,om,wvn,lmaxs(js),lmaxr(jr),wvn2)
c-----
c			  find asymptotic coefficients using these values
c-----
      			  do 102 j=1,16
            		  	call solu(g1(j),g2(j),wave(k,1),
     1			  	wave(k,2),depth,j,
     2			  		aa(k,j),bb(k,j),cc(k,j) )
  102			  continue
c-----
			else
			  do 1101 i=1,16
			  	aa(k,i) = cmplx(0.0,0.0)
			  	bb(k,i) = cmplx(0.0,0.0)
			  	cc(k,i) = cmplx(0.0,0.0)
 1101			  continue
			endif
 1010		continue
 1000	continue
	return
	end

	subroutine gasym(g,k,wvno,depth,jsrc)
c-----
c	remove asymptotic trend from integrands
c-----
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/kint4/aa,bb,cc
		complex aa(NSR,16),bb(NSR,16),cc(NSR,16)
	complex g(16)
	dimension jsrc(16)
	ex = exp(-wvno*depth)
	do 1000 j=1,16
		if(jsrc(j).eq.1)then
			g(j)=g(j) - ex*(aa(k,j)+wvno*(bb(k,j)+
     1				wvno*(cc(k,j))))
		endif
 1000	continue
	return
	end

	subroutine hska(aa,w,x,y,z,cosp,cosq,wvno2,gam,gamm1,rho,
     1		iwat)
#ifdef CRAYSYSTEM
        complex wvno2
        complex aa(4,4),w,x,y,z,cosp,cosq,gam,gamm1
        complex cpq, gcpq, zw2, gzw2, g1w, g1y, gx
        complex zrho
        real*8 exl,ex,exw
        zrho = cmplx((rho),0.0)
#else
	double complex wvno2
	double complex aa(4,4),w,x,y,z,cosp,cosq,gam,gamm1
	double complex cpq, gcpq, zw2, gzw2, g1w, g1y, gx
	double complex zrho
        zrho = dcmplx(dble(rho),0.0d+00)
#endif
	if(iwat.eq.1)then
c-----
c	fluid layer
c-----
		do 100 j=1,4
			do 101 i=1,4
#ifdef CRAYSYSTEM
                                aa(i,j) = cmplx(0.0,0.0)
  101                   continue
                        aa(j,j) = cmplx(1.0, 0.0)
#else
				aa(i,j) = dcmplx(0.0d+00,0.0d+00)
  101			continue
			aa(j,j) = dcmplx(1.0d+00, 0.0d+00)
#endif
  100		continue
		aa(2,2) = cosp
		aa(3,3) = cosp
		aa(2,3) = -x/zrho
		aa(3,2) = - zrho*w
	else
c-----
c	elastic layer
c-----
		cpq = cosp-cosq
		gcpq = gam*cpq
		zw2 = z/wvno2
		gzw2 = gam*zw2
		g1w = gamm1*w
		g1y = gamm1*y
		gx = gam*x
		aa(1,1) = gcpq + cosq
	        aa(1,3) = -cpq/zrho
		aa(1,2)=-g1w+gzw2
		aa(1,4)=(wvno2*w-z)/zrho
		aa(2,1)= gx - wvno2*g1y
		aa(2,2) = -gcpq + cosp
		aa(2,3)=(-x+wvno2*y)/zrho
		aa(2,4)= - wvno2*aa(1,3)
		aa(3,1)= zrho*gamm1*gcpq
		aa(3,2)=zrho*((-gamm1*g1w)+(gam*gzw2))
		aa(3,4)=-wvno2*aa(1,2)
		aa(3,3)=aa(2,2)
		aa(4,1)=zrho*(((gam*gx)/wvno2) - (gamm1*g1y))
		aa(4,2)=-aa(3,1)/wvno2
		aa(4,3)=-aa(2,1)/wvno2
		aa(4,4)=aa(1,1)
	endif
	return
	end

	subroutine hskl(hl,cosql,yl,zl,h,iwat)
#ifdef CRAYSYSTEM
	complex hl(2,2)
	complex cosql,yl,zl,h
#else
	double complex hl(2,2)
	double complex cosql,yl,zl,h
#endif
	if(iwat.eq.0)then	
		hl(1,1) = cosql
		hl(2,1) = zl*h
		hl(1,2) = yl/h
		hl(2,2) = cosql
	else
#ifdef CRAYSYSTEM
		hl(1,1) = cmplx(1.0e+00,0.0e+00)
		hl(1,2) = cmplx(0.0e+00,0.0e+00)
		hl(2,1) = cmplx(0.0e+00,0.0e+00)
		hl(2,2) = cmplx(1.0e+00,0.0e+00)
#else
		hl(1,1) = dcmplx(1.0d+00,0.0d+00)
		hl(1,2) = dcmplx(0.0d+00,0.0d+00)
		hl(2,1) = dcmplx(0.0d+00,0.0d+00)
		hl(2,2) = dcmplx(1.0d+00,0.0d+00)
#endif
	endif
	return
	end 

	subroutine lmult(d11,d12,hl,iwat,exel,exb)
c-----
c	multiply SH matrix by a row vector on left
c-----
#ifdef CRAYSYSTEM
	complex d11,d12,hl(2,2),e1,e2
#else
	double complex d11,d12,hl(2,2),e1,e2
#endif
	real*8 exel, exb
c-----
c	fluid layer do nothing, just return, equivalent to multiplying by
c	identity matrix
c-----
	if(iwat.eq.0)then
c-----
c	elastic layer
c-----
		e1=d11
		e2=d12
c-----
c	a11 = cosql
c	a12 = yl
c	a21 = zl
c	a22 = cosql
c-----
		d11=e1*hl(1,1) + e2*hl(2,1)
		d12=e1*hl(1,2) + e2*hl(2,2)
		exel = exel + exb
	endif
	return
	end

	subroutine normc(e,ex,xnorm)
	real*8 ex
	real *8 test,testt,x,y,fac,xnorm
#ifdef CRAYSYSTEM
	complex e(*)
#else
	double complex e(*)
#endif
	test = 0.0D+00
	testt = 0.0D+00
	do 2 i = 1,5

c - changed to generic function names - joe m. wade - 10/20/00 
#ifdef CRAYSYSTEM
 		if(abs(real(e(i))).gt.testt) testt =abs(real(e(i)))
 		if(abs(aimag(e(i))).gt.testt) testt =abs(aimag(e(i)))
#else
c 		if(dabs(dreal(e(i))).gt.testt) testt =dabs(dreal(e(i)))
c 		if(dabs(dimag(e(i))).gt.testt) testt =dabs(dimag(e(i)))
 		if(abs(real(e(i))).gt.testt) testt =abs(real(e(i)))
 		if(abs(dimag(e(i))).gt.testt) testt =abs(dimag(e(i)))
#endif
    2	continue
	if(testt.lt.1.0e-30)testt=1.0
	do 1 i =1,5

c - changed to generic function names - joe m. wade - 10/20/00 
#ifdef CRAYSYSTEM
		x=real(e(i))/testt
		y=aimag(e(i))/testt
#else
c 		x=dreal(e(i))/testt
c 		y=dimag(e(i))/testt
 		x=real(e(i))/testt
 		y=dimag(e(i))/testt
#endif
		fac = x*x + y*y
		if(test.lt.fac) test = fac
    1	continue
c - changed to generic function names - joe m. wade - 10/20/00 
c#ifdef CRAYSYSTEM
	test = testt*sqrt(test)
	if(test.lt.1.0e-30) test=1.0
	xnorm = 1./test
	ex =-log(xnorm)
c#else
c	test = testt*dsqrt(test)
c	if(test.lt.1.0d-30) test=1.0
c	xnorm = 1./test
c	ex =-dlog(xnorm)
c#endif
	return
	end

	subroutine rnormc(e,ex,xnorm)
	real*8 ex
	real *8 test,testt,x,y,fac,xnorm
#ifdef CRAYSYSTEM
	complex e(5,5)
	test = 0.0e+00
	testt = 0.0e+00
#else
	double complex e(5,5)
	test = 0.0D+00
	testt = 0.0D+00
#endif
	do 3 j=1,5
	  do 2 i = 1,5
c - changed to generic function names - joe m. wade - 10/20/00 
#ifdef CRAYSYSTEM
	    if(abs(real(e(i,j))).gt.testt) testt =abs(real(e(i,j)))
	    if(abs(aimag(e(i,j))).gt.testt) testt =abs(aimag(e(i,j)))
#else
c	    if(dabs(dreal(e(i,j))).gt.testt) testt =dabs(dreal(e(i,j)))
c	    if(dabs(dimag(e(i,j))).gt.testt) testt =dabs(dimag(e(i,j)))
	    if(abs(real(e(i,j))).gt.testt) testt =abs(real(e(i,j)))
	    if(abs(dimag(e(i,j))).gt.testt) testt =abs(dimag(e(i,j)))
#endif
    2	  continue
    3	continue
	if(testt.lt.1.0e-30)testt=1.0
	do 4 j=1,5
		do 1 i =1,5
c - changed to generic function names - joe m. wade - 10/20/00 
#ifdef CRAYSYSTEM
			x=real(e(i,j))/testt
			y=aimag(e(i,j))/testt
#else
c			x=dreal(e(i,j))/testt
c			y=dimag(e(i,j))/testt
			x=real(e(i,j))/testt
			y=dimag(e(i,j))/testt
#endif
			fac = x*x + y*y
			if(test.lt.fac) test = fac
    1		continue
    4	continue
c - changed to generic function names - joe m. wade - 10/20/00 
c#ifdef CRAYSYSTEM
c	test = testt*sqrt(test)
c	if(test.lt.1.0e-30) test=1.0
c	xnorm = 1./test
c	ex =-log(xnorm)
c#else
c	test = testt*dsqrt(test)
c	if(test.lt.1.0d-30) test=1.0
c	xnorm = 1./test
c	ex =-dlog(xnorm)
c#endif
	test = testt*sqrt(test)
	if(test.lt.1.0d-30) test=1.0
	xnorm = 1./test
	ex =-log(xnorm)

	return
	end

	subroutine rshof(gg,om,wvno, lmaxs, lmaxr, wvno2) 
	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL) 
	common/bound/vmin,vamin,vamax,vbmin,vbmax
	common/damp/alpha,ieqex
c-----
c	gus - surface displacements or potentials or top of layer
c-----
#ifdef CRAYSYSTEM
	complex gus(16)
	complex wvno,wvno2,wvno3 
	complex cd(5),da(4,4),fr,y(4,4)
	complex om,fourpi,ka2,kb2 
	complex d11,d12,fl 
	complex s21,s32,s14,s34,s32e,s34e 
	complex s24,s33
	complex atna,atnb 
	complex wv4pi
	complex zzero
#else
	double complex gus(16)
	double complex wvno,wvno2,wvno3 
	double complex cd(5),da(4,4),fr,y(4,4)
	double complex om,fourpi,ka2,kb2 
	double complex d11,d12,fl 
	double complex s21,s32,s14,s34,s32e,s34e 
	double complex s24,s33
	double complex atna,atnb 
	double complex wv4pi
	double complex zzero
#endif
	real *8 fact,facx,exe,exl,exel,exll,elj
	real *8 exwu
	complex gg(16) 
c-----
c	Initialization
c-----
c - changed to generic function names - joe m. wade - 10/20/00 
#ifdef CRAYSYSTEM
	fourpi=12.5663706e+00*om*om
	zzero = cmplx(0.0e+00,0.0e+00)
#else
	fourpi=12.5663706d+00*om*om
c	zzero = dcmplx(0.0d+00,0.0d+00)
	zzero = cmplx(0.0d+00,0.0d+00)
#endif
c-----
c	do not evaluate for wvno = 0.0
c-----
c - changed to generic function names - joe m. wade - 10/20/00 
c
c #ifdef CRAYSYSTEM
c 	if(cabs(wvno).eq.0.0e+00) then
c #else
c 	if(zabs(wvno).eq.0.0d+00) then
c #endif

 	if(abs(wvno).eq.0.0d+00) then
		do 102 i=1,16
			gg(i) = cmplx(0.0,0.0)
  102		continue
	else
c-----
c	process for this wavenumber and frequency
c-----
		do 101 i = 1,16
			gus(i) = zzero
  101		continue
#ifdef CRAYSYSTEM
		wv4pi = 2.0e+00 * wvno / fourpi
#else
		wv4pi = 2.0d+00 * wvno / fourpi
#endif
		fourpi=12.5663706*om*om 
		wvno3 = wvno2*wvno 
		call aten(om,qa(lmaxs),qb(lmaxs),ka2,kb2,alpha,
     1			a(lmaxs),b(lmaxs),atna,atnb,iwat) 
		if(b(lmaxr).eq.0.0)then
			iwatr = 1
		else
			iwatr = 0
		endif
c-----
c	this follows Wang and Herrmann (1980), "A numerical study of P-, SV-, 
c		and SH-wave generation in a plane layerd medium,
c		Bull. Seism. Soc. Am. 70, 1015-1036.
c	For p-SV we use equation (8). Note below in "do 60" that the Z
c		component (odd index) is reversed from (8) so that +z is up
c
c	using the trick of reducing the 6x6 compound matrices to 5x5, the
c	following correspondence between what is given her and that in Wang
c	and Herrmann is in effect
c-----
c	Compound Matrix (6x6)	Here (5x5)
c
c	X|12/12 == 		cd(1)
c	X|12/13 ==		cd(2)
c	X|12/14 ==		-k^2 cd(3)
c	X|12/23 ==		cd(3)
c	X|12/24 ==		cd(4)
c	X|12/34 ==		cd(5)
c	X|12/21 = -X|12/12
c	X|12/ij = -X|12/ji
c
c	where
c
c	 |12
c	X|	= X|12/ij
c	 |ij
c-----
		ka2=ka2*ka2 
		kb2=kb2*kb2 
		call scoef(cd,da,fr,om,wvno,exe,exl,exwu,
     1			fl,d11,d12,exel,exll,lmaxs,lmaxr,wvno2) 
c-----
c	Form X|12/ij x Zj2 in Equation 8 of Wang and Herrmann
c----
c KLUDGE to CHANGE ORDER AND ALSO GET UR CORRECT FOR WATER LAYER
		do 50 k=1,2
c-----jj=1 = UZ, jj=2 = UR
			jj = 3 - k
			if(iwatr.eq.1 .and. jj.eq.2)then
				j = 3
			else
				j = k
			endif
			y(1,jj)= cd(1)*da(2,j) + cd(2)*da(3,j) 
     1				- wvno2*(cd(3)*da(4,j))
			y(2,jj)=-cd(1)*da(1,j) + cd(3)*da(3,j) 
     1				+ cd(4)*da(4,j)
			y(3,jj)=-cd(2)*da(1,j) - cd(3)*da(2,j) 
     1				+ cd(5)*da(4,j)
			y(4,jj)= wvno2*(cd(3)*da(1,j)) - cd(4)*da(2,j) 
     1				- cd(5)*da(3,j)
   50		continue
		if(iwatr.eq.1)then
			y(1,2) = -y(1,2)/rho(lmaxr)
			y(2,2) = -y(2,2)/rho(lmaxr)
			y(3,2) = -y(3,2)/rho(lmaxr)
			y(4,2) = -y(4,2)/rho(lmaxr)
		endif
c-----
c	evaluate different Green's functions
c	apply source terms
c----- 
c-----
c	START OF P-SV
c-----
c		First compute the DELTA displacementstress terms
c		for inverted model, the UZ, TR elements change
c-----
		if(iwat.eq.1)then
			s14 = zzero
			s21 = zzero
			s24 = zzero
			s32 = zzero
			s33 = zzero
			s34 = zzero
			s34e = zzero
		else
			s14=-wv4pi
#ifdef CRAYSYSTEM
			s21=2.0e+00*kb2/((rho(lmaxs))*fourpi)
			s24 = -2.0e+00/fourpi
			s32=wv4pi*2.*ka2/(rho(lmaxs))
			s33 = -wv4pi
			s34=wv4pi*( (2.*b(lmaxs)/a(lmaxs))**2 - 3.)
			s34e=2.0e+00*wv4pi*(ka2/kb2)
		endif
		s32e=ka2*wv4pi/dble(rho(lmaxs))
#else
			s21=2.0d+00*kb2/(dble(rho(lmaxs))*fourpi)
			s24 = -2.0d+00/fourpi
			s32=wv4pi*2.*ka2/dble(rho(lmaxs))
			s33 = -wv4pi
			s34=wv4pi*dble( (2.*b(lmaxs)/a(lmaxs))**2 - 3.)
			s34e=2.0d+00*wv4pi*(ka2/kb2)
		endif
		s32e=ka2*wv4pi/dble(rho(lmaxs))
#endif
c-----
c		receiver beneath the source
c-----
		if(lmaxr .gt. lmaxs)then
			s14 = -s14
			s24 = - s24
			s32 = - s32
			s32e = - s32e
			s34 = -s34
			s34e = -s34e
		endif
		do 61 j=1,2
			gus(j   ) = s32*y(2,j) + s34*y(4,j)
			gus(j+ 2) = s21*y(1,j)             
			gus(j+ 4) =             s14*y(4,j)
			gus(j+ 6) = s32e*y(2,j)+s34e*y(4,j)
			gus(j+ 8) = s33*y(3,j)
			gus(j+10) = s24*y(4,j)
   61		continue
		do 62 j=1,12,1
			gus(j) = -gus(j)
   62		continue
c-----
c		if receiver beneath the source unflip radial
c-----
		if(lmaxr .gt. lmaxs)then
			do 63 j=2,12,2
				gus(j) = - gus(j)
   63			continue
		endif
c-----
c	if the receiver is in the water and the source is an explosion
c	generate pressure time history at receiver
c	Also in water layer radial time history is generated differently
c-----
		if(iwatr.eq.1)then
#ifdef CRAYSYSTEM
			gus(16) =  (rho(lmaxr))*gus(8)
#else
			gus(16) =  dble(rho(lmaxr))*gus(8)
#endif
		endif
c-----
c	END OF P-SV
c-----
c	START OF SH
c-----
		if(iwat.eq.0 .and. iwatr.eq.0)then
#ifdef CRAYSYSTEM
			gus(13) = 2.0e+00*d11/(rho(lmaxs))
			gus(14) = -2.0e+00*wvno*d12*atnb*atnb*
     1				(b(lmaxs)*b(lmaxs))
			gus(15) = -2.0e+00*d12*
     1				(b(lmaxs)*b(lmaxs))*atnb*atnb
#else
			gus(13) = 2.0d+00*d11/dble(rho(lmaxs))
			gus(14) = -2.0d+00*wvno*d12*atnb*atnb*
     1				dble(b(lmaxs)*b(lmaxs))
			gus(15) = -2.0d+00*d12*
     1				dble(b(lmaxs)*b(lmaxs))*atnb*atnb
#endif
			if(lmaxr .gt. lmaxs)then
				gus(13) = - gus(13)
			endif
		endif
c-----
c	END OF SH
c-----
c-----
c	do final scaling for exponential
c-----
c-----
c	SV
c-----
c	fix for radial derived from vertical for fluid
c-----
		if(iwatr.eq.1)exwu = zzero
		do 71 k=1,2
			if(k.eq.1)then
				elj = -exe + exl 
			else
				elj = -exe + exl + exwu 
			endif
c - changed to generic function names - joe m. wade - 10/20/00 
#ifdef CRAYSYSTEM
			fact = 0.0e+00
			if(elj.gt.-55.) fact=exp(elj)
#else
			fact = 0.0D+00
c			if(elj.gt.-55.) fact=dexp(elj)
			if(elj.gt.-55.) fact=exp(elj)
#endif
			do 72 i=0,10,2
				j = i + k
				gg(j) = ( gus(j) * fact/fr)
				if(k.eq.1)then
					gg(j) = -gg(j)
				endif
   72			continue
c----
c	do pressure field
c----
			if(k.eq.1)then
				gg(16) = - (gus(16)*fact/fr)
			endif
   71		continue
c-----
c	SH
c-----
		elj=-exel+exll
		if(iwat.eq.0)then
			facx = 1./(12.5663706*b(lmaxs)*b(lmaxs))
			fact = 0.0
c - changed to generic function names - joe m. wade - 10/20/00 
c#ifdef CRAYSYSTEM
			if(elj.gt.-55.) fact = exp(elj)
c#else
c			if(elj.gt.-55.) fact = dexp(elj)
c#endif
			facx = fact*facx
			gg(13)=(gus(13 )*facx)/(fl*(atnb*atnb))
			gg(14)=(gus(14)*facx)/(fl*(atnb*atnb))
			gg(15)=(gus(15)*facx)/(fl*(atnb*atnb))
		else
			gg(13) = cmplx(0.0,0.0)
			gg(14) = cmplx(0.0,0.0)
			gg(15) = cmplx(0.0,0.0)
		endif
	endif
	return
	end

	subroutine evlmat(omega,wvno,jbdrys,jbdryh,wvno2)
	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	real *8 ex,exa,exb
	integer lmaxs, lmaxr, mdpths, mdpthr
	common/damp/alpha,ieqex
#ifdef CRAYSYSTEM
	complex omega,xka,xkb,ra,rb,gam,gamm1,p,q,w,x,y
	complex cosq,z,cosp
	complex  ca(5,5), hl(2,2)
	complex atna,atnb
	complex yl,zl,cosql
	complex wvno,wvno2
	complex h
	complex aa(4,4)
	complex zone
c-----
c	matrix components in layers and boundaries saved
c-----
	complex har(NL,4,4), dar(NL,5,5), hsr(2,5), gbr(2,5), 
     1		hal(NL,2,2), hsl(2,2), gbl(2,2)
#else
	double complex omega,xka,xkb,ra,rb,gam,gamm1,p,q,w,x,y
	double complex cosq,z,cosp
	double complex  ca(5,5), hl(2,2)
	double complex atna,atnb
	double complex yl,zl,cosql
	double complex wvno,wvno2
	double complex h
	double complex aa(4,4)
	double complex zone
c-----
c	matrix components in layers and boundaries saved
c-----
	double complex har(NL,4,4), dar(NL,5,5), hsr(2,5), gbr(2,5), 
     1		hal(NL,2,2), hsl(2,2), gbl(2,2)
#endif
	real*8 hex(NL), lex(NL), dex(NL), hexw(NL)
	common/hamat/har
 	common/damat/dar
	common/hsrfr/hsr
	common/gbrfr/gbr
	common/hlmat/hal
	common/hsrfl/hsl
	common/gbrfl/gbl
	common/hexex/hex
	common/hexexw/hexw
	common/dexex/dex
	common/lexex/lex 
	common/water/iwater(NL),iwats(2),iwatb(2)
	common/updnsm/equalu(NL), equald(NL)
	logical equalu, equald
	logical compute
c - changed to generic function names - joe m. wade - 10/20/00 
#ifdef CRAYSYSTEM
	zone  = cmplx(1.0e+00,0.0e+00)
#else
c	zone  = dcmplx(1.0d+00,0.0d+00)
	zone  = cmplx(1.0d+00,0.0d+00)
#endif
c-----
c	evaluate the G matrix 
c		gbr(1,x) is for normal stack
c		gbr(2,x) is for inverted stack
c-----
	call evalg(jbdryh,mmax,mmax-1,gbr,gbl,1,wvno,omega,wvno2)
	call evalg(jbdrys,1,   2,     gbr,gbl,2,wvno,omega,wvno2)
c-----
c	evaluate the H matrix
c		hsr(1,x) is for normal stack
c		hsr(2,x) is for inverted stack
c-----
	call evalh(jbdrys,1,   2,     hsr,hsl,1,wvno,omega,wvno2)
	call evalh(jbdryh,mmax,mmax-1,hsr,hsl,2,wvno,omega,wvno2)
c-----

c-----
c	matrix multiplication from bottom layer upward
c-----
	do 1340 m = 1,mmax,1
c-----
c	first check to see if computations already done
c-----
		if(equald(m))then
			compute = .false.
		else
			compute = .true.
		endif
		if(compute)then
			call aten(omega,qa(m),qb(m),xka,xkb,
     1				alpha,a(m),b(m),atna,atnb,iwat)

c - changed to generic function names - joe m. wade - 10/20/00 

c#ifdef CRAYSYSTEM
c			h =((rho(m)*b(m)*b(m))*atnb*atnb)
c			gam=(b(m))*(wvno/omega)
c			gam = gam * atnb
c			gam = cmplx(2.0e+00,0.0e+00)*gam*gam
c			gamm1 = gam - zone
c			ra=csqrt(wvno2-xka*xka)
c			rb=csqrt(wvno2-xkb*xkb)
c			p=ra*(d(m))
c			q=rb*(d(m))
c#else
c			h =(dble(rho(m)*b(m)*b(m))*atnb*atnb)
c			gam=dble(b(m))*(wvno/omega)
c			gam = gam * atnb
c			gam = dcmplx(2.0d+00,0.0d+00)*gam*gam
c			gamm1 = gam - zone
c			ra=zsqrt(wvno2-xka*xka)
c			rb=zsqrt(wvno2-xkb*xkb)
c			p=ra*dble(d(m))
c			q=rb*dble(d(m))
c#endif
			h =(dble(rho(m)*b(m)*b(m))*atnb*atnb)
			gam=dble(b(m))*(wvno/omega)
			gam = gam * atnb
			gam = cmplx(2.0d+00,0.0d+00)*gam*gam
			gamm1 = gam - zone
			ra=sqrt(wvno2-xka*xka)
			rb=sqrt(wvno2-xkb*xkb)
			p=ra*dble(d(m))
			q=rb*dble(d(m))

			call var(p,q,ra,rb,w,x,y,z,cosp,cosq,
     1				ex,exa,exb,yl,zl,cosql,iwat)
			call dnka(ca,wvno2,gam,rho(m),iwat,w,x,cosp)
			call hska(aa,w,x,y,z,cosp,cosq,wvno2,gam,
     1				gamm1,rho(m),iwat)
			call hskl(hl,cosql,yl,zl,h,iwat)
		endif
		iwater(m) = iwat
		call copy5(ca,dar,m,0,dex,exa)
		call copy4(aa,har,m,0,hex,ex)
		call copy2(hl,hal,m,0,lex,exb)
 1340	continue
	return
	end

	subroutine copy5(ca,dar,m,itofrm,dex,exa)
	parameter (NL=100)
#ifdef CRAYSYSTEM
	complex dar(NL,5,5)
	complex ca(5,5)
#else
	double complex dar(NL,5,5)
	double complex ca(5,5)
#endif
	integer itofrm
	real*8 dex(NL)
	real*8 exa
c-----
c	copy from ca to dar
c-----
	if(itofrm.eq.0)then
		do 100 j=1,5
			do 110 i=1,5
				dar(m,i,j) = ca(i,j)
  110			continue
			dex(m) = exa
  100		continue
c-----
c	copy from dar to ca
c-----
	else
		do 200 j=1,5
			do 210 i=1,5
				ca(i,j) = dar(m,i,j)
  210			continue
			exa = dex(m)
  200		continue
	endif
	return
	end

	subroutine copy4(aa,har,m,itofrm,hex,ex)
	parameter (NL=100)
#ifdef CRAYSYSTEM
	complex har(NL,4,4)
	complex aa(4,4)
#else
	double complex har(NL,4,4)
	double complex aa(4,4)
#endif
	integer itofrm
	real*8 hex(NL)
	real*8 ex
c-----
c	copy from aa to har
c-----
	if(itofrm.eq.0)then
		do 100 j=1,4
			do 110 i=1,4
				har(m,i,j) = aa(i,j)
  110			continue
			hex(m) = ex
  100		continue
c-----
c	copy from har to aa
c-----
	else
		do 200 j=1,4
			do 210 i=1,4
				aa(i,j) = har(m,i,j)
  210			continue
			ex = hex(m)
  200		continue
	endif
	return
	end

	subroutine copy2(hl,hal,m,itofrm,lex,exb)
	parameter (NL=100)
#ifdef CRAYSYSTEM
	complex hal(NL,2,2)
	complex hl(2,2)
#else
	double complex hal(NL,2,2)
	double complex hl(2,2)
#endif
	integer itofrm
	real*8 lex(NL)
	real*8 exb
c-----
c	copy from hl to hal
c-----
	if(itofrm.eq.0)then
		do 100 j=1,2
			do 110 i=1,2
				hal(m,i,j) = hl(i,j)
  110			continue
			lex(m) = exb
  100		continue
c-----
c	copy from hal to hl
c-----
	else
		do 200 j=1,2
			do 210 i=1,2
				hl(i,j) = hal(m,i,j)
  210			continue
			exb = lex(m)
  200		continue
	endif
	return
	end

	subroutine copy1(a,b,itofrm,num)
#ifdef CRAYSYSTEM
	complex a(*), b(*)
#else
	double complex a(*), b(*)
#endif
c-----
c	copy from a to b
c-----
	if(iftofrm.eq.0)then
		do 100 i=1,num
			b(i) = a(i)
  100		continue
c-----
c	copy from b to a
c-----
	else
		do 200 i=1,num
			a(i) = b(i)
  200		continue
	endif
	return
	end

	subroutine evalg(jbdry,m,m1,gbr,gbl,in,
     1		wvno,omega,wvno2)
	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/damp/alpha,ieqex
#ifdef CRAYSYSTEM
	complex gbr(2,5), gbl(2,2)
	complex omega,xka,xkb,ra,rb,gam,gamm1
	complex atna,atnb
	complex wvno,wvno2
	complex h
#else
	double complex gbr(2,5), gbl(2,2)
	double complex omega,xka,xkb,ra,rb,gam,gamm1
	double complex atna,atnb
	double complex wvno,wvno2
	double complex h
#endif
c-----
c	set up halfspace conditions
c-----
	wvno2=wvno*wvno
	call aten(omega,qa(m),qb(m),xka,xkb,alpha,a(m),
     1		b(m),atna,atnb,iwat)

c - changed to generic function names - joe m. wade - 10/20/00 

#ifdef CRAYSYSTEM
c	ra=csqrt(wvno2-xka*xka)
c	rb=csqrt(wvno2-xkb*xkb)
	ra=sqrt(wvno2-xka*xka)
	rb=sqrt(wvno2-xkb*xkb)
	gam = (b(m))*wvno/omega
	gam = gam * atnb
	gam = 2.0e+00 * (gam * gam)
	gamm1 = gam - cmplx(1.0e+00,0.0e+00)
        h =((rho(m)*b(m)*b(m))*atnb*atnb)
#else
c	ra=zsqrt(wvno2-xka*xka)
c	rb=zsqrt(wvno2-xkb*xkb)
	ra=sqrt(wvno2-xka*xka)
	rb=sqrt(wvno2-xkb*xkb)
	gam = dble(b(m))*wvno/omega
	gam = gam * atnb
	gam = 2.0d+00 * (gam * gam)
c	gamm1 = gam - dcmplx(1.0d+00,0.0d+00)
	gamm1 = gam - cmplx(1.0d+00,0.0d+00)
        h =(dble(rho(m)*b(m)*b(m))*atnb*atnb)
#endif
c-----
c	set up halfspace boundary conditions
c
c	jbdry	= -1  RIGID
c		=  0  ELASTIC
c		= +1  FREE SURFACE
c
c-----
	if(jbdry.lt.0)then
c-----
c	RIGID - check properties of layer above
c-----
		if(b(m) .gt. 0.0)then
c-----
c			ELASTIC ABOVE - RIGID
c-----
#ifdef CRAYSYSTEM
			gbr(in,1) = cmplx(1.0e+00,0.0e+00)
			gbr(in,2) = cmplx(0.0e+00,0.0e+00)
			gbr(in,3) = cmplx(0.0e+00,0.0e+00)
			gbr(in,4) = cmplx(0.0e+00,0.0e+00)
			gbr(in,5) = cmplx(0.0e+00,0.0e+00)
			gbl(in,1) = cmplx(1.0e+00,0.0e+00)
			gbl(in,2) = cmplx(0.0e+00,0.0e+00)
#else
			gbr(in,1) = dcmplx(1.0d+00,0.0d+00)
			gbr(in,2) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,3) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,4) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,5) = dcmplx(0.0d+00,0.0d+00)
			gbl(in,1) = dcmplx(1.0d+00,0.0d+00)
			gbl(in,2) = dcmplx(0.0d+00,0.0d+00)
#endif
		else
c-----
c			FLUID ABOVE - RIGID
c-----
#ifdef CRAYSYSTEM
			gbr(in,1) = cmplx(0.0e+00,0.0e+00)
			gbr(in,2) = cmplx(0.0e+00,0.0e+00)
			gbr(in,3) = cmplx(0.0e+00,0.0e+00)
			gbr(in,4) = cmplx(1.0e+00,0.0e+00)
			gbr(in,5) = cmplx(0.0e+00,0.0e+00)
#else
			gbr(in,1) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,2) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,3) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,4) = dcmplx(1.0d+00,0.0d+00)
			gbr(in,5) = dcmplx(0.0d+00,0.0d+00)
#endif
c-----
c			(pseudo SH)
c-----
#ifdef CRAYSYSTEM
			gbl(in,1) = cmplx(1.0e+00,0.0e+00)
			gbl(in,2) = cmplx(0.0e+00,0.0e+00)
#else
			gbl(in,1) = dcmplx(1.0d+00,0.0d+00)
			gbl(in,2) = dcmplx(0.0d+00,0.0d+00)
#endif
		endif
	else if(jbdry.eq.0)then
c-----
c	HALFSPACE
c-----
		if(iwat.eq.0)then
c-----
c			SOLID HALFSPACE
c-----
#ifdef CRAYSYSTEM
			gbr(in,1)=(rho(m)*rho(m))*
     1				(-gam*gam*ra*rb+wvno2*gamm1*gamm1)
			gbr(in,2)=-(rho(m))*(wvno2*ra)
			gbr(in,3)=(rho(m))*(-gam*ra*rb+wvno2*gamm1)
			gbr(in,4)=(rho(m))*(wvno2*rb)
			gbr(in,5)=wvno2*(wvno2-ra*rb)
			gbl(in,1) = (rho(m))*rb
			gbl(in,2) = cmplx(1.0e+00,0.0e+00)
     1				/((b(m)*b(m))*atnb*atnb)
#else
			gbr(in,1)=dble(rho(m)*rho(m))*
     1				(-gam*gam*ra*rb+wvno2*gamm1*gamm1)
			gbr(in,2)=-dble(rho(m))*(wvno2*ra)
			gbr(in,3)=dble(rho(m))*(-gam*ra*rb+wvno2*gamm1)
			gbr(in,4)=dble(rho(m))*(wvno2*rb)
			gbr(in,5)=wvno2*(wvno2-ra*rb)
			gbl(in,1) = dble(rho(m))*rb
c - changed to generic function names - joe m. wade - 10/20/00 
c			gbl(in,2) = dcmplx(1.0d+00,0.0d+00)
			gbl(in,2) = cmplx(1.0d+00,0.0d+00)
     1				/(dble(b(m)*b(m))*atnb*atnb)
#endif
		else if(iwat.eq.1)then
c-----
c			FLUID HALFSPACE
c-----
#ifdef CRAYSYSTEM
			gbr(in,1) = cmplx(0.0e+00,0.0e+00)
			gbr(in,2) = cmplx(0.0e+00,0.0e+00)
			gbr(in,3) = cmplx(0.0e+00,0.0e+00)
			gbr(in,4) = (0.5*rho(m)) / ra
			gbr(in,5) = cmplx(-0.5e+00,0.0e+00)
#else
			gbr(in,1) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,2) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,3) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,4) = dble(0.5*rho(m)) / ra
			gbr(in,5) = dcmplx(-0.5d+00,0.0d+00)
#endif
		endif
	else if(jbdry.eq.1)then
c-----
c	FREE - check properties of layer above
c-----
		if(b(m) .gt. 0.0)then
#ifdef CRAYSYSTEM
			gbr(in,1) = cmplx(0.0e+00,0.0e+00)
			gbr(in,2) = cmplx(0.0e+00,0.0e+00)
			gbr(in,3) = cmplx(0.0e+00,0.0e+00)
			gbr(in,4) = cmplx(0.0e+00,0.0e+00)
			gbr(in,5) = cmplx(1.0e+00,0.0e+00)
			gbl(in,1) = cmplx(0.0e+00,0.0e+00)
			gbl(in,2) = cmplx(1.0e+00,0.0e+00)
#else
			gbr(in,1) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,2) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,3) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,4) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,5) = dcmplx(1.0d+00,0.0d+00)
			gbl(in,1) = dcmplx(0.0d+00,0.0d+00)
			gbl(in,2) = dcmplx(1.0d+00,0.0d+00)
#endif
		else
#ifdef CRAYSYSTEM
			gbr(in,1) = cmplx(0.0e+00,0.0e+00)
			gbr(in,2) = cmplx(0.0e+00,0.0e+00)
			gbr(in,3) = cmplx(0.0e+00,0.0e+00)
			gbr(in,4) = cmplx(0.0e+00,0.0e+00)
			gbr(in,5) = cmplx(1.0e+00,0.0e+00)
			gbl(in,1) = cmplx(0.0e+00,0.0e+00)
			gbl(in,2) = cmplx(1.0e+00,0.0e+00)
#else
			gbr(in,1) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,2) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,3) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,4) = dcmplx(0.0d+00,0.0d+00)
			gbr(in,5) = dcmplx(1.0d+00,0.0d+00)
			gbl(in,1) = dcmplx(0.0d+00,0.0d+00)
			gbl(in,2) = dcmplx(1.0d+00,0.0d+00)
#endif
		endif
	endif
	return
	end

	subroutine evalh(jbdry,m,m1,hsr,hsl,in,wvno,omega,wvno2)
	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/damp/alpha,ieqex
#ifdef CRAYSYSTEM
	complex hsr(2,5), hsl(2,2)
	complex omega,xka,xkb,ra,rb,gam,gamm1
	complex atna,atnb
	complex wvno,wvno2
	complex h
#else
	double complex hsr(2,5), hsl(2,2)
	double complex omega,xka,xkb,ra,rb,gam,gamm1
	double complex atna,atnb
	double complex wvno,wvno2
	double complex h
#endif
c-----
c	set up surface conditions
c-----
	call aten(omega,qa(m),qb(m),xka,xkb,alpha,a(m),
     1		b(m),atna,atnb,iwat)
c - changed to generic function names - joe m. wade - 10/20/00 
#ifdef CRAYSYSTEM
c	ra=csqrt(wvno2-xka*xka)
c	rb=csqrt(wvno2-xkb*xkb)
	ra=sqrt(wvno2-xka*xka)
	rb=sqrt(wvno2-xkb*xkb)
	gam = (b(m))*wvno/omega
	gam = gam * atnb
	gam = 2.0e+00 * (gam * gam)
	gamm1 = gam - cmplx(1.0e+00,0.0e+00)
        h =((rho(m)*b(m)*b(m))*atnb*atnb)
#else
c	ra=zsqrt(wvno2-xka*xka)
c	rb=zsqrt(wvno2-xkb*xkb)
	ra=sqrt(wvno2-xka*xka)
	rb=sqrt(wvno2-xkb*xkb)
	gam = dble(b(m))*wvno/omega
	gam = gam * atnb
	gam = 2.0d+00 * (gam * gam)
c	gamm1 = gam - dcmplx(1.0d+00,0.0d+00)
	gamm1 = gam - cmplx(1.0d+00,0.0d+00)
        h =(dble(rho(m)*b(m)*b(m))*atnb*atnb)
#endif
c-----
c	do top surface condition
c
c		= -1  RIGID
c		=  0  ELASTIC
c		= +1  FREE SURFACE
c-----
		if(iwat.eq.0)then
			if(jbdry.eq.0)then
c-elastic
ccompound-elastic-only need first column
#ifdef CRAYSYSTEM
			  hsr(in,1) = -(wvno2 - ra*rb)/(4.0*rho(m)*rho(m))
			  hsr(in,2) = - rb/(4.0*rho(m))
			  hsr(in,3) =  2.0e+00*( wvno2*gamm1 - gam*ra*rb)/
     1					(4.0*rho(m))
			  hsr(in,4) = ra/(4.0*rho(m))
			  hsr(in,5) = (-gamm1*gamm1 +
     1					gam*gam*ra*rb/wvno2)/
     2					(4.0)
			  hsl(in,1) = cmplx(0.5e+00,0.0e+00)
			  hsl(in,2) = 0.5e+00*h*rb
#else
			  hsr(in,1) = -(wvno2 - ra*rb)/
     1					(4.0*rho(m)*rho(m))
			  hsr(in,2) = - rb/(4.0*rho(m))
 			  hsr(in,3) = 2.0e+00 *
     1					(wvno2*gamm1-gam*ra*rb) /
     2					(4.0 * rho(m))
			  hsr(in,4) = ra/(4.0*rho(m))
			  hsr(in,5) =
     1				(-gamm1*gamm1 + gam*gam*ra*rb/wvno2)
     2					/ (4.0)
			  hsl(in,1) = cmplx( 0.5e+00, 0.0e+00 )
			  hsl(in,2) = 0.5e+00*h*rb
#endif
			else if(jbdry.eq.-1)then
c-rigid
#ifdef CRAYSYSTEM
			  hsr(in,1) = cmplx(0.0e+00,0.0e+00)
			  hsr(in,2) = cmplx(0.0e+00,0.0e+00)
			  hsr(in,3) = cmplx(0.0e+00,0.0e+00)
			  hsr(in,4) = cmplx(0.0e+00,0.0e+00)
			  hsr(in,5) = cmplx(1.0e+00,0.0e+00)
			  hsl(in,1) = cmplx(0.0e+00,0.0e+00)
			  hsl(in,2) = cmplx(1.0e+00,0.0e+00)
#else
			  hsr(in,1) = dcmplx(0.0d+00,0.0d+00)
			  hsr(in,2) = dcmplx(0.0d+00,0.0d+00)
			  hsr(in,3) = dcmplx(0.0d+00,0.0d+00)
			  hsr(in,4) = dcmplx(0.0d+00,0.0d+00)
			  hsr(in,5) = dcmplx(1.0d+00,0.0d+00)
			  hsl(in,1) = dcmplx(0.0d+00,0.0d+00)
			  hsl(in,2) = dcmplx(1.0d+00,0.0d+00)
#endif
			else if(jbdry.eq.1)then
c-rigid
#ifdef CRAYSYSTEM
			  hsr(in,1) = cmplx(1.0e+00,0.0e+00)
			  hsr(in,2) = cmplx(0.0e+00,0.0e+00)
			  hsr(in,3) = cmplx(0.0e+00,0.0e+00)
			  hsr(in,4) = cmplx(0.0e+00,0.0e+00)
			  hsr(in,5) = cmplx(0.0e+00,0.0e+00)
			  hsl(in,1) = cmplx(1.0e+00,0.0e+00)
			  hsl(in,2) = cmplx(0.0e+00,0.0e+00)
#else
			  hsr(in,1) = dcmplx(1.0d+00,0.0d+00)
			  hsr(in,2) = dcmplx(0.0d+00,0.0d+00)
			  hsr(in,3) = dcmplx(0.0d+00,0.0d+00)
			  hsr(in,4) = dcmplx(0.0d+00,0.0d+00)
			  hsr(in,5) = dcmplx(0.0d+00,0.0d+00)
			  hsl(in,1) = dcmplx(1.0d+00,0.0d+00)
			  hsl(in,2) = dcmplx(0.0d+00,0.0d+00)
#endif
			endif
c-----fluid surface
		else if(iwat.gt.0)then
			if(jbdry.eq.0)then
ccompound-elastic-only need first column
#ifdef CRAYSYSTEM
				hsr(in,1) = -ra/(rho(m))
				hsr(in,2) = cmplx(1.0e+00,0.0e+00)
				hsr(in,3) = cmplx(0.0e+00,0.0e+00)
				hsr(in,4) = cmplx(0.0e+00,0.0e+00)
				hsr(in,5) = cmplx(0.0e+00,0.0e+00)
				hsl(in,1) = cmplx(1.0e+00,0.0e+00)
				hsl(in,2) = cmplx(0.0e+00,0.0e+00)
#else
				hsr(in,1) = -ra/dble(rho(m))
				hsr(in,2) = dcmplx(1.0d+00,0.0d+00)
				hsr(in,3) = dcmplx(0.0d+00,0.0d+00)
				hsr(in,4) = dcmplx(0.0d+00,0.0d+00)
				hsr(in,5) = dcmplx(0.0d+00,0.0d+00)
				hsl(in,1) = dcmplx(1.0d+00,0.0d+00)
				hsl(in,2) = dcmplx(0.0d+00,0.0d+00)
#endif
			else if(jbdry.eq.-1)then
c-rigid do not change SH
#ifdef CRAYSYSTEM
				hsr(in,1) = cmplx(0.0e+00,0.0e+00)
				hsr(in,2) = cmplx(1.0e+00,0.0e+00)
				hsr(in,3) = cmplx(0.0e+00,0.0e+00)
				hsr(in,4) = cmplx(0.0e+00,0.0e+00)
				hsr(in,5) = cmplx(0.0e+00,0.0e+00)
#else
				hsr(in,1) = dcmplx(0.0d+00,0.0d+00)
				hsr(in,2) = dcmplx(1.0d+00,0.0d+00)
				hsr(in,3) = dcmplx(0.0d+00,0.0d+00)
				hsr(in,4) = dcmplx(0.0d+00,0.0d+00)
				hsr(in,5) = dcmplx(0.0d+00,0.0d+00)
#endif
			else if(jbdry.eq.1)then
#ifdef CRAYSYSTEM
				hsr(in,1) = cmplx(1.0e+00,0.0e+00)
				hsr(in,2) = cmplx(0.0e+00,0.0e+00)
				hsr(in,3) = cmplx(0.0e+00,0.0e+00)
				hsr(in,4) = cmplx(0.0e+00,0.0e+00)
				hsr(in,5) = cmplx(0.0e+00,0.0e+00)
				hsl(in,1) = cmplx(1.0e+00,0.0e+00)
				hsl(in,2) = cmplx(0.0e+00,0.0e+00)
#else
				hsr(in,1) = dcmplx(1.0d+00,0.0d+00)
				hsr(in,2) = dcmplx(0.0d+00,0.0d+00)
				hsr(in,3) = dcmplx(0.0d+00,0.0d+00)
				hsr(in,4) = dcmplx(0.0d+00,0.0d+00)
				hsr(in,5) = dcmplx(0.0d+00,0.0d+00)
				hsl(in,1) = dcmplx(1.0d+00,0.0d+00)
				hsl(in,2) = dcmplx(0.0d+00,0.0d+00)
#endif
			endif
		endif
	return
	end

	subroutine scoef(cd,da,fr,omega,wvno,exe,exl,exwu,
     1		fl,d11,d12,exel,exll,llmaxs,llmaxr,wvno2)
	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/damp/alpha,ieqex
#ifdef CRAYSYSTEM
	complex omega
	complex  da(4,4),ca(5,5)
	complex   cd(5),e(5),fr
	complex d11,d12,e1,e2,fl
	complex wvno,wvno2
	complex zdum
	complex aa(4,4)
	complex cy(5,5)
	complex zzero, zone
	complex y11, y12, sd11, sd21
	complex hl(2,2)
c-----
c	matrix components in layers and boundaries saved
c-----
	complex har(NL,4,4), dar(NL,5,5), hsr(2,5), gbr(2,5), 
     1		hal(NL,2,2), hsl(2,2), gbl(2,2)
#else
	double complex omega
	double complex  da(4,4),ca(5,5)
	double complex   cd(5),e(5),fr
	double complex d11,d12,e1,e2,fl
	double complex wvno,wvno2
	double complex zdum
	double complex aa(4,4)
	double complex cy(5,5)
	double complex zzero, zone
	double complex y11, y12, sd11, sd21
	double complex hl(2,2)
c-----
c	matrix components in layers and boundaries saved
c-----
	double complex har(NL,4,4), dar(NL,5,5), hsr(2,5), gbr(2,5), 
     1		hal(NL,2,2), hsl(2,2), gbl(2,2)
#endif
	real*8 hex(NL), lex(NL), dex(NL), hexw(NL)
	real *8 exe,exl,exel,exll,ex,exa,exb,exwu
	common/hamat/har
 	common/damat/dar
	common/hsrfr/hsr
	common/gbrfr/gbr
	common/hlmat/hal
	common/hsrfl/hsl
	common/gbrfl/gbl
	common/hexex/hex
	common/hexexw/hexw
	common/dexex/dex
	common/lexex/lex 
	common/water/iwater(NL),iwats(2),iwatb(2)
	common/updnsm/equalu(NL), equald(NL)
	logical equalu, equald
	logical retrieve
c-----
c	initialize matrices
c-----
#ifdef CRAYSYSTEM
#else
	zzero = cmplx(0.0e+00,0.0e+00)
	zone  = cmplx(1.0e+00,0.0e+00)
#endif
	exe=0.0
	exl=0.0
	exwu = 0.0
	do 2 j = 1,4
		do 3 i = 1,4
			da(i,j)=zzero
    3		continue
		da(j,j) = zone
    2	continue
	do 12 j=1,5
		do 13 i=1,5
			cy(i,j) = zzero
   13		continue
		cy(j,j) = zone
   12	continue
	y11 = zone
	y12 = zzero
	exel = 0.0
	exll = 0.0
c-----
c     set up halfspace conditions
c-----
	if(llmaxs .ge. llmaxr)then
		in = 1
	else
		in = 2
	endif
	do 100 i=1,5
		e(i) = gbr(in,i)
  100	continue
	e1 = gbl(in,1)
	e2 = gbl(in,2)
	do 11 i=1,5
		cd(i)=e(i)
   11	continue
	d11=e1
	d12=e2
c-----
c	set up limits on the layer stacking
c-----
	if(llmaxs .ge. llmaxr)then
		lmaxs = llmaxs
		lmaxr = llmaxr
	else
		lmaxs = mmax - llmaxs + 2
		lmaxr = mmax - llmaxr + 2
	endif
c-----
c	matrix multiplication from bottom layer upward
c-----
	do 1340 mm = mmax,1,-1
		if(llmaxs .ge. llmaxr)then
			m = mm
			if(equalu(m))then
				retrieve = .false.
			else
				retrieve = .true.
			endif
		else
			m = mmax + 1 - mm
			if(equald(m))then
				retrieve = .false.
			else
				retrieve = .true.
			endif
		endif
		iwat = iwater(m)
		if(retrieve)then
			call copy5(ca,dar,m,1,dex,exa)
			call copy2(hl,hal,m,1,lex,exb)
				call copy4(aa,har,m,1,hex,ex)
		endif
		call cmult(e,ca,exa,exe)
		call lmult(e1,e2,hl,iwat,exel,exb)
		if(mm.lt.lmaxr)then
			call rcmult(cy,ca,exa,exl)
			call lmult(y11,y12,hl,iwat,exll,exb)
		else if(mm.ge.lmaxr .and. mm.lt.lmaxs) then
			call dmult(da,aa)
			if(iwat.eq.0)then
				exl = exl + ex
			else 
				exw = exw + ex
			endif
c-----
c	save values at top of source layer
c-----
		else if(mm.eq.lmaxs) then
                  	do 1352 i=1,5
				cd(i)=e(i)
 1352			continue
			exl=exe
			exll = exel
			d11=e1
			d12=e2
		endif
		if(mm.eq.1)then
			do 200 i=1,5
				ca(i,1) = hsr(in,i)
  200			continue
			sd11 = hsl(in,1)
			sd21 = hsl(in,2)
			zdum = e1
			e1 = zdum*sd11 + e2*sd21
			e2 = zdum*sd11 - e2*sd21
			zdum = y11
			y11 = zdum*sd11 + y12*sd21
			y12 = zdum*sd11 - y12*sd21
#ifdef CRAYSYSTEM
			zdum = cmplx(0.0,0.0)
#else
			zdum = dcmplx(0.0,0.0)
#endif
			do 1402 i=1,5
				zdum = zdum + e(i)*ca(i,1)
 1402			continue
			e(1) = zdum
			call rcmult(cy,ca,zzero,exl)
		endif
 1340 continue
c-----
c	get final matrices
c-----
c-SH
	d11 = y11*d11
	d12 = y11*d12
	fl=e1
c-P-SV
c	form x(l,m)y(ij|12)
c-----take care of x(i,j) y(1j|12) and replace the da
		aa(1,1) = czero
		aa(2,1) = cy(1,1)
		aa(3,1) = cy(2,1)
#ifdef CRAYSYSTEM
		aa(4,1) = -cy(3,1) /(2.0e+00 * wvno2)
#else
		aa(4,1) = -cy(3,1) /(2.0d+00 * wvno2)
#endif
c change sign 0430 1200
		aa(1,2) = -aa(2,1)
		aa(2,2) = zzero
#ifdef CRAYSYSTEM
		aa(3,2) = 0.5e+00 * cy(3,1)
#else
		aa(3,2) = 0.5d+00 * cy(3,1)
#endif
		aa(4,2) = cy(4,1)
		aa(1,3) = - aa(3,1)
		aa(2,3) = - aa(3,2)
		aa(3,3) = zzero
		aa(4,3) = cy(5,1)
		aa(1,4) = - aa(4,1)
		aa(2,4) = - aa(4,2)
		aa(3,4) = - aa(4,3)
		aa(4,4) = zzero
		call dmult(da,aa)
	fr=e(1)
	return
	end

	subroutine var(p,q,ra,rb,w,x,y,z,cosp,cosq,ex,
     1		exa,exl,yl,zl,cosql,iwat)
c     not modified for negative p,q
c     this assumes that real p and real q have same signs
	common/ovrflw/a0,cpcq,cpy,cpz,cqw,cqx,xy,xz,wy,wz
#ifdef CRAYSYSTEM
	complex cpcq,cpy,cpz,cqw,cqx,xy,xz,wy,wz
	complex p,q,ra,rb,w,x,y,z,cosp,cosq
	complex yl,zl,cosql
	complex eqp,eqm,epp,epm,sinp,sinq
#else
	double complex cpcq,cpy,cpz,cqw,cqx,xy,xz,wy,wz
	double complex p,q,ra,rb,w,x,y,z,cosp,cosq
	double complex yl,zl,cosql
	double complex eqp,eqm,epp,epm,sinp,sinq
#endif
	real *8 a0,pr,pi,qr,qi,fac,qmp,ex,exa,exl
c-----
c	form terms such as cos(p), sin(p), cos(q), sin(q)
c	and cos(p)*cos(q)
c
c	Introduce a factorization of exponentials to
c	make a pseudo floating point system
c
c	ex is the exponent in cosp
c	exl is the exponent in cosq for SH
c	exa is the exponent in cosp*cosq
c-----
#ifdef CRAYSYSTEM
      ex=0.0e+00
      exl = 0.0e+00
      a0=0.0e+00
      pr=real(p)
      pi=aimag(p)
      epp=cmplx(cos(pi),sin(pi))/2.
      epm=conjg(epp)
      ex=pr
      fac=0.0
      if(pr.lt.15.) fac=exp(-2.*pr)
#else
      ex=0.0d+00
      exl = 0.0d+00
      a0=0.0d+00
      pr=real(p)
      pi=dimag(p)
      epp=dcmplx(dcos(pi),dsin(pi))/2.
      epm=dconjg(epp)
      ex=pr
      fac=0.0
      if(pr.lt.15.) fac=dexp(-2.*pr)
#endif
      cosp=epp + fac*epm
      sinp=epp - fac*epm
      w=sinp/ra
      x=ra*sinp
	if(iwat.eq.1)then
c-----
c	fluid layer
c-----
#ifdef CRAYSYSTEM
		a0 = 1.0e+00
		exa = ex
		cosq = 1.0e+00
		y = 0.0e+00
		z = 0.0e+00
		cosql = 1.0e+00
		yl = 0.0e+00
		zl = 0.0e+00
		exl = 0.0e+00
#else
		a0 = 1.0d+00
		exa = ex
		cosq = 1.0d+00
		y = 0.0d+00
		z = 0.0d+00
		cosql = 1.0d+00
		yl = 0.0d+00
		zl = 0.0d+00
		exl = 0.0d+00
#endif
	else
c-----
c	elastic layer
c-----
#ifdef CRAYSYSTEM
		qr=real(q)
		qi=aimag(q)
		eqp=cmplx(cos(qi),sin(qi))/2.
		eqm=conjg(eqp)
		exl=qr
		fac=0.0e+00
		if(qr.lt.15.) fac=exp(-2.*qr)
		cosql=eqp + fac*eqm
		sinq=eqp - fac*eqm
		yl=sinq/rb
		zl=rb*sinq
c-----
c	form factors for compound P-SV matrix
c-----
		exa=pr + qr
		cpcq=cosp*cosql
		cpy=cosp*yl
		cpz=cosp*zl
		cqw=cosql*w
		cqx=cosql*x
		xy=x*yl
		xz=x*zl
		wy=w*yl
		wz=w*zl
		fac=0.0e+00
		qmp=qr-pr
		if(qmp.gt.-40.) fac=exp(qmp)
		cosq=cosql*fac
		y=fac*yl
		z=fac*zl
		fac=0.0e+00
		if(exa.lt.60.) a0=exp(-exa)
#else
		qr=real(q)
		qi=dimag(q)
		eqp=dcmplx(dcos(qi),dsin(qi))/2.
		eqm=dconjg(eqp)
		exl=qr
		fac=0.0d+00
		if(qr.lt.15.) fac=dexp(-2.*qr)
		cosql=eqp + fac*eqm
		sinq=eqp - fac*eqm
		yl=sinq/rb
		zl=rb*sinq
c-----
c	form factors for compound P-SV matrix
c-----
		exa=pr + qr
		cpcq=cosp*cosql
		cpy=cosp*yl
		cpz=cosp*zl
		cqw=cosql*w
		cqx=cosql*x
		xy=x*yl
		xz=x*zl
		wy=w*yl
		wz=w*zl
		fac=0.0d+00
		qmp=qr-pr
		if(qmp.gt.-40.) fac=dexp(qmp)
		cosq=cosql*fac
		y=fac*yl
		z=fac*zl
		fac=0.0d+00
		if(exa.lt.60.) a0=dexp(-exa)
#endif
	endif
	return
	end

      subroutine bufini(irdwr,ierr)
c------initialize buffer pointer
c------irdwr = 0 read initialize
c------irdwr = 1 write initialize
      integer BUFMAX
       parameter(BUFMAX=2000)
       common/buf/iptr,max,buffer(BUFMAX)
c       save /buf/
      iptr = 1
      if(irdwr.eq.0)call getbuf(ierr)
      return
      end

        subroutine buflsh
c------flush output buffer
      integer BUFMAX
      parameter(BUFMAX=2000)
        common/buf/iptr,max,buffer(BUFMAX)
c     save /buf/
      ipt = iptr -1
      if(ipt.gt.0)write(2)ipt,(buffer(i),i=1,ipt)
        iptr = 1
      return
      end

        subroutine bufwr(x)
c------fill buffer with floating point variable x,
c------flush buffer as necessary
      integer BUFMAX
      parameter(BUFMAX=2000)
      common/buf/iptr,max,buffer(BUFMAX)
c     save /buf/
      buffer(iptr) = x
      iptr = iptr + 1
      if(iptr.gt.BUFMAX)call buflsh
      return
      end

        subroutine getbuf(ierr)
c------read in file contents into buffer, taking care not to
c------read beyond the contents of the file
      integer BUFMAX
      parameter(BUFMAX=2000)
      common/buf/iptr,max,buffer(BUFMAX)
c     save /buf/
c------ierr = 0 successful read
c------     = 1 read error
c------     = 2 end of file
c------
      read(2,err=1000,end=2000)max,(buffer(i),i=1,max)
      iptr = 1
      ierr = 0
      return
 1000 ierr = 1
      return
 2000 ierr = 2
      return
      end

      subroutine bufrd(x,ierr)
c-----retrieve a value from buffer array, red in new array
c-----as necessary
c-----iptr is here the next array element to be read
c-----it is always >= 1. We do not worry the upper limit
c-----since the calling program must worry about this
c-----because read always follows a complete write
      integer BUFMAX
      parameter(BUFMAX=2000)
      common/buf/iptr,max,buffer(BUFMAX)
c     save /buf/
c       only yank in new data if actually required
      if(iptr.gt.max)call getbuf(ierr)
      x = buffer(iptr)
      iptr = iptr + 1
      return
      end

	subroutine wvint(r,smm,dk)
c-----
c	to work with potentially large disk files, we cannot read in
c	all wavenumbers at once. We only work with neighboring
c	points at any time. The first two are for the DC correction,
c	followed by wavenumbers in decreasing order
c-----
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	common/c/cmax,c1,c2,cmin
	common/jout/jsrc(16) , jbdrys, jbdryh
	common/fct/fact ,fact0
        common/asym/j0k0(NSR),j0k1(NSR),j0k2(NSR),j0k3(NSR),
     1		j1k0(NSR),j1k1(NSR),j1k2(NSR),j1k3(NSR),
     2		j2k0(NSR),j2k1(NSR),j2k2(NSR),j2k3(NSR),
     3		j1k0r(NSR),j1k1r(NSR),j1k2r(NSR),j1k3r(NSR)
        real*4 j0k0,j0k1,j0k2,j0k3,
     1		j1k0,j1k1,j1k2,j1k3,
     2		j2k0,j2k1,j2k2,j2k3,
     3		j1k0r,j1k1r,j1k2r,j1k3r
	common/kint4/aa,bb,cc
		complex aa(NSR,16),bb(NSR,16),cc(NSR,16)
	complex gg1(NSR),sumc(NSR)
	complex g(NSR,16)
	complex smm(NSR,16)
	complex sumd(NSR)
	real*4 wvn
	real j01,j11
c-----
c	process
c-----
	rewind 2
	read(2)  omega,nk
	call bufini(0,ierr)
c-----
c	initialize integral
c-----
	call intini(smm,r)
c-----
c	we now can procede with integration
c-----
c	in the variables below the t0,j0,j1,sum refer to upper limit
c	of integration and t01,j01,j11 and sum1 refer to the lower limit
c-----
	wvcm=omega*cmax
	wvc1=omega*c1
	wvc2=omega*c2
	wvcn=omega*cmin
	do 200 ik = nk,1,-1
		call getgk(g,jsrc,wvn)
		t01 = wvn * r
		dkk = dk 
		call hank(t01,j01,j11)
c-----
c	perform windowing in wavenumber domain to pass
c	certain ranges of phase velocity
c-----
		call wvfilt(cmax,wvcm,wvc1,wvc2,wvcn,wvn,fact0)
		if(jsrc(1).eq.1)then
			call fmake(1,0,wvn,0,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,0,dkk,r,wvn)
			call smmadd(1,smm,sumd)
		endif
		if(jsrc(2).eq.1)then
			call fmake(2,0,wvn,1,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,1,dkk,r,wvn)
			call smmadd(2,smm,sumd)
		endif
		if(jsrc(3).eq.1)then
			call fmake(3,0,wvn,0,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,1,dkk,r,wvn)
			call smmadd(3,smm,sumd)
		endif
		call smmzer(sumc)
c-----
c           only include near field term if both SH and P-SV
c           computed
c-----
		if(jsrc(4).eq.1.and.jsrc(13).eq.1)then
			call fmake(4,13,wvn,0,g,gg1)
			call wint(sumc,gg1,j01,j11,t01,10,dkk,r,wvn)
		endif
		if(jsrc(4).eq.1)then
			call fmake(4,0,wvn,1,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,0,dkk,r,wvn)
			call smmadd(4,smm,sumd)
			call smmadd(4,smm,sumc)
		endif
		if(jsrc(13).eq.1)then
			call fmake(13,0,wvn,1,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,0,dkk,r,wvn)
			call smmadd(5,smm,sumd)
			call smmadd(5,smm,sumc)
		endif
		if(jsrc(5).eq.1)then
			call fmake(5,0,wvn,0,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,2,dkk,r,wvn)
			call smmadd(6,smm,sumd)
		endif
		call smmzer(sumc)
c-----
c           only include near field term if both SH and P-SV
c           computed
c-----
		if(jsrc(6).eq.1.and.jsrc(14).eq.1)then
			call fmake(6,14,wvn,0,g,gg1)
			call wint(sumc,gg1,j01,j11,t01,20,dkk,r,wvn)
		endif
		if(jsrc(6).eq.1)then
			call fmake(6,0,wvn,1,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,1,dkk,r,wvn)
			call smmadd(7,smm,sumd)
			call smmadd(7,smm,sumc)
		endif
		if(jsrc(14).eq.1)then
			call fmake(14,0,wvn,1,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,1,dkk,r,wvn)
			call smmadd(8,smm,sumd)
			call smmadd(8,smm,sumc)
		endif
		if(jsrc(7).eq.1)then
			call fmake(7,0,wvn,0,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,0,dkk,r,wvn)
			call smmadd(9,smm,sumd)
		endif
		if(jsrc(8).eq.1)then
			call fmake(8,0,wvn,1,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,1,dkk,r,wvn)
			call smmadd(10,smm,sumd)
		endif
		if(jsrc(9).eq.1)then
			call fmake( 9,0,wvn,0,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,0,dkk,r,wvn)
			call smmadd(11,smm,sumd)
		endif
		if(jsrc(10).eq.1)then
			call fmake(10,0,wvn,1,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,1,dkk,r,wvn)
			call smmadd(12,smm,sumd)
		endif
		if(jsrc(11).eq.1)then
			call fmake(11,0,wvn,0,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,1,dkk,r,wvn)
			call smmadd(13,smm,sumd)
		endif
		call smmzer(sumc)
c-----
c           only include near field term if both SH and P-SV
c           computed
c-----
		if(jsrc(12).eq.1.and.jsrc(15).eq.1)then
			call fmake(12,15,wvn,0,g,gg1)
			call wint(sumc,gg1,j01,j11,t01,10,dkk,r,wvn)
		endif
		if(jsrc(12).eq.1)then
			call fmake(12,0,wvn,1,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,0,dkk,r,wvn)
			call smmadd(14,smm,sumd)
			call smmadd(14,smm,sumc)
		endif
		if(jsrc(15).eq.1)then
			call fmake(15,0,wvn,1,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,0,dkk,r,wvn)
			call smmadd(15,smm,sumd)
			call smmadd(15,smm,sumc)
		endif
		if(jsrc(16).eq.1)then
			call fmake(16,0,wvn,0,g,gg1)
			call wint(sumd,gg1,j01,j11,t01,0,dkk,r,wvn)
			call smmadd(16,smm,sumd)
		endif
  200	continue
c-----
c	sign change due to k j(-1)
c-----
	call smmflp(smm)
	return
	end

	subroutine wint(smm,g1,j01,j11,t01,n,dkk,r,wvn)
c-----
c	perform the wavenumber integration for the particular
c	integrand
c-----
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	complex smm(NSR),g1(NSR)
	real j01,j11
	k = 0
	do 1000 js=1,mdpths
	do 1010 jr=1,mdpthr
		k = k + 1
		call wwint(smm(k),g1(k),j01,j11,t01,n,dkk,r,wvn)
 1010	continue
 1000	continue
	return
	end

	subroutine wwint(smm,g1,j01,j11,t01,n,dkk,r,wvn)
	common/fct/fact1 ,fact0
	complex smm,g1
	real j01,j11
	real j21
	common/rlimit/rlim
	real*4 rlim
c-----
c	trapezoidal rule
c-----
c	if(ik.eq.1)then
c	      fact = 0.5*fact0
c	else
c	      fact = fact0
c	endif
c-----
c	if commented out then rectangular rule
c-----
	fact = fact0
	if(n.eq.0)then
c-----
c	integral (c + d z) * j0(z) dz
c-----
		smm = fact * (g1 * (j01 * dkk))
	elseif(n.eq.1)then
c-----
c	integral (c + d z) j1(z) dz
c-----
		smm = fact * (g1 * (j11 * dkk))
c-----
c	integral (c + d z) j2(z) dz
c-----
	elseif(n.eq.2)then
		if(t01.eq.0.0)then
			j21 = 0.0
		else
			j21 = 2.*j11/t01 - j01
		endif
		smm = fact * (g1 * (j21 * dkk))
c-----
c	 - integral (c + d z) j1(kr) dk / r
c-----
	elseif(n.eq.10)then
		if(r.le.rlim)then
			smm = fact * (g1 * (0.5 * dkk)) * wvn
		else
			smm = fact * (g1 * (j11 * dkk))/r
		endif
		smm = - smm
c-----
c	 - 2 integral (c + d z) j2(kr) dk / r
c-----
	elseif(n.eq.20)then
		if(t01.eq.0.0)then
			j21 = 0.0
		else
			j21 = 2.*j11/t01 - j01
		endif
		if(r.le.rlim)then
			smm = 0.0
		else
			smm = fact * (g1 * (j21 * dkk)) / r
		endif
		smm = -2.0*smm
	endif
	return
	end

	subroutine hank(z,h0,h1)
c-----
c	evaluate Bessel functions using Abromiwitz and Stegun
c-----
	real z,h0,h1
	real j1z
	if(z.eq.0.0)then
		h0 = 1.0
		h1 = 0.0
	elseif(z.gt.0.0 .and. z.le.3.0)then
		x = (z/3.)*(z/3.)
		h0 = 1.-x*(2.2499997-x*(1.2656208-x*(.3163866-x*(
     1            .0444479-x*(.0039444-x*(.0002100))))))
		j1z = 0.5-x*(.56249985-x*(.21093573-x*(.03954289-x*(
     1      .00443319-x*(.00031761-x*(.00001109))))))
		h1 = z * j1z
	else
		x = 3./z
		fac = 1./sqrt(z)
		f0 = .79788456+x*(-.00000077 + x*(-.00552740 + x*(
     1      -.00009512+x*(.00137237+x*(-.00072805+x*(.00014476))))
     2            ))
		t0 = z - .78539816+x*(-.04166397+x*(-.00003954+x*(
     1      .00262573+x*(-.00054125+x*(-.00029333+x*(.00013558))))
     2            ))
		f1 = .79788456+x*(.00000156+x*(.01659667+x*(.00017105+
     1            x*(-.00249511+x*(.00113653+x*(-.00020033))))))
		t1 = z-2.35619449+x*(.12499612+x*(.00005650+x*(
     1       -.00637879+x*(.00074348+x*(.00079824+x*(-.00029166)))
     2            )))
		h0 = fac * f0 * cos(t0)
		h1 = fac * f1 * cos(t1)
	endif
	return
	end

	subroutine solu(y1,y2,x1,x2,h,j,a,b,c)
c-----
c	Using two data points, determine the coefficients of
c	a function
c	y(k) = [ a + bk + ck^2 ] exp [ -kh]
c
c	Given only two data points, we will constrain one of the a,b,c
c	to be zero, depending on the nature of the elastic wave integrand
c-----
c	we do not solve for a,b,c together, only two at most
c	thus we only need two values of wavenumber, x1 and x2
c
c
c	Since the program permits consideration of more than a
c	single depth, we must check for overflow here and underflow in gasym
c-----
	complex y1,y2,a,b,c
	integer imap(16)
	data imap/3,2,3,2,3,2,3,2,3,2,3,2,2,2,2,3/
	a=cmplx(0.0,0.0)
	b=cmplx(0.0,0.0)
	c=cmplx(0.0,0.0)
	wfac = x1*h
	if(wfac.gt.10.0)return
	ii = imap(j)
	if(ii.eq.1)then
c-----
c	a exp(-kh)
c-----
		b=cmplx(0.0,0.0)
		a=y1*exp(x1*h)
	else if(ii.eq.2)then
c-----
c	[ a + b k  ]exp(-kh)
c-----
		u1=x1*h
		u2=x2*h
		det=x2-x1
		a= x2*(y1*exp(u1))-x1*(y2*exp(u2))
		a=a/det
		b= y2*exp(u2) - y1*exp(u1)
		b=b/det
	else if(ii.eq.3)then
c-----
c	[ b + c k  ]  k exp(-kh)
c-----
		u1=x1*h
		u2=x2*h
		det=x2-x1
		a = cmplx(0.0,0.0)
		b = x2*(y1*exp(u1))/x1 - x1*(y2*exp(u2))/x2
		b = b/det
		c= y2*exp(u2)/x2 - y1*exp(u1)/x1
		c = c/det
	else if(ii.eq.4)then
c-----
c	[ c k*k ] exp(-kh)
c-----
		a = cmplx(0.0,0.0)
		b = cmplx(0.0,0.0)
		c = y1 * exp(x1*h)/(x1)**2
	else if(ii.eq.5)then
c-----
c	[ b k ] exp(-kh)
c-----
		a = cmplx(0.0,0.0)
		b = y1 * exp(x1*h)/ x1
	endif
	return
	end

        subroutine setup(rr) 
c---------------------------------------------------------- 
c 
c       jnkm =  integral exp(-kh) ksup m j sub n (kr) dk 
c
c	This is used in the fit of low frequency information
c
c	integral f(k) Jn(kr) dk = 
c		integral [ f(k) - (a+bk+ck^2)e^{-kh} ] Jn(kr) dk
c		+integral [  (a+bk+ck^2)e^{-kh} ] Jn(kr) dk
c
c	The last integral is obtained analytically
c
c	Special care is taken when r=0, especially for a near field
c	TDS, RDS term
c	j1kmr = lim r->0 integral exp(-kh) k sup m j sub 1 (kr) dk
c
c	Herrmann, R. B., and C. Y. Wang (1985).
c	A comparison of synthetic seismograms,
c	Bull. Seism. Soc. Am. 75, 41-56.
c 
c---------------------------------------------------------- 
#ifdef CRAYSYSTEM
c       implicit double precision (a-h,o-z)
#else
        implicit double precision (a-h,o-z)
#endif
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
        real*4 rr,zz
	common/rlimit/rlim
	real*4 rlim
        common/asym/j0k0(NSR),j0k1(NSR),j0k2(NSR),j0k3(NSR),
     1		j1k0(NSR),j1k1(NSR),j1k2(NSR),j1k3(NSR),
     2		j2k0(NSR),j2k1(NSR),j2k2(NSR),j2k3(NSR),
     3		j1k0r(NSR),j1k1r(NSR),j1k2r(NSR),j1k3r(NSR)
        real*4 j0k0,j0k1,j0k2,j0k3,
     1		j1k0,j1k1,j1k2,j1k3,
     2		j2k0,j2k1,j2k2,j2k3,
     3		j1k0r,j1k1r,j1k2r,j1k3r
	k = 0
	do 2500 i=1,mdpths
		do 2600 j=1,mdpthr
			zz = abs(depths(i) - depthr(j))
			k = k + 1
#ifdef CRAYSYSTEM
#else
		        r = (rr)
		        z = (zz)
		        dist=sqrt(r*r + z*z) 
#endif
c-----
c	if distance == 0 , force small answers
c-----
#ifdef CRAYSYSTEM
			if(dist.le.0.0001e+00)dist=0.0001e+00
#else
			if(dist.le.0.0001d+00)dist=0.0001d+00
#endif
		        dist3=dist**3 
		        dist5=dist**5 
		        dist7=dist**7 
		        rz=r*z 
		        z2=z*z 
		        r2=r*r 
		        r3=r*r2 
		        z3=z*z2 
		        rz2=r*z2 
		        rz3=r*z3 
		        zor = z/dist
		        zor2= zor*zor
		        zor3= zor*zor2
#ifdef CRAYSYSTEM
		        j0k0(k) = ( 1.0/dist   )
		        j0k1(k) = ( z/dist3   )
		        j0k2(k) = ( (2.0*z2 - r2)/dist5   )
		        j0k3(k) = ( (6.0*z3 - 9.0*z*r2)/dist7   )
#else
		        j0k0(k) = sngl( 1.0/dist   )
		        j0k1(k) = sngl( z/dist3   )
		        j0k2(k) = sngl( (2.0*z2 - r2)/dist5   )
		        j0k3(k) = sngl( (6.0*z3 - 9.0*z*r2)/dist7   )
#endif
			if(rr.le.rlim)then
			  j1k0(k) = 0.0
			  j1k1(k) = 0.0
			  j1k2(k) = 0.0
			  j1k3(k) = 0.0
			  if(zz .le.rlim)then
#ifdef CRAYSYSTEM
			    j1k0r(k) = (0.5/(dist*dist))
			  else
			    j1k0r(k) = (0.5/z2)
			  endif
			  j1k1r(k) = (1.0/dist3)
		          j1k2r(k) = ( 3.0*z/dist5   )
		          j1k3r(k) = ( 12.0*z2 /dist7   )
#else
			    j1k0r(k) = sngl(0.5/(dist*dist))
			  else
			    j1k0r(k) = sngl(0.5/z2)
			  endif
			  j1k1r(k) = sngl(1.0/dist3)
		          j1k2r(k) = sngl( 3.0*z/dist5   )
		          j1k3r(k) = sngl( 12.0*z2 /dist7   )
#endif
				
			else
#ifdef CRAYSYSTEM
		          j1k0(k) = (( 1.0 -z/dist   )/r       )
		          j1k1(k) = ( r/dist3                  )
		          j1k2(k) = ( 3.0*z*r/dist5            )
		          j1k3(k) = ( 3.0*r*(4.0*z2 - r2)/dist7)
#else
		          j1k0(k) = sngl(( 1.0 -z/dist   )/r       )
		          j1k1(k) = sngl( r/dist3                  )
		          j1k2(k) = sngl( 3.0*z*r/dist5            )
		          j1k3(k) = sngl( 3.0*r*(4.0*z2 - r2)/dist7)
#endif
			  j1k0r(k) = j1k0(k)/rr
			  j1k1r(k) = j1k1(k)/rr
			  j1k2r(k) = j1k2(k)/rr
			  j1k3r(k) = j1k3(k)/rr
			endif
			if(rr.le.rlim)then
		        	j2k0(k) = 0.0
		        	j2k1(k) = 0.0
			else
#ifdef CRAYSYSTEM
		          j2k0(k)=((1.0 -zor)*(1.0-zor)*(dist/r2))
		          j2k1(k)=((1.0-zor)*(1.0-zor)*(2.0+zor)/r2)
			endif
		        j2k2(k) = ( 3.0*r2/dist5   )
		        j2k3(k) = ( 15.0*z*r2/dist7   )
#else
		          j2k0(k)=sngl((1.0 -zor)*(1.0-zor)*(dist/r2))
		          j2k1(k)=sngl((1.0-zor)*(1.0-zor)*(2.0+zor)/r2)
			endif
		        j2k2(k) = sngl( 3.0*r2/dist5   )
		        j2k3(k) = sngl( 15.0*z*r2/dist7   )
#endif
 2600		continue
 2500	continue
        return 
        end 

	subroutine fmake(j,k,wvn,l,g,gg1)
c-----
c	make the proper integrand
c-----
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	real*4 wvn
	complex g(NSR,16)
	complex gg1(NSR)
	kk = 0
	do 1000 js=1,mdpths
	do 1010 jr=1,mdpthr
		kk = kk + 1
		gg1(kk)= g(kk,j)
		if(k.gt.0)then
				gg1(kk)=gg1(kk) + g(kk,k)
		endif
		if(l.gt.0)then
				gg1(kk)=gg1(kk) * wvn
		endif
 1010	continue
 1000	continue
	return
	end

	subroutine getgk(g,jsrc,wvno)
c-----
c	read input to obtain elements of g(16,j) array
c-----
	parameter(NSOURCE=100,NRECEIVER=100,NSRC=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	complex g(NSRC,16)
	dimension jsrc(16)
	call bufrd(wvno,ierr)
	k = 0
	do 1000 js=1,mdpths
	do 1010 jr=1,mdpthr
		k = k + 1
		do 101 i=1,16
			if(jsrc(i).eq.1)then
				call bufrd(xr,ierr)
				call bufrd(xi,ierr)
				g(k,i)=cmplx(xr,xi)
			endif
  101		continue
 1010	continue
 1000	continue
	return
	end

	subroutine intini(smm,r)
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	common/jout/jsrc(16) , jbdrys, jbdryh
        common/asym/j0k0(NSR),j0k1(NSR),j0k2(NSR),j0k3(NSR),
     1		j1k0(NSR),j1k1(NSR),j1k2(NSR),j1k3(NSR),
     2		j2k0(NSR),j2k1(NSR),j2k2(NSR),j2k3(NSR),
     3		j1k0r(NSR),j1k1r(NSR),j1k2r(NSR),j1k3r(NSR)
        real*4 j0k0,j0k1,j0k2,j0k3,
     1		j1k0,j1k1,j1k2,j1k3,
     2		j2k0,j2k1,j2k2,j2k3,
     3		j1k0r,j1k1r,j1k2r,j1k3r
	common/kint4/aa,bb,cc
		complex aa(NSR,16),bb(NSR,16),cc(NSR,16)
	complex smm(NSR,16),sumd
	common/kint1/gasymp
		logical gasymp(NSR)
	common/rlimit/rlim
	real*4 rlim
	k = 0
	do 1000 js=1,mdpths
	do 1010 jr=1,mdpthr
		k = k + 1
		if(gasymp(k))then
c-----
c	set up sum arrays, but put in asymptotic value now
c	of setting to zero and then resetting
c-----
			smm(k,1)=        aa(k,1)*j0k0(k) 
     1					+ bb(k,1)*j0k1(k) 
     2					+ cc(k,1)*j0k2(k)
			smm(k,2)=        aa(k,2)*j1k1(k) 
     1					+ bb(k,2)*j1k2(k) 
     2					+ cc(k,2)*j1k3(k)
			smm(k,3)=        aa(k,3)*j1k0(k) 
     1					+ bb(k,3)*j1k1(k) 
     2					+ cc(k,3)*j1k2(k)
			if(jsrc(4).eq.1 .and. jsrc(5).eq.1)then
				sumd  = (aa(k,4)+aa(k,13))*j1k0r(k) 
     1					+ (bb(k,4)+bb(k,13))*j1k1r(k) 
     2					+ (cc(k,4)+cc(k,13))*j1k2r(k)
				sumd = - sumd
			else
					sumd = cmplx(0.0,0.0)
			endif
			smm(k,4)= sumd + aa(k,4)*j0k1(k) 
     1					+ bb(k,4)*j0k2(k) 
     2					+ cc(k,4)*j0k3(k)
			smm(k,5)= sumd + aa(k,13)*j0k1(k) 
     1					+ bb(k,13)*j0k2(k) 
     2					+ cc(k,13)*j0k3(k)
			smm(k,6)=  	aa(k,5)*j2k0(k) 
     1					+ bb(k,5)*j2k1(k) 
     2					+ cc(k,5)*j2k2(k)
			if(jsrc(6).eq.1 .and. jsrc(7).eq.1 .and.
     1				r.gt.rlim)then
				sumd= (aa(k,6)+aa(k,14))*j2k0(k) 
     1					+ (bb(k,6)+bb(k,14))*j2k1(k) 
     2					+ (cc(k,6)+cc(k,14))*j2k2(k)
				sumd = -2.*sumd/r
			else
				sumd = cmplx(0.0,0.0)
			endif
			smm(k,7)= sumd + aa(k,6)*j1k1(k) 
     1					+ bb(k,6)*j1k2(k) 
     2					+ cc(k,6)*j1k3(k)
			smm(k,8)= sumd + aa(k,14)*j1k1(k)
     1					+ bb(k,14)*j1k2(k)
     2					+ cc(k,14)*j1k3(k)
			smm(k,9)=	aa(k,7)*j0k0(k)        
     1					+ bb(k,7)*j0k1(k) 
     2					+ cc(k,7)*j0k2(k)
			smm(k,10)=      aa(k,8)*j1k1(k) 
     1					+ bb(k,8)*j1k2(k) 
     2					+ cc(k,8)*j1k3(k)
			smm(k,11)=        aa(k,9)*j0k0(k) 
     1					+ bb(k,9)*j0k1(k) 
     2					+ cc(k,9)*j0k2(k)
			smm(k,12)=        aa(k,10)*j1k1(k) 
     1					+ bb(k,10)*j1k2(k) 
     2					+ cc(k,10)*j1k3(k)
			smm(k,13)=        aa(k,11)*j1k0(k) 
     1					+ bb(k,11)*j1k1(k) 
     2					+ cc(k,11)*j1k2(k)
			if(jsrc(15).eq.1 .and. jsrc(14).eq.1)then
				sumd  = (aa(k,12)+aa(k,15))*j1k0r(k) 
     1					+ (bb(k,12)+bb(k,15))*j1k1r(k) 
     2					+ (cc(k,12)+cc(k,15))*j1k2r(k)
				sumd = - sumd
			else
					sumd = cmplx(0.0,0.0)
			endif
			smm(k,14)= sumd + aa(k,12)*j0k1(k) 
     1					+ bb(k,12)*j0k2(k) 
     2					+ cc(k,12)*j0k3(k)
			smm(k,15)= sumd + aa(k,15)*j0k1(k) 
     1					+ bb(k,15)*j0k2(k) 
     2					+ cc(k,15)*j0k3(k)
			smm(k,16)=        aa(k,16)*j0k0(k) 
     1					+ bb(k,16)*j0k1(k) 
     2					+ cc(k,16)*j0k2(k)
		else
			do 100 i=1,16
				smm(k,i)=cmplx(0.0,0.0)
  100			continue
		endif
 1010	continue
 1000	continue
	return
	end

	subroutine wvfilt(cmax,wvcm,wvc1,wvc2,wvcn,wvno,fact)
c-----
c	apply a cosine taper wavenumber filter
c-----
	pi = 3.1415927
	if(cmax.lt.0.0)then
		fact = 1.0
	elseif(wvno.ge.wvc1.and.wvno.le.wvc2) then
		fact=1.0
	elseif(wvno.ge.wvcm.and.wvno.lt.wvc1)then
		fact=(1.-cos(pi*(wvno-wvcm)/ (wvc1-wvcm)))/2.
	elseif(wvno.gt.wvc2.and.wvno.le.wvcn)then
		fact=(1.-cos(pi*(wvno-wvcn)/ (wvc2-wvcn)))/2.
	else
		fact = 0.0
	endif
	return
	end

	subroutine smmadd(i,smm,sumd)
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	complex smm(NSR,16), sumd(NSR)
c-----
c	add sumd vector to the particular entry of smm
c-----
	k = 0
	do 1000 js=1,mdpths
	do 1010 jr=1,mdpthr
		k = k + 1
		smm(k,i) = smm(k,i) +  sumd(k)
 1010	continue
 1000	continue
	return
	end

	subroutine smmzer(sumc)
c-----
c	zero an array for all depths
c-----
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	complex sumc(NSR)
c-----
c	zero a vector over all depths
c-----
	k = 0
	do 1000 js=1,mdpths
	do 1010 jr=1,mdpthr
		k = k + 1
		sumc(k) = cmplx(0.0,0.0)
 1010	continue
 1000	continue
	return
	end

	subroutine smmscl(sumc,scl)
c-----
c	scale an array for all depths
c-----
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	complex sumc(NSR)
	real*4 scl
c-----
c	add sumd vector to the particular entry of smm
c-----
	k = 0
	do 1000 js=1,mdpths
	do 1010 jr=1,mdpthr
		k = k + 1
		sumc(k) = sumc(k) * scl
 1010	continue
 1000	continue
	return
	end

	subroutine smmflp(smm)
c-----
c	flip the -1 Bessel function values
c-----
	parameter(NSOURCE=100,NRECEIVER=100,NSR=100)
	common/source/depths(NSOURCE),lmaxs(NSOURCE),mdpths
	common/receiv/depthr(NRECEIVER),lmaxr(NRECEIVER),mdpthr
	real*4 depths, depthr
	integer lmaxs, lmaxr, mdpths, mdpthr
	complex smm(NSR,16)
	k = 0
	do 1000 js=1,mdpths
	do 1010 jr=1,mdpthr
		k = k + 1
		smm(k,2)  = -smm(k,2)
		smm(k,10) = -smm(k,10)
		smm(k,12) = -smm(k,12)
 1010	continue
 1000	continue
	return
	end

	subroutine werror(ostr)
c-----
c	output error message and terminate program
c-----
c	parameter(LER=0, LIN=5, LOT=6)
#include <f77/iounit.h>

	character ostr*(*)
	write(LER,*)'PROGRAM TERMINATION'
	write(LER,*)ostr
	stop
	end

	subroutine modcpy(totmp) 
	logical totmp
c-----
c	copy model to temporary array
c-----
	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/modelt/dt(NL),at(NL),bt(NL),rhot(NL),mmaxt,
     1                qat(NL),qbt(NL)
c-----
c	copy to temporary array
c-----
	if(totmp)then
		do 20 i = 1,mmax 
			dt(i) = d(i)
			at(i) = a(i)
			bt(i) = b(i)
			rhot(i) = rho(i)
			qat(i) = qa(i)
			qbt(i) = qb(i)
   20		continue 
		mmaxt = mmax
	else
		do 30 i = 1,mmaxt 
			d(i) = dt(i)
			a(i) = at(i)
			b(i) = bt(i)
			rho(i) = rhot(i)
			qa(i) = qat(i)
			qb(i) = qbt(i)
   30		continue 
		mmax = mmaxt
	endif
	return 
	end 

	subroutine chkmod()
	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
	common/jout/jsrc(16) , jbdrys, jbdryh
c-----
c	check model for inconsistencies
c-----
c-----
c	Model cannot consist entirely of water layers
c	Also determine first solid layer from top
c-----
	iw = 0  
	isoldd = 0
	do 100 i=1,mmax
		if(b(i).eq.0.0)then
			iw = iw + 1
		else
			if(isoldd .eq.0)isoldd=i
		endif
  100	continue
	if(iw .eq. mmax)then
		call werror('MODEL CONSISTS ONLY OF LIQUID LAYERS')
	endif
c-----
c	Determine first solid layer from bottom
c-----
	iw = 0  
	isoldu = 0
	do 101 i=mmax,1,-1
		if(b(i).eq.0.0)then
			iw = iw + 1
		else
			if(isoldu .eq.0)isoldu=i
		endif
  101	continue
c-----
c	Check for interior water layer
c-----
	if(iw.gt.0)then
		do 102 i=isoldd,isoldu
			if(b(i).eq.0.0)then
			call werror('MODEL HAS INTERIOR  FLUID LAYERS')
			endif
  102		continue
	endif
c-----
c	If boundary condition is rigid, and the adjacent layer is
c	fluid, terminate 
c-----
	if(b(1).le.1.0e-04 .and. jbdrys.eq.-1)then
		call werror('TOP LAYER IS FLUID AND RIGID BOUNDARY')
	endif
	if(b(mmax).le.1.0e-04 .and. jbdryh.eq.-1)then
		call werror('BOTTOM LAYER IS FLUID AND RIGID BOUNDARY')
	endif
	return
	end
