C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine vel3d  (maxnum, maxfunc, nhor, nli, ndi, limin, limax,
     1                   divec, livec, times, velocities, horizons,
     2                   SZSMPD, ITHWP1, itr, tri, nsamp, si, lmax,
     3                   dimin, dimax, wrk1, wrkt, wrk2, nmax,
     4                   obytes, luout, name, tim1, timt, tim2,
     5                   thor1, thort, thor2, vhor1, vhort, vhor2,
     6                   vel1, velt, vel2, fmap, ineighb, jneighb,
     7                   iz, zz, irad, verbos, XYs, IX1, IY1, DX, DY,
     8                   XX, XY, YX, YY, XXT, XYT, YXT, YYT, DE, DF,
     9                   E, F, XYYXXY)

#include <f77/iounit.h>

      real       times (maxnum, maxfunc), velocities (maxnum, maxfunc)
      real       horizons (ndi, nli, nhor)
      integer    divec (ndi), livec (nli), fmap (ndi, nli)
      integer    jneighb (lmax), ineighb (lmax)
      real       velf
      real * 8   XX, XY, YX, YY, XXT, XYT, YXT, YYT
      REAL * 8   DE, DF, E, F, XYYXXY
      real       DX, DY, CDPX, CDPY
      integer    IX1, IY1
      pointer    (wkvelf, velf (100000))
      real       tim1 (nsamp), timt (nsamp), tim2 (nsamp)
      real       thor1 (maxnum, maxfunc), thort (maxnum, maxfunc)
      real       thor2 (maxnum, maxfunc)
      real       vhor1 (maxnum, maxfunc), vhort (maxnum, maxfunc)
      real       vhor2 (maxnum, maxfunc)
      real       vel1 (nmax), velt (nmax), vel2 (nmax)
      real       wrk1 (nmax), wrkt (nmax), wrk2 (nmax)
      real       tri (nsamp)
      real       zz(4*nsamp)
      integer    iz(nsamp)
      integer    itr (*)
      integer    maxnum, maxfunc, nhor, ndi, SZSMPD, ITHWP1
      integer    nsamp, dimin, dimax, obytes, luout
      integer    limin, limax
      integer    ierr1, iabort
      real       si
      character  name*(*)
      logical    first, verbos, XYs
      common /hdrs/
     1        ifmt_RecNum,l_RecNum,ln_RecNum,
     2        ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     3        ifmt_StaCor,l_StaCor,ln_StaCor,
     4        ifmt_DphInd,l_DphInd,ln_DphInd,
     5        ifmt_LinInd,l_LinInd,ln_LinInd,
     5        ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,
     5        ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY

      maxcell = max (nli, ndi)
      limit   = maxcell / 4
      first = .false.
      iabort = 1
      item = max (nli, ndi)
      call galloc (wkvelf, item*SZSMPD, ierr1, iabort)
      if (ierr1 .ne. 0) then
        write(LERR,*)' '
        write(LERR,*)'Unable to allocate workspace for ',name
        write(LERR,*) item * SZSMPD, '  bytes'
        write(LER ,*)' '
        write(LER ,*)'Unable to allocate workspace for ',name
        write(LER ,*) item * SZSMPD, '  bytes'
        call ccexit (666)
      endif

      call savew2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor,
     :              0, 1)

      nfuncmax = -9999

c     write(0,*)'nli,ndi= ',nli,ndi
c     do j = limin, limax
c     write(0,*)(fmap(i,j),i=dimin, dimax)
c     enddo
c     write(0,*)'maxnum,maxfunc= ',maxnum,maxfunc
c     do j = 1, maxfunc
c     write(0,*)'tim'
c     write(0,*)(times(ii,j),ii=1,maxnum)
c     write(0,*)'vel'
c     write(0,*)(velocities(ii,j),ii=1,maxnum)
c     enddo

      DO  J = limin, limax
      DO  I = dimin, dimax

          iradji = irad
          do ii = 1, nmax
             velt (ii) = 0.
          enddo
c*******
c   Find vel function locations for current output location

1         continue
          nfunc = 0
          do  jj = -iradji, +iradji

              jr = J + jj
              if (jr .ge. limin .AND. jr .le. limax) then

                 do  ii = -iradji, +iradji

                     ir = I + ii
                     if (ir .ge. dimin .AND. ir .le. dimax) then

                        iseq = fmap(ir,jr)
                        IF (iseq .ne. 0) THEN
                           nfunc = nfunc + 1
                           if (nfunc .ge. nfuncmax) nfuncmax = nfunc
                           jneighb (nfunc) = jr
                           ineighb (nfunc) = ir
                           do  it = 1, maxnum
                               tt = times (it, iseq)
                               vv = velocities (it, iseq)
                               if (vv .gt. 0.) then
                                  thor1 (it,nfunc) = tt
                                  vhor1 (it,nfunc) = vv
                               else
                                  thor1 (it,nfunc) = 0.
                                  vhor1 (it,nfunc) = 0.
                               endif
                           enddo

                        ENDIF

                     endif
                 enddo

              endif

          enddo

c*******
          if (nfunc .le. 1) then
             write(LERR,*)'At LI/DI ',j,i,' could find no functions.'
             write(LERR,*)'Will increase search radius from ',iradji,
     1                    ' to ',iradji+1
             iradji = iradji + 1
             if (iradji .gt. limit) then
               write(LERR,*)'FATAL ERROR in ',name
               write(LERR,*)'At LI/DI ',j,i,' could find no functions'
               write(LERR,*)'using search radius of ',iradji,' cells'
               write(LER ,*)'FATAL ERROR in ',name
               write(LER ,*)'At LI/DI ',j,i,' could find no functions'
               write(LER ,*)'using search radius of ',iradji,' cells'
               call ccexit (666)
             endif
             go to 1
          endif
          if (verbos) then
               write(LERR,*)' '
               write(LERR,*)'At LI/DI ',j,i,' found ',nfunc,
     1                      'functions within search radius= ',iradji
          endif

          item = nsamp * nfunc
          call grealloc (wkvelf, item*SZSMPD, ierr1, iabort)
          if (ierr1 .ne. 0) then
            write(LERR,*)' '
            write(LERR,*) item * SZSMPD, '  bytes'
            write(LERR,*)'At LI/DI ',j,i,' found ',nfunc,' functions'
            write(LERR,*)'Suggest decreasing radius of search'
            write(LER ,*)' '
            write(LER ,*)'Unable to allocate workspace for ',name
            write(LER ,*) item * SZSMPD, '  bytes'
            write(LER ,*)'At LI/DI ',j,i,' found ',nfunc,' functions'
            write(LER ,*)'Suggest decreasing radius of search'
            call ccexit (666)
          endif

c----
c   For our current output LI/DI location J/I we now have found vel functions
c   within the neighborhood defined by the search radius (really a box for
c   simplicity).  The sparse functions are captured in arrays thor1 & vhor1
c   ready for expansion.
c   We have allocated enough space to store the expanded (to nsamp) velocity
c   traces.
c----
          do  ii = 1, nfunc

              ipntr = (ii-1) * nsamp + 1
              call vel (thor1(1,ii), vhor1(1,ii), nsamp, si, maxnum,
     1                  maxfunc, velf(ipntr) )
          enddo

          call vbld3d (si, nsamp, nhor, nli, ndi, nmax, nfunc, lmax,
     1                 J, I, jneighb, ineighb, velf, horizons,
     2                 tim1, timt, tim2, vel1, velt, vel2, zz, iz,
     3                 wrk1, wrkt, wrk2, SZSMPD, name, iradji)
          
          call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                  I, 1)
          call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     :                  J, 1)
          call savew2 ( itr, ifmt_DphInd, l_DphInd, ln_DphInd,
     :                  I, 1)
          call savew2 ( itr, ifmt_LinInd, l_LinInd, ln_LinInd,
     :                  J, 1)

          IF ( XYs ) THEN

               E = (DBLE(FLOAT( J )) - 0.5) * DX + DE
               F = (DBLE(FLOAT( I )) - 0.5) * DY + DF
               CDPX  = (F * XYT - E * YYT) / XYYXXY
               if (YYT .ne. 0.) then
                  CDPY  = (F - CDPX * YXT) / YYT
               elseif (XYT .ne. 0.) then
                  CDPY  = (E - CDPX * XXT) / XYT
               endif
               icxx = CDPX
               icyy = CDPY
               call savew2(itr,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                     icxx   , 1)
               call savew2(itr,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                     icyy   , 1)

          ENDIF

c     call maxmgv (velt, 1, vmax, loc2, nsamp)
c     call minmgv (velt, 1, vmin, loc1, nsamp)
c     write(0,*)'velt: ',J,I,loc1,vmin,loc2,vmax

          call vmov (velt, 1, itr(ITHWP1), 1, nsamp)
          call wrtape (luout, itr, obytes)

      ENDDO
      ENDDO

      write(LERR,*)' '
      write(LERR,*)'End sweep through all requested LIs & DIs. Maximum'
      write(LERR,*)'number of functions used in interpolation= ',
     1             nfuncmax
      write(LERR,*)' '
         
      return
      end
