C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
      subroutine cmdln(ntap,otap,ftaper,verbos,vref,irs,ire,dxrec,
     1                 fmax,npad,nwt1,nwt2,pmin,pmax,boost)

#include <f77/iounit.h>

      character   ntap*(*), otap*(*)
      integer     irs,ire, nwt1,nwt2,npad
      real        fmax,dxrec,vref
      real        pmin,pmax,ftaper
      integer     argis
      logical     verbos, boost

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     VREF  = REFERENCE VELOCITY
C      irs  = STARTING RECORD
C      ire  = ENDING RECORD
C     DXREC = SPATIAL RECORD INCREMENT
C     NPAD  = EXTRA ZEROES TO PAD
C     FMAX  = MAXIMUM FREQUENCY TO USE
C     numtp = NUMBER OF ANGLES (P'S)
C     P(1)  = STARTING ANGLE
C     INC   = ANGLE INCREMENT
c     pmin  = start ray parameter
c     pmax  = end ray parameter
C     ntap  = input data set
c     otap  = output data set name
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

c-------------------------------------
c  read parameters from command line
c-------------------------------------

        call argstr('-N',ntap, ' ', ' ')
        call argstr('-O',otap, ' ', ' ')
            call argr4 ('-ft',ftaper,0.,0.)
            call argr4('-v',vref,0.,0.)
            call argi4('-rs',irs,0,0)
            call argi4('-re',ire,0,0)
            call argr4('-dx',dxrec,0.,0.)
            call argr4('-fmax',fmax,0.,0.)
            call argi4('-ot',nwt1,0,0)
            call argi4('-it',nwt2,0,0)
            call argr4('-p',pmin,-90.,-90.)
            call argr4('-P',pmax, 90., 90.)

        boost  = ( argis('-B') .gt. 0 )
        verbos = ( argis('-V') .gt. 0 )

      if (vref .eq. 0.) then
         write(LERR,*)'No reference velocity given -- FATAL'
         write(LERR,*)'rerun with -v[] on cmd line'
         stop
      endif


      RETURN
      END
 
