C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c slstkf reads seismic trace data from an input file,
c performs forward tau-p transform in the frequency domain and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

 
      integer * 2 itr ( SZLNHD ), itrhdr ( 128, SZSMPM )
      integer     lhed( 1500 )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ltaper,nw,nspad,istpr,nwt1,nwt2
      integer     irs,ire,ns,ne
      real        vel,fmax,tp1,tp2,ftaper,domega,delf,deltp
#include <f77/pid.h>
      integer     recnum, trcnum, static
      real        p(SZSMPM),weight(SZSMPM),taper(SZSMPM)
c------
c  static memory allocation
c     real        data ( SZSMPM ), datarr(SZSPRD*SZSMPM)
c     complex     data2d(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation
      real        data ( SZSMPM ), datarr
      complex     data2d
      pointer     (wkadr1, datarr(1))
      pointer     (wkadr2, data2d(1))
c------
      character   ntap * 100, otap * 100, name*6
      logical     verbos, query, heap1, heap2, boost
      integer     argis
 
      equivalence ( itr(129), data (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'SLSTKF'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
c-----
c     get some global command line args
c-----
      call cmdln(ntap,otap,ftaper,verbos,vel,irs,ire,dx,
     1           fmax,npad,nwt1,nwt2,pmin,pmax,boost)
      tp1 = pmin
      tp2 = pmax

c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'SLSTKF: no header read from unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'DptInt', dpint, LINHED)

      call hlhprt (itr, lbytes, name, 6, LERR)

c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c---------------------------------------------------
c-----
c     initialize tp parameters
c-----
      call tpinit (nsamp,nspad,nw,ncmplx,nsi,si,fnyq,tp1,tp2,
     1             numtp,fmax,ltaper,ftaper,domega,nwt1,nwt2,
     2             delf,deltp,p,weight,taper,istpr,ntrc,vel)

c---------------------------------------------------
c  malloc only space we're going to use
      heap1 = .true.
      heap2 = .true.

      itemr = max(ntrc,numtp) * (nspad)
      itemc = max(ntrc,numtp) * (nspad)
      write(LERR,*)'numtp=  ',numtp
      call galloc (wkadr1, itemr*SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heap1 = .false.
      call galloc (wkadr2, 2*itemc*SZSMPD, errcd2, abort2)
      if (errcd2 .ne. 0.) heap2 = .false.
      if (.not. heap1 .or. .not. heap2) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) 2*itemc*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else 
         write(LERR,*)' ' 
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) 2*itemc*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c-----
c     modify line header to reflect actual number of traces output
c     save original trcs/rec
c-----
      obytes = SZTRHD + SZSMPD * nsamp
      nsamp4 = SZSMPD * nsamp
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', numtp, LINHED)
      write(LERR,*)'Saving original # traces/rec=  ',ntrc
      call savew(itr, 'OrNTRC', ntrc , LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     output of all pertinent information before
c     processing begins
c-----
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  vel,numtp,tp1,tp2,delf,deltp,
     2                  nw,ltaper,fmax,p,weight,nwt1,nwt2,
     3                  istpr,ntap,otap,boost) 

c-----
c     BEGIN PROCESSING
c     read trace, do slstkf, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      DO 1000 jj = irs, ire
 
 
               ic = 0
               nlive = 0
               do 1001  kk = 1, ntrc

                  ic = ic+1
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif

                  dist   = itr(119)
                  static = itr(125)
                  recnum = itr(106)
                  trcnum = itr(107)
                  itr(1) = static

                  IF(static .eq. 30000) THEN
                    call vclr (data,1,nsamp)
                    itr(125) = 0
                  ELSE
                    nlive = nlive + 1
                  ENDIF
                  istrc = (kk-1) * nsamp
                  call move (1,itrhdr(1,ic),itr(1),SZTRHD )
                  call vmov (data,1,datarr(istrc+1),1,nsamp) 

1001           continue
 

c----------------------
c  do tp processing
c----------------------

               call taupee (nsamp,ntrc,nspad,nw,nlive,ncmplx,domega,dx,
     1                     numtp,istpr,vel,p,weight,taper,datarr,itrhdr,
     2                     data2d)
 
c-------------------
c  fill in headers
c  write out data
c-------------------
               do 1002  kk = 1, numtp

                   irp = 100000000. * p(kk)
                   irpd = float(irp) / 10.

                   if     (p(numtp) .ge. 0.0) then
                           idx = 1000.*dx*(JJ-1)*p(kk)
                   elseif (p(numtp) .lt. 0.0) then
                           idx = 1000.*dx*(ire -JJ)*p(kk)
                   endif

                   call move (1,itr(1),itrhdr(1,kk),SZTRHD )
                   call savhdr (itr,lhed,JJ,kk,irp,irpd,idx)
                   istrc = (kk-1) * nsamp
                   call vmov (datarr(istrc+1),1,data,1,nsamp)
                   gam = abs(vel) * p(kk)
                   angle = 180. * asin (gam)/3.14159
                   iangl = angle
                   itr(42) = iangl

                   call wrtape (luout, itr, obytes)

1002           continue

1000        CONTINUE
c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of slstkf, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
 

      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     1'***************************************************************'
       write(LER,*)' '
        write(LER,*)
     1'execute slstkf by typing slstkf and  list of program parameters.'
        write(LER,*)
     1'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     1'a character(s) corresponding to some parameter.'
        write(LER,*)
     1'users enter the following parameters, or use the default values'
       write(LER,*)' '
        write(LER,*)
     1' -N [ntap]    (no default)       : input data file name'
        write(LER,*)
     1' -O [otap]    (default = stdout ): output data file name'
        write(LER,*)' '
        write(LER,*)
     1' -v [vel]    (def = none)        : reference velocity (ft,m/s)'
        write(LER,*)
     1' -dx [dx]    (def = none)        : input trace spacing (ft,m)'
        write(LER,*)
     1' -p [pmin]   (def = -90)         : minimum angle to scan (deg)'
        write(LER,*)
     1' -P [pmax]   (def = +90)         : maximum angle to scan (deg)'
        write(LER,*)
     1' -fmax [fmax] (def = 1/2 Nyquist): maximum frequency to use'
        write(LER,*)
     1' -ft[ftaper] (def = none)        : start frequency taper (Hz)'
        write(LER,*)
     1' -rs [nstrt] (def = first)       : start record'
        write(LER,*)
     1' -re [nend] (def = last)         : end record'
        write(LER,*)
     1' -ot [nwt1] (def = none)         : # outside traces to taper'
        write(LER,*)
     1' -it [nwt2] (def = none)         : # inside traces to taper'
       write(LER,*)' '
        write(LER,*)
     1' -B       if present, apply linear frequency boost (dafd-like)'
        write(LER,*)
     1' -V       if present, verbose printout'
       write(LER,*)' '
       write(LER,*)
     1'usage:   slstkf -N[ntap] -O[otap] -v[vel] -ft[ftaper] [-B -V]'
       write(LER,*)' '
       write(LER,*)
     1'                -rs[] -re[] -dx[] -fmax[] -ot[] -it[] -p[] -P[]'
       write(LER,*)' '
       write(LER,*)
     1'***************************************************************'

      return
      end

      subroutine savhdr ( itr, lhed, nr, jp, irp, irpd, idx )
#include <f77/iounit.h>
      integer    lhed(*), nr, jp, irp, irpd, idx
      integer*2  itr(*)
c
c    save trace header values
c

           lhed(3)   = irp
           itr(106) = nr
           itr(107) = jp
           itr(117) = irpd
           itr(5) = idx

      return
      end
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  vel,numtp,tp1,tp2,delf,deltp,
     2                  nw,ltaper,fmax,p,weight,nwt1,nwt2,
     3                  istpr, ntap,otap,boost)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     vel   - R*4 shot velocity
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c      tp1  - R*4 start taup value
c      tp2  - R*4 end taup value
c    numtp  - I*4 number taup values
c     delf  - R*4 delta freq
c    deltp  - R*4 delta taup
c        p  - R*4 vector of ray parameters
c   weight  - R*4 spread weights
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      real        p(*), weight(*)
      integer     nsamp, nsi, ntrc, nrec
      integer     numtp
      real        vel,tp1,tp2,delf,deltp
      character   ntap*(*), otap*(*)
      logical     boost
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' shot medium velocity =  ', vel
            write(LERR,*) ' start taup value     =  ', tp1
            write(LERR,*) ' end taup value       =  ', tp2
            write(LERR,*) ' number taup values   =  ', numtp
            write(LERR,*) ' taup increment       =  ', deltp
            write(LERR,*) ' frequency increment=  ', delf
            write(LERR,*) ' max freq to use    =  ',fmax
            write(LERR,*) ' number freqs in x-form= ',nw
            write(LERR,*) ' number freqs to taper = ',ltaper
            write(LERR,*) ' start taper at freq indx= ',istpr
            write(LERR,*) ' number inside traces taper = ',nwt2
            write(LERR,*) ' number outside traces taper = ',nwt1
            write(LERR,*) ' Apply linear frequency boost? = ', boost
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            if (nwt1 .gt. 0 .or. nwt2 .gt. 1) then
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,*) ' weights:'
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,1000) (weight(j),j=1,ntrc)
1000           format(10(1x,f7.3))
            endif
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,*) ' taup values used:'
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,1001) (p(j),j=1,numtp)
1001           format(5(1x,e10.3))
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 

