C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c slstkr reads seismic trace data from an input file,
c performs reverse tau-p transform in the frequency domain and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

 
      integer * 2 itr ( SZLNHD ), itrhdr ( 128, SZSMPM )
      integer     lhed( 1500 )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ltaper,nw,nspad,istpr,nwt1,nwt2
      integer     irs,ire,ns,ne
      real        fmax,ftaper,domega,delf
#include <f77/pid.h>
      integer     recnum, trcnum, static
      real        p(SZSMPM),weight(SZSMPM),taper(SZSMPM)
c------
c  static memory allocation
c     real        data ( SZSMPM ), datarr(SZSPRD*SZSMPM)
c     complex     data2d(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation
      real        data ( SZSMPM ), datarr
      complex     data2d
      pointer     (wkadr1, datarr(1))
      pointer     (wkadr2, data2d(1))
c------
      character   ntap * 100, otap * 100, name*6
      logical     verbos,query,heap1,heap2, boost
      integer     argis
 
      equivalence ( itr(129), data (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'SLSTKR'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
c-----
c     get some global command line args
c-----
      call cmdln(ntap,otap,irs,ire,fmax,nwt1,nwt2,ftaper,
     1           verbos, boost)

c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'SLSTKR: no header read from unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'DptInt', dpint, LINHED)

      call hlhprt (itr, lbytes, name, 5, LERR)

c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c-----
c     initialize tp parameters
c-----
      call tpinit (nsamp,nspad,nw,ncmplx,nsi,si,fnyq,
     1             numtp,fmax,ltaper,ftaper,domega,nwt1,nwt2,
     2             delf,weight,taper, istpr,ntrc,itr)

c---------------------------------------------------
c  malloc only space we're going to use
      heap1 = .true.
      heap2 = .true.
 
      items = max(ntrc,numtp) * (nspad)
      call galloc (wkadr1, items*SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heap1 = .false.
      call galloc (wkadr2, 2*items*SZSMPD, errcd2, abort2)
      if (errcd2 .ne. 0.) heap2 = .false.
      if (.not. heap1 .or. .not. heap2) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) 2*items*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) 2*items*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c-----
c-----
c     modify line header to reflect actual number of traces output
c-----
      obytes = SZTRHD + SZSMPD * nsamp
      nsamp4 = SZSMPD * nsamp
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', numtp, LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     output of all pertinent information before
c     processing begins
c-----
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  numtp,delf,
     2                  nw,ltaper,fmax,weight,nwt1,nwt2,
     3                  istpr,ntap,otap, boost) 

c-----
c     BEGIN PROCESSING
c     read trace, do taupf, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      DO 1000 jj = irs, ire
 
 
               ic = 0
               nlive = 0
               do 1001  kk = 1, ntrc

                  ic = ic+1
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif

                  dist   = itr(41)
                  static = itr(125)
                  recnum = itr(106)
                  trcnum = itr(107)

                  IF(static .eq. 30000) THEN
                    call vclr (data,1,nsamp)
                  ELSE
                    nlive = nlive + 1
                  ENDIF
                  p(ic) = dist
                  istrc = (kk-1) * nsamp
                  call move (1,itrhdr(1,ic),itr(1),SZTRHD )
                  call vmov (data,1,datarr(istrc+1),1,nsamp)

1001           continue
 

c----------------------
c  do tp processing
c----------------------

               call taupee (nsamp,ntrc,nspad,nw,nlive,ncmplx,domega,
     1                     numtp,istpr,vel,p,weight,taper,datarr,itrhdr,
     2                     data2d, boost)
 
c-------------------
c  fill in headers
c  write out data
c-------------------
               do 1002  kk = 1, numtp

                   idx = 0
                   irp =  p(kk)

                   call move (1,itr(1),itrhdr(1,kk),SZTRHD )
                   call savhdr (itr,JJ,kk,irp,idx)
                   istrc = (kk-1) * nsamp
                   call vmov (datarr(istrc+1),1,data,1,nsamp)
                   if (itr(125) .eq. 30000) call vclr (data,1,nsamp)
                   call wrtape (luout, itr, obytes)

1002           continue

1000        CONTINUE
c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of slstkr, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
 

      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     1'***************************************************************'
       write(LER,*)' '
        write(LER,*)
     1'execute slstkr by typing slstkr and  list of program parameters.'
        write(LER,*)
     1'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     1'a character(s) corresponding to some parameter.'
        write(LER,*)
     1'users enter the following parameters, or use the default values'
       write(LER,*)' '
        write(LER,*)
     1' -N [ntap]    (no default)       : input data file name'
        write(LER,*)
     1' -O [otap]    (default = stdout ): output data file name'
        write(LER,*)' '
        write(LER,*)
     1' -rs [nstrt] (def = first)       : start record'
        write(LER,*)
     1' -re [nend]  (def = last)        : end record'
        write(LER,*)
     1' -fmax [fmax] (def = 1/2 Nyquist): maximum frequency to use'
        write(LER,*)
     1' -ft[ftaper]  (def= no taper)    : start frequency taper (Hz)'
        write(LER,*)
     1' -ot [nwt1] (def = none)         : # outside traces to taper'
        write(LER,*)
     1' -it [nwt2] (def = none)         : # inside traces to taper'
       write(LER,*)' '
        write(LER,*)
     1' -B         if present, apply linear frequency boost (dafd-like)'
        write(LER,*)
     1' -V         if present, verbose prinout'
       write(LER,*)' '
       write(LER,*)
     1'usage:   slstkr -N[ntap] -O[otap] -ft[ftaper]  [-B -V]'
       write(LER,*)
     1'                -rs[] -re[] -fmax[] -ot[] -it[]'
       write(LER,*)' '
         write(LER,*)
     1'***************************************************************'

      return
      end

      subroutine savhdr ( itr,nr, jp, irp, idx )

#include <f77/lhdrsz.h>

      integer    nr, jp, irp, idx
      integer*2  itr(*)
c
c    save trace header values
c

           itr(106) = nr
           itr(107) = jp
           itr(119) = irp
           itr(117) = iabs(irp)
           itr(5) = idx
           itr(125) = itr(1)

      return
      end
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  numtp,delf,
     2                  nw,ltaper,fmax,weight,nwt1,nwt2,
     3                  istpr, ntap,otap, boost)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     vel   - R*4 shot velocity
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c    numtp  - I*4 number taup values
c     delf  - R*4 delta freq
c   weight  - R*4 spread weights
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      real        weight(*)
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     numtp, nw,ltaper,istpr,nwt1,nwt2
      real        delf
      character   ntap*(*), otap*(*)
      logical     boost
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' number taup values   =  ', numtp
            write(LERR,*) ' frequency increment=  ', delf
            write(LERR,*) ' max freq to use    =  ',fmax
            write(LERR,*) ' number freqs in x-form= ',nw
            write(LERR,*) ' number freqs to taper = ',ltaper
            write(LERR,*) ' start taper at freq indx= ',istpr
            write(LERR,*) ' number inside traces taper = ',nwt2
            write(LERR,*) ' number outside traces taper = ',nwt1
            write(LERR,*) ' Linear frequency boost?     =  ', boost
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            if (nwt1 .gt. 0 .or. nwt2 .gt. 1) then
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,*) ' weights:'
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,1000) (weight(j),j=1,ntrc)
1000           format(10(1x,f7.3))
            endif
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 

