C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE taupnmo
C
C**********************************************************************C
C
C taupnmo READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C APPLIES NORMAL MOVEOUT (WITH OPTIONAL STATICS BEFORE),
C AND PRINTS UPDATED LINE HEADER AND REQUIRED RECORDS
C OR TRACES
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

      INTEGER     ITR ( SZLNHD ) , NTR (SZLNHD)
      INTEGER     LUIN, LUOUT, NBYTES,LUVEL
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM, LBYTES, VFLAG,vrs,vre
      INTEGER     NSAMPV, NSIV, NTRCV, NRECV, LVBYTES, IFORMV,vst,ved
      REAL        TRI ( SZLNHD ),V(SZLNHD), TOL
      REAL        work ( SZLNHD )
      real        vref, angle, dip, rad, deg
#include <f77/pid.h>
      CHARACTER   NAME * 7, ntap * 512, otap * 512, vmod *512
      CHARACTER   atap * 512
      logical     verbos, query, stat,remove,slnt,radon,IKP,dead
      integer     argis, pipe, pipe1
      integer     irs, ire, ns, ne
      integer     nreout, ntrout

c     EQUIVALENCE ( ITR(129), TRI (1) )
c     EQUIVALENCE ( NTR(129), V (1) )
c     EQUIVALENCE ( ITR(  1), LHED(1) )
c     EQUIVALENCE ( NTR(  1), LVHED(1) )
      DATA  NBYTES / 0 /, LBYTES / 0 /, name/'TAUPNMO'/
      DATA  NVBYTES / 0 /, LVBYTES / 0 /,pi/3.14159265/
      DATA  pipe /3/
      DATA  pipe1/4/
      DATA  dead/.false./

      rad = 3.14159265/180.
      deg = 1./rad

C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = ( argis ('-?').gt.0 .or. argis('-h').gt.0 )
      if ( query ) then
        call help()
        stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>
      
C**********************************************************************C
C     read command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,vmod,ns,ne,irs,ire,vrs,vre,stat,tol,
     1           vref,dip,slnt,remove,verbos,radon,atap,IKP,vscl)
      vst = 1
      ved = 1
c     if ( verbos ) then
         write(LERR,*)' First record to process              =  ',irs
         write(LERR,*)' Last record to process               =  ',ire
         write(LERR,*)' First velocity to use                =  ',vrs
         write(LERR,*)' Last  velocity to use                =  ',vre
         write(LERR,*)' Starting trace number                =  ',ns
         write(LERR,*)' Ending   trace number                =  ',ne
         write(LERR,*)' % of ellipse to moveout              =  ',tol
         write(LERR,*)' Constant dip angle (deg)             =  ',dip
         write(LERR,*)' Reference Velocity                   =  ',vref
         write(LERR,*)' Velocity scale factor                =  ',vscl
         write(LERR,*)' Remove nmo (true ?)                  =  ',remove
         write(LERR,*)' Apply statics before nmo             =  ',istat
         if (slnt)
     1   write(LERR,*)' Input data from program SLNT'
         if (radon)
     1   write(LERR,*)' Input data from program radonf'
c     end if
      tol = tol/100.

C**********************************************************************C
C     open logical i/o units
C     check line header; save key values
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      call getln(luvel, vmod, 'r',-1)
      luvel = -1
      if (vmod .ne. ' ') then
          call getln(luvel, vmod, 'r',-1)
          IKP = .false.
      else
          write(LERR,*)'taupnmo assumed to be running inside IKP'
          IKP = .true.
          call sisfdfit (luvel, pipe)
          write(LERR,*)'taupnmo: got unit ',luvel,' for velocity tape'
      endif
      if  (luvel .lt. 0)   then
           call error ('taupnmo error: velocity file -v not accessible')
      endif

      lugam = -1
      if (atap(1:1) .ne. ' ') then
         call getln (lugam, atap, 'w', -1)
         if (lugam .lt. 0)   then
             call error ('taupnmo error: angle file -A not accessible')
         endif
      elseif (IKP) then
          write(LERR,*)'taupnmo assumed to be running inside IKP'
          call sisfdfit (lugam, pipe1)
          write(LERR,*)'taupnmo: got unit ',lugam,' for angle data'
          if (lugam .lt. 0)   then
             call error ('taupnmo error: angle file -A not accessible')
          endif
      endif

c-----------------
c  input data
c-----------------
      vflag=1
      lbytes=0
      CALL RTAPE (LUIN , ITR , lbytes           )
      if(lbytes .eq. 0) then
         write(LERR,*)'TAUPNMO: no header read on unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif
      CALL HLHprt ( ITR , LBYTES, name, 7, LERR         )
#include <f77/saveh.h>

      if (.not. slnt .and. radon) then
         call saver (itr, 'MxRSEL' , ixmax , LINHED)
         call saver (itr, 'MxGrEl' , itmax , LINHED)
         call saver (itr, 'MnGrEl' , itmin , LINHED)
         xmax = ixmax
         tmin = itmin
         tmax = itmax
         tmxx = amax1 (float(itmax), float(iabs(itmin)))
         if (tmxx .eq. 0.) then
            vref = 0.
         else
            vref = 1000. * xmax / tmxx
         endif
         write(LERR,*)' '
         write(LERR,*)'radonf input:'
         write(LERR,*)'Max distance      =  ',xmax
         write(LERR,*)'Max time (ms)     =  ',tmax
         write(LERR,*)'Min time (ms)     =  ',tmin
         write(LERR,*)'Reference velocity=  ',vref
         write(LERR,*)' '
      elseif (.not. slnt .and. .not. radon) then
         call saver(itr, 'WatVel', ivref, LINHED)
         call saver(itr, 'MxTrSt', itmax, LINHED)
         call saver(itr, 'MnTrSt', itmin, LINHED)
         tmin = itmin
         tmax = itmax
         vref = ivref
         write(LERR,*)' '
         write(LERR,*)'taupf input:'
         write(LERR,*)'Max time (ms)     =  ',tmax
         write(LERR,*)'Min time (ms)     =  ',tmin
         write(LERR,*)'Reference velocity=  ',vref
         write(LERR,*)' '
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SGRNum',ifmt_SGRNum,l_SGRNum,ln_SGRNum,TRACEHEADER)


c-----------------
c  velocity data
c-----------------
      lvbytes=0
      CALL RTAPE (LUVEL , NTR , lvbytes          )
      if(lvbytes .eq. 0) then
         write(LERR,*)'TAUPNMO: no header read on velocity unit ',luvel
         write(LERR,*)'FATAL'
         stop
      endif

      call saver(ntr, 'NumSmp', nsampv, LINHED)
      call saver(ntr, 'SmpInt', nsiv  , LINHED)
      call saver(ntr, 'NumTrc', ntrcv , LINHED)
      call saver(ntr, 'NumRec', nrecv , LINHED)
      call saver(ntr, 'Format', iformv, LINHED)

c--------------------------------------
c   vflag=0 single velocity function
c   vflag=1 multiple velocity function
c--------------------------------------
      if(nrecv .le. 1 .and. ntrcv .eq. 1) vflag=0

      dt = real (nsi) * unitsc

c     if ( verbos ) then
         write(LERR,*)' Values read from input data set lineheader'
         write(LERR,*)' # of Samples/Trace =  ',nsamp
         write(LERR,*)' Sample Interval    =  ',nsi
         write(LERR,*)' Traces per Record  =  ',ntrc
         write(LERR,*)' Records per Line   =  ',nrec
         write(LERR,*)' Format of Data     =  ',iform
         if(vflag .eq. 0) then
            write(LERR,*)' Single velocity function will be used'
         endif
         if(stat) write(LERR,*)' Apply Internal Statics'
         if(remove)write(LERR,*)' Remove normal moveout'
         write(LERR,*)' Values read from velocity data set lineheader'
         write(LERR,*)' # of Samples/Trace =  ',nsampv
         write(LERR,*)' Sample Interval    =  ',nsiv
         write(LERR,*)' Traces per Record  =  ',ntrcv
         write(LERR,*)' Records per Line   =  ',nrecv
         write(LERR,*)' Format of Data     =  ',iformv
c     end if
      if(nsampv .lt. nsamp) then
         write(LERR,*)'velocity trace(s) too short; contains ',nsampv,
     &                'samples'
         write(LERR,*)'input data contains ',nsamp,' samples'
         write(LERR,*)'Rerun velin job so that trace at least ',
     &                nsi*nsamp,' ms long'
         stop
      endif

C**********************************************************************C
C     CHECK DEFAULT VALUES AND SET PARAMETERS
C**********************************************************************C
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      call cmdchk(vst,ved,vrs,vre,ntrcv,nrecv)

c-----
c      modify header as needed
c-----
      nreout = ire - irs + 1
      ntrout =  ne -  ns + 1
      call savew( itr, 'NumTrc',ntrout, LINHED)
      call savew( itr, 'NumRec',nreout, LINHED)
      call savhlh(itr, lbytes, lbyout)

C**********************************************************************C
C     write out modified line header
C**********************************************************************C
      call wrtape(luout, itr, lbyout)

      if (lugam .gt. 0)
     1    call wrtape(lugam, itr, lbyout)

c check for multiple trace per record velocity dataset and reset vre
c appropriately so that 3D data can be handled without utoping the
c velocity cube.  This should not affect 2D data as there should be
c a single trace velocity gather in effect at that point. Even if there
c isn't then it should still allow 2D single record, multi-trace velocity
c datasets to be used with 2D lines.
 
      if ( ntrcv .gt. 1 ) then
         vre = ( vre - vrs + 1 ) * ntrcv
         if ( vrs .gt. 1 ) vrs = ( vrs - 1 ) * ntrcv + 1
         nrecv = nrecv * ntrcv
         ntrcv = 1
      endif


c-----
c      skip unwanted records
c-----
      nvbytes=1
c---------------------------------
c     multiple velocity functions
c---------------------------------
      if(vflag .eq. 1) then
         if(vrs .le. nrecv) then
           call recskp(1,vrs-1,luvel,ntrcv,ntr)
         else
             call error('start record to skip to exceeds number')
             call error('records on velocity file')
             call error('check velin run to make sure your velocity')
             call error('model covers the part of the data between')
             write(LERR,*)'records ',vrs,' and ', vre
             stop
         endif
c-------------------------------------------------------
c     slingle velocity function:  read him right away
c-------------------------------------------------------
      elseif(vflag .eq. 0) then
           nvbytes=0
           call rtape (luvel,ntr,nvbytes)
           if(nvbytes .eq. 0) then
              write(LERR,*)'End of file on velocity file: FATAL'
              stop
            endif
c           call vmov (ntr(ITHWP1), 1, v, 1, nsampv)
            call vsmul (ntr(ITHWP1), 1, vscl, v, 1, nsampv)
 
            if(verbos) then
               write(LERR,*)'velocity'
               write(LERR,777)(v(i),i=1,nsampv)
 777           format(10f8.2)
            endif
c
c ----- check for valid velocities -----
c
            call dotpr (v,1,v,1,vdot,nsampv)
            if (abs(vdot) .lt. 1.e-06) then
               write(LERR,*)' '
               write(LERR,*)'TAUPNMO: Velocity trace contains zeros'
               write(LERR,*)'       Check the velin step thoroughly'
               write(LERR,*)'FATAL '
               write(LER,*)' '
               write(LER,*)'TAUPNMO: Velocity trace contains zeros'
               write(LER,*)'       Check the velin step thoroughly'
               write(LER,*)'FATAL '
               go to 999
            endif
      endif

      call recskp(1,irs-1,luin, ntrc,itr)

c--------------------------------------------------------------------
c       read trace
c      beware perhaps the individual trace number should change ?
c-----
c   when reading velocity traces make sure that if we run out of vel. traces
c   we use the last vel trace to the end of the line...
c--------------------------------------------------------------------
        nvbytes=1
        DO 5000 JJ = irs, ire
           if(vflag.eq.1 .and. nvbytes.ne.0 .and. jj.le.vre) then
              nvbytes=0
              call rtape (luvel,ntr,nvbytes)
              if(nvbytes .eq. 0) then
               write(LERR,*)' '
               write(LERR,*)'TAUPNMO: Premature EOF on Velocity Dataset'
               write(LERR,*)'       at sequential record number ',JJ
               write(LERR,*)'FATAL'
               write(LER,*)' '
               write(LER,*)'TAUPNMO: Premature EOF on Velocity Dataset'
               write(LER,*)'       at sequential record number ',JJ
               write(LER,*)'FATAL'
               goto 999
              endif
              call vsmul (ntr(ITHWP1), 1, vscl, v, 1, nsampv)
c             call vmov  (ntr(ITHWP1), 1, v, 1, nsampv)
              call saver2(ntr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irecv , TRACEHEADER)
              call saver2(ntr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    itrcv , TRACEHEADER)
              call saver2(ntr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                    ilinv , TRACEHEADER)
              call saver2(ntr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                    idphv , TRACEHEADER)
              if (verbos)
     1        write(LERR,*)'Reading velocity trace: rec/trc ',irecv,
     2                      itrcv,' LI/DI ',ilinv,idphv
c
c ----- check for valid velocities -----
c
             call dotpr (v,1,v,1,vdot,nsampv)
             if (abs(vdot) .lt. 1.e-06) then
                write(LERR,*)' '
                write(LERR,*)'TAUPNMO: Velocity trace contains zeros'
                write(LERR,*)'       Check the velin step thoroughly'
                write(LERR,*)'FATAL '
                write(LER,*)' '
                write(LER,*)'TAUPNMO: Velocity trace contains zeros'
                write(LER,*)'       Check the velin step thoroughly'
                write(LER,*)'FATAL '
                go to 999
             endif
           endif

c---------------
c skip to beg of
c cur rec
           dead = .false.
           call trcskp(jj,1,ns-1,luin,ntrc,itr)

           DO 5001 KK = ns, ne
            nbytes = 0
            CALL RTAPE  ( LUIN, ITR, NBYTES )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
               call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istat , TRACEHEADER)

c-----
c   check for completely dead record. This is indicated by all traces
c   in the record having a static of 30000 so we only have to check
c   to see if the first processed trc is dead to know about the whole rec
c-----
               IF (KK .eq. ns .AND. istat .eq. 30000) dead = .true.
               IF (dead) THEN
                   call vclr (tri , 1, nsamp)
                   call vclr (work, 1, nsamp)
                   call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                         30000 , TRACEHEADER)
                   go to 4999
               ENDIF
               

                IF (slnt) THEN

                  if (vref .eq. 0.0) then
                     call saver2(itr,ifmt_DstUsg,l_DstSgn, ln_DstUsg,
     1                           ivref , TRACEHEADER)
                     vrefh = float( ivref )
                  else
                     vrefh = vref
                  endif
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        irayp , TRACEHEADER)
                  angle = pi * float( irayp )/180.
                  angle = angle - dip
                  p = sin( angle )/vrefh

                ELSEIF (radon) THEN

                  call saver2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                        irayp , TRACEHEADER)
                  p0 = float(irayp)/10000000.
                  if (vref .eq. 0.0) vref = v(1)
                  if (p0 .gt. +.999999) p0 = +.9999999
                  if (p0 .lt. -.999999) p0 = -.9999999
                  iangle = deg * asin (p0)
                  p = p0 - sin( rad*dip )/vref
c     write(0,*)'radon: jj,kk,irayp,vref,p0 ',jj,kk,irayp,vref,p
                  call savew2(itr,ifmt_SGRNum,l_SGRNum, ln_SGRNum,
     1                        iangle, TRACEHEADER)

                ELSE

                  call saver2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                        irayp , TRACEHEADER)
                  p0 = float(irayp)/10000000.
                  if (vref .eq. 0.0) vref = v(1)
                  vp0 = vref * p0
                  if (vp0 .gt. +.999999) vp0 = +.9999999
                  if (vp0 .lt. -.999999) vp0 = -.9999999
                  iangle = deg * asin (vp0)
                  p = p0 - sin( rad*dip )/vref
c     write(0,*)'taupf: jj,kk,irayp,vref,vp0 ',jj,kk,irayp,vref,vp0,p
                  call savew2(itr,ifmt_SGRNum,l_SGRNum, ln_SGRNum,
     1                        iangle, TRACEHEADER)

                ENDIF

                  call x2t2(TRI,dt,NSAMP,p,V,work,tol,remove)

4999              continue

                  call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
                  call wrtape (luout,itr, nbytes)

                  if (lugam .gt. 0) then
                     call vmov (work, 1, itr(ITHWP1), 1, nsamp)
                     call wrtape (lugam,itr, nbytes)
                  endif
 5001          continue

c---------------
c skip to end of
c cur rec
           call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)

 5000       continue
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luvel )
      if (lugam .gt. 0)
     1call lbclos ( lugam )
      END


c------------------------------------------------------
c  write messages to printout
c------------------------------------------------------
      subroutine error(mesgs)
#include <f77/iounit.h>
      character     mesgs*(*)
      write(LERR,*) mesgs
      stop
      end

c------------------------------------------------------
c  online help screen
c------------------------------------------------------
      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'                  taupnmo - NMO in tau-p domain'
      write(LER,*)
     :'Run this program by typing: taupnmo and the following arguments'
         write(LER,*)
     :' -N [ntap]    (stdin)      : Input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)      : Output data file name'
        write(LER,*)
     :' -A [atap]    (no output)   : optional output angle-time data'
        write(LER,*)
     :' -v [vmod] velocity model (no default)                     '
        write(LER,*)
     :' -d [dip] constant dip (angle for slnt data or ray parameter)'
        write(LER,*)
     :' -g [vref] reference velocity overrride (def = first vmod vel.)'
        write(LER,*)
     :' -t [tol] % ellipse to moveout (measured from p=0) (def=100)'
        write(LER,*)
     :' -vs [vscl] scale factor for velocities (def = 1.0)'
        write(LER,*)
     :' -ns [ns] starting trace (default = 1)'
      write(LER,*)
     :' -ne [ne] ending trace   (default = all traces)'
      write(LER,*)
     :' -rs[irs] starting record (default = 1)'
      write(LER,*)
     :' -re[ire] ending record (default = all)'
      write(LER,*)
     :' -sv[vrs] starting velocity record (default = 1)'
      write(LER,*)
     :' -ev[vrs] ending velocity record (default = last)'
      write(LER,*)
     :' -S apply trace header statics'
      write(LER,*)
     :' -R remove normal moveout'
      write(LER,*)
     :' -radon input data is from program radonf'
      write(LER,*)
     :' -slnt input data is from program slnt'
      write(LER,*)
     :' -V verbose printout'
      write(LER,*)
     :'Usage: taupnmo -N[ntap] -O[otap] -v[vmod] -t[tol] -d[] -g[]'
         write(LER,*)
     :'               -vs[] -A[] -ns[] -ne[] -rs[] -re[] -sv[] -ve[]'
         write(LER,*)
     :'                [-S -radon -slnt -R -V]'
         write(LER,*)
     :'***************************************************************'

      return
      end

C**********************************************************************C
C     get command line parameters
C**********************************************************************C
      subroutine cmdln(ntap,otap,vmod,ns,ne,irs,ire,vrs,vre,stat,tol,
     1                 vref,dip,slnt,remove,verbos,radon,atap,IKP,vscl)
c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     vmod  - C*100  velocity file name
c     tol   - R      % ellipse to moveout (measured from p=0)
c     dip   - R      dip angle (constant)
c    vref   - R      reference velocity
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c     vrs   - I      start velocity record
c     vre   - I      end velocity record
c    stat   - L      normalize stacked trace by # live traces
c    slnt   - L      input data from program slnt
c  radon    - L      input data from program radon
c  remove   - L      remove normal moveout
c    verbos - L      verbose output or not
c-----
      integer     ns,ne,irs,ire,vrs,vre, argis
      real        tol, dip, vref
      character   ntap*(*),otap*(*),vmod*(*),atap*(*)
      logical     stat,remove,verbos,slnt,radon,IKP

      IKP = .false.

      call argstr ('-N', ntap, ' ', ' ' )
      call argstr ('-O', otap, ' ', ' ' )
      call argstr ('-A',atap, ' ', ' ')
      call argr4  ('-vs',vscl,1.0,1.0)
      call argstr ('-v',vmod, ' ', ' ')
      call argr4  ('-t',tol,100.,100.)
      call argr4  ('-d',dip,0.,0.)
      call argr4  ('-g',vref,0.,0.)

      call argi4  ('-ns',ns,0,0)
      call argi4  ('-ne',ne,0,0)
      call argi4  ('-rs',irs,0,0)
      call argi4  ('-re',ire,0,0)
      call argi4  ('-sv',vrs,1,1)
      call argi4  ('-ev',vre,0,0)
      stat   = ( argis ('-S') .gt. 0 )
      radon  = ( argis('-radon') .gt. 0)
      slnt   = ( argis('-slnt') .gt. 0)
      remove = ( argis ('-R') .gt. 0 )
      verbos = ( argis ('-V') .gt. 0 )
      IKP    = (in_ikp() .gt. 0)

      return
      end
