C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************


      subroutine taupee (nsamp,ntrc,nspad,nw,nlive,ncmplx,domega,
     1                   numtp,istpr,vel,p,weight,taper,data,dist,
     2                   slant,orig,data2d,vref)

c  subroutine to do forward tau-p transform in frequency domain
c
c  input:
c
c     nsamp  I  number samples/trace
c      ntrc  I  number traces/rec
c     nspad  I  next power of 2 samples/trace
c        nw  I  number frequencies in FFT
c      nlive I  number live input traces
c     ncmplx I  number complex freqs
c     domega R  delta freq
c      numtp I  number ray parameters
c      istpr I  number weights in freq taper
c        vel R  reference velocity
c     weight R  vector spread weights
c          p R  vector ray parameters
c      taper R  vector freq weights
c       data R  matrix of input data
c      ithdr I  matrix of input trace headers
c       orig L  use original trace distances
c      slant L  input data is from program SLNT

c output:
c
c       data R  matrix containing transformed data

 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      real          p(*), weight(*),taper(*), dist(*)
      COMPLEX       DATA2D(*), DATAC1(SZLNHD), c0, sum
      complex       slnt(SZLNHD), sslnt(SZLNHD), dslnt(SZLNHD)
 
      REAL          WORK(2*SZLNHD)
      REAL          DATA(*), xoff2(SZLNHD)
      real          tp,vel,arg,scalr,pi,vref
      logical       orig, slant
 
      data PI/3.14159265/

      if (slant) then
         sgn = -1.
      else
         sgn = 1.0
      endif

      c0 = cmplx (0.,0.)
      scalr = 1.
      if (nlive .gt. 0) scalr = 1./float(nlive)
c     gam1 = p(1) * pi/180.
c     gam2 = p(numtp) * pi/180.
c     ds   = abs (sin(gam1) - sin(gam2))
      delf = .5 * domega/pi
 
C +--------------------------------------+
c |  fft data and transpose into data2d array
C +--------------------------------------+
      do  101  nx = 1, ntrc

          if (slant) then
              idist = dist (nx)
              xoff2 (nx) = sin (float(idist) * pi/180.) / vref
          else
              xoff2 (nx) = dist (nx)
          endif

          istrc = (nx-1) * nsamp
          call vclr (work,1,nspad)
          call vmov (data(istrc+1),1,work,1,nsamp)
          call rfftb (work,datac1,nspad,1)
          call rfftsc (datac1,nspad,3,-1)

          jxw = nx - ntrc
          do  121  jw = 1, nw

              jxw = jxw + ntrc
              data2d (jxw) = datac1 (jw) * weight (nx)

              if (istpr .ne. 0 .and. jw .ge. istpr) then

                  kjw = jw - istpr + 1
                  data2d (jxw) = data2d (jxw) * taper(kjw)

              endif

121       continue

101   continue

c---------------------------------------------
c initialize slant arrays & do tp slant stack

      do  201  jp = 1, numtp

          tp = sgn * p (jp)

          do  202  nx = 1, ntrc

              slnt (nx) = cmplx (1.0,0.0)
              arg =  -domega * tp * xoff2(nx)
              dslnt (nx) = cmplx (cos (arg), sin (arg))

202       continue

          jxw = 1 - ntrc

          do  203  jw = 1, nw

              call cvmov (slnt,2,sslnt,2,ntrc)

              do  777  ix = 1, ntrc
                  slnt (ix) = sslnt (ix) * dslnt (ix)
777           continue

              jxw = jxw + ntrc
c             call cdotpr (data2d (jxw),2,slnt,2,datac1(jw),ntrc)
              sum = cmplx(0.,0.)
              do  15  ii = 1, ntrc
                   sum = sum + data2d(jxw+ii-1) * slnt(ii)
15            continue
              datac1(jw) = sum * float(jw) * delf

203       continue

          call rfftsc (datac1,nspad,-3,0)
          call rfftb (datac1,work,nspad,-1)
          istrc = (jp-1) * nsamp
          call vmul (scalr,0,work,1,data(istrc+1),1,nsamp)

201   continue

      return
      end
