C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE tau-p  Predictive Deconvolution
C
C**********************************************************************C
C
C TAUPRED READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C does a predictive deconvolution with optional filtering and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, predictive routines
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis
#include <f77/pid.h>
      REAL        xtr ( SZLNHD ), otrace(SZLNHD), wtrace(4*SZLNHD)
      REAL        xtrs( SZLNHD )
      real        pf(SZLNHD), weight(SZLNHD), rad
      real        pfs(SZLNHD)
      CHARACTER   NAME * 7, ntap * 256, otap * 256, stap * 256
      logical     verbos,query, slnt, predict, gate, cost, bart, radon
      logical     TV

 
c     EQUIVALENCE ( ITR(129), xtr (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )

      DATA  NAME     /'TAUPRED'/
      DATA  LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      data  verbos/.false./
      rad = 3.14159265/180.

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = ( argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if( query ) then
              call help()
              stop
      endif

C**********************************************************************C
C     open printout files
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     read program parameters from the command line
C**********************************************************************C
      call cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,
     1                 vel,pr,pmin,ol,prew,predict, verbos,
     2                 slnt,gate,cost, bart, radon,stap,TV,lslide)

C**********************************************************************C
C     open data units
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)
      if (stap(1:1) .ne. ' ' .AND. .not. TV) then
         call getln(luat, stap, 'w', 2)
         if (luat .le. 0) then
            write(LERR,*)'TAUPRED: unable to open predictable'
            write(LERR,*)'signal data set for output.'
            write(LERR,*)'Check write permissions in directory'
            stop
         endif
      endif

C**********************************************************************C
C     read lineheader; save key parameters; modify parameters;
C     update header; write out header
C**********************************************************************C
      lbytes = 0
      CALL RTAPE ( LUIN, ITR, LBYTES        )
      CALL HLHprt ( ITR , LBYTES, NAME, 7, LERR        )
      if(lbytes .eq. 0) then
         write(LERR,*)'TAUPRED: no header read on unit ',ntap
         write(LERR,*)'check existence of data file'
         write(LERR,*)'FATAL'
         stop
      endif

#include <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SGRNum',ifmt_SGRNum,l_SGRNum,ln_SGRNum,TRACEHEADER)


      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      call cmdchk(nst,ned,nrst,nred,ntrc,nrec)
      ntr   = ntrc
      nrecc = nrec

         dt = float(nsi) * unitsc

         veldt = vel * dt
         iend=iend/nsi + .5
         ist=ist/nsi
         if(ist .le. 1) ist=1
         ist0 = ist
         if(iend .eq. 0) iend=nsamp
         if(iend .gt. nsamp) iend=nsamp
         lpr0=max(pr/nsi,1.)
         lprmin=max(pmin/nsi,1.)
         lpf0=ol/nsi
         lf0 = lpr + lpf
         lf2 = 2 * lf0
         lslide = lslide / nsi
         iovlp  = lslide / 2

      if (TV) then
         iwnd = nsi * (iend - ist + 1)
         if(ol.gt.iwnd/2)then
          write(LER,*)' '
          write(LER,*)'Fatal: time variant option error'
          write(LER,*)'Operator too long.  Max is 1/2 the window length'
          write(LER,*)'Window length is ',iwnd,' op length is ',ol
          write(LER,*)'Fatal'
          call lbclos(luin)
          stop
         endif
      endif

         nsampo=iend-ist+1

       call savew( itr, 'NumSmp', nsamp , LINHED)
       call savew( itr, 'NumTrc', ntr  , LINHED)
       call savew( itr, 'NumRec', nrecc, LINHED)

C**********************************************************************C
C     print line header values
C**********************************************************************C
c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform
c     endif
c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' Samples in design wind =  ', nsampo
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntr 
        write(LERR,*) ' Records per Line   =  ', nrecc 
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) 'p    (    pred. distance) = ',lpr0  , 'samples'
        write(LERR,*) 'pmin (min pred. distance) = ',lprmin, 'samples'
        write(LERR,*)'p=0 operator length= ',ol,'  ms ',lpf0,' samples'
        write(LERR,*)'p=0 total taupred filt length = ',lf0,' samples'
        write(LERR,*)'Prewhitening= ',prew
        write(LERR,*)'Design window start time  =  ',ist0
        write(LERR,*)'Reference velocity        =  ',vel
        if (slnt)
     1  write(LERR,*)'Getting ray parameter from header wd 41 (mvs prgm
     2 SLNT)'
        if (gate)
     1  write(LERR,*)'Apply decon only within design window'
        write(LERR,*)'Cosine weighting of auto-corr  = ',cost
        write(LERR,*)'Bartlett weighting of auto-corr= ',bart
        if (TV)
     1  write(LERR,*)'Sliding window length=  ',lslide,' samples'
c     endif

      prew = prew / 100.

      if    (cost)  then
          do  16  i = 1, lpf0
              ang = 3.14159265 * float(i-1)/float(lpf0)
              weight(i) = .5 * (1. + cos ( ang ))
16        continue
      elseif (bart) then
          do  17  i = 1, lpf0
              weight(i) = float(lpf0 -i + 1)/ float(lpf0)
17        continue
      else
          call vfill (1.0, weight, 1, lpf0)
      endif
      write(LERR,*)'weights:'
      write(LERR,*)(weight(i),i=1,lpf0)


      obytes = SZTRHD + SZSMPD * nsamp
      call savhlh( itr, lbytes, lbyout)
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

      if (stap(1:1) .ne. ' ' .AND. .not. TV)
     1   call wrtape (luat, itr, lbyout)


C**********************************************************************C
C     skip unwanted records
C**********************************************************************C
c     call recskp(1,nrst-1,luin,ntrc,itr)

C**********************************************************************C
C     main processing loop:
C          read trace; deconvolve; write output
C**********************************************************************C
      DO 100 JJ = 1, nrec

c---------------------------
c  skip traces within rec
c---------------------------
c           call trcskp(jj,1,nst-1,luin,ntrc,itr)

             DO 99 KK = 1, ntrc
                   nbytes = 0
                   CALL RTAPE  ( LUIN , ITR, NBYTES         )
                   if(nbytes .eq. 0) then
                      write(LERR,*)'End of file on input:'
                      write(LERR,*)'  rec= ',jj,'  trace= ',kk
                      go to 999
                   endif
                   call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)

                 call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                       istatic, TRACEHEADER)

                 IF (JJ .ge. nrst .and. JJ .le. nred .AND.
     1               KK .ge. nst  .and. KK .le. ned       ) THEN


                   IF(istatic .ne. 30000) THEN
                      if (verbos) write(LERR,*)' '
c------------------
c calc ray param
c stored by taupf
                      IF (slnt) then
                        call saver2(lhed,ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     1                              irayp , TRACEHEADER)
                         dist = irayp
                         cosine = cos(rad*dist)
                      ELSE
                        call saver2(lhed,ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     1                              irayp , TRACEHEADER)
                         dist = abs(float(irayp)/10000000.)
                         xyz = (vel*dist) **2
                         if (xyz .le. 1.0) then
                            cosine = sqrt (1. - xyz)
                         else
c_____________________________________________________________________
c                           use spiking decon for ray parameters that
c                           are too large for the reference velocity
c_____________________________________________________________________
                            cosine=0.
                         endif
                      ENDIF
                      ist = ist0 * cosine
                      if (ist .lt. 1) ist = 1
c                     nsampk = nsampo * ist -1
                      nsampk = nsampo * cosine
                      if (nsampk .lt. lf2) nsampk = lf2
                      call dotpr (xtr(ist),1,xtr(ist),1,xdot,nsampk)

                      if ( xdot .ne. 0.0 ) then
                         lpr = float(lpr0) * cosine
                         lpr=max(lpr,lprmin)
                         lpf = lpf0
c                        lpf = float(lpf0) * cosine
                         if (lpf .lt. 1) lpf = 1 
                         lf = lpr + lpf
                         if (verbos) then
                            if(kk .eq. 1) then
                              write(lerr,*) 'Record',jj             
                              write(lerr,*) 'RecNum',itr(l_RecNum)
                              write(lerr,*) 'TrcNum','pr dist',
     1                            'op len','filt len','start',
     2                            'window','p','cosine'
                            endif
                            write(lerr,'(/,6i8,2f12.6)') 
     1                          itr(l_RecNum),lpr,
     2                          lpf,lf,ist,nsampk,dist,cosine
                         endif

                         if (TV) then

                            call tvwin (lslide,iovlp,nsampk,nwin)
                            call decon_tv(xtr(ist),nsampk,lpf,lpr,prew,
     1                                    wtrace,ierr,lslide,nwin,iovlp,
     2                                    weight)
                            call vmov (wtrace, 1, xtr(ist), 1, nsampk)
                         else

                            call predik(nsampk,xtr(ist),lpr,lpf,pf,
     1                                  ase,prew,wtrace,weight)
                         endif
                       
                      endif
                       
c################################################################
c time invariant section
                  if (.not. TV) then
                      if( predict ) then
                          do 51  ii = 1, lf-1
                                 pf (ii) = - pf (ii+1)
   51                     continue
                          call fold(lf,pf,nsamp,xtr,nfold,otrace)
                          call vmov(otrace,1,xtr,1,nsamp)
                          call vrvrs(pf,1,lf)
                      endif

                      if (stap(1:1) .ne. ' ') then
                          call vmov (xtr, 1, xtrs, 1, nsamp)
                          lf1 = lf - 1
                          do    ii = 1, lf1
                                 pfs (ii) = - pf (ii+1)
                          enddo
                      endif
                       
c--------------------
c apply only within
c design window, or
                      if (gate) then
                         call fold(lf,pf,nsampk,xtr(ist),nfold,otrace)
                         call vmov(otrace,1,xtr(ist),1,nsampk)
                         if (stap(1:1) .ne. ' ') then
                             call fold(lf1,pfs,nsampk,xtrs(ist),
     1                                 nfold,otrace)
                             call vmov(otrace,1,xtrs(ist),1,nsampk)
                         endif
c over whole trace
                      else
                         call fold(lf,pf,nsamp,xtr,nfold,otrace)
                         call vmov(otrace,1,xtr,1,nsamp)
                         if (stap(1:1) .ne. ' ' .AND. .not. TV) then
                             call fold(lf1,pfs,nsamp,xtrs,
     1                                 nfold,otrace)
                             call vmov(otrace,1,xtrs,1,nsamp)
                         endif
                      endif
c--------------------
                  endif
c################################################################

 

                   ENDIF

                 ENDIF

                    call vmov (xtr, 1, lhed(ITHWP1), 1, nsamp)
                    call wrtape(luout,itr,obytes)
                    if (stap(1:1) .ne. ' ' .AND. .not. TV) then
                        call vmov (xtrs, 1, lhed(ITHWP1), 1, nsamp)
                        call wrtape(luat,itr,obytes)
                    endif
 
   99        CONTINUE

c-----------------------------
c  skip to end of record
c-----------------------------
c           call trcskp(jj,ned+1,ntrc,luin,ntrc,itr)

  100 CONTINUE

  999 continue

         call lbclos(luin)
         call lbclos(luout)
         if (stap(1:1) .ne. ' ' .AND. .not. TV) call lbclos (luat)

      END

c---------------------------------------
c  online help section
c---------------------------------------
      subroutine help
#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'Command Line Arguments for TAUPRED: predictive'
     1               //' decon in tau-p'
      write(LER,*)' '
      write(LER,*)'Input....................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[ntap]   -- input data set name'
      write(LER,*)'-O[otap]   -- output data set name'
      write(LER,*)'-S[atap]   -- predictable signal optional DSN'
      write(LER,*)' '
      write(LER,*)'design window:'
      write(LER,*)'-s[ist]    -- start time                    (0 ms)'
      write(LER,*)'-v[vel]    -- reference velocity m or ft/s  (none)'
      write(LER,*)'-e[iend]   -- end time                 (last samp)'
      write(LER,*)' '
      write(LER,*)'prediction parameters:'
      write(LER,*)'-p[pr]     -- pred dist at ray parm=0 (ms)(1 samp)'
      write(LER,*)'-pmin[pmin]-- minimum pred dist (ms)      (1 samp)'
      write(LER,*)'-ol[ol]    -- operator length, ms'
      write(LER,*)'-P[prew]   -- prewhitening                   (.01)'
      write(LER,*)' '
      write(LER,*)'trace/record limitation:'
      write(LER,*)'-ns[nst]   -- start process trace #     (first tr)'
      write(LER,*)'-ne[ned]   -- end process trace #        (last tr)'
      write(LER,*)'-rs[nrst]  -- start process #          (first rec)'
      write(LER,*)'-re[nred]  -- end process #             (last rec)'
      write(LER,*)' '
      write(LER,*)'-TV        -- decon time varying:'
      write(LER,*)'-w[lslide] -- sliding window length (ms)     (500)'
      write(LER,*)'Note:         -G, -S options below & -S[atap] above'
      write(LER,*)'              ignored'
      write(LER,*)' '
      write(LER,*)'-S         -- output predictable part of data only'
      write(LER,*)'-G         -- apply decon only in design window'
      write(LER,*)'-R         -- input data is from program radonf'
      write(LER,*)'-M         -- input data is from program slnt'
      write(LER,*)'-C         -- cosine weighting of auto-corr'
      write(LER,*)'-B         -- bartlett weighting of auto-corr'
      write(LER,*)'           -- default is no weighting of auto-corr'
      write(LER,*)'              default = non-predictable'
     1                           //' (normal pred)'
      write(LER,*)'-V         -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'    taupred -N[] -O[] -A[] -s[] -e[] -p[] -pmin[]'
      write(LER,*)'            -ol[] -P[] -v[] -ns[] -ne[] -rs[] -re[]'
      write(LER,*)'            [-TV -w[] ] [-P -V -R -M -G -C -B]'
      write(LER,*)' '
 
      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c       s   - I      start time
c       e   - I      stop time
c     nst   - I      start trace
c     ned   - I      stop trace
c    nrst   - I      start record
c    nred   - I      end record
c      pr   - R      prediction distance
c     vel   - R      velocity for design window
c      ol   - R      operator length
c    prew   - R      prewhitening
c   predict - L      output predictable part of data
c    slnt   - L      use slnt p header wrd 41 * 10000
c    radon  - L      use radonf p header wrd
c    gate   - L      apply decon only within design window
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,
     1                 vel,pr,pmin,ol,prew,predict, verbos,
     2                 slnt,gate,cost, bart, radon,stap,TV,lslide)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*), stap*(*)
      integer    ist,iend,nst,ned,nrst,nred, argis
      real       pr,ol,prew,vel
      logical    verbos, predict, slnt, gate, cost, bart, radon
      logical    TV

      gate    = .false.
      predict = .false.
      slnt    = .false.
      radon   = .false.
      TV      = .false.

          call argstr('-N',ntap,' ',' ')
          call argstr('-O',otap,' ',' ')
          call argstr('-A',stap,' ',' ')
          call argi4('-s',ist,1,1) 
          call argi4('-e',iend,0,0) 
          call argr4('-v',vel,0.,0.)
          call argr4('-p',pr,0.,0.)
          call argr4('-pmin',pmin,0.,0.)
          call argr4('-ol',ol,0.,0.)
          call argr4('-P',prew,.01,.01)
          call argi4('-w',lslide,500,500)
          call argi4('-ns',nst,0,0)
          call argi4('-ne',ned,0,0)
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)

          if(vel .eq. 0.) then
             write(LERR,*)'No reference velocity given -- FATAL'
             stop
          endif
          if(ol .eq. 0.) then
             write(LERR,*)'No operator length given -- FATAL'
             stop
          endif
          TV      = ( argis( '-TV' ) .gt. 0 )
          cost    = ( argis( '-C' ) .gt. 0 )
          bart    = ( argis( '-B' ) .gt. 0 )
          predict = ( argis( '-S' ) .gt. 0 )
          radon   = ( argis( '-R' ) .gt. 0 )
          slnt    = ( argis( '-M' ) .gt. 0 )
          gate    = ( argis( '-G' ) .gt. 0 )
          verbos  = ( argis( '-V' ) .gt. 0 )

          if (predict) gate = .false.

          if (TV) then
             predict = .false.
             gate    = .false.
          endif

          if (stap(1:1) .ne. ' ' .AND. TV) then
             write(LERR,*)'Cannot have output decon operator file with'
             write(LERR,*)'time varying option. Will ignore output file'
             write(LER ,*)'Cannot have output decon operator file with'
             write(LER ,*)'time varying option. Will ignore output file'
             do i = 1, 100
                stap(i:i) = ' '
             enddo
          endif


      return
      end
