C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getload(swgt,rwgt,cwgt,cmute,minap,maxap,
     1                   vcut,ifl,ifh,domega,nkx,dcrp,lerr)
c
      parameter (pi=3.1415926)
      parameter (nktaper=4)
      real      swgt(minap:maxap,ifl:ifh)
      real      rwgt(-nkx/2:+nkx/2-1)
      complex   cwgt(nkx/2)   
      complex   cmute(nkx/2)
      real      romega
c
      dkx=2.*pi/(nkx*dcrp)
c__________________________________________________________
c     begin with an impulsive load
c__________________________________________________________
      call vclr(rwgt,1,nkx)  
      rwgt(0)=1.
c__________________________________________________________
c     calculate its spectrum in the wavenumber domain.
c__________________________________________________________
      call vmov(rwgt,1,cwgt,1,nkx)
      call rfft(cwgt,nkx,+1)
      call rfftsc(cwgt,nkx,2,1)
c__________________________________________________________
c     mute out wavenumbers that are too high.          
c__________________________________________________________
      do 90000 ifreq=ifl,ifh   
       romega=ifreq*domega
       akmax=romega/vcut
       call vmov(cwgt,1,cmute,1,nkx)
       iakmax=nint(akmax/dkx)
       ibegintaper=min(iakmax-nktaper,nkx)
       ibegintaper=max(iakmax-nktaper,1)
       iendtaper=min(iakmax+nktaper,nkx)
       iendtaper=max(iakmax+nktaper,1)
       do 40000 ikx=1,ibegintaper 
        cmute(ikx)=cwgt(ikx)
40000  continue
       do 50000 ikx=ibegintaper+1,iendtaper-1       
        taper=float(iendtaper-ikx)/(iendtaper-ibegintaper)
        cmute(ikx)=taper*cwgt(ikx)
50000  continue
       do 60000 ikx=iendtaper,nkx     
        cmute(ikx)=(0.,0.)
60000  continue
c__________________________________________________________
c      inverse transform to x and store.               
c__________________________________________________________
       call rfft(cmute,nkx,-1)
       call vmov(cmute,1,rwgt,1,nkx)               
       do 70000 k=minap,maxap
        swgt(k,ifreq)=rwgt(k)
70000  continue
c      write(lerr,*) 'romega,vcut,akmax ',romega,vcut,akmax 
c      write(lerr,*) 'ibegintaper,iendtaper,nkx ',
c    1              ibegintaper,iendtaper,nkx 
c      write(lerr,'(3a12)') 'k','swgt(k)','rwgt(k)'
c      write(lerr,'(i12,2e12.3)') (k,swgt(k,ifreq),rwgt(k),
c    1                           k=minap,maxap)
90000 continue
c
      return
      end
