C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      program PWPARAX                                         
c_______________________________________________________________________
c     calculate the impulse response using paraxial approximation to the
c     hyperbolic wave equation.
c_______________________________________________________________________
c     Author:
c
c     Kurt J. Marfurt, Amoco EPTG, Tulsa, OK, USA. 3.1/95.
c
c     Paraxial equation solver due to:
c
c     Andreas Ehinger, Institut Francais du Petrole, Pau, France.
c     Francis Collino, Institut National de Recherche Informatique
c                      et Automatique, le Chesnay, France.
C***********************************************************************
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)
      parameter (maxg2=0 000 002)
      dimension g(maxg2)
      pointer   (pntrg,g)
C
      integer   hbegin
      parameter (lensqrr=5000) 
      integer    argis
      integer    stdin,stdout,stderr
C
      dimension cputim(30) , waltim(30)
      parameter (pi=3.1415926)
C
      integer   ipwr(4)
      integer   order_pade,maxorder_pade
      parameter (maxorder_pade=10)
      parameter (gamma=.1)           
      parameter (teta=.53)
C
      complex   omega
      integer   firstcrp,lastcrp
      integer   firstp,lastp
      integer   firstg,lastg
      integer   nodenumber,totalnodes
C
      logical   query
      logical   rfans,sfans
      logical   verbose,adjoint,svd
      logical   asynch
      logical   singlev       
C
      character*2   int2str
      character*7   name
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
#include <f77/sisdef.h>
#include <save_defs.h>
      parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)
      parameter (lenrhead=5)
      integer   sheader(SZLNHD)
C
      data       lugeom/62/,luzeta/63/
c____________________________________________________________________
c     get online help if necessary
c____________________________________________________________________
      query=(argis('-?').gt.0 .or. argis('-h').gt.0)
      if(query) then
         call help(ler)
         call exit(0)
      endif

      stdin=LIN
      stdout=LOT
      stderr=LER
      asynch=.true.
      luxx=luse
c_____________________________________________________________
c     read total number of nodes and current node number from command line.
c_____________________________________________________________
      call argi4('-totalnodes',totalnodes,1,1)
      call argi4('-nodenumber',nodenumber,1,1)
      write(stderr,*) 'nodenumber,totalnodes ',nodenumber,totalnodes
      name='PARAX'//int2str(nodenumber,'_')
      write(stderr,*) 'name = ',name
      call timstr(vtot,wtot)
      call vclr(cputim,1,30)
      call vclr(waltim,1,30)
c__________________________________________________________________
c     look up hardware specific trace sheader indices.
c     these indices will be the same for all output records.
c__________________________________________________________________
      call savelu('RecNum',ifmt,l_RecNum,length,TRACEsheader)
      call savelu('RecInd',ifmt,l_RecInd,length,TRACEsheader)
c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>
c_______________________________________________________________________
C     read in file name command line arguments.
c_______________________________________________________________________
      call cmdlin(luvgrid,lugeom,luout,luzeta,lutwt, 
     1            verbose,stdout,stderr,luxx,nodenumber,totalnodes)
C***********************************************************************
C     read in velocity work tape linesheader
C***********************************************************************
      lenvh=0
      call rtape(luvgrid,sheader,lenvh)
      if(lenvh .le. 0) then
         write(luxx,*) 'error in routine pwparax'
         write(luxx,*) 'velocity worktape linesheader ',lenvh,
     1                 ' bytes long!'
         call exit(1666)
      endif
      call hlhprt(sheader,lenvh,name,6,luxx)
C***********************************************************************
C     pull input data parameters off the line sheader.
C***********************************************************************
      call saver(sheader,'NumTrc',nveltr ,LINEsheader)
      call saver(sheader,'NumRec',nvelrec,LINEsheader)
      call saver(sheader,'NumSmp',nz_tape ,LINEsheader)
      call saver(sheader,'TmSlIn',idz_1000,LINEsheader)
      dz=.001*idz_1000
      nzgrid=nz_tape-1
      if(nveltr .eq. 1) then
         nxgrid=nvelrec
      ELSE
         nxgrid=nveltr
      endif
      if(nxgrid .lt. 1) then
         write(luxx,*) 'error in velocity worktape. nxgrid = ',nxgrid
         call exit(10001)
      elseif(nxgrid .le. 3) then
c______________________________________________________________________
c        check for single velocity trace.
c______________________________________________________________________
         singlev=.true.
         nxgrid=3
      else
         singlev=.false.
      endif
c______________________________________________________________________
c     read in geom control file
c______________________________________________________________________
      read(lugeom,*)
      read(lugeom,*) nt,dtmsec
      read(lugeom,*)
      read(lugeom,*) nshot,minr,maxr,dsta
      read(lugeom,*)
      read(lugeom,*) xdatamin,xdatamax,gdistmin,gdistmax
      read(lugeom,*)
      read(lugeom,*) topomin,topomax
      dt=.001*dtmsec
C_______________________________________________________________________
c     read in the irregular sampling control information.
C_______________________________________________________________________
      read(luzeta,*,iostat=ioerr)                                      
      if(ioerr .ne. 0) then
         write(luxx,*) ' error in reading file luzeta = ',luzeta
         call exit(4666)
      endif
      read(luzeta,*) xvo,dxgrid,dzdum,fref,vsr
      read(luzeta,*)
      read(luzeta,*) zetamin,zetamax,nz
c________________________________________________________________________
c     override input data parameters by pulling information
c     off the command line.
c________________________________________________________________________
      call rdparm(xdatamin,xdatamax,xgmin,xgmax,ximin,ximax,
     1            zetamax,zmax,dtmsec,
     2            xhalfap,minap,maxap,sfans,rfans,
     3            dxg,dcrp,dsta,firstcrp,lastcrp,
     5            firstg,lastg,firstp,lastp,
     6            f1,f2,f3,f4,fl,fh,tmax,tdelay,wrapt,
     7            pmin,pmax,dp,adjoint,svd,
     8            order_pade,maxorder_pade,xtaper,luxx)
      nap=max(1,order_pade-1)
c________________________________________________________________________
c     nt.......input trace length in samples
c     ntnew....length of array just greater than nt that is a factor of
c              2,3 and 5. i.e. ntnew=(2**m2)*(3**m3)*(5**m5).
c     dt.......temporal increment
c________________________________________________________________________
      if(tmax .ne. 0.) then
         ntmax=tmax/dtmsec
         nt=min(ntmax,nt)
      endif
      call nrfft(nt,2,ntnew,ipwr)       
      fnyquist=1./(2.*dt)
      df=1./(ntnew*dt)
      if(f1 .eq. 0.) f1=df
      if(f4 .eq. 0.) f4=fnyquist
      fl=f1
      fh=f4
      f2=max(f2,f1)
      f3=max(f2,f3)
      f3=min(f3,f4)
      ifl=nint(fl/df)
      ifl=max(ifl,1)
      ifh=nint(fh/df)
      ifh=min(ifh,ntnew/2-1)
      nbytes_out=(lenhed+nt)*szsmpd
      alphat=alog(wrapt)/(ntnew*dt)
c_______________________________________________________________________
c     computation of frequency limits.               
c     firstomega = 1 corresponds to omega = 0
c_______________________________________________________________________
      domega=2.*pi*df               
      nomega=1
c---->determine number of paraxial fractions
c________________________________________________________________________
c     lenap....length of the seismic aperature in units of dcrp
c________________________________________________________________________
      lenap=maxap-minap+1
      call nrfft(lenap,2,nkx,ipwr)       
      nr=maxr-minr+1
      if(sfans) then
c________________________________________________________________________
c        shoot rays at shot locations
c________________________________________________________________________
         ming=1
         maxg=nshot
         xvleft=xdatamin-xhalfap
         xvright=xdatamax+xhalfap
      elseif(rfans) then
c________________________________________________________________________
c        shoot rays at group(receiver) locations
c________________________________________________________________________
         ming=minr
         maxg=maxr 
         xvleft=xdatamin-xhalfap
         xvright=xdatamax+xhalfap
      else
c________________________________________________________________________
c        shoot rays between xgmin and xgmax at equal increments dxg
c________________________________________________________________________
         ming=nint(xgmin/dxg)
         maxg=nint(xgmax/dxg)
         xvleft=ming*dxg-xhalfap
         xvright=maxg*dxg+xhalfap
      endif
      mincrp=xvleft/dcrp
      maxcrp=xvright/dcrp
      ng=maxg-ming+1           
      ngperproc=(maxg-ming)/totalnodes+1
      firstg=ming+(nodenumber-1)*ngperproc
      lastg=min(ming+nodenumber*ngperproc-1,maxg)
      ngperproc=(lastg-firstg+1)
      ncrp=lastcrp-firstcrp+1
      np=lastp-firstp+1
c
      write(luxx,'(a20,a20)') 'variable','value'
      write(luxx,'(a20,i20)') 'nt',nt,'ntnew',ntnew,'nkx',nkx,
     2                        'ifl',ifl,'ifh',ifh,  
     3                        'nomega',nomega,
     4                        'nz',nz,'nz_tape',nz_tape,
     5                        'nxgrid',nxgrid,'nzgrid',nzgrid,
     6                        'nr',nr,'lenap',lenap,
     7                        'ming',ming,'maxg',maxg,
     8                        'ng',ng,  
     9                        'ngperproc',ngperproc,  
     a                        'firstg',firstg,'lastg',lastg,
     b                        'firstp',firstp,'lastp',lastp,'np',np,
     c                        'mincrp',mincrp,'maxcrp',maxcrp,
     c                        'firstcrp',firstcrp,'lastcrp',lastcrp,
     d                        'lntrhd',lntrhd,'i2fact',i2fact,
     f                        'nbytes_out',nbytes_out 
      write(luxx,'(a20,f20.5)') 'dt',dt,'xvo',xvo,'dxgrid',dxgrid,
     2                      'gdistmin',gdistmin,'gdistmax',gdistmax
      write(luxx,'(a20,f20.5)') 'xgmin',xgmin,'xgmax',xgmax,
     1                          'ximin',ximin,'ximax',ximax,
     2                          'xtaper',xtaper,
     2                          'pmin',pmin,'pmax',pmax,'dp',dp
      write(luxx,'(a20,f20.5)') 'wrapt',wrapt,
     1                          'alphat',alphat,'tdelay',tdelay
      write(luxx,'(a30,l2)') 'use svd to solve normal equations? ',
     1                           svd     
      write(luxx,'(a30,l2)') 'use adjoint vs. inverse operator?  ',
     1                           adjoint
      write(luxx,'(a30,l2)') 'calculate fans at shot points?     ',sfans
      write(luxx,'(a30,l2)') 'calculate fans at receiver points? ',rfans
      write(luxx,'(a30,l2)') 'single trace velocity work tape? ',singlev
      ierror=0
      call icompare(nz,nzgrid,'zeta file',                       
     1             'velocity worktape','nz',ierror,luxx)
      if(ierror .gt. 0) then
         write(luxx,*) 'program PWPARAX aborted due to ',ierror,
     1    'velocity model (following -N option) and',
     2    'depth grid (following -Z option) incompatabilities'
         call exit(666)
      endif
c____________________________________________________________________
      write(luxx,'(///,80a1)') ('_',i=1,80)
      write(luxx,'(/,a,/)') ' memory to hold geometry information.'
      write(luxx,'(80a1)') ('_',i=1,80)
c____________________________________________________________________
      write(luxx,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('xg',l_xg,l_free,ng,luxx)        
      call mapmem('zg',l_zg,l_free,ng,luxx)        
      call mapmem('xs',l_xs,l_free,nshot,luxx)        
      call mapmem('zs',l_zs,l_free,nshot,luxx)        
      call mapmem('xr',l_xr,l_free,nr,luxx)        
      call mapmem('zr',l_zr,l_free,nr,luxx)        
      call mapmem('zeta',l_zeta,l_free,nz+1,luxx)        
C_______________________________________________________________________
C     allocate dynamic memory.                      
C_______________________________________________________________________
      leng=l_free-1
      write(luxx,'(a30,10x,i10)') 'total g vector length',leng
c
      write(luxx,'(//,a)') 'allocate dynamic memory for PWPARAX: '
      write(luxx,*) 1.e-6*leng,' Mwords'
      write(luxx,*) 1.e-6*leng*szsmpd,' Mbytes'
      call galloc(pntrg,leng*szsmpd,ierrcd,0)                   
      if(ierrcd .ne. 0 ) then
         write(luxx,*)'galloc memory allocation error from main'   
         write(luxx,*)'ierrcd = ',ierrcd
         write(luxx,*)'length in words requested = ',leng
         write(luxx,*)'length in bytes requested = ',leng*szsmpd
         write(luxx,*)
         write(luxx,*)'probable cause: too much memory requested!' 
         write(luxx,*)
         write(luxx,*)'program PWPARAX aborted'
         call exit(5666)
      endif
C_______________________________________________________________________
c     read in the irregular depth sampling grid.         
c     close the file.
C_______________________________________________________________________
      call rdzeta0(g(l_zeta),nz,zmax,jzmax,luzeta)  
      close(luzeta)
      write(luxx,'(a20,i20)') 'jzmax',jzmax
C__________________________________________________________________
c     read in summary information of the seismic recording geometry.
c     calculate the nearest group to the output crp points.
c     these will be used for station location, topography and seismic
c     record index control.
C___________________________________________________________________
      call rdgeom(g(l_xs),g(l_zs),g(l_xr),g(l_zr),
     1            minr,maxr,nshot,zetamin,zetamax,
     2            verbose,lugeom,lexx,
     3            g(l_xg),g(l_zg),dxg,ming,maxg, 
     4            sfans,rfans,xgmin,xgmax,ns)
c______________________________________________________________________
c     calculate workspace memory 
c______________________________________________________________________
      maxwork=19*lenap+4*nomega+2*nomega*lenap+2*nomega*nap
      maxbuf=lenhed+max(nz+1,ntnew)
      write(luxx,'(a20,i20)') 'ns',ns
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(luxx,'(///,80a1)') ('_',i=1,80)
      write(luxx,'(A)')'storage map of major arrays'
      write(luxx,'(80a1)') ('_',i=1,80)
C
      l_free=1
c____________________________________________________________________
      write(luxx,'(///,80a1)') ('_',i=1,80)
      write(luxx,'(/,a,/)') ' memory for velocity work tape.'   
      write(luxx,'(80a1)') ('_',i=1,80)
c____________________________________________________________________
      write(luxx,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('v',l_v,l_free,(nz+1)*nxgrid,luxx)
      call mapmem('vinterp',l_vinterp,l_free,
     1               nz*(maxcrp-mincrp+1),luxx)
c____________________________________________________________________
      write(luxx,'(///,80a1)') ('_',i=1,80)
      write(luxx,'(/,a,/)') ' memory for impulse response results.'
      write(luxx,'(80a1)') ('_',i=1,80)
c____________________________________________________________________
      write(luxx,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('work',l_work,l_free,maxwork,luxx)
      call mapmem('cdata',l_cdata,l_free,2*nomega*lenap,luxx)
      call mapmem('unwrap',l_unwrap,l_free,ntnew,luxx)
      call mapmem('fwgt',l_fwgt,l_free,ntnew/2,luxx)
      call mapmem('alpha',l_alpha,l_free,maxorder_pade,luxx)
      call mapmem('beta',l_beta,l_free,maxorder_pade,luxx)
      call mapmem('g',l_g,l_free,2*lenap*ng,luxx)
c____________________________________________________________________
      write(luxx,'(///,80a1)') ('_',i=1,80)
      write(luxx,'(/,a,/)') ' work arrays.'
      write(luxx,'(80a1)') ('_',i=1,80)
c____________________________________________________________________
      call mapmem('tap',l_tap,l_free,lenap,luxx)
      call mapmem('f1',l_f1,l_free,2*nomega*nap,luxx)
      call mapmem('f2coeff',l_f2coeff,l_free,2*nomega*nap,luxx)
      call mapmem('f2',l_f2,l_free,2*nomega*nap,luxx)
      call mapmem('vfac',l_vfac,l_free,lenap,luxx)
      call mapmem('cphi1',l_cphi1,l_free,2*lenap,luxx)
      call mapmem('cphi2',l_cphi2,l_free,2*lenap,luxx)
      call mapmem('cphi',l_cphi,l_free,2*lenap,luxx)
      call mapmem('bcos',l_bcos,l_free,lenap,luxx)
      call mapmem('cw',l_cw,l_free,2*nomega*lenap,luxx)
      call mapmem('cydata',l_cydata,l_free,2*nomega,luxx)
      call mapmem('cyd1',l_cyd1,l_free,2*nomega,luxx)
      call mapmem('t1sub',l_t1sub,l_free,lenap,luxx)
      call mapmem('t1dia',l_t1dia,l_free,lenap,luxx)
      call mapmem('t1sup',l_t1sup,l_free,lenap,luxx)
      call mapmem('t2sub',l_t2sub,l_free,lenap,luxx)
      call mapmem('t2dia',l_t2dia,l_free,lenap,luxx)
      call mapmem('t2sup',l_t2sup,l_free,lenap,luxx)
      call mapmem('t3sub',l_t3sub,l_free,lenap,luxx)
      call mapmem('t3dia',l_t3dia,l_free,lenap,luxx)
      call mapmem('t3sup',l_t3sup,l_free,lenap,luxx)
      call mapmem('swgt',l_swgt,l_free,lenap*nomega,luxx)
      call mapmem('cwgt',l_cwgt,l_free,nkx,luxx)
      call mapmem('rwgt',l_rwgt,l_free,nkx,luxx)
      call mapmem('cmute',l_cmute,l_free,nkx,luxx)
c____________________________________________________________________
      write(luxx,'(///,80a1)') ('_',i=1,80)
      write(luxx,'(/,a,/)') ' memory inverse calculation'
      write(luxx,'(80a1)') ('_',i=1,80)
c____________________________________________________________________
      lensvd=max(ns,ncrp)+1
      call mapmem('w',l_w,l_free,2*ns*np,luxx)
      call mapmem('xwgt',l_xwgt,l_free,ncrp,luxx)
      call mapmem('u',l_u,l_free,2*ncrp,luxx)
      call mapmem('r',l_r,l_free,2*ns*ncrp,luxx)
      call mapmem('rc',l_rc,l_free,2*ns*ncrp,luxx)
      call mapmem('rinv',l_rinv,l_free,2*ns*ncrp,luxx)
      call mapmem('r2',l_r2,l_free,2*ncrp*ncrp,luxx)
      call mapmem('z',l_z,l_free,2*ncrp,luxx)
      call mapmem('iperm',l_iperm,l_free,ncrp,luxx)
      call mapmem('sigma',l_sigma,l_free,2*lensvd,luxx)
      call mapmem('re',l_re,l_free,2*lensvd,luxx)
      call mapmem('ru',l_ru,l_free,2*ns*np,luxx)
      call mapmem('rv',l_rv,l_free,2*ns*np,luxx)
      call mapmem('rwork',l_rwork,l_free,2*lensvd,luxx)
c____________________________________________________________________
      write(luxx,'(///,80a1)') ('_',i=1,80)
      write(luxx,'(/,a,/)') ' memory for input and output data.'    
      write(luxx,'(80a1)') ('_',i=1,80)
c____________________________________________________________________
      write(luxx,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('tracebuf',l_tracebuf,l_free,maxbuf*lenap,luxx)
      call mapmem('cbuffer',l_cbuffer,l_free,ntnew,luxx)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(luxx,'(a20,10x,i10)') 'total s vector lensth',lens
c
      write(luxx,'(//,a)') 'allocate dynamic memory for PWPARAX: '
      write(luxx,*) 1.e-6*lens,' Mwords'
      write(luxx,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(luxx,*)'galloc memory allocation error from main'
         write(luxx,*)'ierrcd = ',ierrcd
         write(luxx,*)'length in words requested = ',lens
         write(luxx,*)'length in bytes requested = ',lens*szsmpd
         write(luxx,*)
         write(luxx,*)'probable cause: too much memory requested!'
         write(luxx,*)
         write(luxx,*)'program PWPARAX aborted'
         call exit(5666)
      endif
C_______________________________________________________________________
c     read in the irregularly sampled velocity worktape.
C_______________________________________________________________________
      call rdv(s(l_v),s(l_tracebuf),
     1         dxgrid,nz,nxgrid,lenhed,luvgrid,nbyptr,singlev)
      call interpv(s(l_v),s(l_vinterp),dxgrid,dcrp,xvo,
     1             nz,nxgrid,mincrp,maxcrp)
C_______________________________________________________________________
c     calculate the frequency tapers.                             
C_______________________________________________________________________
      call gttapr(s(l_fwgt),f1,f2,f3,f4,df,0,ntnew/2-1)
C_______________________________________________________________________
c     calculate the incident plane wave tapers.                     
C_______________________________________________________________________
      x1=ximin
      x2=ximin+xtaper
      x3=ximax-xtaper
      x4=ximax
      call gttapr(s(l_xwgt),x1,x2,x3,x4,dcrp,firstcrp,lastcrp)
C_______________________________________________________________________
c     write out the line sheader for the output greens' functions.
C_______________________________________________________________________
      nsi=dtmsec
      call savhlh(sheader,lenvh,lbyout)
      call wrtape(luout,sheader,lbyout)
      lentr2=lntrhd+ntnew*i2fact
      call hdinit(s(l_tracebuf),firstcrp,lastcrp,dcrp,lentr2)
      do 50000 ifreq=ifl,ifh
       omega=cmplx(ifreq*domega,alphat)
c_______________________________________________________________________
c      initialize matrices for paraxial solution.     
c_______________________________________________________________________
       write(luse,*) 'initialize. ifreq = ',ifreq
       call paraxinit(s(l_f1),s(l_f2),s(l_f2coeff),ifreq,ifreq,
     1                s(l_alpha),s(l_beta),s(l_tap),lenap,
     2                dcrp,teta,domega,alphat,
     3                order_pade,maxorder_pade,nxtaper,luxx)
c_______________________________________________________________________
c      calculate the Greens' function response.       
c_______________________________________________________________________
       write(luse,*) 'prepare to call getg. ifreq ',ifreq,'of ',ifh
       call getg(s(l_g),s(l_cdata),s(l_vinterp),g(l_xg),g(l_zg),
     1           g(l_zeta),nz,lenap,nt,nomega,nap,nxtaper,
     2           maxorder_pade,domega,teta,gamma,
     3           s(l_tap),s(l_f1),s(l_f2),s(l_f2coeff),
     4           s(l_vfac),s(l_cphi1),s(l_cphi2),s(l_cphi),
     5           s(l_bcos),s(l_cw),s(l_cydata),s(l_cyd1),
     6           s(l_t1sub),s(l_t1dia),s(l_t1sup),
     7           s(l_t2sub),s(l_t2dia),s(l_t2sup),
     8           s(l_t3sub),s(l_t3dia),s(l_t3sup),
     9           firstg,lastg,luxx,stderr,
     a           minap,maxap,mincrp,maxcrp,dcrp,cputim,waltim,
     b           s(l_swgt),s(l_rwgt),s(l_cwgt),s(l_cmute),nkx,
     c           alphat,dt,ifreq,ifreq,ifreq,tdelay,jzmax)
c_______________________________________________________________________
c      calculate the source weights needed to form a plane wave at jzmax 
c      due to sources along the surface.
c_______________________________________________________________________
       write(luse,*) 'prepare to call getsw'
       call getsw(s(l_g),s(l_r),s(l_rc),s(l_r2),s(l_rinv),s(l_z),
     1            s(l_iperm),rcond,s(l_sigma),s(l_re),
     2            s(l_ru),s(l_rv),s(l_rwork),s(l_w),
     3            ncrp,prew,svd,adjoint,luse,luxx,
     4            minap,maxap,firstg,lastg,
     5            firstp,lastp,firstcrp,lastcrp,
     6            s(l_xwgt),s(l_u),xgmin,xgmax,g(l_xs),ns,nshot,
     6            s(l_fwgt),ifreq,ntcalc,omega,dxg,dcrp,dp)
       write(luse,*) 'return from getsw'
c_______________________________________________________________________
c      calculate the receiver weights needed to downward continue the 
c      plane wave response down to the target horizon.
c_______________________________________________________________________
c      call getrw()
50000 continue
c_______________________________________________________________________
c     close the rayfiles.       
c_______________________________________________________________________
      call timend(cputim(20),vtot,V2,waltim(20),wtot,W2)
      write(luxx,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(luxx,'(A30,2f15.3)')
     1         'f1 & f2',cputim(1),waltim(1),
     2         'shift1',cputim(2),waltim(2),
     3         'tmat',cputim(6),waltim(6),
     4         'solve1',cputim(7),waltim(7),
     5         'border',cputim(4),waltim(4),
     6         'output',cputim(5),waltim(5),
     7         'total',cputim(20),waltim(20)
c
      write(luxx,*)'Normal completion of PWPARAX'
      write(stderr,*)'Normal_completion_of_PWPARAX'
      write(0,*) 'prepare to close luout = ',luout
      call lbclos(luout)
      write(0,*) 'prepare to close luxx = ',luxx   
      close(luxx)
      write(0,*) 'ok'
C
      call exit(0)
      end
      subroutine  help(ler)
      write(ler,*)' '
      write(ler,*)'Command Line Arguments for pwparax: '
      write(ler,*)'Common shot prestack Kirchhoff depth migration'
      write(ler,*)' '
      write(ler,*)'Input....................................... (def)'
      write(ler,*)' '
      write(ler,*)'-N [file_vsamp] (stdin)     :'
      write(ler,*)'         Input irregularly gridded velocity model'
      write(ler,*)'-O [file_green] (no default):'
      write(ler,*)'         Output plane wave impulse response weights'
      write(ler,*)'-Z [file_zeta] (no default) :'
      write(ler,*)'                Input irregular depth grid'      
      write(ler,*)'-P [file_geommig] (no default)  :'
      write(ler,*)'                Geometry file from prepmig'
c
      write(ler,*)'-dcrp[dcrp]  -- common reflection point'//
     1                      ' x increment (station location increment)'
      write(ler,*)'-xgmin[xgmin]  -- first surface shot position'//
     1                        '  (leftmost shot or receiver position)' 
      write(ler,*)'-xgmax[xgmax]  -- last surface shot position'//  
     1                        '  (rightmost shot or receiver position)' 
      write(ler,*)'-ximin[ximin]  -- first plane wave position'//
     1                        '  (leftmost shot or receiver position)' 
      write(ler,*)'-ximax[ximax]  -- last plane wave position'//  
     1                        '  (rightmost shot or receiver position)' 
      write(ler,*)'-zmax[zmax]  -- plane wave simulation depth'//
     1                      '  (bottom of irregular velocity worktape)'
      write(ler,*)'-pmin[pmin]  -- minimum ray parameter in ms/m (0.)'
      write(ler,*)'-pmax[pmax]  -- maximum ray parameter in ms/m (0.)'
      write(ler,*)'-dp[dp]      -- ray parameter increment in ms/m (0.)'
      write(ler,*)'-xhalfap[xhalfap] '//
     1                   ' -- migration half aperature (zmax)'
      write(ler,*)'-dxg[dxg]  -- Greens function response increment'//
     1                           ' (dcrp)'
      write(ler,*)'-tmax[tmax]  -- output time section length'//
     1                      '  (length of input section)'               
       write(ler,*)
     1' -f1[f1]   (0.)      :  begin roll in frequency taper '
     2                   //'weights (Hz, cycles/km, cycles/kft) '
        write(ler,*)
     1' -f2[f2]   (f1)      :  end roll in frequency taper '
     2                   //'weights (Hz, cycles/km, cycles/kft) '
        write(ler,*)
     1' -f3[f3]   (f4)      :  begin roll off frequency taper '
     2                   //'weights (Hz, cycles/km, cycles/kft) '
        write(ler,*)
     1' -f4[f4]   (Nyquist) :  end roll off frequency taper'
     2                   //'weights (Hz, cycles/km, cycles/kft) '

      write(ler,*)'-wrapt[wrapt]      --wrap around suppression factor'
     1                               //' (100.)'
      write(ler,*)'-order[order_pade] -- order of Pade expansion (3) '
      write(ler,*)'-xtaper[xtaper] -- taper on plane wave in m (0.)'
      write(ler,*)'-S           -- shoot fans from every shot point'
     1                            //' (shoot at dxg increment)'
      write(ler,*)'-R           -- shoot fans from every receiver '
     1                             //' point'
     1                            //' (shoot at dxg increment)'
      write(ler,*)'-V           -- verbos printout'
      write(ler,*)' '
      write(ler,*)'Usage:'
      write(ler,*)'   pwparax -N[] -O[] -Z[] -T[] -P[]'
      write(ler,*)'          -xgmin[] -xgmax[] -ximin[] -ximax[]'
      write(ler,*)'          -xhalfap[] -dcrp[] -dxg[] -xtaper[]'
      write(ler,*)'          -pmin[] -pmax[] -dp[]'                 
      write(ler,*)'          -zmax[] -order[] '   
      write(ler,*)'          -f1[] -f2[] -f3[] -f4[]'
      write(ler,*)'          -tmax[] -wrapt[]'                   
      write(ler,*)'          [-adjoint, -svd, -R,-S,-V]'
      write(ler,*)' '

      return
      end
c 
