C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdparm(xdatamin,xdatamax,xgmin,xgmax,ximin,ximax,
     1                  zetamax,zmax,dtmsec,
     2                  xhalfap,minap,maxap,sfans,rfans,
     3                  dxg,dcrp,dsta,firstcrp,lastcrp,
     4                  firstg,lastg,firstp,lastp,
     5                  f1,f2,f3,f4,fl,fh,tmax,tdelay,wrapt,
     6                  pmin,pmax,dp,adjoint,svd,
     7                  order_pade,maxorder_pade,xtaper,lerr)
C
      parameter    (pi=3.1415926)
      integer      firstcrp,lastcrp
      integer      firstp,lastp,firstg,lastg             
      integer      argis
      logical      sfans,rfans,adjoint,svd
      integer      order_pade,maxorder_pade
C
      data         undefined/999999./
C-----------------------------------------------------------------------
      ierror=0
      call argr4('-pmin',pmin,0.,0.)
      call argr4('-pmax',pmax,0.,0.)
      call argr4('-dp',dp,0.1,0.1)
      call argr4('-xgmin',xgmin,undefined,undefined)  
      call argr4('-xgmax',xgmax,undefined,undefined)  
      call argr4('-ximin',ximin,undefined,undefined)  
      call argr4('-ximax',ximax,undefined,undefined)  
      call argr4('-dcrp',dcrp,undefined,undefined) 
      call argr4('-dxg',dxg,undefined,undefined)
      call argr4('-zmax',zmax,undefined,undefined)
      call argr4('-xhalfap',xhalfap,undefined,undefined)   
      call argr4('-f1',f1,0.,0.)                           
      call argr4('-f2',f2,0.,0.)                           
      call argr4('-f3',f3,0.,0.)                           
      call argr4('-f4',f4,0.,0.)                           
      call argr4('-tmax',tmax,0.,0.)                           
      call argr4('-tdelay',tdelay,0.,0.)                           
      call argr4('-wrapt',wrapt,100.,100.)
C
      call argi4('-order',order_pade,3,3)     
      call argr4('-xtaper',xtaper,0.,0.)
      sfans=argis('-S') .gt. 0
      rfans=argis('-R') .gt. 0
      adjoint=argis('-adjoint') .gt. 0
      svd=argis('-svd') .gt. 0
c______________________________________________________________________
c     set defaults.               
c______________________________________________________________________
      if (xgmin .eq. undefined) xgmin = xdatamin
      if (xgmax .eq. undefined) xgmax = xdatamax
      if (ximin .eq. undefined) ximin = xdatamin
      if (ximax .eq. undefined) ximax = xdatamax
      if (dcrp .eq. undefined) dcrp = dsta
      if (dxg .eq. undefined) dxg = dcrp
      if (zmax .eq. undefined) zmax = zetamax 
      if (xhalfap .eq. undefined) xhalfap = zmax
c______________________________________________________________________
c     input data error checking
c______________________________________________________________________
      if(order_pade .gt. maxorder_pade .or. order_pade .lt. 1) then
         write(lerr,*) 'error in input parameters detected in rdparm!'
         write(lerr,*) 'pade order (-order)       = ',order_pade
         write(lerr,*) 'must be between 1 and ',maxorder_pade
         write(lerr,*) 'order_pade=1 ==> 15 degree accuracy' 
         write(lerr,*) 'order_pade=2 ==> 45 degree accuracy' 
         write(lerr,*) 'order_pade=3 ==> 60 degree accuracy' 
         write(lerr,*)
         ierror=ierror+1
      endif
      if(xhalfap  .lt. 0.) then            
         write(lerr,*) 'error in input parameters detected in rdparm!'
         write(lerr,*) 'half aperature    (-xhalfap) = ',xhalfap
         write(lerr,*)
         ierror=ierror+1
      endif
      if(dcrp .le. 0.) then 
         write(lerr,*) 'error in input parameters detected in rdparm!'
         write(lerr,*) 'dcrp less than or equal to 0! (-dcrp) = ',dcrp   
         write(lerr,*)
         ierror=ierror+1
      endif
      if(dxg .le. 0.) then 
         write(lerr,*) 'error in input parameters detected in rdparm!'
         write(lerr,*) 'dcrp less than or equal to 0! (-dxg) = ',
     1                   dxg  
         write(lerr,*)
         ierror=ierror+1
      endif
      if(rfans .and. sfans) then
         write(lerr,*) 'error in input parameters detected in rdparm!'
         write(lerr,*) 'cannot specify both -S and -R options!'
         write(lerr,*)
         ierror=ierror+1
      endif

      if(ierror .gt. 0) then
         write(lerr,*)'program aborted in rdparm due to input errrors'
         write(lerr,*)
         call exit(7666)
      endif
C***********************************************************************
C     OTHER DERIVED PARAMETERS
C***********************************************************************
      firstcrp=nint(ximin/dcrp)
      lastcrp=nint(ximax/dcrp)
      firstg=nint(xgmin/dxg) 
      lastg=nint(xgmax/dxg) 
      firstp=nint(pmin/dp)
      lastp=nint(pmax/dp)
      nhalfap=nint(xhalfap/dcrp)
      minap=-nhalfap
      maxap=+nhalfap
C
      write(lerr ,*) 'routine rdparm: parameters read in. exit rdparm'
C
      return
      end
