C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine solve1(cdata,t1sub,t1dia,t1sup,t2sub,t2dia,t2sup, 
     +                       t3sub,t3dia,t3sup,f1,f2,iap,cw,cydata,cyd1,
     +                       nx,nomega,teta,nap)
c
C/---------------------------------------------------------------------
C/REM/             Proprietary of CONSORTIUM P.S.I.
C/REM/               Institut Francais du Petrole
C/REM/               92500 Rueil Malmaison FRANCE
C/REM/
C/REM/                    All rights reserved
C/
C/NAME/  (subroutine name):  solve1
C/
C/CALL/  call solve1(cdata,t1sub,t1dia,t1sup,t2sub,t2dia,t2sup,
C/CALL/                   t3sub,t3dia,t3sup,f1,f2,iap,cw,cydata,cyd1,
C/CALL/                   nx,nomega,teta,nap)
C/
C/HIST/  creation    author: Andreas Ehinger
C/HIST/              date:   28.07.1993
C/HIST/
C/HIST/  modifications
C/HIST/  (author)      (date)       (modification)        (tested(y/n))
C/HIST/
C/
C/PURP/  solve the tridiagonal system of the approximation problem
C/
C/DESC/  -
C/
C/ARG/   in    : t1sub   subdiagonal of matrix t1 [nx]
C/ARG/           t1dia   diagonal of matrix t1 [nx]
C/ARG/           t1sup   supdiagonal of matrix t1 [nx]
C/ARG/           t....   similar for other matrices
C/ARG/           f1,f2   arrays of approximation functions [nomega,nap] 
C/ARG/           iap     index of approximation (1<=iap<=nap)
C/ARG/           cw      local array of this subroutine [nomega,nx]
C/ARG/           cydata  local array of this subroutine [nomega]
C/ARG/           cyd1    local array of this subroutine [nomega]
C/ARG/           nx,nomega,teta,nap
C/ARG/   in-out: cdata   complex data matrix [nomega,nx]
C/ARG/   out   : -
C/
C/LOCAL/ -
C/
C/FILES/ -
C/
C/DOWN/  -
C/
C/EXPL/  -
C/
C/--------------------------------------------------------------------
c
 
c     declaration of arguments
      integer nx,nomega,iap,nap
      complex cdata(nomega,nx)
      real    t1sub(nx),t1dia(nx),t1sup(nx)
      real    t2sub(nx),t2dia(nx),t2sup(nx)
      real    t3sub(nx),t3dia(nx),t3sup(nx)
      complex f1(nomega,nap),f2(nomega,nap)
      complex cw(nomega,nx),cydata(nomega),cyd1(nomega)
      real    teta
 
c     declaration of local variables
      complex ctsub,ctdia,ctsup, cssub,csdia,cssup
      real    sub1,dia1,sup1, sub2,dia2,sup2, sub3,dia3,sup3
      complex ci, cdenominator, cf2, cf1p, cf1b, cf1a
      complex cf2a, cf2b, cf2p
      real    tfac
      integer ix,io,ixm1,ixp1
c
c------------------------------------------------------------------------
c
c     computation of some useful quantities
      ci = cmplx(0.,1.)
      tfac = (1.-teta)/teta
c
c     for all omega the initialisation for the descent operation
c     has to be performed
c
c     1. scalarisation of the used elements of the T-matrices
c        (the first row of the T matrix is processed)
      dia1 = t1dia(1)
      dia2 = t2dia(1)
      dia3 = t3dia(1)
      sup1 = t1sup(2)
      sup2 = t2sup(2)
      sup3 = t3sup(2)
c
c     2. the actual initialisation is performed
c
      do 100 io = 1,nomega

         ctdia = dia1 + f1(io,iap)*dia2 - ci*f2(io,iap)*dia3
         ctsup = sup1 + f1(io,iap)*sup2 - ci*f2(io,iap)*sup3 

         csdia = dia1 + f1(io,iap)*dia2 + ci*f2(io,iap)*dia3*tfac
         cssup = sup1 + f1(io,iap)*sup2 + ci*f2(io,iap)*sup3*tfac
c
         cw(io,1) = ctsup/ctdia
         cydata(io)   = ( csdia*cdata(io,1)
     +                        + cssup*cdata(io,2)  ) / ctdia
c
c        cydata will be needed in the ascent operation
c        so it is copied into another vector
         cyd1(io) = cydata(io)
c
100   continue
c
c     operation of descent
c
c
      do 200 ix = 2,nx-1

         ixp1 = ix+1
         ixm1 = ix-1
c
c        1. scalarisation of the used elements of the T-matrices
c           (the row ix of matrix T will be processed)
         dia1 = t1dia(ix)
         dia2 = t2dia(ix)
         dia3 = t3dia(ix)
         sup1 = t1sup(ixp1)
         sup2 = t2sup(ixp1)
         sup3 = t3sup(ixp1)
         sub1 = t1sub(ixm1)
         sub2 = t2sub(ixm1)
         sub3 = t3sub(ixm1)
c
c        2. descent for all frequencies
         do 300 io = 1,nomega
c
            cf2 = ci*f2(io,iap)

            cf1a = dia1 + f1(io,iap)*dia2
            cf1b = sub1 + f1(io,iap)*sub2
            cf1p = sup1 + f1(io,iap)*sup2

            cf2a = cf2*dia3
            cf2b = cf2*sub3
            cf2p = cf2*sup3

            ctdia = cf1a - cf2a
            ctsub = cf1b - cf2b
            ctsup = cf1p - cf2p
c
            csdia = cf1a + cf2a*tfac
            cssub = cf1b + cf2b*tfac
            cssup = cf1p + cf2p*tfac
c
            cdenominator = ctdia - ctsub*cw(io,ixm1)

            cw(io,ix) = ctsup / cdenominator
c
            cydata(io) = (  cssup*cdata(io,ixp1)
     +                      + csdia*cdata(io,ix)
     +                      + cssub*cdata(io,ixm1)
     +                      - ctsub*cydata(io)     )
     +                                 /
     +                        ( cdenominator )
c
c           cydata(io) will be needed in the ascend operation
c           therefore it is copied into the never more used
c           vector cdata(io,ix-1) 

            cdata(io,ixm1) = cydata(io)
c
300      continue
200   continue
c
c
c     end of descent operation
c     1. scalarisation of the used elemnts of the T-matrices
c        (the last row of the T matrix is processed)
      dia1 = t1dia(nx)
      dia2 = t2dia(nx)
      dia3 = t3dia(nx)
      sub1 = t1sub(nx-1)
      sub2 = t2sub(nx-1)
      sub3 = t3sub(nx-1)
c
c     end of descent for all frequencies
c
c
      do 400 io = 1,nomega 
c
         ctdia = dia1 + f1(io,iap)*dia2 - ci*f2(io,iap)*dia3
         ctsub = sub1 + f1(io,iap)*sub2 - ci*f2(io,iap)*sub3
c
         csdia = dia1 + f1(io,iap)*dia2 + ci*f2(io,iap)*dia3*tfac
         cssub = sub1 + f1(io,iap)*sub2 + ci*f2(io,iap)*sub3*tfac
c
         cdenominator = ctdia - ctsub*cw(io,nx-1)
c
c
         cw(io,nx) = ctsup / cdenominator
c
         cydata(io) = (  csdia*cdata(io,nx)
     +                   + cssub*cdata(io,nx-1)
     +                   - ctsub*cydata(io)     )
     +                              /
     +                     ( cdenominator )
c
c
         cdata(io,nx-1) = cydata(io)
         cdata(io,nx) = cydata(io)
c
400   continue

      do 500 ix = nx-1,2,-1
c
         do 600 io = 1,nomega
c
            cdata(io,ix) = cdata(io,(ix-1)) - 
     +                       cw(io,ix)*cdata(io,(ix+1))
c
600      continue
c
500   continue
c
c     end of ascent operation
c
      do 700 io = 1,nomega
         cdata(io,1) = cyd1(io) - cw(io,1)*cdata(io,2)
700   continue
c
c
      end
