C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tmat(t1sub,t1dia,t1sup,t2sub,t2dia,t2sup,
     +                     t3sub,t3dia,t3sup,vz,
     +                     nx,gamma)
C/---------------------------------------------------------------------
C/REM/              Proprietary of CONSORTIUM P.S.I.
C/REM/               Institut Francais du Petrole
C/REM/               92500 Rueil Malmaison FRANCE
C/REM/ 
C/REM/                    All rights reserved
C/
C/NAME/  (subroutine name):  tmat
C/
C/CALL/  call tmat(t1sub,t1dia,t1sup,t2sub,t2dia,t2sup,
C/CALL/                 t3sub,t3dia,t3sup,vz,nx,gamma)
C/
C/HIST/  creation    author: Andreas Ehinger
C/HIST/              date:   28.07.1993
C/HIST/
C/HIST/  modifications
C/HIST/  (author)      (date)       (modification)        (tested(y/n))
C/HIST/
C/
C/PURP/  calculate the T-matrices for the approximation (diffraction) problem
C/
C/DESC/  -
C/
C/ARG/   in    : vz velocity field in fixed depth [nx]
C/ARG/           nx,gamma
C/ARG/   in-out: - 
C/ARG/   out   : t1sub subdiagonal of matrix T1 [nx]
C/ARG/           t1dia diagonal of matrix T1 [nx]
C/ARG/           t1sup supdiagonal of matrix T1 [nx]
C/ARG/           t2sub subdiagonal of matrix T2 [nx]
C/ARG/           t2dia diagonal of matrix T2 [nx]
C/ARG/           t2sup supdiagonal of matrix T2 [nx]
C/ARG/           t3sub subdiagonal of matrix T3 [nx]
C/ARG/           t3dia diagonal of matrix T3 [nx]
C/ARG/           t3sup supdiagonal of matrix T3 [nx]
C/
C/LOCAL/  -
C/
C/FILES/  -
C/
C/DOWN/   - 
C/
C/EXPL/   -
C/
C/-------------------------------------------------------------------
c
c     declaration of arguments
      integer nx
      real    t1sub(nx), t1dia(nx), t1sup(nx)
      real    t2sub(nx), t2dia(nx), t2sup(nx)
      real    t3sub(nx), t3dia(nx), t3sup(nx)
      real    vz(nx)
      real    gamma
 
c     declaration of local variables
      real    v1,v2,vsum,vmult
      integer ix
c
c-----------------------------------------------------------------------
c
      v2=vz(1)
      do 10 ix=1,nx
c
c        computation of some useful quantities
         v1=v2
         v2 = vz(ix)
         vsum = v2 + v1
         vmult = v2 * v1
c
c        computation of the vectors
         t1sub(ix) = 2.*gamma*v1 / vsum
         t1dia(ix) = 1. - 2.*gamma
         t1sup(ix) = 2.*gamma*v2 / vsum
c
         t2sub(ix) = 2.*vmult*v2 / vsum
         t2dia(ix) = -2.*vmult
         t2sup(ix) = 2.*vmult*v1 / vsum 
c 
         t3sub(ix) = v2
         t3dia(ix) = -vsum
         t3sup(ix) = v1
c
10    continue 
c
c     correction of the (wrongly calculated) border values,
c     (these are the first and the last elements 
c      of the diagonals of t1 and t3)
c
      t1dia(1) = 1. - gamma
      t1dia(nx) = 1. - gamma 
c
      t2dia(1) = 0.5 * t2dia(1)
      t2dia(nx) = 0.5 * t2dia(nx) 
c
      t3dia(1) = 0.5 * t3dia(1)
      t3dia(nx) = 0.5 * t3dia(nx) 
c
      end
