/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <ikp_Xheaders.h>

enum WidgetType { NONE, LABEL_WIDGET, TOGGLE_WIDGET, TEXT_WIDGET,
		  FILEBOX_NONE, FILEBOX_WIDGET, SLIDER_WIDGET ,
		  RADIOBUTTON_WIDGET };

enum TypeType   { NOT_TYPED, INTEGER, FLOAT, STRING };

  
typedef struct Attribute Attribute;
struct Attribute {
  Attribute *next;
  Widget w;
  int set_flag;			/* Mark if variable was set already. */
  int widget_type;
  int rows;
  int columns;
  int sticky;
  int socket;
  char position[20];
  unsigned char orientation;
  char *name;
  char *variable;
  char *help;
  char *default_value;
  int stdin_flag;
  int stdout_flag;
  int type;
  char min_value[20];
  char max_value[20];
};


typedef struct Panel Panel;
struct Panel {
  Attribute *attribute;
  char *program_library;
  char *program_mod;
  char *program_exec;
  char *program_help;
  Widget dialog_window;
  Widget message_window;
  XtPointer data;
};
 
extern Widget top_level;
extern Display *display;

extern int xui_trace_flag_internal;

extern Panel *init_panel(
#if NeedFunctionPrototypes
Widget
#endif
);
extern void create_panel(
#if NeedFunctionPrototypes
Widget,int,int
#endif
);
extern void delete_panel(
#if NeedFunctionPrototypes
Panel *
#endif
);
extern char **get_panel_defaults(
#if NeedFunctionPrototypes
Panel *
#endif
);
extern void set_panel(
#if NeedFunctionPrototypes
Panel *,char *
#endif
);
extern void ok_help_cancel_panel(
#if NeedFunctionPrototypes
Panel *,XtPointer
#endif
);
