/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
 *	Module	:	swks.h
 *	Date	:	8706.23
 *	Author	:	J. Neisen
 *	Purpose	:	Include file for seismic workstation
 *			interface.
 *
 *	$Log:	s_wks.h,v $
 * Revision 1.1  88/09/27  15:56:34  dwm
 * Initial revision
 * 
 */


/*
 *	Opcodes for workstation interface
 */
#define	SEIS_OPEN	0x00	/* Start processing a seismic file */
#define	SEIS_CLOSE	0x01	/* Quit remote program */
#define	SEIS_GHDR	0x02	/* Request Header information */
#define	SEIS_DATA	0x03	/* Request Seismic data */ 
#define	SEIS_SEEK	0x04	/* Seek to a Seismic record */
#define	SEIS_CLIPW	0x05	/* Set the clip window for data */
#define	SEIS_GAIN	0x06	/* Amplitude gain multiplier */
#define	SEIS_BIAS	0x07	/* Zero value bias (percentage */
#define	SEIS_DATAH	0x08	/* Request Seismic data whith histogram conv. */
#define SEIS_CMD	0x09	/* Request aux command processor */
#define SEIS_GINFO	0x0a	/* Request info about file data */
				/* Response is SEIS_STAT followed by SEIS_INFO*/

typedef	char	SEIS_OP;
typedef	char	SEIS_STR[128];
typedef char	SEIS_CMD_STR[1000];

enum	axis {S_TRACSAMP, S_RECSAMP, S_TRACREC, S_TRACRECSAMP, S_RECTRACSAMP};
/* 	      fixed rec, fixed trace, fixed samp, record summary trace summary */
/*            front      side         top        traces by rec  recs by trace */

typedef
struct	seis_stat	{
	int	s_stat:32;	/* Status word */
	int	s_errno:32;	/* Errno (if error occurred) */
}	SEIS_STAT;

typedef
struct	seis_hdr	{
	int	s_nrec:32;		/* # of records (lines) */
	int	s_ntrac:32;		/* # of traces per record */
	int	s_nsamp:32;		/* # of samples per trace */
	int	s_save:32;		/* Unused */
}	SEIS_HEAD;

typedef
struct	seis_clip	{
	int	s_recstart:32;		/* Starting record # */
	int	s_recend:32;		/* Ending record # */
	int	s_recskip:32;		/* Record skip count */
	int	s_trstart:32;		/* Starting trace # */
	int	s_trend:32;		/* Ending trace # */
	int	s_trskip:32;		/* Trace skip count */
	int	s_smstart:32;		/* Starting sample # */
	int	s_smend:32;		/* Ending sample # */
	int	s_smskip:32;		/* Sample skip count */
	enum axis s_axis:32;		/* axis orientation */
}	SEIS_CLIP;

#define	FLOAT_BIAS	1000000.0
typedef
struct	seis_float	{
	int	s_int:32;		/* Integer part of clamp */
	int	s_frac:32;		/* Fractional part of clamp */
}	SEIS_FLOAT;

typedef
struct	seis_info	{
	SEIS_STR	s_mag;		/* magnitude */
	SEIS_STR	s_gain;		/* gain */
	SEIS_STR	s_intvl;	/* sample interval */
	SEIS_STR	s_gintvl;	/* group (trace) interval */
	SEIS_STR	s_bias;		/* trace number bias */
}	SEIS_INFO;
