/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
	/* line header  */
typedef struct {
  char		EqpCod;			/* Equipment Code */
  char  	CrwNam[6];		/* Crew Six Characters	*/
  char		DatTyp;			/* Data Type		*/
  char		DgTrkS[2];		/* Digital Truck System	*/
  char		PrcNam[10];		/* Processor Name		*/
  char		blank_1[4];		/* unused			*/
  char		PrcDat[8];		/* Processing Date		*/
  char		OACLin[8];		/* OAC Line 8 char 		*/
  char		JobNum[8];		/* JOB Number 		*/
  int 		NumTrc;			/* number traces per record	*/
  int 		NumRec;			/* number records per line	*/
  int 		SmpInt;			/* sample interval ms		*/
  int 		NumSmp;			/* number samples per trace	*/
  short		Format;			/* format code			*/
  short		IndAdj;			/* index adjustment		*/
  short		OpGrFl;			/* Opposite/Between Group Flag	*/
  char		blank_2[2];		/* unused			*/
  char		SrtTyp[2];		/* Sort Type	0=FIFO 		*/
  short		CDPFld;			/* CDP Fold			*/
  char		GrpInt[4];		/* Group Inverval		*/
  int 		DtInFl;			/* Data Indicator Flag		*/
  short		MxSPEl;			/* Max Source Point Elevation	*/
  short		MnSPEl;			/* Min Source Point Elevation	*/
  short		MxRSEL;			/* Max Ref Surface Elevation	*/
  short		MnRSEL;			/* Min Ref Surface Elevation	*/
  short		MxGrEl;			/* Maximum group Elevation	*/
  short		MnGrEl;			/* Minimum group Elevation	*/
  short		MxTrSt;			/* Maximum trace Static		*/
  short		MnTrSt;			/* Minimum trace Static		*/
  char		LinDir[4];			/* Line Direction e.g., N45E*/
  int 		AERcPr;			/* Accumulative Est Rec Proc	*/
  short		OrNTRC;			/* Original traces Per Record	*/
  short		OrNREC;			/* Original Number records	*/
  float		MutVel;			/* Muting Velocity		*/
  short		ZDMuTm;			/* Zero Distance Mutine Time	*/
  short		IntInc;			/* interpolation increment	*/
  union {
   int 		WatVel;			/* Water Velocity		*/
   int 		RefVel;			/* SLNT Reference Velocity(MBS) */
   } union_1 ;
  short		MxShDp;			/* Maximum Shot Depth		*/
  short		MnShDp;			/* Minimum Shot Depth		*/
  short		MxUHTm;			/* Maximum Uphole Time		*/
  short		MnUHTm;			/* Minimum Uphole Time		*/
  short		MxTrOf;			/* Maximum traverse Offset	*/
  short		MnTrOf;			/* Minimum traverse Offset	*/
  union {
   short	RATTrc;			/* RATS Traces per Record Entry */
   short	AnglSt;			/* SLNT Starting Angle    (MBS) */
   } union_2 ;
  union {
   short	RATFld;			/* RATS Fold Entry		*/
   short	AngInc;			/* SLNT Angle Increment   (MBS) */
   } union_3 ;
  short		UnitFl;			/* Units Flag 0=ft 1=m		*/
  short		FrstSP;			/* 1st SP Number on Line	*/
  short		DpN1SP;			/* Dep Pt Num Below 1st Src Pt	*/
  short		NmDpIn;			/* Num Dep Pt Int per Unit Inc	*/
  short		StWdFl;			/* Static Wd Flag 0=old >=1 new	*/
  short		DptInt;			/* Depth Point interval		*/
  union {
   int 		TmMsSl;			/* Time in ms of First Slice	*/
   int 		Dx1000;			/* Trace interval * 1000  (MBS) */ 
   } union_4 ;
  union {
   int 		TmSlIn;			/* Time Slice increment in ms	*/
   int 		Dz1000;			/* Depth Interval * 1000  (MBS) */
   } union_5 ;
  float		TmMsFS;			/* Time in ms of First Sample	*/
  int 		NTrLnS;			/* Number Traces/Line Sorted In	*/
  short		PltDir;			/* Plot Direction		*/
  short		LgRfEl;			/* Log Reference Elevation	*/
  short		MnLnIn;			/* Minimum line Index		*/
  short		MxLnIn;			/* Maximum line Index		*/
  short		MnDpIn;			/* Minimum depth Index		*/
  short		MxDpIn;			/* Maximum depth Index		*/
  float		ILClIn;			/* In Line Cell Increment	*/
  float		CLClIn;			/* Cross Line Cell Increment	*/
  short		ReSpFm;			/* Reserved Special Format	*/
  short		VlFnRF;			/* Vel Func Ref Flag 0=RI 1=DI	*/
  char		OACUsr[4];		/* OAC USER Field		*/
  char		LinNam[8];		/* Line Name		*/
  short		MutFlg;			/* Mute Flag 0=yes 1=no		*/
  char		SPBias[2];		/* Shot point Bias 		*/
  short		SpBiFl;			/* Shot Point Bias Flag		*/
  char		APIWNo[12];		/* API Well Number		*/
  char		blank_3[2]; 		/* unused 			*/
  float		NmSpMi;			/* Number Shot points per Mile	*/
  char		blank_4[372];		/* unused 			*/
  short		MinVel;		        /* Minimum velocity       (MBS) */ 
  short		MaxVel;		        /* Maximum velocity       (MBS) */
  char		blank_5[396];		/* unused 			*/
  short		HlhEnt;			/* Number of Entries in HLH	*/
  short		HlhByt;			/* Number of Bytes in HLH	*/
} IEEE_usp_line_header;

	/* trace header	*/
typedef struct {
  short		SGRNum;			/* SGR number			*/
  short		SGRAmp;			/* SGR PreAmp Gain, Filter	*/
  int 		SGRDat;			/* SGR Julian Date Recorded	*/
  short		FlReFN;			/* Field Record File Number	*/
  short		FlStNm;			/* Field Station Number		*/
  short		PREPIn;			/* PREP Initiation Static .25ms	*/
  short		InStUn;			/* Initiation Static Unapplied	*/
  short		InStAp;			/* Initiation Static Applied	*/
  short		PREPRc;			/* PREP Reception Static .25ms	*/
  short		RcStUn;			/* Reception Static Unapplied	*/
  short		RcStAp;			/* Reception Static Applied	*/
  short		ToStAp;			/* Total Static Applied 	*/
  short		ToTmAA;			/* Total Timing Adjust Applied	*/
  short		ToStUn;			/* Total Static Unapplied 	*/
  short		ToTmAU;			/* Total Timing Adjust Unapplied*/
					/* all ten above are .25ms units */
  short		blank_1[4];		/* unused			*/
  short		TrHdID;			/* Trace Header Identifier	*/
  short		SrRcAz;			/* Source-to-Receiver Azimuth	*/
  int 		SrPtXC;			/* Src Point X-Coordinate 3D	*/
  int 		SrPtYC;			/* Src Point Y-Coordinate 3D	*/
  int 		RcPtXC;			/* Rec Point X-Coordinate 3D	*/
  int 		RcPtYC;			/* Rec Point Y-Coordinate 3D	*/
  int 		SrRcMX;			/* Src Rec Midpoint X 3D	*/
  int 		SrRcMY;			/* Src Rec Midpoint Y 3D	*/
  int 		CDPBCX;			/* CDP Bin Center X Coordinate	*/
  int 		CDPBCY;			/* CDP Bin Center Y Coordinate	*/
  int 		InTrCn;			/* Incremental Trace Counter	*/
  short		FlDtEl;			/* Floating Datum Elev this CDP	*/
  short		MulSkw;			/* Multiplex Skew (ms*1000)	*/
  short		PerSPO;			/* Perpendicular Src Pt Off y	*/
  short		InlSPO;			/* Inline Src Pt Off x	*/
  short		TiLiI1;			/* Tie Line Indicator 1		*/
  short		TiLiI2;			/* Tie Line Indicator 2		*/
  short		TiLiI3;			/* Tie Line Indicator 3		*/
  short		TiLiI4;			/* Tie Line Indicator 4		*/
  short		TiLiI5;			/* Tie Line Indicator 5		*/
  short		TiLiI6;			/* Tie Line Indicator 6		*/
  short		TVPT01;			/* Time of Time-Velocity Pair	*/
  short		TVPV01;			/* Velocity of Time-Velocity Pair*/
  short		TVPT02;			/* Time of Time-Velocity Pair	*/
  short		TVPV02;			/* Velocity of Time-Velocity Pair*/
  short		TVPT03;			/* Time of Time-Velocity Pair	*/
  short		TVPV03;			/* Velocity of Time-Velocity Pair*/
  short		TVPT04;			/* Time of Time-Velocity Pair	*/
  short		TVPV04;			/* Velocity of Time-Velocity Pair*/
  short		TVPT05;			/* Time of Time-Velocity Pair	*/
  short		TVPV05;			/* Velocity of Time-Velocity Pair*/
  short		TVPT06;			/* Time of Time-Velocity Pair	*/
  short		TVPV06;			/* Velocity of Time-Velocity Pair*/
  short		TVPT07;			/* Time of Time-Velocity Pair	*/
  short		TVPV07;			/* Velocity of Time-Velocity Pair*/
  short		TVPT08;			/* Time of Time-Velocity Pair	*/
  short		TVPV08;			/* Velocity of Time-Velocity Pair*/
  short		TVPT09;			/* Time of Time-Velocity Pair	*/
  short		TVPV09;			/* Velocity of Time-Velocity Pair*/
  short		TVPT10;			/* Time of Time-Velocity Pair	*/
  short		TVPV10;			/* Velocity of Time-Velocity Pair*/
  short		TVPT11;			/* Time of Time-Velocity Pair	*/
  short		TVPV11;			/* Velocity of Time-Velocity Pair*/
  short		TVPT12;			/* Time of Time-Velocity Pair	*/
  short		TVPV12;			/* Velocity of Time-Velocity Pair*/
  short		TVPT13;			/* Time of Time-Velocity Pair	*/
  short		TVPV13;			/* Velocity of Time-Velocity Pair*/
  short		TVPT14;			/* Time of Time-Velocity Pair	*/
  short		TVPV14;			/* Velocity of Time-Velocity Pair*/
  short		TVPT15;			/* Time of Time-Velocity Pair	*/
  short		TVPV15;			/* Velocity of Time-Velocity Pair*/
  short		TVPT16;			/* Time of Time-Velocity Pair	*/
  short		TVPV16;			/* Velocity of Time-Velocity Pair*/
  short		TVPT17;			/* Time of Time-Velocity Pair	*/
  short		TVPV17;			/* Velocity of Time-Velocity Pair*/
  short		TVPT18;			/* Time of Time-Velocity Pair	*/
  short		TVPV18;			/* Velocity of Time-Velocity Pair*/
  short		TVPT19;			/* Time of Time-Velocity Pair	*/
  short		TVPV19;			/* Velocity of Time-Velocity Pair*/
  short		TVPT20;			/* Time of Time-Velocity Pair	*/
  short		TVPV20;			/* Velocity of Time-Velocity Pair*/
  union {
   short	TVPT21;			/* Time of Time-Velocity Pair	*/
   short	RedVel;			/* Reduction Velocity for vred	*/
   } union_1 ;
  union {
   short	TVPV21;			/* Velocity of Time-Velocity Pair*/
   short	RedTim;			/* Time of first sample for vred */
   } union_2 ;
  short		VPick1;			/* Auto Static Pick 1		*/
  short		VPick2;			/* Auto Static Pick 2		*/
  short		LRcCDP;			/* Last Record CDP		*/
  short		CabDep;			/* Cable Depth			*/
  short		WDepDP;			/* Water Depth Above Depth Point*/
  short		DPOPer;			/* Depth Point Offset Perpendic	*/
  short		ShtDep;			/* shot depth			*/
  short		UphlTm;			/* uphole time in ms		*/
  int 		DpPtLt;			/* depth pt lat (deg* 10^5)	*/
  int 		DpPtLn;			/* depth pt lon (deg* 10^5)	*/
  short		FoldNm;			/* fold				*/
  short		RecNum;			/* record number		*/
  short		TrcNum;			/* trace number			*/
  short		SrcPnt;			/* src point above this depth pt*/
  short		SrcLoc;			/* src location ind mult by 10	*/
  short		PrRcNm;			/* permanent record number PRI	*/
  short		PrTrNm;			/* permanent trace number  PTI	*/
  short		SrPtEl;			/* source point elevation	*/
  int 		SrPrLt;			/* source point lat (deg* 10^5)	*/
  int 		SrPrLn;			/* source point lon (deg* 10^5)	*/
  short		DstUsg;			/* unsigned trace distance	*/
  short		RecInd;			/* rec location index	GI	*/
  short		DstSgn;			/* signed trace distance	*/
  short		GrpElv;			/* group elevation		*/
  short		LinInd;			/* line index 3D		*/
  short		DphInd;			/* depth index			*/
  short		DePtEl;			/* depth point elevation	*/
  short		RfSrEl;			/* reference surface elevation	*/
  short		StaCor;			/* correction		*/
  short		DatShf;			/* datum shift			*/
  short		SoPtNm;			/* source point number		*/
  char		SoPtAl[1];		/* source point alphabetic sufix */
  char		SoPtBi[1];		/* source point bias/10000	*/
/* float		TrcDat[1]; */	/* Data Samples			*/
} IEEE_usp_trace_header ;

/* vanl analysis header	*/
typedef struct {
  int 		CDPNum;			/* RI(CDP) Number of this anal. */
  char		LinNum[4];		/* Line Number			*/
  int 		CohRec;			/* # of coherence records       */
  int 		FstCoh;			/* number of 1st coherence samp */
  int 		NumCoh;			/* # of coherence values/record */
  int 		VelPrs;			/* # of v,delta-v pairs in hdr  */
  int 		RsmpIn;			/* resampling increment used	*/
  int 		SmpInt;			/* coherence sample interval(ms)*/
  short		StFlag;			/* statics application flag 	*/
				/*	0=reg. ref.		*/
				/*	1=No statics		*/
				/*	2=Mean ground		*/
  short		PanWid;			/* panel width in CDPs		*/
  short		AvPnSt;			/* average panel statics in ms. */
  short		RfSfEl;			/* reference surface elevation  */
  int 		SrcPNm;			/* source point number 		*/
  short		LinInd;			/* line index			*/
  short		CDPFld;			/* fold				*/
  short		NStkTr;			/* # stacked traces in analysis */
  short		DphInd;			/* depth index			*/
  short		WDepDP;			/* water depth above depth point*/
  short		WatVel;			/* water velocity		*/
  char		OACCod[4];		/* OAC code			*/
  short		SoPtBi;			/* source point bias		*/
  short		EMFlag;			/* english/metric flag		*/
  short		LevNum;			/* VANL tape level number	*/
} IEEE_usp_vanl_header ;

typedef struct {
  short		RecLng;			/* Record length in bytes	*/
  short		LevNum;			/* VSPN tape level number-unused*/
  short		FFDLat;			/* 1st four digits of Latitude  */
  short		LFDLat;			/* Last four digits of Latitude */
  short		FFDLon;			/* 1st four digits of Longitude */
  short		LFDLon;			/* Last four digits of Longitude*/
  int 		AVFNum;			/* Archival Vel. File number	*/
  char		OACCod[3];		/* OAC code			*/
  int 		OAVFNm;			/* OAVF number			*/
  char		DatSrc[1];		/* Data Source			*/
  char		MthCmp[1];		/* Method of Computation        */
  short		TmLsEn;			/* Time Last Entry for Well Func*/
  short		LinCod;			/* Line Code for Reflection Func*/
  short		MonDay;			/* Month & Day in integer form	*/
  short		Year  ;			/* Year in integer form		*/
  short		CDPNum;			/* RI(CDP) Number of this anal. */
  short		MaxDst;			/* Maximum Distance		*/
  short		DirSht;			/* Direction of Shooting	*/
  short		CDPFld;			/* fold				*/
  short		PanWid;			/* panel width in CDPs		*/
  short		WinLng;			/* Window Length ( in ms )	*/
  short		SrfElv;			/* Surface Elevation		*/
  short		RgRSEL;			/* Regional Ref Surface Elev	*/
  short		TCRfSf;			/* Time Corr to Ref Surface	*/
  short		VelSbW;			/* Velocity of Subweathering	*/
  short		VelPrs;			/* # of time,velocity pairs 	*/
  short		HrzPrs;			/* # of seismic horizon,time prs*/
  short		ICNByt;			/* # of bytes in int. comments	*/
  short		WatDep;			/* Water Depth 			*/
  short		DivCod;			/* Division Code		*/
  short		StNoAr;			/* Strat. Nomenclature Area	*/
  char		HstOAC[3];		/* Historical OAC		*/
  int 		SrcPnt;			/* Source Point			*/
  char		SoPtAl[1];		/* Source Point Alpha		*/
  char		LinNum[5];		/* Line Number			*/
  char		DrSht1[1];		/* Direction of Shooting	*/
  char		DrSht2[1];		/* Direction of Shooting	*/
  char		RelFlg[1];		/* Reliablity			*/
  char		RlAlFg[1];		/* Reliablity Alpha Flag	*/
} IEEE_usp_vspn_header ;

typedef struct {
/* line header  */
  char 		space1[7];		/* buffer space			*/
  char		EqpCod[1];		/* Equipment code		*/
  char 		space2[2];		/* buffer space			*/
  char		CrwNam[6];		/* Crew Six Characters	*/
  char 		space3[7];		/* buffer space			*/
  char		DatTyp[1];		/* Data Type		*/
  char 		space4[6];		/* buffer space			*/
  char		DgTrkS[2];		/* Digital Truck System	*/
  char		PrcNam[10];		/* Processor Name		*/
  char 		space5[6];		/* buffer space			*/
  char 		blank_1[8];		/* unused 			*/
  char		PrcDat[8];		/* Processing Date		*/
  char		OACLin[8];		/* OAC Line 		*/
  char		JobNum[8];		/* JOB Number 7 char right just */
  int 		NumTrc;			/* number traces per record	*/
  int 		NumRec;			/* number records per line	*/
  int 		SmpInt;			/* sample interval ms		*/
  int 		NumSmp;			/* number samples per trace	*/
  int 		Format;			/* format code			*/
  int 		IndAdj;			/* index adjustment		*/
  int 		OpGrFl;			/* Opposite/Between Group Flag	*/
  char 		blank_2[8];		/* unused			*/
  char		SrtTyp[2];		/* Sort Type 0=FIFO 1=LgArrow	*/
  char 		space6[6];		/* buffer space			*/
  int 		CDPFld;			/* CDP Fold			*/
  char 		space7[4];		/* buffer space			*/
  char		GrpInt[4];		/* Group Inverval		*/
  int 		DtInFl;			/* Data Indicator Flag		*/
  int 		MxSPEl;			/* Max Source Point Elevation	*/
  int 		MnSPEl;			/* Min Source Point Elevation	*/
  int 		MxRSEL;			/* Max Ref Surface Elevation	*/
  int 		MnRSEL;			/* Min Ref Surface Elevation	*/
  int 		MxGrEl;			/* Maximum group Elevation	*/
  int 		MnGrEl;			/* Minimum group Elevation	*/
  int 		MxTrSt;			/* Maximum trace Static		*/
  int 		MnTrSt;			/* Minimum trace Static		*/
  char		LinDir[4];		/* Line Direction e.g., N45E	*/
  char 		space8[4];		/* buffer space			*/
  int 		AERcPr;			/* Accumulative Est Rec Proc	*/
  int 		OrNTRC;			/* Original traces Per Record	*/
  int 		OrNREC;			/* Original Number records	*/
  float		MutVel;			/* Muting Velocity		*/
  int 		ZDMuTm;			/* Zero Distance Mutine Time	*/
  int 		IntInc;			/* interpolation increment	*/
  union {
   int 		WatVel;			/* Water Velocity		*/
   int 		RefVel;			/* SLNT Reference Velocity(MBS) */
   } union_1 ;
  int 		MxShDp;			/* Maximum Shot Depth		*/
  int 		MnShDp;			/* Minimum Shot Depth		*/
  int 		MxUHTm;			/* Maximum Uphole Time		*/
  int 		MnUHTm;			/* Minimum Uphole Time		*/
  int 		MxTrOf;			/* Maximum traverse Offset	*/
  int 		MnTrOf;			/* Minimum traverse Offset	*/
  union {
   int 		RATTrc;			/* RATS Traces per Record Entry */
   int 		AnglSt;			/* SLNT Starting Angle    (MBS) */
   } union_2 ;
  union {
   int 		RATFld;			/* RATS Fold Entry		*/
   int 		AngInc;			/* SLNT Angle Increment   (MBS) */
   } union_3 ;
  int 		UnitFl;			/* Units Flag 0=ft 1=m		*/
  int 		FrstSP;			/* 1st SP Number on Line	*/
  int 		DpN1SP;			/* Dep Pt Num Below 1st Src Pt	*/
  int 		NmDpIn;			/* Num Dep Pt Int per Unit Inc	*/
  int 		StWdFl;			/* Static Wd Flag 0=old >=1 new	*/
  int 		DptInt;			/* Depth Point interval		*/
  union {
   int 		TmMsSl;			/* Time in ms of First Slice	*/
   int 		Dx1000;			/* Trace interval * 1000  (MBS) */ 
   } union_4 ;
  union {
   int 		TmSlIn;			/* Time Slice increment in ms	*/
   int 		Dz1000;			/* Depth Interval * 1000  (MBS) */
   } union_5 ;
  float		TmMsFS;			/* Time in ms of First Sample	*/
  int 		NTrLnS;			/* Number Traces/Line Sorted In	*/
  int 		PltDir;			/* Plot Direction		*/
  int 		LgRfEl;			/* Log Reference Elevation	*/
  int 		MnLnIn;			/* Minimum line Index		*/
  int 		MxLnIn;			/* Maximum line Index		*/
  int 		MnDpIn;			/* Minimum depth Index		*/
  int 		MxDpIn;			/* Maximum depth Index		*/
  float		ILClIn;			/* In Line Cell Increment	*/
  float		CLClIn;			/* Cross Line Cell Increment	*/
  int 		ReSpFm;			/* Reserved Special Format	*/
  int 		VlFnRF;			/* Vel Func Ref Flag 0=RI 1=DI	*/
  char 		space9[4];		/* buffer space			*/
  char		OACUsr[4];		/* OAC USER Field		*/
  char		LinNam[8];		/* Line Name		*/
  int 		MutFlg;			/* Mute Flag 0=yes 1=no		*/
  char		SPBias[2];		/* Shot point Bias		*/
  char 		space10[6];		/* buffer space			*/
  int 		SpBiFl;			/* Shot Point Bias Flag		*/
  char		APIWNo[12];		/* API Well Number		*/
  char 		space_11[4];		/* buffer space			*/
  char 		blank_3[8];		/* unused			*/
  float		NmSpMi;			/* Number Shot points per Mile	*/
  int  		blank_4[47];		/* unused			*/
  int 		MinVel;		        /* Minimum velocity       (MBS) */ 
  int 		MaxVel;		        /* Maximum velocity       (MBS) */
  int  		blank_5[198];		/* unused			*/
  int 		HlhEnt;			/* Number of Entries in HLH	*/
  int 		HlhByt;			/* Number of Bytes in HLH	*/
} cray_usp_line_header ;


/* trace header	*/
typedef struct {
  int 		SGRNum;			/* SGR number			*/
  int 		SGRAmp;			/* SGR PreAmp Gain, Filter	*/
  int 		SGRDat;			/* SGR Julian Date Recorded	*/
  int 		blank_1;		/* unused			*/
  int 		FlReFN;			/* Field Record File Number	*/
  int 		FlStNm;			/* Field Station Number		*/
  int 		PREPIn;			/* PREP Initiation Static .25ms	*/
  int 		InStUn;			/* Initiation Static Unapplied	*/
  int 		InStAp;			/* Initiation Static Applied	*/
  int 		PREPRc;			/* PREP Reception Static .25ms	*/
  int 		RcStUn;			/* Reception Static Unapplied	*/
  int 		RcStAp;			/* Reception Static Applied	*/
  int 		ToStAp;			/* Total Static Applied 	*/
  int 		ToTmAA;			/* Total Timing Adjust Applied	*/
  int 		ToStUn;			/* Total Static Unapplied 	*/
  int 		ToTmAU;			/* Total Timing Adjust Unapplied*/
				/* all ten above are .25ms units */
  int 		blank_2[4];		/* unused			*/
  int 		TrHdID;			/* Trace Header Identifier	*/
  int 		SrRcAz;			/* Source-to-Receiver Azimuth	*/
  int 		SrPtXC;			/* Src Point X-Coordinate 3D	*/
  int 		blank_3;		/* unused			*/
  int 		SrPtYC;			/* Src Point Y-Coordinate 3D	*/
  int 		blank_4;		/* unused			*/
  int 		RcPtXC;			/* Rec Point X-Coordinate 3D	*/
  int 		blank_5;		/* unused			*/
  int 		RcPtYC;			/* Rec Point Y-Coordinate 3D	*/
  int 		blank_6;		/* unused			*/
  int 		SrRcMX;			/* Src Rec Midpoint X 3D	*/
  int 		blank_7;		/* unused			*/
  int 		SrRcMY;			/* Src Rec Midpoint Y 3D	*/
  int 		blank_8;		/* unused			*/
  int 		CDPBCX;			/* CDP Bin Center X Coordinate	*/
  int 		blank_9;		/* unused			*/
  int 		CDPBCY;			/* CDP Bin Center Y Coordinate	*/
  int 		blank_10;		/* unused			*/
  int 		InTrCn;			/* Incremental Trace Counter	*/
  int 		blank_11;		/* unused			*/
  int 		FlDtEl;			/* Floating Datum Elev this CDP	*/
  int 		MulSkw;			/* Multiplex Skew (ms*1000)	*/
  int 		PerSPO;			/* Perpendicular Src Pt Off y	*/
  int 		InlSPO;			/* Inline Src Pt Off x	*/
  int 		TiLiI1;			/* Tie Line Indicator 1		*/
  int 		TiLiI2;			/* Tie Line Indicator 2		*/
  int 		TiLiI3;			/* Tie Line Indicator 3		*/
  int 		TiLiI4;			/* Tie Line Indicator 4		*/
  int 		TiLiI5;			/* Tie Line Indicator 5		*/
  int 		TiLiI6;			/* Tie Line Indicator 6		*/
  int 		TVPT01;			/* Time of Time-Velocity Pair	*/
  int 		TVPV01;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT02;			/* Time of Time-Velocity Pair	*/
  int 		TVPV02;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT03;			/* Time of Time-Velocity Pair	*/
  int 		TVPV03;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT04;			/* Time of Time-Velocity Pair	*/
  int 		TVPV04;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT05;			/* Time of Time-Velocity Pair	*/
  int 		TVPV05;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT06;			/* Time of Time-Velocity Pair	*/
  int 		TVPV06;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT07;			/* Time of Time-Velocity Pair	*/
  int 		TVPV07;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT08;			/* Time of Time-Velocity Pair	*/
  int 		TVPV08;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT09;			/* Time of Time-Velocity Pair	*/
  int 		TVPV09;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT10;			/* Time of Time-Velocity Pair	*/
  int 		TVPV10;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT11;			/* Time of Time-Velocity Pair	*/
  int 		TVPV11;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT12;			/* Time of Time-Velocity Pair	*/
  int 		TVPV12;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT13;			/* Time of Time-Velocity Pair	*/
  int 		TVPV13;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT14;			/* Time of Time-Velocity Pair	*/
  int 		TVPV14;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT15;			/* Time of Time-Velocity Pair	*/
  int 		TVPV15;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT16;			/* Time of Time-Velocity Pair	*/
  int 		TVPV16;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT17;			/* Time of Time-Velocity Pair	*/
  int 		TVPV17;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT18;			/* Time of Time-Velocity Pair	*/
  int 		TVPV18;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT19;			/* Time of Time-Velocity Pair	*/
  int 		TVPV19;			/* Velocity of Time-Velocity Pair*/
  int 		TVPT20;			/* Time of Time-Velocity Pair	*/
  int 		TVPV20;			/* Velocity of Time-Velocity Pair*/
  union {
   short	TVPT21;			/* Time of Time-Velocity Pair	*/
   short	RedVel;			/* Reduction Velocity for vred	*/
   } union_1 ;
  union {
   short	TVPV21;			/* Velocity of Time-Velocity Pair*/
   short	RedTim;			/* Time of first sample for vred */
   } union_2 ;
  int 		VPick1;			/* Auto Static Pick 1		*/
  int 		VPick2;			/* Auto Static Pick 2		*/
  int 		LRcCDP;			/* Last Record CDP		*/
  int 		CabDep;			/* Cable Depth			*/
  int 		WDepDP;			/* Water Depth Above Depth Point*/
  int 		DPOPer;			/* Depth Point Offset Perpendic	*/
  int 		ShtDep;			/* shot depth			*/
  int 		UphlTm;			/* uphole time in ms		*/
  int 		DpPtLt;			/* depth pt lat (deg* 10^5)	*/
  int 		blank_12;		/* unused			*/
  int 		DpPtLn;			/* depth pt lon (deg* 10^5)	*/
  int 		blank_13;		/* unused			*/
  int 		FoldNm;			/* fold				*/
  int 		RecNum;			/* record number		*/
  int 		TrcNum;			/* trace number			*/
  int 		SrcPnt;			/* src point above this depth pt*/
  int 		SrcLoc;			/* src location ind mult by 10	*/
  int 		PrRcNm;			/* permanent record number PRI	*/
  int 		PrTrNm;			/* permanent trace number  PTI	*/
  int 		SrPtEl;			/* source point elevation	*/
  int 		blank_14;		/* unused			*/
  int 		SrPrLt;			/* source point lat (deg* 10^5)	*/
  int 		blank_15;		/* unused			*/
  int 		SrPrLn;			/* source point lon (deg* 10^5)	*/
  int 		DstUsg;			/* unsigned trace distance	*/
  int 		RecInd;			/* rec location index	GI	*/
  int 		DstSgn;			/* signed trace distance	*/
  int 		GrpElv;			/* group elevation		*/
  int 		LinInd;			/* line index 3D		*/
  int 		DphInd;			/* depth index			*/
  int 		DePtEl;			/* depth point elevation	*/
  int 		RfSrEl;			/* reference surface elevation	*/
  int 		StaCor;			/* correction		*/
  int 		DatShf;			/* datum shift			*/
  int 		SoPtNm;			/* source point number		*/
  char		SoPtAl[1];		/* source point alphabetic sufix */
  char		SoPtBi[1];		/* source point bias/10000	*/
  char		space_1[6];		/* buffer space 		*/
/*  float		TrcDat[1]; */	/* Data Samples			*/
} cray_usp_trace_header ;

	/* vanl analysis header	*/
typedef struct {
  int 		CDPNum;			/* RI(CDP) Number of this anal. */
  char		LinNum[4];		/* Line Number			*/
  char		space_1[4];		/* buffer space 		*/
  int 		CohRec;			/* # of coherence records       */
  int 		FstCoh;			/* number of 1st coherence samp */
  int 		NumCoh;			/* # of coherence values/record */
  int 		VelPrs;			/* # of v,delta-v pairs in hdr  */
  int 		RsmpIn;			/* resampling increment used	*/
  int 		SmpInt;			/* coherence sample interval(ms)*/
  int 		StFlag;			/* statics application flag 	*/
				/*	0=reg. ref.		*/
				/*	1=No statics		*/
				/*	2=Mean ground		*/
  int 		PanWid;			/* panel width in CDPs		*/
  int 		AvPnSt;			/* average panel statics in ms. */
  int 		RfSfEl;			/* reference surface elevation  */
  int 		SrcPNm;			/* source point number 		*/
  int 		LinInd;			/* line index			*/
  int 		CDPFld;			/* fold				*/
  int 		NStkTr;			/* # stacked traces in analysis */
  int 		DphInd;			/* depth index			*/
  int 		WDepDP;			/* water depth above depth point*/
  int 		WatVel;			/* water velocity		*/
  char		OACCod[4];		/* OAC code			*/
  char		space_2[4];		/* buffer space 		*/
  int 		SoPtBi;			/* source point bias		*/
  int 		EMFlag;			/* english/metric flag		*/
  int 		LevNum;			/* VANL tape level number	*/
} cray_usp_vanl_header ;

typedef struct {
  int 		RecLng;			/* Record length in bytes	*/
  int 		LevNum;			/* VSPN tape level number-unused*/
  int 		FFDLat;			/* 1st four digits of Latitude  */
  int 		LFDLat;			/* Last four digits of Latitude */
  int 		FFDLon;			/* 1st four digits of Longitude */
  int 		LFDLon;			/* Last four digits of Longitude*/
  int 		AVFNum;			/* Archival Vel. File number	*/
  char		OACCod[3];		/* OAC code			*/
  char		space_1[5];		/* buffer space 		*/
  int 		OAVFNm;			/* OAVF number			*/
  char		DatSrc[1];		/* Data Source			*/
  char		space_2[7];		/* buffer space 		*/
  char		MthCmp[1];		/* Method of Computation        */
  char		space_3[7];		/* buffer space 		*/
  union {
  int 		TmLsEn;			/* Time Last Entry for Well Func*/
  int 		LinCod;			/* Line Code for Reflection Func*/
   } union_1 ;
  int 		MonDay;			/* Month & Day in integer form	*/
  int 		Year  ;			/* Year in integer form		*/
  int 		CDPNum;			/* RI(CDP) Number of this anal. */
  int 		MaxDst;			/* Maximum Distance		*/
  int 		DirSht;			/* Direction of Shooting	*/
  int 		CDPFld;			/* fold				*/
  int 		PanWid;			/* panel width in CDPs		*/
  int 		WinLng;			/* Window Length ( in ms )	*/
  int 		SrfElv;			/* Surface Elevation		*/
  int 		RgRSEL;			/* Regional Ref Surface Elev	*/
  int 		TCRfSf;			/* Time Corr to Ref Surface	*/
  int 		VelSbW;			/* Velocity of Subweathering	*/
  int 		VelPrs;			/* # of time,velocity pairs 	*/
  int 		HrzPrs;			/* # of seismic horizon,time prs*/
  int 		ICNByt;			/* # of bytes in int. comments	*/
  int 		WatDep;			/* Water Depth 			*/
  int 		DivCod;			/* Division Code		*/
  int 		StNoAr;			/* Strat. Nomenclature Area	*/
  char		HstOAC[3];		/* Historical OAC		*/
  char		space_4[5];		/* buffer space 		*/
  int 		SrcPnt;			/* Source Point			*/
  char		SoPtAl[1];		/* Source Point Alpha		*/
  char		space_5[7];		/* buffer space 		*/
  char		LinNum[5];		/* Line Number			*/
  char		space_6[3];		/* buffer space 		*/
  char		DrSht1[1];		/* Direction of Shooting	*/
  char		space_7[7];		/* buffer space 		*/
  short		DrSht2[1];		/* Direction of Shooting	*/
  char		space_8[7];		/* buffer space 		*/
  char		RelFlg[1];		/* Reliablity			*/
  char		space_9[7];		/* buffer space 		*/
  char		RlAlFg[1];		/* Reliablity Alpha Flag	*/
  char		space_10[7];		/* buffer space 		*/
} cray_usp_vspn_header ;

#ifndef CRAYSYSTEM
typedef IEEE_usp_line_header usp_line_header;
typedef IEEE_usp_trace_header usp_trace_header;
typedef IEEE_usp_vanl_header usp_vanl_header;
typedef IEEE_usp_vspn_header usp_vspn_header;
#else
typedef cray_usp_line_header usp_line_header;
typedef cray_usp_trace_header usp_trace_header;
typedef cray_usp_vanl_header usp_vanl_header;
typedef cray_usp_vspn_header usp_vspn_header;
#endif
