C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine hsort2(n,ra,rb)
C ******************************************************************** C
C *  Subroutine to sort array RA of length N into ascending          * C
C *  numerical order using the Heapsort algorithm, while making      * C
C *  the corresponding rearrangement of the array RB.                * C
C *  From Numerical Recipes in Fortran , pp 231-232                  * C
C *                                                                  * C
C ******************************************************************** C
      real ra(*),rb(*)
      real rra, rrb
      integer n

      if(n.le.0)return
      L = n/2+1
      ir = n
   10 continue
       if(L.gt.1)then
         L=L-1
         rra=ra(L)
         rrb = rb(L)
       else
         rra=ra(ir)
         rrb=rb(ir)
         ra(ir)=ra(1)
         rb(ir)=rb(1)
         ir=ir-1
         if(ir.eq.1)then
           ra(1)=rra
           rb(1)=rrb
           return
         endif
       endif
       i=L
       j = L+L
   20  if(j.le.ir)then
         if(j.lt.ir)then
           if(ra(j).lt.ra(j+1))j=j+1
         endif
         if(rra.lt.ra(j))then
           ra(i)=ra(j)
           rb(i)=rb(j)
           i = j
           j = j + j
         else
           j=ir+1
         endif
         go to 20
       endif
       ra(i)=rra
       rb(i)=rrb
       go to 10
       end
      subroutine hsort(n,ra)
C ******************************************************************** C
C *  Subroutine to sort array RA of length N into ascending          * C
C *  numerical order using the Heapsort algorithm.                   * C
C *  From Numerical Recipes in Fortran , pp 231-232                  * C
C *                                                                  * C
C ******************************************************************** C
      real ra(*)
      real rra
      integer n

      if(n.le.0)return
      L = n/2+1
      ir = n
   10 continue
       if(L.gt.1)then
         L=L-1
         rra=ra(L)
       else
         rra=ra(ir)
         ra(ir)=ra(1)
         ir=ir-1
         if(ir.eq.1)then
           ra(1)=rra
           return
         endif
       endif
       i=L
       j = L+L
   20  if(j.le.ir)then
         if(j.lt.ir)then
           if(ra(j).lt.ra(j+1))j=j+1
         endif
         if(rra.lt.ra(j))then
           ra(i)=ra(j)
           i = j
           j = j + j
         else
           j=ir+1
         endif
         go to 20
       endif
       ra(i)=rra
       go to 10
       end
