C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C******************************************************************
C                                                                 
C     SUBROUTINE - RDANGS            ENTRY POINT - RDANGS        
C                                                               
C     LANGUAGE - FORTRAN                                       
C     SYSTEM(S) - IBM                                         
C     AUTHOR - Richard Crider
C     DATE WRITTEN - May, 1991
C                                                         
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE
C                                                                     
C     ABSTRACT -                                                     
C            READ IN MIN_MAX ANGLE PAIRS FROM A FILE CONTAING ANGL 
C            CARD IMAGES.                                          
C                                                                 
C     USAGE                                                      
C                                                               
C      CALL RDANGS  (C,AMN,NCA,JRA,NSETS)
C                                                             
C  ARGUMENTS:                                                
C      AMN     INTEGER  O       (63,* ) - Minimum angle vector
C      AMX     INTEGER  O       (63,* ) - Maximum angle vector
C      NCA     INTEGER  O       (1)     - ARRAY CONTAINING COUNT OF 
C                                         angle PAIRS IN EACH FUNCTION. 
C      JRA     INTEGER  O       (1)     - RI NUMBERS                 
C      lucrd   INTEGER  O               - card image file logical unit
C      nstak   INTEGER  O               - maximum number of angle 
C                                         pairs.
C  NOTES:                                                        
C                                                              
C  SHOULD BE ASSURED THAT NCA AND JRA ARRAYS ARE ZERO BEFORE ENTERING
C  THIS ROUTINE.                                                  
C                                                                
C  GENERAL DESCRIPTION:  (SEE PURPOSE)                          
C                        A MAXIMUM OF 63 angle PAIRS/FUNCTION ALLOWED.
C                                                                     
C     SUBROUTINES CALLED - WRCARD                                    
C                                                                  
C                                                                 
C     ERROR FILE AND MNEUMONIC - NONE                            
C                                                               
C     ERROR/RETURN CODES -                                     
C                   IER IS INITIALIZED TO ZERO.  IF ERROR COND
C                   ARE ENCOUNTERED, IER IS SET TO A NON-ZERO, ERROR
C                   MESSAGE IS DISPLAYED AND EXECUTION RETURNS TO  
C                   THE CALLING ROUTINE.  USER SHOULD INSPECT IER. 
C                   (SEE CODE FOR MESSAGES DISPLAYED)             
C                                                                
C                                                                 
C****************************************************************
      SUBROUTINE RDANGS (AMN, AMX, NCA, JRA, lucrd, nstak,nsets,nf)
#include <f77/iounit.h>
C                                                                               
C       DATA DECLARATIONS                                       
C                                                              
      REAL amn(63,nf), amx(63,nf)                                
C                                                            
      CHARACTER CARD*80
C                      
      INTEGER  JRA(nf),NCA(nf)
C                        
      ns = -6
      nd = 0
      iff = 1
      nrd = 0
      mx = 0
      jrsv = 0
      nstak = 0
C                                   
C       CHECK FOR MAXIMUM NUMBER OF angle pairs
C                                                      
   10 IF (ND.GT.63) GO TO 9000                        
C                                                    
C        SET INDEXES FOR TIMES AND VELOCITIES       
C                                                  
      NS = NS+7                                   
      ND = NS+6                                  
C                                               
C        READ angl CARDS                       
C                                             
      READ (lucrd,40,END=180) CARD,(AMN(J,IFF),amx(J,IFF),
     * J=NS,ND),JRA(IFF)
   40 FORMAT (A80,T1,5X,7(f5.0,f5.0),t76,I5)                       
C                                                            
      IF (JRA(IFF).GT.JRSV) GO TO 90                          
      WRITE (LER,80)iff, jra(iff)
   80 FORMAT(T8,' ** M0080 ** WARNING FROM SUBROUTINE RDANGS',/,
     * T19,' RI NO. READ FOR VELOCITY FUNCTION ',i5,'( ',i5,')',
     :' IS ZERO OR LESS ',
     * 'THAN RI NO. FOR PREVIOUS FUNCTION ',/,T19,' SET TO 9999'//)
      JRA(IFF) = 9999                                               
C                                                                
C       WRITE OUT ANGL CARDS                                    
C                                                              
   90 write(LER,*)card
C                                                           
C       CHECK FOR 9ANGL CARD                                 
C                                                          
      IF (CARD(1:5).NE.'9ANGL') GO TO 110
      NRD = 1                           
      JRSV = JRA(IFF)
C                                     
C       CHECK FOR VELOCITY FUNCTION  
C                                   
  110 IF (NS.EQ.1) GO TO 130       
      IF (AMX(NS,IFF).NE.0.0) GO TO 130
      WRITE (LER,120) AMN(NS,IFF),IFF 
  120 FORMAT(T8,' ** M0120 ** ERROR DETECTED IN SUBROUTINE RDANGS',/,
     * T19,' NEED MAXIMUM ANGLE FOR MINIMUM ANGEL ',f5.0,
     *' - FUNCTION ',I5//)     
      IER = 3                                                      
      return
C                                                                
C       COUNT PAIRS IN FUNCTIONS and find largest number
C                                                              
  130 DO 150 J=NS,ND                                          
         IF (J.EQ.1) GO TO 140                              
         IF (AMX(J,IFF).EQ.0.0) GO TO 160                    
  140    NCA(IFF) = NCA(IFF)+1                                
         if(NCA(Iff).gt.nstak)nstak = NCA(iff)
  150 CONTINUE                                           
C                                                       
C       SEE IF NUMBER OF FUNCTIONS HAS BEEN EXCEEDED  
C                                                    
  160 IF (NRD.EQ.0) GO TO 10                        
      NRD = 0                                      
      nsets = iff
      IFF = IFF+1                                   
  170 NS = -6                                     
      GO TO 10                                   
C                                               
C        CHECK FOR NUMBER OF FUNCTIONS PAIRS  
C                                            
  180 continue
      return
C                                                       
C       ERROR MESSAGES                                 
C                                                     
 9000 WRITE (LER,9020)                               
 9020 FORMAT(T8,' ** M0020 ** ERROR DETECTED IN SUBROUTINE RDANGS',/,
     * T19,' TOO MANY ANGLE PAIRS (63 MAX) '//)             
      IER = 1                                                      
      return
C                                                                
C       RETURN TO CALLING ROUTINE                                
C                                                               
      END                                                                       
