C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C******************************************************************
C                                                                 
C     PROGRAM - angsyn
C                                                               
C                 AMOCO PRODUCTION CO. PROPRIETARY 
C                  TO BE MAINTAINED IN CONFIDENCE
C                                                                     
C     ABSTRACT - Fit data to 2nd order polynomial and reconstruct
C                from the coefficients
C                                                                  
C
C******************************************************************
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>

      real vel_array(1), t_array(1),dx(1)
      real data(1), angles(1), stack(1),vsvpsqr(1)
      real sig(1),vtrms(1),vsrms(1),vism(1),vit(1)
      real b0(1),b1(1),b2(1)
      integer trhd(1),LH,TH
      integer pipep, in_ikp
      POINTER (pc,vel_array),(ptt,t_array),(pdx,dx)
      POINTER (pdata, data), (pang, angles)
      POINTER (pstk, stack), (ptrhd, trhd)
      POINTER (pvsvpq,vsvpsqr),(pb0,b0),(pb1,b1),(pb2,b2)
      POINTER (psig,sig),(pvtrms,vtrms),(pvsrms,vsrms)
      POINTER (pvism,vism),(pvit,vit)

      real coefs(6),errprm(5)
      real timvec(SZLNHD)
      real Ritr(SZLNHD),Vtrc(SZLNHD)
      real angb, ange
C                                                      
      CHARACTER name*6,title(17)*4
      character ntap*100,otap*100
      character vtap*100
C
      logical query,H,ikp,xt,veltape
c
      integer argis,luv
      integer irs, ire
      integer emerg
      integer itr(SZLNHD),vitr(SZLNHD)
C
C
      DATA name/'ANGSYN'/
      DATA IER/0/
      data emerg/0/
      data pipep/3/
      DATA title/6*'    ','AVO ','Reco','stru','ctio','n   ',6*'    '/

      equivalence(itr(1),Ritr(1))
      equivalence(vitr(1),Vtrc(1))

      ival = 0
      ithw = ITHWP1-1
      const = .0174533
c +---------------------------------------------------------+
c |     check for help flag.  If found, print help and quit |
c +---------------------------------------------------------+
      h = (argis('-H').gt.0).or.(argis('-h').gt.0)
      query= ((argis ('-?').gt.0).or.h)
      if (query) then
       if(H)then
        call help(LER,1)
        stop
       else
        call help(LER,0)
        stop
       endif
      endif

      ikp = .false.
      if(in_ikp().eq.1)ikp=.true.
#include <f77/open.h>
C               +------------------------------+
C               |       Begin Edit Phase       |
C               +------------------------------+
      call gcmdln(ntap,otap,vtap,irs,ire,mode,angb,ange,xt)

      if(ange.eq.0)ange=45
      if(irs.eq.0)irs=1
      if(ire.eq.0)ire = 999999
C
      fact = .00005
      if(xt.and.mode.eq.-1)then
       mode = 1
       write(LER,*)' Ray tracing set to curved ray'
       write(LERR,*)' Ray tracing set to curved ray'
      endif
c +=========================+
c |   print torch and oval  |
c +=========================+
      call gamoco(title,1,lerr) 
c +====================================+
c |   read line header from input data |
c +====================================+

      call getln(luin,ntap,'r',0)
      if(luin.lt.0)then
       write(LERR,*)'Unable to open ', ntap
       stop
      endif
      veltape = .false.
      if(xt)then
       if (ikp .AND. vtap(1:1).eq.' ') then
         call sisfdfit (luv, pipep)
       elseif (vtap(1:1).ne.' ') then
         call getln(luv,vtap,'r',-1)
         veltape = .true.
       else
         luv = -1
       endif
       if(luv.lt.0)then
        write(LERR,*)'Unable to open ', vtap
        write(LER, *)'Unable to open ', vtap
        call lbclos(luin)
        stop
       endif
      endif
      if (luin .eq. 0) call sislgbuf(luin,'off')
      nby = 0 
      call rtape(luin,itr,NBY)     
      if (nby.EQ.0) then         
       write(LERR,*)'No line header found on ntap. Fatal!'
       write(LER,*)'No line header found on ntap. Fatal!'
       call lbclos(luin)
       stop
      endif
C   get processing constants from line header
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LINEHEADER)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LINEHEADER)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LINEHEADER)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LINEHEADER)

      LH = LINEHEADER
      TH = TRACEHEADER
      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LH)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsr,LH)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc,LH)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec,LH)
      call saver2(itr,ifmt_Format,l_Format,ln_Format,iform,LH)
      call saver(itr, 'UnitSc', unitsc, LINEHEADER)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINEHEADER)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
C
      nsi = nsr
      delt = float(nsi) * unitsc
      do i = 1,  nsamp
       timvec(i) = float(i) * delt
      end do
      n4 = 6
      call hlhprt (itr,NBY,name,n4, LERR)
      ntbyt = nsamp*iszbyt + sztrhd
                           
      call getln(luout,otap,'w',1)
      if(luout.lt.0)then
       write(LERR,*)'  Unable to open ',otap
       call lbclos(luin)
       stop
      endif
      if(ire.lt.999999.and.irs.gt.0)then
        jnrec=ire-irs+1
        call savew2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,jnrec,LINEHEADER)
      endif

      nout = ntrc
      call savew2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,nout,LINEHEADER)
      call savhlh(itr,nby,jtbyt)
      call wrtape(luout,itr,jtbyt)
c +==================================================+
c | get line header parameters for velocity data set |
c +==================================================+
      if(xt)then
       nby = 0
       call rtape(luv,vitr,nby)
       if(nby.eq.0)then
        write(lerr,*)'EOF on velocity data set reading header. FATAL'
        call lbclos(luin)
        call lbclos(luout)
        if(veltape)call lbclos(luv)
        stop
       endif
       call saver2(vitr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nvsamp,LH)
       call saver2(vitr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsrv,LH)
       call saver2(vitr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrcv,LH)
       call saver2(vitr,ifmt_NumRec,l_NumRec,ln_NumRec,nrecv,LH)
       nsiv = nsrv
       if((nvsamp.ne.nsamp).or. (nsiv  .ne. nsi))then
        write(LERR,*)
     : ' Velocity dataset not compatible with input. Must have same'
         write(LERR,*)
     :' number samples and sample interval. FATAL!'
        write(LER,*)
     : ' Velocity dataset not compatible with input. Must have same'
        write(LER,*)
     :' number samples and sample interval. FATAL!'
        call lbclos(luin)
        call lbclos(luout)
        if(veltape)call lbclos(luv)
        stop
       endif
      endif
C +==================================+
C |   allocate the required memory   |
C +==================================+
      ier = 0
      ner = 0
      iget =nsamp * ntrc * ISZBYT
      call galloc(pdata,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pang, iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pstk  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1

      iget= nsamp*ISZBYT
      call galloc(pvsvpq,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pb0   ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pb1   ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pb2   ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(psig  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvtrms,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvsrms,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvism ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvit  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pc    ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(ptt,iget,ier,0)
      if(ier.ne.0)ner=ner+1

      iget = ITRWRD * ntrc * ISZBYT
      call galloc(ptrhd,iget,ier,0)
      if(ier.ne.0)ner = ner+1

      iget = ntrc*ISZBYT
      call galloc(pdx,iget,ier,0)
      if(ier.ne.0)ner=ner+1

      if(ner.ne.0)then
       write(LERR,*)' Memory allocation failed.  FATAL'
       call lbclos(luin)
       call lbclos(luout)
       stop
      endif

      write(LERR,*)' AGNS Processing Parameters :'
      write(LERR,'(a,i5)')'Start Record ...............',irs
      write(LERR,'(a,i5)')'End Record .................',ire
      if(xt)then
      write(LERR,'(a,i5)')'Mode........................',mode
      write(LERR,'(a   )')'     0 = Straight Ray'
      write(LERR,'(a   )')'     1 = Curved Ray'
      write(LERR,'(a   )')'     2 = Perturbed Curved Ray'
      endif
      write(LERR,'(a,f5.1)')'Start Angle.................',angb
      write(LERR,'(a,f5.1)')'End Angle...................',ange
C               +---------------------------------+
C               |       Begin Process Phase       |
C               +---------------------------------+
c +=================================+
c | Convert limit angles to radians |
c +=================================+
      angb=angb*const
      ange=ange*const
c +=================+
c | go get the data |      
c +=================+
      if(irs.gt.1)then
       do i=1,irs-1
        do j=1,ntrc
         nit = 0
         call rtape(luin,itr,nit)
         if(nit.eq.0)then
          write(LER,*)'EOF on input trying to find rs. Fatal!'
          write(LERR,*)' EOF on input trying to find rs. Fatal!'
          call lbclos(luin)
          call lbclos(luout)
          stop
         endif
        end do
        if(nrecv.gt.1.and.xt)then
         nit = 0
         call rtape(luv,vitr,nit)
         if(nit.eq.0)then
          write(LER,*)'EOF on velocity data set. FATAL!'
          write(LERR,*)' EOF on velocity data set. FATAL!'
          call lbclos(luin)
          call lbclos(luout)
          if(veltape)call lbclos(luv)
          stop
         endif
        endif
       end do
      endif
c +==========================+
c | If have only 1 velocity  |
c | record, read it up front |
c +==========================+
      if(nrecv.eq.1.and.xt)then
       nit = 0
       call rtape(luv,vitr,nit)
       if(nit.eq.0)then
        write(LER,*)'EOF on velocity data set. FATAL!'
        write(LERR,*)' EOF on velocity data set. FATAL!'
        call lbclos(luin)
        call lbclos(luout)
        if(veltape)call lbclos(luv)
        stop
       endif
      end if
c +=================+
c |  Process data   |
c +=================+
      do while (irs.le.ire)
       do j=1,ntrc
        nby = 0   
        CALL rtape (luin,itr,nby)
        if (nby.eq.0) then
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv) 
         stop
        endif
        call saver2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,irec,TH)
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istat,TH)
        ndx = (j-1)*nsamp
        if(istat.ge.30000)then
         do k=1,nsamp
          data(ndx+k)=0.
         end do
        else
         do k=1,nsamp
          data(ndx+k)=Ritr(ithw+k)
         end do
        endif
        call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,idist,TH)
        call saver2(itr,ifmt_DstUsg,l_DstUsg,ln_DstUsg,id2,TH)
        if(xt)then
         idist = iabs(idist)
         dx(j) = idist
        else
         avang = (idist+id2)/2.*const
         do k=1,nsamp
          angles(ndx+k)=avang
         end do
        endif
        jdx = (j-1)*ITRWRD
        do k=1,ITRWRD
         trhd(jdx+k)=itr(k)
        end do
       end do
c +=====================================================+
C | Get the local velocity function if X-T domain input |
c +=====================================================+
       if(xt) then
        if(nrecv.gt.1)then
         nby=0
         call rtape(luv,vitr,nby)
         if(nby.eq.0)then
          write(lerr,*)' EOF on velocity file. FATAL.'
          call lbclos(luin)
          call lbclos(luout)
          if(veltape)call lbclos(luv)
          stop
         endif
        endif
        nv=nsamp
        do i=1,nv
         vel_array(i)=Vtrc(ITHWP1+i-1)
         t_array(i)=i*delt
        end do
        do i=1,nsamp
         sig(i)=1.0
        end do
        chisq = 0.
c +======================================================+
c | Resample the input velocity field to something more  |
c | manageable by the lsq routine in fitvel, then call   |
c | fitvel to get the rms, interval, smoothed rms, and   | 
c | smoothed interval velocities (vtrms, vit, vsrms,     |
c | and vism, respectively)                              |
c +======================================================+
        call sloper(t_array, vel_array, nv,fact)
        call fitvel(t_array, vel_array, nv,nsamp, delt, coefs,
     :   sig,ch,vtrms,vsrms,vism, vit,jerr)
        if(jerr.ne.0)then
         write(lerr,*)' Error allocating memory in getvel. FATAL.'
         write(ler,*)' Error allocating memory in getvel. FATAL.'
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv)
         stop
        endif
       endif
c                                          
c     Go compute the angles and do stacking
c                                       
       if(xt)then
        do i=1,nsamp*ntrc
         angles(i)=0.
        end do
        vtmax = (nsamp-1)*delt
        call GetAngleMatrix(nsamp, coefs, angles, dx,ntrc,delt,timvec,
     :   vtrms,mode,emerg,vtmax,vsrms,vism,vit,ier,errprm)
        if(ier.ne.0)then
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv)
         write(LERR,'(a,i5)')
     :  ' Fatal Error in Velocity Function for Record',irec
          write(LERR,'(a,f8.3,a)')
     :  ' Found imaginary interval velocity at ',errprm(5),' seconds.'
         write(LERR,'(a,f10.0,a,f8.3)')
     :  ' V2 = ',errprm(1),' T2 = ',errprm(3)
         write(LERR,'(a,f10.0,a,f8.3)')
     :  ' V1 = ',errprm(2),' T1 = ',errprm(4)
         write(LERR,*)' coefs'
         call writer(coefs,6,1,LERR)
         write(LERR,*)'vsrms '
         call writer(vsrms,nsamp,1,LERR)
         write(LERR,*)'vism '
         call writer(vism,nsamp,1,LERR)
         write(LERR,*)'vit '
         call writer(vit,nsamp,1,LERR)
         stop
        endif
       endif
       do i=1,nsamp
        vsvpsqr(i) = 1.
       end do
c +----------------------------------------------------+
c | create the B0, B1, and B2 attributes, 3-component  |
c | note that in this call the use of vsvpsqr is used  |
c | only to maintain call capability between subs here |
c | and in program attin.                              |
c +----------------------------------------------------+
       call weightamB0(nsamp,ntrc, data, b0,b1,b2,
     :  vsvpsqr, angles, angb,ange,vism,ierr)
c +----------------------+
c | Build predicted data |
c +----------------------+
       do i=1,nsamp
        a0 = b0(i)
        a1 = b1(i)
        a2 = b2(i)
        do j=1,ntrc
         ndx = (j-1)*nsamp+i
         ang = angles(ndx)
         tang = tan(ang)
         sing = sin(ang)
         rp = 0.
         if(ang.ge.angb.and.ang.le.ange)then
          tang = tang*tang
          sing = sing*sing
          tangsing=tang*sing
          rp = a0 + a1*tang + a2*tangsing
          xr = data(ndx)
          if(xr.eq.0.0)rp = 0.
         endif
         stack(ndx)=rp
        end do
       end do
c +-----------------+
c | Output the data |
c +-----------------+
       do i = 1,nout
        ndx = (i-1)*nsamp
        do k=1,nsamp
         Ritr(ITHWP1+k-1)=stack(ndx+k)
        end do
        jdx = (i-1)*ITRWRD
        do k=1,ITRWRD
         itr(k)=trhd(jdx+k)
        end do
        call wrtape(luout,itr,ntbyt)
       end do   
       irs = irs+1
      end do
      call lbclos(luin)                   
      call lbclos(luout)                   
      if(xt.and.veltape)call lbclos(luv)
      stop
      END                                                    
      subroutine gcmdln(ntap,otap,vtap,rs,re,mode,angb,ange,xt)
#include <f77/iounit.h>
      character ntap*100, otap*100, vtap*100
      character mdc*2,cc*8
      logical xt
      integer rs, re,argis,mode
c                                                         
      call argstr ('-N',ntap,' ',' ')          
      call argstr ('-O',otap,' ',' ')            
      vtap = ' '
      call argstr ('-v',vtap,' ',' ')
      call argi4('-rs', rs, 0,0)
      if(rs.eq.0)rs=1
      call argi4('-re', re, 0,0)
      call argstr('-md',mdc,' ',' ')
      if(mdc.eq.'0'.or.mdc.eq.'1'.or.mdc.eq.'2')then
        read(mdc,'(I1)')mode
      else
        mode = -1
      endif
      if(mode.gt.2)mode = 0
      call argr4('-as',angb,0.0,0.0)
      call argr4('-ae',ange,0.0,0.0)
      call argstr('-c',cc,' ',' ')
      if(cc.ne.' ')then
       read(cc,'(f8.0)')c
      else
       c = 0.25
      endif
      xt = (argis('-xt').gt.0)
      return                                                  
      end
      subroutine help(LER,n)
          write(LER,*)  
     :'***************************************************************'
         write(LER,*)
     :'Program angsyn............Angle-dependent amplitude prediction '
      call describe
      write(LER,*)' '                                             
      write(LER,*)                                               
     :' -N[ntap]    (default = stdin)  : Input data file name'   
      write(LER,*)                                             
     :' -O[otap]    (default = stdout) : Output data file name'
      write(LER,*)                                             
     :' -v[vtap]    (required for XT)  : RMS velocity (Vp) file'   
      write(LER,*)
     :' -rs[irs]  (default = first)    : Starting sequential record'
      write(LER,*)
     :' -re[ire]  (default = last)     : Ending sequential record'
      write(LER,*)
     :' -as[as]      (default = 0)     : Beginning angle for compute'
      write(LER,*)
     :' -ae[ae]      (default = 45)    : Ending angle for compute'
      write(LER,*)
     :' -md[mode] (default = 1 for     : Solution flag for angle comp.'
      write(LER,*)
     :'                                  for XT-domain data'
      write(LER,*)
     :'            XT-domain input)      0 = Straight Ray'
      write(LER,*)
     :'                                  1 = Curved Ray'
      write(LER,*)
     :'                                  2 = Perturbed Curved Ray'
      write(LER,*)
     :' -xt         (default =  no)    : If present, input data is'
      write(LER,*)
     :'                                  X-T domain instead of angle-T'
      write(LER,*)' '
      write(LER,*)                                        
     :'Usage:  ',                                         
     :' angsyn -N[] -O[] -v[] -rs[] -re[] -as[] -ae[] -md[] -xt '
      return                                                          
      end                                                            
