C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine nmosub(iuin,uin,iuout,uout,
     1                  t0,t02,tnmo,
     2                  slow,slow2,v,dt,
     2                  wgt,jleft,jdiv,adiv,ndiv,
     3                  irs,ire,ns,ne,ntrc,obytes,remove,stat,
     4                  minsamp,nsamp,nsampin,nsampout,nsamporig,
     5                  vrs,vre,nrecv,vflag,ntrcv,factor,
     6                  hbegin,lenhed,lerr,luin,luout,luvel,
     7                  t0irreg,top2bot,bot2top,linear,
     8 ifmt_StaCor,l_StaCor,ln_StaCor,ifmt_DstSgn,l_DstSgn,ln_DstSgn)
c
#include <save_defs.h>

      integer   hbegin
      integer   iuin(*),iuout(*)
      real      uin(hbegin:nsampin)
      real      uout(hbegin:nsampout)
      real      v(hbegin:nsamporig)
      real      slow(0:nsamporig-1)
      real      slow2(0:nsamporig-1)
      real      t0(0:nsamporig-1)
      real      t02(0:nsamporig-1)
      real      tnmo(0:nsamporig-1)
      real      t0irreg(0:nsamporig-1)
      real      wgt(*)             
      integer   jleft(0:nsamporig-1),jdiv(0:nsamporig-1)
c
      integer irs,ire,ns,ne
      integer vrs,vre,nrecv,ntrcv,vflag
      integer obytes
      integer l_StaCor                             
      logical stat,remove
      logical top2bot,bot2top
      logical linear             
C______________________________________________________________________
C     calculate (only once):
c  
c     t0........the normal incidence time
c     t02.......the normal incidence time squared
c______________________________________________________________________
      do 10000 k=0,nsamporig-1
       t0(k)=k
       t02(k)=t0(k)**2
10000 continue
c______________________________________________________________________
c     skip past velocity records:
c______________________________________________________________________
      nvbytes=1
      if(vflag .eq. 1) then
c______________________________________________________________________
c        multiple velocity functions
c______________________________________________________________________
         if(vrs .le. nrecv) then
            call recskp(1,vrs-1,luvel,ntrcv,v(hbegin))
         else
            write(lerr,*)'start record to skip to exceeds number'
            write(lerr,*)'records on velocity file'
            write(lerr,*)'check velin run to make sure your velocity'
            write(lerr,*)'model covers the part of the data between'
            write(lerr,*)'records ',vrs,' and ', vre
            write(lerr,*)'program terminated in routine nmosub'
            call exit(5666)
         endif
      elseif (vflag .eq. 0) then
c______________________________________________________________________
c        single velocity function:  read him right away
c______________________________________________________________________
         nvbytes=0
         call rtape(luvel,v(hbegin),nvbytes)
         if(nvbytes .eq. 0) then
            write(lerr,*)'End of file on velocity file: FATAL'
            write(lerr,*)'single velocity function anticipated'
            write(lerr,*)'program terminated in routine nmosub'
            call exit(6666)
         endif
c_____________________________________________________________________
c         heuristic to check for valid velocities.
c_____________________________________________________________________
          call dotpr (v(1),1,v(1),1,vdot,nsamporig)
          if(abs(vdot) .lt. 1.e-06) then
             write(lerr,*)'Velocity trace contains zeros'
             write(lerr,*)'---    FATAL  ---'
             write(lerr,*)'Check the velin step thoroughly'
             go to 99999
          endif
C______________________________________________________________________
C         calculate the slowness and slowness squared:
C______________________________________________________________________
          do 20001 k=0,nsamporig-1
           slow(k)=1./v(k+1)
           slow2(k)=1./v(k+1)**2
20001     continue
      endif
c______________________________________________________________________
c     skip past seismic records:                             
c______________________________________________________________________
      call recskp(1,irs-1,luin,ntrc,uin(hbegin))
c--------------------------------------------------------------------
c     loop over record/gathers to process.
c--------------------------------------------------------------------
      nvbytes=1
      do 90000 irec=irs,ire
       if(vflag.eq.1 .and. nvbytes.ne.0 .and. irec.le.vre) then
c_____________________________________________________________________
c         read in the next velocity trace.
c         don't  stop the program if we run out.                       
c_____________________________________________________________________
          nvbytes=0
          call rtape(luvel,v(hbegin),nvbytes)
c_____________________________________________________________________
c         heuristic to check for valid velocities.
c_____________________________________________________________________
          call dotpr (v(1),1,v(1),1,vdot,nsamporig)
          if(abs(vdot) .lt. 1.e-06) then
             write(lerr,*)'Velocity trace contains zeros'
             write(lerr,*)'---    FATAL  ---'
             write(lerr,*)'Check the velin step thoroughly'
             go to 99999
          endif
C______________________________________________________________________
C         calculate the slowness squared:             
C______________________________________________________________________
          do 20000 k=0,nsamporig-1
           slow(k)=1./v(k+1)
           slow2(k)=1./v(k+1)**2
20000     continue
       endif
c______________________________________________________________________
c      skip over beginning undesired traces in this seismic gather.
c______________________________________________________________________
       call trcskp(irec,1,ns-1,luin,ntrc,uin(hbegin))
c______________________________________________________________________
c      process traces that fall within the processing window.
c______________________________________________________________________
       do 30000 itrace=ns,ne
        nbytes = 0
        call rtape(luin,uin(hbegin),nbytes)
        if(nbytes .eq. 0) then
           write(lerr,*)'End of file on input:'
           write(lerr,*)'  rec= ',irec,'  trace= ',itrace
           go to 99999
        endif

        call saver2(iuin,ifmt_StaCor,l_StaCor, ln_StaCor,
     1              istatic, 1)
        call saver2(iuin,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1              idis   , 1)
        x = idis
        if(istatic .ne. 30000)then
c_____________________________________________________________________
c          live trace.
c          check if we wish to apply static correction.
c______________________________________________________________________
           if(stat) then
              tstatic=float(istatic)/dt
           else
              tstatic=0.
           endif
           if(.not. remove) then

C______________________________________________________________________
C             perform the forward nmo correction.                 
c______________________________________________________________________
              call nmof(uin(1),uout(1),dt,minsamp,nsamporig, 
     1                  x,v(1),slow,slow2,t0,t02,tnmo,tstatic,factor,
     2                  jleft,wgt,jdiv,ndiv,adiv,linear)
           else
c______________________________________________________________________
c             perform the reverse nmo correction.                 
c______________________________________________________________________
              call nmor(uin(1),uout(1),dt,minsamp,nsamporig,
     1                  x,v(1),slow,slow2,t0,t02,tnmo,tstatic,factor,
     2                  t0irreg,wgt,ndiv,adiv,bot2top,top2bot,
     3                  jleft,jdiv,linear) 

           endif
        else
c_____________________________________________________________________
c          dead trace. zero it out.
c______________________________________________________________________
           call vclr(uout(1),1,nsampout)
        endif
c______________________________________________________________________
c       copy the input trace header to the output trace.
c       write out the output trace header and data.                        
c______________________________________________________________________
        call vmov(uin(hbegin),1,uout(hbegin),1,lenhed)
        call wrtape(luout,uout(hbegin),obytes)
30000  continue
c______________________________________________________________________
c      skip over ending undesired traces in this seismic gather.
c______________________________________________________________________
       call trcskp(irec,ne+1,ntrc,luin,ntrc,uin(hbegin))
90000 continue
99999 continue
c
      return
      end
