C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  append
C
C**********************************************************************C
C
C APPEND READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C and puts it at the end of the data set specified as the output file
C after adjusting the line header accordingly.  This appending process
C is done on a record basis.  The traces/rec, samples/trace, etc, for each
C data set are assumed to be the same.
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR  ( SZLNHD )
      INTEGER     ITRO ( SZLNHD )
      INTEGER     LHED ( SZLNHD ),luin,lhedo(SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUOUT, LBYTES, NBYTES,obytes
      integer     argis
#include <f77/pid.h>
      CHARACTER   NAME * 5, otap * 256, ntap *256
      logical verbos,query,rnum
 
      EQUIVALENCE ( ITR (  1), LHED (1) )
      EQUIVALENCE ( ITRO(  1), LHEDO(1) )
      DATA NAME     /'APEND'/
      DATA  LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./, rnum/.false./

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help()
          stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     get command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,rnum,verbos)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER, save key parameters,
C     WRITE LINE HEADER
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      if(otap .eq. ' ') then
         write(LERR,*)'Output data set cannot be a pipe -- FATAL'
         write(LERR,*)'use a named file after -O'
         write(LERR,*)'then rerun job'
         stop
      endif
 
         call lbopen(luout,otap,'a+')
      if(luout.lt.0)then
         write(LERR,*)' UNABLE OPEN O FILES - STOP'
         stop
      endif
      lbytes=0
      CALL RTAPE  ( LUIN, ITR, LBYTES                  )
      if(lbytes .eq. 0) then
         write(LERR,*)'APEND: no header read on input unit ',luin
         write(LERR,*)'for data set ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'check existence of file & rerun'
         stop
      endif
#include <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)

      CALL HLHprt    ( ITR , LBYTES, NAME, 5,        LERR )
c------------------------------------------
c  check to see if output data set exists
c------------------------------------------
      lbyteso=0
      CALL RTAPE  ( LUOUT, ITRO, LBYTESO                 )
c----------------------------------------------------------------------
c   if no output data set exists then create one based on the input data
c   set
c----------------------------------------------------------------------
      if(lbyteso .eq. 0) then
        call rwd(luout)
        call wrtape(luout,itr,lbytes)
        nreco = 0
      else
         call saver(itro, 'NumSmp', nsampo, LINHED)
         call saver(itro, 'SmpInt', nsio  , LINHED)
         call saver(itro, 'NumTrc', ntrco , LINHED)
         call saver(itro, 'NumRec', nreco , LINHED)
         call saver(itro, 'Format', iformo, LINHED)
        if(nsamp .ne. nsampo) then
           write(LERR,*)'input/output samples per trace not equal'
           write(LERR,*)'FATAL'
           stop
        endif
        if(nsi .ne. nsio) then
           write(LERR,*)'input/output sample interval not equal'
           write(LERR,*)'FATAL'
           stop
        endif
        if(ntrc .ne. ntrco) then
           write(LERR,*)'input/output number of traces/rec not equal'
           write(LERR,*)'FATAL'
           stop
        endif
      endif
      nrecc = nrec + nreco
       call savew( itro, 'NumRec', nrecc, LINHED)
      nbyte = SZDTHD + SZSMPD * nsamp
      obytes = SZTRHD + SZSMPD * nsamp

c---------------------------------------------------
c  verbos printout if desired
c---------------------------------------------------
      if( verbos ) then
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Traces per Record = ', ntrc
         write(LERR,*)'  Output Records= ',nrecc
      endif

c-----------------------------------------------------------------------
c   if there first exists an otap then...
c   rewind otap & write modified trace header.  then rewind again, read
c   pass the modified line header and then skip to the end of the file
c   this should be ok since the historical line header is not being
c   so that the line header will remain the same length
c-----------------------------------------------------------------------
      if(lbyteso .ne. 0) then
        call rwd(luout)
        CALL WRTAPE ( LUOUT, ITRO, LBYTESO                )
c       call rwd(luout)
        write(LERR,*)'Appending input data to output data set'
        write(LERR,*)'skipping ',nreco,' records with ',ntrc,' traces to
     &  end of current output file'
        call skipt(luout,ntrc*nreco,idummy)
      endif
C**********************************************************************C
C
C     Now we read data off NTAP and append it to the end of OTAP
C
C**********************************************************************C

      DO 100 JJ = 1, NREC
         DO 99 KK = 1, ntrc
           nbytes = 0
           CALL RTAPE  ( LUIN , ITRO, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif

               call saver2(lhedo,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     irec , TRACEHEADER)
               call saver2(lhedo,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     itrc , TRACEHEADER)

              if(verbos) then
              write(LERR,*)'LUIN= ',luin,' Trace= ',itrc
              endif
c   adjust record numbers
              if(rnum) then
                 irec = nreco + jj
                 call savew2(lhedo,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                       irec , TRACEHEADER)
              endif
 
                call wrtape(luout,itro,nbytes)
              if(verbos) then
                 write(LERR,*)'LUOUT= ',luout,' Trace= ',itrc
              endif
 
   99    continue
  100 CONTINUE

  999 continue
         call lbclos(luin)
         call lbclos(luout)
      END

c-------------------------------------
c  online help
c-------------------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for APEND: append a data set
     &'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set:  can be a pipe'
        write(LER,*)'-O[otap]   -- output data set: cannot be a pipe'
        write(LER,*)' '
        write(LER,*)' the records of ntap are placed at the end of the'
        write(LER,*)' the file otap.  traces/rec, samples/trace, etc of'
        write(LER,*)' both files are assumed the same'
        write(LER,*)' '
        write(LER,*)'-R         -- renumber output record numbers'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        apend -N[] -O[] [-R -V]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c    rnum   - L      renumber output data
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,rnum,verbos)
      integer    argis
      character  ntap*(*), otap*(*)
      logical    rnum, verbos

               call argstr('-N',ntap,' ',' ')
               call argstr('-O',otap,' ',' ')
               rnum = (argis('-R') .gt. 0)
               verbos = (argis('-V') .gt. 0)

      return
      end
