C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ManualLoad(luplotxy,XgraphIndex,CumShotStatic,
     :     SmoothedCumShotStatic,CumSmoothedDiff,work1,work2,nrec)

#include <f77/iounit.h>

      integer luplotxy,nrec,NN1,NN2,ierr,XgraphIndex(*),X

      real CumShotStatic(*),SmoothedCumShotStatic(*)
      real CumSmoothedDiff(*),work1(*),work2(*),slope

c     read index and cum static curve from xgraph file

      call GetPlotXY(luplotxy,work1,CumShotStatic,NN1,ierr)
      if(ierr.gt.1)then
         write(LERR,*) 'SARCS: error reading plotxy file'
         write(LERR,*) 'FATAL'
         write(LERR,*) ' '
         stop
      endif

      do i = 1,NN1
         XgraphIndex(i) = nint(work1(i))
      enddo

      nrec = NN1

c read manual fit curve

      call GetPlotXY(luplotxy,work1,work2,NN2,ierr)
      if(ierr.gt.1)then
         write(LERR,*) 'SARCS: error reading plotxy file'
         write(LERR,*) 'FATAL'
         write(LERR,*) ' '
         stop
      endif

c fill out manual curve for all entries

      do 10 i = 1,nrec

         X = XgraphIndex(i)
         if(X.le.nint(work1(1)))then
            SmoothedCumShotStatic(i) = work2(1)
            goto 10
         elseif(X.ge.nint(work1(NN2)))then
            SmoothedCumShotStatic(i) = work2(NN2)
            goto 10
         else

            do j= 2,NN2
               
               if(X.le.nint(work1(j)))then
                  slope = (work2(j) - work2(j-1))/(work1(j)-work1(j-1))
                  SmoothedCumShotStatic(i) = work2(j-1) + slope * 
     :                 (X-work1(j-1))
                  goto 10
               endif

            enddo

         endif

 10   continue

c calculate difference curve

      do i = 1,nrec

         CumSmoothedDiff(i) = CumShotStatic(i)-SmoothedCumShotStatic(i)

      enddo

      return
      end
      
