C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadCrossPicks(lucrosspick,CrossPicks,CrossPickLocation
     :     ,CrossIndex,nsegsCross)


#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer lucrosspick,nsegsCross,CrossIndex(nsegsCross)
      integer pointer, nelem, count
      real CrossPickLocation(2*SZLNHD),strc
      real CrossPicks(2*SZLNHD),rec_units,trc_units,samp_units

      character junk*1

c initialize counters
      
      count = 1
      nelem = 0
      nsegsCross = 1
      pointer = 0

c rewind file

      rewind lucrosspick

c read past file header

      read(lucrosspick,'(a1,4x,3f13.7)')junk,rec_units,trc_units,
     :     samp_units

c read past segment header

      read(lucrosspick,'(a1)',end=900)junk

c read first segment

 1    read(lucrosspick,'(a1)',end=20)junk

      if(junk.ne.'S') then
         nelem = nelem + 1
         goto 1
      else
         CrossIndex(nsegsCross) = nelem
         write(LERR,*) ' segment number : ', nsegsCross 
         write(LERR,*) ' number of elements : ', nelem 

c	advance segment register and reset element counter

         nsegsCross = nsegsCross + 1
         nelem = 0

c start next segment

         goto 1
      endif

c have reached end of pick file assign number of elements for last segment

 20   CrossIndex(nsegsCross) = nelem
      
      write(LERR,*) ' segment number : ', nsegsCross 
      write(LERR,*) ' number of elements : ', nelem 

c now know total number of segments and number of elements in each
	
      rewind lucrosspick

c read and load each segment

      read(lucrosspick,'(a1)') ajunk

c SEGMENT LOOP

      do 30 i = 1,nsegsCross

c read past segment header

         read(lucrosspick,'(a1)') ajunk

c ELEMENT LOOP

         do 40 j = 1,CrossIndex(i)

c multi-record single trace

            read ( lucrosspick, *, end=900 ) CrossPickLocation(count), 
     :           strc, CrossPicks(count)

c advance the array element counter

            count = count + 1

 40      continue

 30   continue

 900  continue

c sort horizon entries by increasing CrossPickLocation() index

      do i = 1,nsegsCross
         pointer = pointer + 1
         call hsort2 (CrossIndex(i),CrossPickLocation(pointer),
     :        CrossPicks(pointer))
         pointer = pointer + CrossIndex(i) - 1
      enddo

c echo picks read to printout file

        pointer = 0
        do i = 1,nsegsCross
           write(LERR,*)' Segment ',i 
           write(LERR,*)' Record           Time'
           do j = 1,CrossIndex(i)
              pointer = pointer + 1
              write(LERR,*) CrossPickLocation(pointer),
     :             CrossPicks(pointer)
           enddo
        enddo
      return
      end
 
