C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine XgraphOut(luout,Cumulative,Smoothed,Static,Xaxis,
     :     CrossCorrAmp,nelem)

c -----
c
c     Routine to build and output xgraph format file plottable using 
c     xgraph to show the cumulative static curve, the current fit to it
c     and the resulting static application profile
c
c -----

      integer luout,nelem,Xaxis(*)

      real Cumulative(nelem), Smoothed(nelem), Static(nelem) 
      real CrossCorrAmp(nelem)

      character CumShotStat*23, SmoothFit*11, CalcShotStat*23
      character CrossCorAmp*28

      CumShotStat = '"Cumulative Shot Static'
      SmoothFit = '"Smooth Fit'
      CalcShotStat = '"Calculated Shot Static'
      CrossCorAmp = '"Cross Correlation Amplitude'

c -----
c
c     output curve 1 : cumulative record to record static
c
c -----

      write(luout,'(a23)') CumShotStat
      write(luout,100)(float(Xaxis(i)),Cumulative(i),i=1,nelem)
 100  format(f15.3,2x,f15.3)

      write(luout,110)
 110  format(/)

c -----
c
c     output curve 2: smoothed fit to cumulative shot static
c
c -----

      write(luout,'(a11)') SmoothFit
      write(luout,100)(float(Xaxis(i)),Smoothed(i),i=1,nelem)
      write(luout,110)

c -----
c
c     output curve 3: calculated shot static
c
c -----

      write(luout,'(a23)') CalcShotStat
      write(luout,100)(float(Xaxis(i)),Static(i),i=1,nelem)
      write(luout,110)

c -----
c
c     output curve 4: cross correlation amplitude at static
c
c -----

      write(luout,'(a28)') CrossCorAmp
      write(luout,100)(float(Xaxis(i)),
     :     CrossCorrAmp(i)*10.,i=1,nelem)

      return
      end
