C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, xytap, irs, ire, ns, ne, start,  
     :     end, nsamp, nsampo, ntrc, ntrco, nsi, nrec, nreco, iform, 
     :     ShotWord, GroupWord, StaticWord, QC, SmoothOrder, verbos ) 

c     verbose output of processing parameters

#include <f77/iounit.h>
 
      integer  irs, ire, ns, ne, start, end, nsamp, nsampo, ntrc, ntrco
      integer  nsi, nrec, nreco, iform, SmoothOrder, length

      character   ntap*(*), otap*(*), StaticWord*(*), ShotWord*(*)
      character   GroupWord*(*), xytap*(*)

      logical QC, verbos
 
      write(LERR,*)' '
      write(LERR,*)' Input line header values '
      write(LERR,*) ' # of samples/trace   =  ', nsamp
      write(LERR,*) ' sample interval      =  ', nsi
      write(LERR,*) ' traces per record    =  ', ntrc
      write(LERR,*) ' records per line     =  ', nrec
      write(LERR,*) ' format of data       =  ', iform
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name  =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set       =  stdin'
      endif
      write(LERR,*)' '
      if ( .not. QC ) then
         write(LERR,*)' Output line header values '
         write(LERR,*) ' # of samples/trace   =  ', nsampo
         write(LERR,*) ' sample interval      =  ', nsi
         write(LERR,*) ' traces per record    =  ', ntrco
         write(LERR,*) ' records per line     =  ', nreco
         write(LERR,*) ' format of data       =  ', iform
      else
         write(LERR,*)' Output Xgraph QC file values '
         write(LERR,*) ' records per line     =  ', nreco
      endif
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name =  ', otap(1:length)
      else
        write(LERR,*) ' output data set       =  stdout'
      endif
      write(LERR,*)' '
      if ( xytap .ne. ' ' )  then
         length = lenth(xytap)
         write(LERR,*)' Datum solution read from ',xytap(1:length)
         write(LERR,*)' Smoothing Order       =  ',SmoothOrder
      endif
      write(LERR,*)' '
      write(LERR,*)' Command Line Entries'
      write(LERR,*) ' Start Record = ', irs
      write(LERR,*) ' End Record = ', ire
      write(LERR,*) ' Start Trace = ', ns
      write(LERR,*) ' End Trace = ', ne
      write(LERR,*) ' Start Sample = ', start
      write(LERR,*) ' End Sample = ', end
      write(LERR,*) ' Static Mnemonic = ', StaticWord
      write(LERR,*) ' Shot Static Mnemonic = ', ShotWord
      write(LERR,*) ' Group Static Mnemonic = ', GroupWord

      if ( verbos ) write(LERR,*)' Verbos printout requested'
      return
      end


