C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine SS_map (nsi, nsamp, npoints, Datum, Horizon, MapTrace)

c routine to calculate the stretch-squeeze map required to perform
c the structural correction to a given record where the horizon information
c is contained in Horizon() and datum information is in Datum().  
c There are npoints [horizon,datum] pairs to consider.  The stretch/squeeze map is
c in MapTrace().

c variables passed from calling routine

      integer nsi, nsamp, npoints

      real Datum(npoints), Horizon(npoints), MapTrace(nsamp)

c local variables

      integer pointer

      real SI, tsamp
      real DatumLast, DatumNext, HorizonLast, HorizonNext

c initialize variables

      SI = float(nsi)
      pointer = 1
      call vclr ( MapTrace, 1, nsamp )

      DO i = 1, nsamp
         
         tsamp = float(i)

         IF( tsamp .lt. Datum(pointer)
     :        .and.
     :        tsamp .lt. Datum(npoints)
     :        .and.
     :        pointer .eq. 1 ) then

c            DatumLast = SI
            DatumLast = 1
            DatumNext = Datum(pointer)
            HorizonLast = DatumLast
            HorizonNext = Horizon(pointer)
            MapTrace(i) = HorizonLast +  ( HorizonNext - HorizonLast ) *
     :           ( tsamp - DatumLast ) / ( DatumNext - DatumLast )
            
         ELSEIF( tsamp .lt. Datum(pointer)
     :           .and.
     :           tsamp .lt. Datum(npoints) ) then
            
            DatumLast = Datum(pointer-1)
            DatumNext = Datum(pointer)
            HorizonLast = Horizon(pointer-1)
            HorizonNext = Horizon(pointer)
            MapTrace(i) = HorizonLast +  ( HorizonNext - HorizonLast ) *
     :           ( tsamp - DatumLast ) / ( DatumNext - DatumLast )
            
         ELSEIF( tsamp .ge. Datum(pointer)
     :           .and.
     :           pointer .lt. npoints ) then
            
            pointer = pointer + 1
            DatumLast = Datum(pointer-1)
            DatumNext = Datum(pointer)
            HorizonLast = Horizon(pointer-1)
            HorizonNext = Horizon(pointer)
            MapTrace(i) = HorizonLast +  ( HorizonNext - HorizonLast ) *
     :           ( tsamp - DatumLast ) / ( DatumNext - DatumLast )
            
         ELSEIF( tsamp .ge. Datum(pointer)
     :           .and.
     :           pointer .eq. npoints ) then
            
            DatumLast = Datum(pointer)
            DatumNext = float(nsamp)
            HorizonLast = Horizon(pointer)
            HorizonNext = DatumNext
            MapTrace(i) = HorizonLast +  ( HorizonNext - HorizonLast ) *
     :           ( tsamp - DatumLast ) / ( DatumNext - DatumLast )
            
         ENDIF

         MapTrace(i) = MapTrace(i)

      ENDDO            

      return
      end
