C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  ARDE: AutoRegressive DEconvolution
C
C**********************************************************************C
C
C ARDE READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C estimates an AR polynomial of a given order to the data, applies it, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, ARDEC
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis, ist, iend, nst, ned, nrst, nred
      integer     nfilt, iwin, inc, ntr, nrecc
      integer     idist, istv, iendv, nsampk, nsampo

      REAL xtr( SZLNHD ), ytr(SZLNHD)
      real vel, dt, veldt, dist, unitsc

      CHARACTER   NAME*4, ntap*256, otap*256

      logical     verbos

      EQUIVALENCE ( ITR(1), LHED(1) )

      DATA NAME     /'ARDE'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      data verbos/.false./

c---------------------------------------
c  get online help if necessary
c---------------------------------------
      if ( argis( '-?' ) .gt. 0 .or. 
     :     argis( '-h' ) .gt. 0 .or. 
     :     argis( '-help' ) .gt. 0 ) then
         call help ()
         stop
      endif
      
c---------------------------------------
c  open printout
c---------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     get command line paramters
C**********************************************************************C
      call cmdln (ntap,otap,ist,iend,nst,ned,nrst,nred,
     &            vel,nfilt,iwin,inc,verbos)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )
      lbytes=0
      CALL RTAPE  ( LUIN, ITR, LBYTE          )
      if(lbyte .eq. 0) then
         write(LERR,*)'ARDE: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
c----------------------------
c  save key parameters
cmam...jan 27, 1998....this was missing...
      call saver(itr, 'NumSmp', nsamp , LINEHEADER)
      call saver(itr, 'SmpInt', nsi   , LINEHEADER)
      call saver(itr, 'NumTrc', ntrc  , LINEHEADER)
      call saver(itr, 'NumRec', nrec  , LINEHEADER)
      call saver(itr, 'Format', iform , LINEHEADER)
      call saver(itr, 'UnitSc', UnitSc, LINEHEADER)

#include <f77/saveh.h>
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      CALL HLHprt    ( ITR , LBYTE, NAME, 4, LERR)

      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
c---------------------------------------
c  check defaults & adjust line header

      call cmdchk ( nst, ned, nrst, nred, ntrc, nrec )

      ntr=ned-nst+1
       call savew( itr, 'NumTrc', ntr  , LINHED)
      nrecc=nred-nrst+1
       call savew( itr, 'NumRec', nrecc, LINHED)

c---------------------------------
c  print line header values
      if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform
      endif

C**********************************************************************C
C     CHECK DEFAULTS AND SET PARAMETERS
C**********************************************************************C

cmam...jan 27, 1998....this was missing...
c check header for units scaling.  Using UnitSc, remember
c that UnitSc default is milliseconds [i.e. 0.001] and UnitSc
c is a floating point variable.  A UnitSc entry of 1.0 would
c mean units are in seconds.  A UnitSc entry of 0 indicates that
c the unit was not defined.  In this case milliseconds are
c assumed and loaded to the header for further processing.
 
      if ( UnitSc .eq. 0.0 ) then
         write(LERR,*)'********************************************'
         write(LERR,*)'WARNING: sample unit scaler in LH = ',UnitSc
         write(LERR,*)'         will set to .001 (millisec default)'
         write(LERR,*)'********************************************'
         UnitSc = 0.001
         call savew ( itr, 'UnitSc', UnitSc, LINHED)
      endif

      dt = float(nsi) * unitsc

      iend = iend / nsi + .5
      ist  = ist / nsi

c convert iwin and inc to samples

      iwin = nint ( float (iwin) * unitsc / dt )
      inc  = nint ( float (inc) * unitsc / dt )

      if(iwin .lt. 1) then
        write(LERR,*)'Window length lt 1  -- FATAL'
        write(LER ,*)'Window length lt 1  -- FATAL'
        stop
      endif

      if(iwin .gt. nsamp) then
        write(LERR,*)'Window length gt # samps/trc  -- FATAL'
        write(LER ,*)'Window length gt # samps/trc  -- FATAL'
        if ( verbos) then
           write(LER,*)' iwin = ',iwin,' nsamp = ',nsamp
           write(LER,*)' nsi = ',nsi,' dt = ',dt
        endif
        stop
      endif

      if(inc .lt. 1) inc=1
      if(ist .le. 1) ist=1
      if(iend .eq. 0) iend=nsamp
      if(iend .gt. nsamp) iend=nsamp
      veldt  = vel * dt
      nsampo = iend - ist + 1
      call savew( itr, 'NumSmp', nsamp, LINHED)
      obytes = SZTRHD + SZSMPD * nsamp

c--------------------------------------
c  update historical line header
      call savhlh ( itr, lbyte, lbyout )
      CALL WRTAPE ( LUOUT, ITR, LBYOUT )

c------------------------------------------
c  print header values after default check
c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntr 
        write(LERR,*) ' Records per Line   =  ', nrecc
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) 'Number of filter points =  ',nfilt
        write(LERR,*) 'Window length (pts)  =  ',iwin
        write(LERR,*) 'Window increment (pts) =  ',inc
        write(LERR,*) 'Design Window velocity =  ',vel
c     endif

c-------------------------------------
c  skip to start record
      call recskp(1,nrst-1,luin,ntrc,itr)

C**********************************************************************C
C
C     READ TRACE, DO ARDE, WRITE TO OUTPUT FILE
C
C**********************************************************************C
      DO 100 JJ = NRST, NRED
c--------------------------------------
c  skip to start trace of this record
         call trcskp(jj,1,nst-1,luin,ntrc,itr)

         DO 99 KK = NST, NED

            nbytes = 0
            CALL RTAPE  ( LUIN , ITR, NBYTES         )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)

            call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1           irec   , TRACEHEADER)
            call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           istatic, TRACEHEADER)
            call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1           idist  , TRACEHEADER)
 
            IF ( istatic .ne. 30000 ) THEN

               dist = abs( float(idist) )
               istv = ist + nint ( dist / veldt )
               iendv = istv + nsampo -1
               if (iendv .le. nsamp) then
                  nsampk = nsampo
               else
                  nsampk = nsamp - istv + 1
               endif

               call vmov ( xtr(istv),1,ytr,1,nsampk)
               call ardec (ytr, nsamp, xtr(istv), nfilt, iwin, inc)

            ENDIF

            call vmov (xtr, 1, lhed(ITHWP1), 1, nsamp)
            call wrtape(luout,itr,obytes)
 
 99      CONTINUE

         if(verbos) then
            write(LERR,*)'Output Record ',irec
         endif

c--------------------------------------
c  skip to end trace of this record
         call trcskp(jj,ned+1,ntrc,luin,ntrc,itr)

 100  CONTINUE

 999  continue
      call lbclos(luin)
      call lbclos(luout)
      stop
      END

c----------------------------------
c  online help section
c----------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for ARDE: autoregresv decon'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-s[ist]    -- filter start time             (0 ms)'
        write(LER,*)'-e[iend]   -- filter end time          (last samp)'
        write(LER,*)'-v[vel]    -- design window velocity        (flat)'
        write(LER,*)'-ns[nst]   -- start trace number        (first tr)'
        write(LER,*)'-ne[ned]   -- end trace number           (last tr)'
        write(LER,*)'-rs[nrst]  -- start record             (first rec)'
        write(LER,*)'-re[nred]  -- end record                (last rec)'
        write(LER,*)'-f[nfilt]  -- number of filter points        ( 4 )'
        write(LER,*)'-w[iwin]   -- window length [max 500 ms]'
        write(LER,*)'-i[inc]    -- window increment [ms]         ( dt )'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      arde -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[]'
        write(LER,*)'           -re[] -f[] -w[] -i[] -v[] -V'
        write(LER,*)' '
        
      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start time
c    iend   - I      stop time
c     nst   - I      start trace
c     ned   - I      stop end trace
c    nrst   - I      start record
c    nred   - I      stop end record
c     vel   - R      design window velocity
c   nfilt   - I      number filter points
c    iwin   - I      length of ar window
c     inc   - I      time between filter updates
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,ist,iend,nst,ned,nrst,nred,
     &            vel,nfilt,iwin,inc,verbos)
#include <f77/iounit.h>
      character ntap*(*), otap*(*)
      integer   argis,ist,iend,nst,ned,nrst,nred,nfilt,iwin,inc
      logical   verbos

          call argstr('-N',ntap,' ',' ')
          call argstr('-O',otap,' ',' ')
          call argi4('-s',ist,1,1) 
          call argi4('-e',iend,0,0) 
          call argi4('-ns',nst,0,0)
          call argi4('-ne',ned,0,0)
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)
          call argi4('-f',nfilt,4,4)
          call argi4('-w',iwin,0,0)
          call argi4('-i',inc,1,1)
          call argr4('-v',vel,99999.,99999.)
          verbos = ( argis( '-V' ) .gt. 0 )
          if(iwin .eq. 0) then
             write(LERR,*)'No window legth given  -- FATAL'
             stop
          endif

      return
      end
