C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c arnmo reads nmo corrected seismic trace gathers from an input file,
c uses a near offset reference trace in a crosscorrelation operation
c to derive a time varying rnmo correction for the non-near offsets &
c writes the slope & intercept as seismic trace pairs to the output
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
c-----
 
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD)
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     rnsamp, rnsi, rntrc, rnrec
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne
      integer     pipe, lutim

c------
c  static memory allocation
c     real        bigar1(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation for big arrays, eg whole records
      real        bigar1, bigar2, tarray, tabl1, tabl2, work
      pointer     (wkadr1, bigar1(1))
      pointer     (wkadr2, bigar2(1))
      pointer     (wkadrt, tarray(1))
      pointer     (wkadt1, tabl1 (1))
      pointer     (wkadt2, tabl2 (1))
      pointer     (wkadrw, work  (1))
      integer     hdrs
      pointer     (wkadrh, hdrs  (1))
      real        lilar
      pointer     (wkadr, lilar(1))
c------

c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     recnum, trcnum, static
      real        tri ( SZLNHD ), dists ( SZLNHD )
      real        wrk ( SZLNHD )
      real        weight ( SZLNHD )
      integer     dedtrc ( SZLNHD )
      character   ntap * 256, otap * 256, name*6, hdrwrd * 6
      character   rtap * 256
      logical     verbos, query, heap1, smootht, ornmo, irnmo
      logical     smoothx
      integer     argis, errcod1, errcod2, abort
 
c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'ARNMO'/
      data abort / 0 /
      data pipe /3/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,rtap,ns,ne,irs,ire,lags,
     1             irnmo, ornmo, smootht, smoothx, iswin, verbos,
     2             ist, ied, hdrwrd, istk, iordt, iordx)

c-----
c     get logical unit numbers for input and output of seismic data
c     0 = default stdin
c     1 = default stdout
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

      if ( irnmo ) then
         if (rtap(1:1) .ne. ' ') then
            call getln(lutim, rtap, 'r', -1)
         else
            call sisfdfit (lutim, pipe)
         endif
         if (lutim .lt. 0) then
            write(LERR,*)'FATAL error in arnmo:'
            write(LERR,*)'Unable to open rtap rnmo times file'
            write(LER ,*)'FATAL error in arnmo:'
            write(LER ,*)'Unable to open rtap rnmo times file'
            call ccexit (666)
         endif
      else
         lutim = -1
      endif

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'ARNMO: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c------
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      if (hdrwrd(1:1) .ne. ' ')
     1call savelu(hdrwrd,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)


      call hlhprt (itr, lbytes, name, 6, LERR)

c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records)
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

      ist = ist / nsi
      ied = ied / nsi
      if (ied .eq. 0) ied = nsamp

      if ( .not. irnmo ) then

         iswin = iswin / nsi
         if (mod(iswin,2).eq.0) then
            iswin = iswin + 1
         endif
         iwin = iswin / 2
         If (iswin .lt.3) then
          write(LERR,*)'FATAL ERROR in arnmo:'
          write(LERR,*)'analysis window length < 3 samps'
          write(LER ,*)'FATAL ERROR in arnmo:'
          write(LER ,*)'analysis window length < 3 samps'
          call ccexit (666)
         endif
 
         if (lags .eq. 0) lags = iswin / 4
         If (lags .lt. 1) then
          write(LERR,*)'FATAL ERROR in arnmo:'
          write(LERR,*)'correlation lags < 1 samp'
          write(LER ,*)'FATAL ERROR in arnmo:'
          write(LER ,*)'correlation lags < 1 samp'
          call ccexit (666)
         endif
      endif

c---------------------------------------------------
c  malloc only space we're going to use
      heap1 = .true.

c--------------------------
c  note: these don't
c  have to be the same size

      item1 = ntrc * nsamp
      itemh = ntrc * ITRWRD
      item  = ntrc * iswin

c  note also SZSMPD is the 
c  size of an item in bytes
c--------------------------

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      call galloc (wkadr1, item1*SZSMPD, errcod1, abort)
      if (errocd1 .ne. 0) heap1 = .false.
      call galloc (wkadr2, item1*SZSMPD, errcod1, abort)
      if (errocd1 .ne. 0) heap1 = .false.
      call galloc (wkadrt, item1*SZSMPD, errcod1, abort)
      if (errocd1 .ne. 0) heap1 = .false.
      call galloc (wkadrh, itemh*SZSMPD, errcod1, abort)
      if (errocd1 .ne. 0) heap1 = .false.
      call galloc (wkadr , item *SZSMPD, errcod2, abort)
      if (errcod2 .ne. 0) heap1 = .false.

      if (.not. heap1) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) itemh*SZSMPD,'  bytes'
         write(LERR,*) item *SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) item1*SZSMPD,'  bytes'
         write(LER ,*) item1*SZSMPD,'  bytes'
         write(LER ,*) item1*SZSMPD,'  bytes'
         write(LER ,*) itemh*SZSMPD,'  bytes'
         write(LER ,*) item *SZSMPD,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) itemh*SZSMPD,'  bytes'
         write(LERR,*) item *SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------

c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = ire - irs+1
      jtr   = ne-ns+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc',  jtr , LINHED)

      if ( .not. irnmo ) then
          igate  = iswin
          igate4 = igate / 3
          call vfill (1.0, weight, 1, igate)
          do  i = 1, igate4
              ang = 3.14159265 * float(igate4-i+1)/float(igate4)
              wt = .5 * (1. + cos ( ang ))
              weight(i) = wt
              j = igate - i + 1
              weight(j) = wt
          enddo
    
          write(LERR,*)' '
          write(LERR,*)'Window Weights'
          write(LERR,*) (weight(ii),ii=1,igate)
          write(LERR,*)' '
      endif
         
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
c----------------------
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     read line header of input
c     save certain parameters
c-----
      if ( irnmo ) then
         call rtape  ( lutim, itr, lbytes)
         if(lbytes .eq. 0) then
            write(LER,*)'ARNMO: no header read from rnmo unit ',lutim
            write(LER,*)'FATAL'
            stop
         endif
         call saver(itr, 'NumSmp', rnsamp, LINHED)
         call saver(itr, 'SmpInt', rnsi  , LINHED)
         call saver(itr, 'NumTrc', rntrc , LINHED)
         call saver(itr, 'NumRec', rnrec , LINHED)

         if (rnsamp .lt. nsamp) then
            write(LERR,*)'Warning from arnmo read rnmo time option:'
            write(LERR,*)'Number time sample < trace data - will repeat 
     1last sample' 
         endif
         if (rnsamp .gt. nsamp) then
            write(LERR,*)'Warning from arnmo read rnmo time option:'
            write(LERR,*)'Number time sample < trace data - will truncat
     1e'
         endif
         if (rnsi .ne. nsi) then
            write(LERR,*)'Warning from arnmo read rnmo time option:'
            write(LERR,*)'Time data set SI = ',rnsi,' data SI= ',nsi
            write(LERR,*)'Will interpolate to data SI'
         endif
         if (rntrc .ne. ntrc) then
             write(LERR,*)'FATAL ERROR in arnmo:'
             write(LERR,*)'Time # trc/rec must equal ',rntrc
             call ccexit (666)
         endif
         if (rnrec .ne. nrec) then
             write(LERR,*)'FATAL ERROR in arnmo:'
             write(LERR,*)'Time # recs must equal ',rnrec
             call ccexit (666)
         endif

         item = max(nsamp,rnsamp)
         call galloc (wkadt1, item*SZSMPD, errcod1, abort)
         call galloc (wkadt2, item*SZSMPD, errcod1, abort)
         call galloc (wkadrw, item*SZSMPD, errcod1, abort)
         if (errocd1 .ne. 0) heap1 = .false.
         if (.not. heap1) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) item*SZSMPD,'  bytes'
            write(LERR,*) item*SZSMPD,'  bytes'
            write(LERR,*) item*SZSMPD,'  bytes'
            write(LERR,*)' '
            write(LER ,*)' '
            write(LER ,*)'Unable to allocate workspace:'
            write(LER ,*) item*SZSMPD,'  bytes'
            write(LER ,*) item*SZSMPD,'  bytes'
            write(LER ,*) item*SZSMPD,'  bytes'
            go to 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) item*SZSMPD,'  bytes'
            write(LERR,*) item*SZSMPD,'  bytes'
            write(LERR,*) item*SZSMPD,'  bytes'
            write(LERR,*)' '
         endif
         do  i = 1, item
             tabl1 (i) = rnsi * (i-1)
         enddo
         do  i = 1, item
             tabl2 (i) = nsi  * (i-1)
         enddo
         icinit = 1

      endif

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      call verbal(nsamp,nsi,ntrc,nrec,iform,lags,iwin,
     1            irnmo,ornmo,smootht,smoothx,iswin,iordt,iordx,
     2            ntap,otap)

c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary

      dt = real (nsi) * unitsc

c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)

c-----
c     process desired trace records
c-----

      do 1000 jj = irs, ire
 
            call vclr (bigar1, 1, nsamp*ntrc)
            call vclr (bigar2, 1, nsamp*ntrc)
            call vclr (tarray, 1, nsamp*ntrc)
            call vclr (lilar , 1, iswin*ntrc)
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
            live = 0
            ic = 0
            do 1001  kk = ns, ne

                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  ic = ic + 1
                  ishd = (ic-1) * ITRWRD
                  call vmov (lhed, 1, hdrs(ishd+1), 1, ITRWRD)
                  call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)

c------
c     for trace header values you can use the I*2 vector
c     rather than saver/savew (which you can use)
c     this is faster in general than saver/w
c------

                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call saver2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                        ili    , TRACEHEADER)
                  call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        idi    , TRACEHEADER)
                  call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        idist  , TRACEHEADER)
                  if (hdrwrd(1:1) .ne. ' ') then
                     call saver2(lhed,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                           ihdrwrd, TRACEHEADER)
                     ihdrwrd = ihdrwrd / nsi
                  else
                     ihdrwrd = 0
                  endif
                  istart = ihdrwrd + ist
                  if (istart .le. 0) istart = 1

                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        static , TRACEHEADER)
                  dist  = iabs( idist )

                  IF (static .eq. 30000) THEN
                     call vclr (tri,1,nsamp)
                     dedtrc (ic) = 1
                  ELSE
                     dedtrc (ic) = 0
                     live = live + 1
c----------------------
c  if live trace
c  pack data into array
c  & also distances
c----------------------
                     istrc = (live-1) * nsamp
                     call vmov (tri,1, bigar1(istrc+1),1,nsamp)
                     dists(live) = dist

c----
c   if rnmo time input then grab
c   rnmo times and deal with sampling
c   differences
c----
                     if (irnmo) then
                        nbytes = 0
                        call rtape( lutim, itr, nbytes)
                        if(nbytes .eq. 0) then
                           write(LERR,*)'End of file on time data set:'
                           write(LERR,*)'  rec= ',jj,'  trace= ',kk
                           go to 999
                        endif
                        call vmov (lhed(ITHWP1), 1, tri, 1, rnsamp)
                        if (rnsi .ne. nsi) then
                            call Linterp (tri, rnsamp, work, nsamp, 
     1                      tabl1, tabl2)
                            call vmov (work, 1, tri, 1, nsamp)
                        endif
                        if (rnsamp .lt. nsamp) then
                           do  ii = rnsamp+1, nsamp
                               tri (ii) = tri (rnsamp)
                           enddo
                        endif
                        call vmov (tri,1, tarray(istrc+1),1,nsamp)
                     endif

                  ENDIF

1001        continue

c----------------------
c  skip to end of record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------

c-----------------------
c  here's the meat...
c  if we have 4 or more
c  live traces compute
c  slope & intercept

                     call rnmo (live, nsamp, bigar1, dists, bigar2,
     1                          iwin, iswin, dedtrc, ornmo, smootht,
     2                          lags, recnum, trcnum, ili, idi, lilar,
     3                          weight, istart, ied, iswin2, tarray,
     4                          istk, irnmo, smoothx, iordt, iordx)

c-----------------------

c---------------------
c  write output data
            ic = 0
            il = 0
            do  kk = ns, ne
                ic = ic + 1
                if ( dedtrc(ic) .eq. 0) then
                     il = il + 1
                     istrc = (il-1) * nsamp
                     call vmov (bigar2(istrc+1), 1, lhed(ITHWP1), 1, 
     1                          nsamp)
                else
                     call vclr (lhed(ITHWP1), 1, nsamp)
                endif
                ishd = (ic-1) * ITRWRD
                call vmov (hdrs(ishd+1), 1, lhed, 1, ITRWRD)
                call wrtape (luout, lhed, obytes)

            enddo

                  if(verbos)write(LERR,*)'ri ',recnum,' trace ',trcnum
 
 
 1000       continue

c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of arnmo, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
            write(LER ,*)'end of arnmo, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'arnmo does time varying auto-rnmo corrections to seismic recs'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute arnmo by typing arnmo and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)      : output data file name'
        write(LER,*)
     :' -R [rtap]    (def = none)      : input rnmo time file'
        write(LER,*)
     :' -s[ist]      (default = 0 ms)  : start processing time'
        write(LER,*)
     :' -e[ied]      (default = last)  : end processing time'
        write(LER,*)
     :' -hw[hdrwrd]  (default = ignore): start time hdr word'
        write(LER,*)
     :' -ns[ns]      (default = first) : start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last)  : end trace number'
        write(LER,*)
     :' -rs[irs]     (default = first) : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)  : end record number'
        write(LER,*)
     :' -w[win]      (default = none)  : search window (samps)'
        write(LER,*)
     :' -l[lag]      (default = win/4) : correlation lag'
        write(LER,*)
     :' -m[istk]     (default = 1)     : stack first n trcs for model'
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*)
     :' -smt  turn on rnmo time soother'
        write(LER,*)
     :' -ordt[ordt]  (default = win/3) : time smoother order'
        write(LER,*)
     :' -smx  turn on rnmo spatial soother'
        write(LER,*)
     :' -ordx[ordx]  (default = ntrc/3): spatial smoother order'
        write(LER,*)
     :' -T  output rnmo times only'
        write(LER,*)
     :' -I  rnmo times input (no internal calculation)'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   arnmo -N[] -O[] -R[] -ns[] -ne[] -rs[] -s[] -e[] -hw[]'
        write(LER,*)
     :'                 -re[] -w[] -l[] -m[] [-smt -ordt[] -smx -ordx[]'
        write(LER,*)
     :'                 -T -I -V'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,rtap,ns,ne,irs,ire,lags,
     1                  irnmo, ornmo, smootht, smoothx, iswin, verbos,
     2                  ist, ied, hdrwrd, istk, iordt, iordx)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     vel   - R*4      design velocity
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), rtap*(*), hdrwrd * 6
      integer     ns, ne, irs, ire, lags
      logical     verbos, irnmo, ornmo, smootht, smoothx
      integer     argis
 
c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            smootht=   (argis('-smt') .gt. 0)
            smoothx=   (argis('-smx') .gt. 0)
            call argstr( '-R', rtap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-w', iswin ,   0  ,  0    )
            call argi4 ( '-l', lags  ,   0  ,  0    )
            call argi4 ( '-s', ist ,   0  ,  0    )
            call argi4 ( '-e', ied ,   0  ,  0    )
            call argi4 ( '-m', istk ,   1  ,  1    )
            call argstr( '-hw', hdrwrd, ' ', ' ')
            call argi4 ( '-ordt', iordt ,   0  ,  0    )
            call argi4 ( '-ordx', iordx ,   0  ,  0    )
            ornmo  =   (argis('-T') .gt. 0)
            irnmo  =   (argis('-I') .gt. 0)
            verbos =   (argis('-V') .gt. 0)

            if ( .not. irnmo ) then
            if (iswin.eq.0) then
              write(LERR,*)'FATAL ERROR in arnmo:'
              write(LERR,*)'Must enter analysis window -w[] (ms)'
              write(LER ,*)'FATAL ERROR in arnmo:'
              write(LER ,*)'Must enter analysis window -w[] (ms)'
              stop
            endif
            if (lags.eq.0) then
              write(LERR,*)'WARNING in arnmo:'
              write(LERR,*)'Lags -l[] will defualt to ',iwin/4,
     1        ' (ms)'
              stop
            endif
            endif
 
      return
      end
 
      subroutine verbal(nsamp,nsi,ntrc,nrec,iform,lags,iwin,
     1                  irnmo,ornmo,smootht,smoothx,iswin,iordt,iordx,
     2                  ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec, iswin, lags, iwin
      character   ntap*(*), otap*(*)
      logical     irnmo,ornmo,smootht,smoothx
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' 1/2 window length   = ',iwin,' samps'
            write(LERR,*) ' correlation lag     = ',lags,' samps'
            if (smootht) then
            write(LERR,*) ' turn on internal rnmo time smoother'
            write(LERR,*) ' smooth order        =  ',iordt
            write(LERR,*) ' if 0 then default = ntrc/3'
            else
            write(LERR,*) ' turn off internal rnmo time smoother'
            endif
            if (smoothx) then
            write(LERR,*) ' turn on internal rnmo spatial smoother'
            write(LERR,*) ' smooth order        =  ',iordx
            write(LERR,*) ' if 0 then default = iwin/3'
            else
            write(LERR,*) ' turn off internal rnmo spatial smoother'
            endif
            if (irnmo) then
            write(LERR,*) ' rnmo times input - no internal calc'
            endif
            if (ornmo) then
            write(LERR,*) ' output rnmo times only'
            else
            write(LERR,*) ' output rnmo corrected gathers'
            endif
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
