C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c---
c  routine to take a temporally windowed gather, build a model trace,
c  correlate the mode trace with the gather, and analyze the xcorrs
c  to determine the shifts
c---
      subroutine fltshift (iswin, iswin2, iwin1, jtr, lags, lags1,
     1                     weight, lilar, shfts, istk, smoothx, iordx)

#include <f77/lhdrsz.h>

      real     lilar(iswin,jtr), weight(iswin)
      real     r(SZLNHD), t1(SZLNHD), t2(SZLNHD)
      real     y(SZLNHD), g(SZLNHD)
      real     x(SZLNHD)
      real     shfts(jtr)
      logical  smoothx
      
      lags2 = lags + lags1

      do  i = 1, iswin
          r (i) = 0.0
          x (i) = 0.0
      enddo

c---
c  build model trace by stacking the first istk traces. apply time
c  weighting function
c---
      do  j = 1, istk
         do  i = 1, iswin
             wt = weight (i)
             amp = wt * lilar (i,j)
             r (i) = r (i) + wt * amp
             if (amp .ne. 0.0) x (i) = x (i) + 1.0
         enddo
      enddo
      do  i = 1, iswin
          xn = x (i)
          if (xn .eq. 0.0) xn = 1.0
          r (i) = r (i) / xn
      enddo

c---
c  now, using the model trace crosscorrelate it with all the other live
c  traces in the gather
c---
      DO  j = 2, jtr

          do  i = 1, iswin
              wt = weight (i)
              y (i) = wt * lilar (i,j)
          enddo
          call dotpr (y, 1, y, 1, ydot, iswin)

c---
c  for live correlations compute 2-sided x-correlation functions
c---
          IF (ydot .ne. 0.0) THEN

             call ccort (Y, R, T1, lags1, iswin)
             call ccort (R, Y, T2, lags1, iswin)

             do  i = 1, lags1
                 ii = lags1 - i + 1
                 G (ii) = T1 (i)
             enddo
             do  i = 1, lags
                 ii = lags1 + i
                 G (ii) = T2 (i+1)
             enddo

c---
c  find crosscorrelation peaks
c---
             call maxv  (G , 1, amaxpk , lc, lags2)
             ishft = lc - lags - 1

c---
c  fit a parabola about the peaks and determine the fractional time of
c  the true peak
c---
             c1 = G (ishft-1)
             c2 = G (ishft  )
             c3 = G (ishft+1)
             call parab (c1, c2, c3, fs, gmax)
             shfts (j) = float(ishft) + fs

          ELSE
c---
c  for zero traces the shift is set to zero
c---

             shfts (j) = 0.

          ENDIF

      ENDDO

c----
c  smooth time shifts across traces
c----
      if (smoothx .AND. iordx .ge. 2)  then
          sumx = 0.
          do  j = 1, jtr
              sumx = sumx + abs( shfts(j) )
          enddo
          if (sumx .ne. 0.) then
             s1 = shfts(1)
             call SmoothFit ( shfts, jtr, iordx)
             shfts(1) = s1
          endif
      endif

      return
      end
