C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rnmo (jtr, nsamp, gather, dists, output,
     1                 iwin, iswin, dedtrc, ornmo, smootht,
     2                 lags, recnum, trcnum, ili, idi, lilar,
     3                 weight, istart, iend, iswin2, tarray,
     4                 istk, irnmo, smoothx, iordt, iordx)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c---
c  routine to take a gather of jtr traces and sample-by-sample
c  compute a linear fit to the amplitude-distance points
c  outputting the sample-by-sample slopes, a, and intercepts, b
c  for all available samples, nsamp
c---
      real      gather(nsamp,jtr), dists(*), output(nsamp,jtr)
      real      tarray(nsamp,jtr)
      integer   dedtrc (*)
      real      weight (iswin)
      real      lilar(iswin,jtr)
      real      X (SZLNHD), Y (SZLNHD), shfts (SZLNHD)
      real      Z (SZLNHD)
      integer   jtr, nsamp, iswin, lags, recnum, trcnum, ili, idi
      integer   iwin, iswin2
      logical   got, irnmo, ornmo, smootht, smoothx

c---
c  time matrix read in from outside
c---
      IF ( irnmo ) THEN

         is = istart
         ie = iend
         call vclr (tarray(1,1), 1, nsamp)

c---
c  need to build time matrix internally
c---
      ELSE

         if (smootht) then
            if (iordt .eq. 0) iordt = iwin / 3
         endif
         if (smoothx) then
            if (iordx .eq. 0) iordx = jtr / 3
         endif

         iwin1 = iwin + 1
         lags1 = lags + 1

         if (istart .ge. iwin1) then
             is = istart
         else
             is = iwin1
         endif
         if (iend .le. nsamp-iwin) then
             ie = iend
         else
             ie = nsamp-iwin
         endif

         DO  i = is, ie    !  for each sample
 
c---
c  for each window position: read in time offset data; weight time
c  window; check to make sure model traces are live and that we only
c  have live traces to mess with
c---
             got = .false.
             nj = 0
             do  j = 1, jtr

                 iw = 0
                 do  ii = i-iwin, i+iwin
                     iw = iw + 1
                     wt = weight (iw)
                     Y (iw) = wt * gather(ii,j)
                 enddo
                 if (.not. got) then
                    call dotpr (Y, 1, Y, 1, ydot, iswin)
                    if (ydot .ne. 0.0) got = .true.
                    nj = 1
                    js = j
                 else
                    nj = nj + 1
                 endif

                 if ( got ) then
                    X (nj) = dists (j)
                    iw = 0
                    do  ii = i-iwin, i+iwin
                        iw = iw + 1
                        wt = weight (iw)
                        lilar (iw,nj) = Y (iw)
                 enddo
   
                 endif

             enddo

c---
c  for current time window go find shifts
c---
             call fltshift (iswin, iswin2, iwin1, nj, lags, lags1,
     1                      weight, lilar, shfts, istk, smoothx, iordx)

             do  j = 1, nj

                 tarray (i, j+js-1) = shfts (j)
             enddo

         ENDDO

c----
c  smooth time shifts along traces
c----
         if (smootht .AND. iordt .ge. 3) then
            do  j = 2, jtr
               do  ii = 1, nsamp
                   Z (ii) = tarray (ii,j)
               enddo
               call SmoothFit ( Z, nsamp, iordt)
               do  ii = 1, nsamp
                   tarray (ii,j) = Z (ii)
               enddo
            enddo
         endif
   
c---
c  for option to output time matrix swap time to output array then bail
c---
         if ( ornmo ) then
            call vclr (output(1,1), 1, nsamp)
            do  j = 2, jtr
                do  ii = is, ie
                    output (ii,j) = tarray (ii,j)
                enddo
            enddo
            return
         endif

      ENDIF

c----
c  apply time shifts to input gather using quadratic interpolator
c----
      call vmov (gather(1,1), 1, output (1,1), 1, nsamp)

      DO  j = 2, jtr

         do  ii = 1, nsamp
             Y (ii) = gather (ii, j)
             Z (ii) = 0.
         enddo

         DO  i = is, ie

             ts  = float (i) - tarray (i, j)
             its = ts
             if ( its .gt. 1 .and. its .lt. nsamp) then
                f   = ts - its
                fs  = f * f
                c1  = fs - f
                c2  = 2.0 - 2.0 * fs
                c3  = fs + f
                Z (i) = .5 * (
     1                c1 * y(its-1) + c2 * y(its) + c3 * y(its+1)
     2                       )
             else
                Z (i) = 0.
             endif

         ENDDO

         do  ii = is, ie
             output (ii,j) = Z (ii)
         enddo

      ENDDO


      return
      end

