C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine process(uin,uquad,env,
     1                    peaktime,slope,tstart_orig,nsi,
     2                    tracebuf,nbytes_out,nbytes_out_r,
     3                    lenhed,nt,nfft,dt,live,
     4                    in_ss,in_se,horizons,uh,lh,
     5                    pipelen,calc,lunit,
     6                    ienv,iphase,ifreq,ibw,
     7                    renv,rphase,rfreq,rbw,
     8                    rlength,car,rt,skew,
     9                    p0,p90,nsamp_in,
     a                    lerr,cputim,waltim)
c
#include <save_defs.h>
c
      real      tracebuf(-lenhed:nt)
      real      uin(0:nfft-1)
      real      uquad(0:nfft-1)
      real      slope(0:nt-1)
      real      env(0:nt)
      real      ienv(0:nt),iphase(0:nt),ifreq(0:nt),ibw(0:nt)
      real      renv(0:nt),rphase(0:nt),rfreq(0:nt),rbw(0:nt)
      real      rlength(0:nt),car(0:nt),skew(0:nt),rt(0:nt)
      real      p0(0:nt),p90(0:nt)
c
      real tstart_orig
      integer nsi, nsamp_in
      integer pipelen
      integer lunit(pipelen)
      logical calc(pipelen)
c
      integer ss, se, in_ss, in_se
      logical horizons
      character*(8) uh, lh
c
      real      peaktime(0:nt)

c Grab the declarations for the process identifiers
#include "initproc.h"

      parameter (pi=3.1415926)
      parameter (degprad=180./pi,radpdeg=pi/180.)
      real      cputim(*),waltim(*)

c_______________________________________________________________
c     If the user has specified upper and lower header words,
c     reset the start and end samples.
c_______________________________________________________________
      ss = in_ss
      se = in_se
      if (horizons) then
         if (uh .ne. '*NONE*') then
            call saver(tracebuf(-lenhed),uh,ss,TRACEHEADER)
            ss = int(0.5 + real(ss - tstart_orig)/real(nsi))
            if (ss .le. 0) ss = 0
         endif
         if (lh .ne. '*NONE*') then
            call saver(tracebuf(-lenhed),lh,se,TRACEHEADER)
            se = int(0.5 + real(se - tstart_orig)/real(nsi))
            if (se .gt. (nsamp_in-1)) se = nsamp_in - 1
         endif
      endif
c
      factfreq=1./(2.*dt*2.*pi)
      factbw=1./(2.*dt*2.*pi)
      fmax=1./(2.*dt)
c
c_______________________________________________________________
c     precompute the instantaneous envelope.
c_______________________________________________________________
       do 11000 jt=0,nt
          env(jt)=sqrt(uin(jt)**2+uquad(jt)**2)
11000  continue
c

c     if (calc(pmrenv) .or. calc(pmrphase) .or. calc(pmrfreq) .or.
c    1    calc(pmrbw) .or. calc(pmrlength)) then
      if (calc(pmrphase) .or. calc(pmp0) .or. calc(pmp90) .or.
     1    calc(pmrenv) .or. calc(pmrfreq) .or. calc(pmrbw)) then
c_______________________________________________________________
c        precompute the map used in response attribute calculations.
c_______________________________________________________________
         call respmap(env(0),slope,peaktime(0),nt)
      endif
c#####################################################################
c     begin calculation and output of given attributes.
c#####################################################################
      if(calc(pmienv)) then
c_______________________________________________________________
c        store the instantaneous envelope.
c_______________________________________________________________
         do 13000 jt=0,nt
          ienv(jt)=env(jt)
13000    continue
         call vmov(ienv,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmienv),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmiphase)) then
c_______________________________________________________________
c        calculate the instantaneous phase.
c_______________________________________________________________
         do 22000 jt=0,nt
          if(uin(jt) .eq. 0. .and. uquad(jt) .eq. 0.) then
             iphase(jt)=0.
          else
             iphase(jt)=atan2(uquad(jt),uin(jt)) * degprad
          endif
22000    continue
         call vmov(iphase,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmiphase),tracebuf(-lenhed),nbytes_out)
      endif
      if(calc(pmifreq)) then
c_______________________________________________________________
c        calculate the instantaneous frequency.
c
c        in principle:
c
c        f=[phase(t+dt)-phase(t-dt)]/(2.*dt)
c
c        however, to avoid phase unwrapping, we use 
c        (Tanner et al, 1979, Geophysics, pg 1043, eqn 9):
c
c                  uin(t)*duquad(t)/dt-uquad(t)*duin(t)/dt
c        f=2.*pi*--------------------------------------
c                       uin(t)**2+uquad(t)**2
c
c        minus sign added to be consistent with program 'asig'
c_______________________________________________________________
         ifreq(0)=0.
         ifreq(nt)=0.
         do 23000 jt=1,nt-1
          duquad=uquad(jt+1)-uquad(jt-1) 
          duin=uin(jt+1)-uin(jt-1) 
          denom=env(jt)**2
          if(denom .ne. 0.) then
             ifreq(jt)=-factfreq*
     1         (uin(jt)*duquad-uquad(jt)*duin)/denom
          else
             ifreq(jt)=0.
          endif
23000    continue
         do 24000 jt=0,nt
          ifreq(jt)=min(ifreq(jt),+fmax)
          ifreq(jt)=max(ifreq(jt),-fmax) 
24000    continue
         call vmov(ifreq,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmifreq),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmibw)) then
c_______________________________________________________________
C        Calculate Instantaneous Bandwidth
c            Cohen  (1993) Instantaneous Anything,
c            Proc. IEEE Int Conf. Acoust. Speech, Signal Processing,
c            vol 4, pp 105-109.
c_______________________________________________________________
         ibw(0)=0.
         ibw(nt)=0.
         do 25000 jt=1,nt-1       
          duquad=uquad(jt+1)-uquad(jt-1)
          duin=uin(jt+1)-uin(jt-1)
          denom=env(jt)**2                       
          if(denom .ne. 0) then
             ibw(jt)=factbw*
     1           abs(uin(jt)*duquad+uquad(jt)*duin)/denom
          else
             ibw(jt)=0.
          endif
25000    continue
         do 26000 jt=0,nt
          ibw(jt)=min(ibw(jt),+fmax)
26000    continue
         call vmov(ibw,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmibw),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmcar)) then
c_______________________________________________________________
c        calculate the carrier. ucar=sin(iphase)=uin/env.
c_______________________________________________________________
         do 28000 jt=0,nt
          denom=env(jt)
          if(denom .ne. 0) then
             car(jt)=uin(jt)/denom
          else
             car(jt)=0.
          endif
28000    continue
         call vmov(car,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmcar),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmrphase) .or. calc(pmp0) .or. calc(pmp90)) then
c_______________________________________________________________
c        calculate the response phase.
c_______________________________________________________________
         do 32000 jt=0,nt
          kt=nint(peaktime(jt))
          delt=kt-peaktime(jt)
c_______________________________________________________________
c         interpolate the real and quadrature components to the
c         fractional time sample corresponding to the peaktime of the
c         instantaneous envelope.
c         interpolating the components instead of the phase avoids
c         the problem of phase unwrapping.
c_______________________________________________________________
          if(delt .ge. 0.) then
             ur=uin(kt)+delt*(uin(kt-1)-uin(kt))
             uq=uquad(kt)+delt*(uquad(kt-1)-uquad(kt))
          else
             ur=uin(kt)+delt*(uin(kt)-uin(kt+1))
             uq=uquad(kt)+delt*(uquad(kt)-uquad(kt+1))
          endif
          if(ur .eq. 0. .and. uq .eq. 0.) then
             rphase(jt)=0.
          else
             rphase(jt)=atan2(uq,ur)*degprad
          endif
32000    continue
      endif
      if(calc(pmrphase)) then
         call vmov(rphase,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmrphase),tracebuf(-lenhed),nbytes_out)
      endif
      if(calc(pmrenv)) then
c_______________________________________________________________
c        calculate the response envelope.
c_______________________________________________________________
         do 41000 jt=0,nt
          kt=nint(peaktime(jt))
          renv(jt)=env(kt)
41000    continue
         call vmov(renv,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmrenv),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmrfreq)) then
c_______________________________________________________________
c        calculate the response frequency.
c_______________________________________________________________
         tracebuf(0)=0.
         tracebuf(nt)=0.
         do 51000 jt=1,nt-1
          kt=nint(peaktime(jt))
          duquad=uquad(kt+1)-uquad(kt-1)
          duin=uin(kt+1)-uin(kt-1)
          denom=env(kt)**2
          if(denom .ne. 0.) then
             rfreq(jt)=-factfreq*(uin(kt)*duquad-uquad(kt)*duin)/denom
          else
             rfreq(jt)=0.
          endif
51000    continue
         do 52000 jt=0,nt
          rfreq(jt)=min(rfreq(jt),+fmax)
          rfreq(jt)=max(rfreq(jt),-fmax)
52000    continue
         call vmov(rfreq,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmrfreq),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmrbw)) then
c_______________________________________________________________
C        Calculate Response Bandwidth
c_______________________________________________________________
         tracebuf(0)=0.
         tracebuf(nt)=0.
         do 55000 jt=1,nt-1
          kt=nint(peaktime(jt))
          duquad=uquad(kt+1)-uquad(kt-1)
          duin=uin(kt+1)-uin(kt-1)
          denom=uin(kt)**2+uquad(kt)**2
          if(denom .ne. 0) then
             rbw(jt)=factbw*abs(uin(kt)*duquad+uquad(kt)*duin)/denom
          else
             rbw(jt)=0.
          endif
55000    continue
         do 56000 jt=0,nt
          rbw(jt)=min(rbw(jt),+fmax)
56000    continue
         call vmov(rbw,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmrbw),tracebuf(-lenhed),nbytes_out)
      endif
c
      if(calc(pmp0) .or. calc(pmp90)) then
c_______________________________________________________________
c        Calculate 0 and 90 phase components.           
c_______________________________________________________________
         do 62000 jt=0,nt
          arg=rphase(jt)*radpdeg
          p0(jt)=cos(arg)*(cos(arg)*uin(jt)+sin(arg)*uquad(jt))
          p90(jt)=uin(jt)-p0(jt)
62000    continue
      endif
      if(calc(pmp0)) then
         call vmov(p0,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmp0),tracebuf(-lenhed),nbytes_out)
      endif
      if(calc(pmp90)) then
         call vmov(p90,1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmp90),tracebuf(-lenhed),nbytes_out)
      endif
c

c_______________________________________________________________
c        Calculate response length (stolen from asig).
c_______________________________________________________________
      if (calc(pmrlength)) then
         do 120 i = 0,nt
            if (uin(i) .ne. 0.0 .and. uquad(i) .ne. 0.0) then
               rlength(i) = (uin(i)**2 + uquad(i)**2) ** .5
            else
               rlength(i) = 0.0
            endif
  120    continue
         call alen(rlength(0), nt)
         call vmov(rlength(0),1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmrlength),tracebuf(-lenhed),nbytes_out)
      endif

c_______________________________________________________________
c        Calculate skewness (stolen from asig).
c_______________________________________________________________
      if (calc(pmskew)) then
         do 130 i = 0, nt
            if (uin(i) .ne. 0.0 .and. uquad(i) .ne. 0.0) then
               skew(i) = (uin(i)**2 + uquad(i)**2) ** .5
            else
               skew(i) = 0.0
            endif
  130    continue
         call askw(skew(0), nt)
         call vmov(skew(0),1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmskew),tracebuf(-lenhed),nbytes_out)
      endif

c_______________________________________________________________
c        Calculate rise time (stolen from asig).
c_______________________________________________________________
      if (calc(pmrt)) then
         do 140 i = 0, nt
            if (uin(i) .ne. 0.0 .and. uquad(i) .ne. 0.0) then
               rt(i) = (uin(i)**2 + uquad(i)**2) ** .5
            else
               rt(i) = 0.0
            endif
  140    continue
         call aslp(rt(0), nt)
         call vmov(rt(0),1,tracebuf(0),1,nt+1)
         call wrtape(lunit(pmrt),tracebuf(-lenhed),nbytes_out)
      endif

      return
      end
