C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

cirflg 0 (AVA - Average Signed Amplitude)
      function avgsmp(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avgsmp = rnul
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         sum = arr(k) + sum
         n = n + 1
      enddo
      if (n .ne. 0) avgsmp = sum/n
cc    write(0,*) 'avgsmp:', avgsmp
      return
      end

cirflg 1 (AAA - Average Absolute Amplitude)
      function avgabs(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avgabs = rnul
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         sum = abs(arr(k)) + sum
         n = n + 1
      enddo
      if (n .ne. 0) avgabs = sum/n
cc    write(0,*) 'avgabs: ',avgabs,minsmp,maxsmp,minwin,maxwin
      return
      end

cirflg 2 (MPA - Maximum Peak Amplitude)
      function peak(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      p = arr(minwin)
      n = 1
      do k = min(minwin,maxwin), max(minwin,maxwin)
         p = max(p,arr(k))
         n = n + 1
      enddo
      if (p .le. 0.0) then
          peak = rnul
      else
          peak = p
      endif 
cc    write(0,*) 'peak:', p, peak
      return
      end

cirflg 3 (MTA - Maximum Trough Amplitude)
      function trough(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      trough = arr(minwin)
      do k = min(minwin,maxwin), max(minwin,maxwin)
         trough = min(trough,arr(k))
      enddo
      if (trough .ge. 0.0) then
          trough = rnul
      else
          trough = abs(trough)
      endif
cc    write(0,*) 'trough:', trough
      return
      end

cirflg 4 (APA - Average Positive Amplitude)
      function avgpos(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avgpos = rnul
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         if (arr(k) .gt. 0.0) then
             sum = sum + arr(k)
             n = n + 1
         endif
      enddo
      if (n .gt. 0) avgpos = sum/n
cc    write(0,*) 'avgpos:', avgpos
      return
      end

cirflg 5 (ANA - Average Absolute Negative Amplitude)
      function avgneg(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avgneg = rnul
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         if (arr(k) .lt. 0.0) then
             sum = sum + arr(k)
             n = n + 1
         endif
      enddo
      if (n .gt. 0) avgneg = abs(sum/n)
cc    write(0,*) 'avgneg:', avgneg
      return
      end 

cirflg 6 (?? PVA - Phase Vector Angle)
      function avgphs(phase,minsmp,maxsmp,minwin,maxwin,rnul)
      real phase(minsmp:maxsmp)
      double precision sx, sy, d2r
      parameter (d2r=0.017453293,phi=0.01)
      avgphs = rnul
      sx = 0.0
      sy = 0.0
      do i = minwin, maxwin, isign(1,maxwin-minwin)
         theta = phase(i)*d2r
         sx = sx + cos(theta)
         sy = sy + sin(theta)
      enddo
      if (sqrt(sx*sx+sy*sy) .gt. phi) then
          avgphs = atan2(sy,sx)/d2r
          if (avgphs .lt. 0.0) then
              avgphs = avgphs + 360.0
          endif
      endif
cc    write(0,*) 'avgphs:', avgphs
      return
      end 

cirflg 7 (unused)
      function phs180(phase,minsmp,maxsmp,minwin,maxwin,rnul)
      real phase(minsmp:maxsmp)
      double precision sx, sy, d2r
      parameter (d2r=0.017453293,phi=0.01)
      phs180 = rnul
      sx = 0.0
      sy = 0.0
      do i = minwin, maxwin, isign(1,maxwin-minwin)
         theta = phase(i)*d2r
         sx = sx + cos(theta)
         sy = sy + sin(theta)
      enddo
      if (sqrt(sx*sx+sy*sy) .gt. phi) then
          phs180 = 180.0 + atan2(sy,sx)/d2r
      endif
cc    write(0,*) 'phs180:', phs180
      return
      end 

cirflg 8 (unused)
      function phsmag(phase,minsmp,maxsmp,minwin,maxwin,rnul)
      real phase(minsmp:maxsmp)
      double precision sx, sy, d2r
      parameter (d2r=0.017453293,phi=1.0E-6)
      phsmag = rnul
      sx = 0.0
      sy = 0.0
      do i = minwin, maxwin, isign(1,maxwin-minwin)
         theta = phase(i)*d2r
         sx = sx + cos(theta)
         sy = sy + sin(theta)
      enddo
      phsmag = sqrt(sx*sx+sy*sy)
      if (phsmag .le. phi) phsmag = rnul 
cc    write(0,*) 'phsmag:', phsmag
      return
      end 

cirflg 9 (?)
      function avgdif(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avgdif = 0
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin) - 1
         sum = abs(arr(k+1) - arr(k)) + sum
         n = n + 1
      enddo
      if (n .ne. 0) avgdif = sum/n
cc    write(0,*) 'avgdif:', avgdif
      return
      end

cirflg 10 (?)
      function totdif(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      totdif = 0
      sum = 0.0D0
      do k = min(minwin,maxwin), max(minwin,maxwin) - 1
         sum = abs(arr(k+1) - arr(k)) + sum
      enddo
      totdif = sum
cc    write(0,*) 'totdif:', totdif
      return
      end

cirflg 11 (EGY - Total Sample Energy)
      function energy(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      energy = 0
      sum = 0.0D0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         sum = arr(k)*arr(k) + sum
      enddo
      energy = sum
cc    write(0,*) 'energy:', energy
      return
      end

cirflg 12 (?)
      function peakt(arr,minsmp,maxsmp,minwin,maxwin,tmin,sr,rnul)
      real arr(minsmp:maxsmp)
      data nent /0/
      nent = nent+1
cc    write(0,*) 'peakt:',nent,minsmp,maxsmp,minwin,maxwin,tmin,sr
      peakt = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      ic = (is+ie)/2
      ip = is
      do i = is, ie
cc       write(0,*) 'i,t,arr(i):', i, (i-1)*sr, arr(i)
         if (arr(i) .gt. arr(ip)) then
             ip = i
         elseif (arr(i) .eq. arr(ip)) then
             if (abs(i-ic) .lt. abs(ip-ic)) ip = i
         endif
      enddo
      if (arr(ip) .gt. 0.0) then
          peakt = tmin + (ip-1)*sr
          if (ip .gt. is .and. ip .lt. ie) then
              if (arr(ip) .eq. max(arr(ip-1),arr(ip),arr(ip+1))) then
                  call parab(arr(ip-1),arr(ip),arr(ip+1),x,y)
                  if (abs(x) .lt. 1.0) peakt = peakt + x*sr
              endif
          endif
      endif
cc    write(0,*) 'ip,peakt,tmin,sr:', ip,peakt,tmin,sr
cc    write(0,*) ' '
      return
      end

cirflg 13 (?)
      function trought(arr,minsmp,maxsmp,minwin,maxwin,tmin,sr,rnul)
      real arr(minsmp:maxsmp)
      trought = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      ic = (is+ie)/2
      ip = is
      do i = is, ie
         if (arr(i) .lt. arr(ip)) then
             ip = i
         elseif (arr(i) .eq. arr(ip)) then
             if (abs(i-ic) .lt. abs(ip-ic)) ip = i
         endif
      enddo
      if (arr(ip) .lt. 0.0) then
          trought = tmin + (ip-1)*sr
          if (ip .gt. is .and. ip .lt. ie) then
              if (arr(ip) .eq. min(arr(ip-1),arr(ip),arr(ip+1))) then
                  call parab(arr(ip-1),arr(ip),arr(ip+1),x,y)
                  if (abs(x) .lt. 1.0) trought = trought + x*sr
              endif
          endif
      endif
cc    write(0,*) 'trought:', trought
      return
      end

cirflg 14 (?)
      function peakp(arr,minsmp,maxsmp,minwin,maxwin,tmin,sr,rnul)
      real arr(minsmp:maxsmp)
      peakp = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      ic = (is+ie)/2
      ip = is
      do i = is, ie
         if (arr(i) .gt. arr(ip)) then
             ip = i
         elseif (arr(i) .eq. arr(ip)) then
             if (abs(i-ic) .lt. abs(ip-ic)) ip = i
         endif
      enddo
      if (arr(ip) .gt. 0.0) then
          peakp = arr(ip)
          if (ip .gt. is .and. ip .lt. ie) then
              if (arr(ip) .eq. max(arr(ip-1),arr(ip),arr(ip+1))) then
                  call parab(arr(ip-1),arr(ip),arr(ip+1),x,y)
                  if (abs(x) .lt. 1.0) peakp = y
              endif
          endif
      endif
cc    write(0,*) 'peakp:', peakp
      return
      end

cirflg 15 (?)
      function troughp(arr,minsmp,maxsmp,minwin,maxwin,tmin,sr,rnul)
      real arr(minsmp:maxsmp)
      troughp = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      ic = (is+ie)/2
      ip = is
      do i = is, ie
         if (arr(i) .lt. arr(ip)) then
             ip = i
         elseif (arr(i) .eq. arr(ip)) then
             if (abs(i-ic) .lt. abs(ip-ic)) ip = i
         endif
      enddo
      if (arr(ip) .lt. 0.0) then
          troughp = arr(ip)
          if (ip .gt. is .and. ip .lt. ie) then
              if (arr(ip) .eq. min(arr(ip-1),arr(ip),arr(ip+1))) then
                  call parab(arr(ip-1),arr(ip),arr(ip+1),x,y)
                  if (abs(x) .lt. 1.0) troughp = y
              endif
          endif
      endif
      if (troughp .ne. rnul) troughp = -troughp
cc    write(0,*) 'rnul,troughp:', rnul,troughp
      return
      end

cirflg 15 (?)
      function avg180(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avg180 = 0.0
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         sum = arr(k) + sum
         n = n + 1
      enddo
      if (n .ne. 0) avg180 = sum/n + 180.0
cc    write(0,*) 'avg180:', avg180
      return
      end

cirflg 16 (SAA - Sum of Absolute Amplitudes)
      function abssum(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      sum = 0.0D0
      abssum = rnul
      n = 0
      do k = minwin, maxwin, isign(1,maxwin-minwin)
         sum = abs(arr(k)) + sum
         n = n + 1
      enddo
      if (n .gt. 0) then
          abssum = sum
      endif
cc    write(0,*) 'abssum:', abssum
      return
      end

cirflg 17 (DAA - Decay of Absolute Amplitudes)
      function adecay(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision asum, hsum
      adecay = rnul
      ks = min(minwin,maxwin)
      ke = max(minwin,maxwin)
      asum = 0.0D0
      hsum = 0.0D0
      na = 0
      nh = 0
      do k = ks, ke
c        write(0,*) k, arr(k)
         asum = abs(arr(k)) + asum
         na = na + 1
      enddo
      if (na .gt. 0) then
          do k = ks, ke
             hsum = abs(arr(k)) + hsum
             nh = nh + 1
             if (2*hsum .ge. asum) then
                 adecay = real(nh)/real(na) * 100.0
                 goto 1
             endif
          enddo
      endif
1     continue
c     write(0,*) 'adecay,na,nh,asum,hsum,ks,ke:',
c    $adecay,na,nh,asum,hsum,ks,ke
      return
      end             

cirflg 18
C      function ctrans(arr,minsmp,maxsmp,minwin,maxwin,rnul)
C      real arr(minsmp:maxsmp)
C      ctrans = 0.0
C      is = min(minwin,maxwin)
C      ie = max(minwin,maxwin)
C      snow = arr(is)
C      do i = is, ie
C         slast = snow
C         snow = arr(i)
C         if (snow .ne. slast) then
C             if (snow .ne. 0.0) then
C                 ctrans = ctrans + 1.0
C             endif
C         endif
C      enddo
C      ctrans = ctrans/(ie-is+1)
Cc     write(0,*) 'ctrans:', ctrans
C      return
C      end
C
Ccirflg 19
C      function tfsrng(arr,minsmp,maxsmp,minwin,maxwin,tmin,sr,smin,
C     $                  smax,rnul)
C      real arr(minsmp:maxsmp)
C      tfsrng = rnul
C      is = min(minwin,maxwin)
C      ie = max(minwin,maxwin)
C      ss = min(smin,smax)
C      se = max(smin,smax)
C      ip = is
C      do i = is, ie
C  s = arr(i)
C         if (s .ge. ss .and. s .le. se) then
C             tfsrng = tmin + (i-1)*sr
Cccc          write(0,*) 'tfsrng:', tfsrng
C             return
C         endif
C      enddo
Cccc   write(0,*) 'tfsrng: rnul'
C      return
C      end

cirflg 18 (PTD - Peak Trough Difference)
      function ptr(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      ptr = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      peak = arr(is)
      trough = arr(is)
      do ip = is, ie
         peak = max(peak,arr(ip))
         trough = min(trough,arr(ip))
      enddo
      ptr = peak + trough
      return
      end


      subroutine parab(c1,c2,c3,x,y)
      a=0.5*(c1+c3-2.0*c2)
      b=0.5*(c3-c1)
      c=c2
      x=-b/(2.0*a)
      y=a*x**2+b*x+c
      return
      end
