C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine chkfile(attribute_number,description,keyword,
     1                   calcfile,wrfile,lufile,
     2                   nstream,nfile,luout,lerr,sheader,
     3                   IKP,pipelen,pipenum,nsamp_out,
     4                   nrec_out,nrec_aug,lbyout)
c_______________________________________________________________
c     check on how to open a USP format file.
c_______________________________________________________________
      character*(*) keyword,description
      logical       calcfile,wrfile
      integer       lufile,luout
      real          sheader(*)
#include <save_defs.h>
c#include <f77/3d_attr_defs.h>
      character*2   int2str
      character*6   hdkey
      integer       attribute_number
      character*120 filename

      logical IKP
      integer pipelen, pipenum, nsamp_out
      integer idx
      integer status

      character*1   quote
      data          quote/'"'/
c_______________________________________________________________
c     Read the command line argument.  Note that some of the
c     options do not contain a full 4 characters.  Only pass the
c     needed amount of keyword to argstr in order for it to work.
c_______________________________________________________________
      idx = LEN(keyword)
 1    if (keyword(idx:idx) .eq. ' ' .and. idx .gt. 1) then
         idx = idx - 1
         goto 1
      endif
      call argstr(keyword(1:idx),filename,'DATA_STREAM',' ') 
c
c - hooking up a socket in IKP overrides options flagged in the input panel
c
      if (IKP) then
	status = 0
	call pipchk(pipenum, status)
	if (status .eq. 0) then
	 call sisfdfit(lufile,pipenum)
         write(lerr,'(a25,i5,a20,i5)') description,lufile,
     1       'IKP socket',pipenum
         wrfile=.true.
         calcfile=.true.
         nfile=nfile+1
         call savew(sheader,'MCLE01',attribute_number,LINEHEADER)
         call savew(sheader,'NumRec',nrec_out,LINEHEADER)
         call savew(sheader,'NumSmp',nsamp_out,LINEHEADER)
	 return
	endif
      endif

      if (filename .eq. ' ') then
c_______________________________________________________________
c        No keyword detected on the command line. 
c        Do not calculate the attribute.
c        Do not generate additional output.
c_______________________________________________________________
         calcfile=.false.
         wrfile=.false.
         write(lerr,'(a25,5x,a20)') description,'Not Calculated'
c     else if(filename .eq. 'DATA_STREAM' .and. .not. IKP) then
      else if(filename .eq. 'DATA_STREAM' ) then
c_______________________________________________________________
c        Keyword detected on command line without an explicit filename. 
c        Calculate the attribute.
c        Add output to the multiattribute data stream 'file' luout.
c        Update the component lineheader word.
c_______________________________________________________________
         calcfile=.true.
         wrfile=.false.
         lufile=luout
         nstream=nstream+1
         nrec_aug=nrec_aug+nrec_out
         hdkey='MCLE'//int2str(nstream,'0')
         write(lerr,'(a25,a6,2i5,a20)') description,hdkey, 
     1             attribute_number,lufile,' Added to Data Stream'
         call savew(sheader,hdkey,attribute_number,LINEHEADER)
      else
c_______________________________________________________________
c        Keyword detected on command line with an explicit filename.
c        Calculate the attribute.
c        Open the file for the output data.
c        Update the lineheader and write it out.
c_______________________________________________________________
         wrfile=.true.
         calcfile=.true.
c           Open the file
         call lbopen(lufile,filename,'w')
         nfile=nfile+1
         write(lerr,'(a25,i5,a120)') description,lufile,filename
         call savew(sheader,'MCLE01',attribute_number,LINEHEADER)
         call savew(sheader,'NumRec',nrec_out,LINEHEADER)
         call savew(sheader,'NumSmp',nsamp_out,LINEHEADER)
      endif
c
      return
      end
