C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine initproc(pipelen, available, keyword, description)

      implicit logical (a-z)

      integer pipelen
      logical available(pipelen)
      character*(*) keyword(pipelen)
      character*(*) description(pipelen)

      integer counter

c Grab the declarations for the process identifiers
#include "initproc.h"

c_______________________________________________________________
c     The number of settings in this file should be <= to the
c     value of pipelen!
c_______________________________________________________________
c     Initialize all process information
c     set the index
c        set the number of samples (1 for reductions, nsamp_in otherwise)
c        has the code been written?
c        set the keyword
c        set the text description
c_______________________________________________________________

c Note: the first four (Semblance, dip, azimuth and solid angle)
c are provided for compatibility with the f77/3d_attr_defs.h file.
c Make sure that the first 18 match this file exactly!
      counter = 1
      pmsemblance =  counter
         available(pmsemblance) = .FALSE.
         keyword(pmsemblance) = '-SEM'
         description(pmsemblance) = 'SEMBLANCE'

      counter = counter + 1
      pmdip    =  counter
         available(pmdip) = .FALSE.
         keyword(pmdip) = '-DIP'
         description(pmdip) = 'DIP'

      counter = counter + 1
      pmazimuth    =  counter
         available(pmazimuth) = .FALSE.
         keyword(pmazimuth) = '-AZI'
         description(pmazimuth) = 'AZIMUTH'

      counter = counter + 1
      pmsolidangle    =  counter
         available(pmsolidangle) = .FALSE.
         keyword(pmsolidangle) = '-SAL'
         description(pmsolidangle) = 'SOLID ANGLE'

      counter = counter + 1
      pmienv    =  counter
         available(pmienv) = .TRUE.
         keyword(pmienv) = '-IE '
         description(pmienv) = 'INSTANTANEOUS ENVELOPE'

      counter = counter + 1
      pmiphase  =  counter
         available(pmiphase) = .TRUE.
         keyword(pmiphase) = '-IP '
         description(pmiphase) = 'INSTANTANEOUS PHASE'

      counter = counter + 1
      pmifreq   =  counter
         available(pmifreq) = .TRUE.
         keyword(pmifreq) = '-IF '
         description(pmifreq) = 'INSTANTANEOUS FREQUENCY'

      counter = counter + 1
      pmibw     =  counter
         available(pmibw) = .TRUE.
         keyword(pmibw) = '-IBW'
         description(pmibw) = 'INSTANTANEOUS BANDWIDTH'

      counter = counter + 1
      pmrenv    =  counter
         available(pmrenv) = .TRUE.
         keyword(pmrenv) = '-RE '
         description(pmrenv) = 'RESPONSE ENVELOPE'

      counter = counter + 1
      pmrphase  =  counter
         available(pmrphase) = .TRUE.
         keyword(pmrphase) = '-RP '
         description(pmrphase) = 'RESPONSE PHASE'

      counter = counter + 1
      pmrfreq   =  counter
         available(pmrfreq) = .TRUE.
         keyword(pmrfreq) = '-RF '
         description(pmrfreq) = 'RESPONSE FREQUENCY'

      counter = counter + 1
      pmrbw     =  counter
         available(pmrbw) = .TRUE.
         keyword(pmrbw) = '-RBW'
         description(pmrbw) = 'RESPONSE BANDWIDTH'

      counter = counter + 1
      pmrlength =  counter
         available(pmrlength) = .TRUE.
         keyword(pmrlength) = '-RL '
         description(pmrlength) = 'RESPONSE LENGTH'

      counter = counter + 1
      pmcar     = counter
         available(pmcar) = .TRUE.
         keyword(pmcar) = '-C  '
         description(pmcar) = 'CARRIER'

      counter = counter + 1
      pmrt      = counter
         available(pmrt) = .TRUE.
         keyword(pmrt) = '-RT '
         description(pmrt) = 'RISE TIME'

      counter = counter + 1
      pmskew    = counter
         available(pmskew) = .TRUE.
         keyword(pmskew) = '-S  '
         description(pmskew) = 'SKEWNESS'

      counter = counter + 1
      pmp0      = counter
         available(pmp0) = .TRUE.
         keyword(pmp0) = '-P0 '
         description(pmp0) = 'PHASE 0'

      counter = counter + 1
      pmp90     = counter
         available(pmp90) = .TRUE.
         keyword(pmp90) = '-P90'
         description(pmp90) = 'PHASE 90'

      counter = counter + 1
      pmtpt     = counter
         available(pmtpt) = .FALSE.
         keyword(pmtpt) = '-TPT'
         description(pmtpt) = 'TIME_PT'

      counter = counter + 1
      pmapt     = counter
         available(pmapt) = .FALSE.
         keyword(pmapt) = '-APT'
         description(pmapt) = 'AMP_PT'

c     Double check the programmer!
      if (pipelen .lt. counter) then
         print*,'Error!  Not enough memory allocated for pipe info!'
         call exitfu(1234)
      endif

      end
