C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgather(tracebuf,uin,uquad,jextremum,
     1                    live,luin,nangs,
     2                    l_StaCor,ifmt_StaCor,ln_StaCor,
     3                    eof,lenhed,nt,nfft,lerr,
     4                    rtabf,itabf,rtabi,
     5                    itabi,work,
     6                    lenrtab,lenitab,lenwork,initfftf,
     7                    cputim,waltim)
c
      real      tracebuf(-lenhed:nt)
      real      uin(0:nfft-1,nangs)  
      complex   uquad(0:nfft/2-1,nangs)  
      complex   ci
      integer   jextremum(0:nt)
      logical   eof,forward 
      parameter (ci=(0.,1.))
      real      cputim(*),waltim(*)
      logical   live
      integer   l_StaCor,ifmt_StaCor,ln_StaCor
      integer   istatic

c_______________________________________________________________
c     fourier transform table and work arrays.
c_______________________________________________________________
      real       rtabf(lenrtab)
      integer    itabf(lenitab)
      real       rtabi(lenrtab)
      integer    itabi(lenitab)
      real       work(lenwork)
c_______________________________________________________________________
c     read in the all angle gathers.
c_______________________________________________________________________
      call timstr(v1,w1)
      eof=.false.
      do 40000 jang=1,nangs       
       nbytes_in=0
       call rtape(luin,tracebuf(-lenhed),nbytes_in)
       if(nbytes_in .le. 0) then
          eof=.true.
          return
       endif

       call saver2(tracebuf(-lenhed),ifmt_StaCor,l_StaCor,ln_StaCor,
     1             istatic,TRACEHEADER)
       if(istatic .eq. 30000) then
          live=.false.
          call vclr(uin(0,jang),1,nfft)
          call vclr(uquad(0,jang),1,nfft)
       else
          live=.true.    
          call vmov(tracebuf(0),1,uin(0,jang),1,nt+1)           
          call vclr(uin(nt+1,jang),1,nfft-1-nt)
          call vmov(uin(0,jang),1,uquad(0,jang),1,nfft)         
       endif
40000 continue
c_______________________________________________________________________
c     read in values that indicate the angle having maximum coherency.
c_______________________________________________________________________
      nbytes_in=0
      call rtape(luin,tracebuf(-lenhed),nbytes_in)
      if(nbytes_in .le. 0) then
          write(ler,*) 'asig lower read 0 bytes'
         eof=.true.
         return
      endif
      do 45000 jt=0,nt
       jextremum(jt)=nint(tracebuf(jt))
45000 continue
      call timend(cputim(1),v1,v2,waltim(1),w1,w2)
c_______________________________________________________________________
c     reset live trace flag.
c_______________________________________________________________________
      if(live) then
         istatic = 0
         call savew2(tracebuf(-lenhed),ifmt_StaCor,l_StaCor,ln_StaCor,
     1               istatic,TRACEHEADER)
      endif
c___________________________________________________________________
c     take fourier transform from t-x into omega-x space.
c___________________________________________________________________
      call timstr(v1,w1)
      forward=.true.
      call rmmfft(uquad(0,1),work,itabf,rtabf,forward,
     1            nfft,lenwork,lenitab,lenrtab,
     2            nfft,nangs,initfftf,lerr)
      initfftf=0
c___________________________________________________________________
c     multiply by sqrt(-1.)
c___________________________________________________________________
      do 60000 jang=1,nangs
       do 50000 kfreq=0,nfft/2-1
        uquad(kfreq,jang)=ci*uquad(kfreq,jang)
50000  continue   
60000 continue
c___________________________________________________________________
c     take fourier transform from omega-x space into t-x space.
c     this will be the quadrature trace.
c___________________________________________________________________
      forward=.false.
      call rmmfft(uquad(0,1),work,itabf,rtabf,forward,
     1            nfft,lenwork,lenitab,lenrtab,
     2            nfft,nangs,initfftf,lerr)
      call timend(cputim(2),v1,v2,waltim(2),w1,w2)
c
      return
      end 
