C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c*****************************************************************
c                                                                 
c     SUBROUTINE - solver     
c                                                               
c     LANGUAGE - FORTRAN 77                                    
c     SYSTEM(S) - SUN
c     AUTHOR - Richard Crider                                
c     DATE WRITTEN - 
c                                                          
c                     BP AMOCO PROPRIETARY
c                 TO BE MAINTAINED IN CONFIDENCE
c                                                        
c     ABSTRACT - Set up storage space for matrix equation solutions
c                and call the appropriate solution manager for the 
c                option requested.
c     USAGE                                                 
c                                                          
c       call solver(nsamp,ntrc, data, vsvpsqr, stacka, 
c              stackb, stackc, angles, astrt,aend,np,rc,iopt,c,sa,ierr)
c                                                       
c             nsamp   =  Number of samples per trace (rows)
c             ntrc    =  Number of traces per record (columns)
c             data    =  Matrix of trace data
c             vsvpsqr =  square of ratio of average Vs to average Vp
c             stacka  =  Returned coefficient corresponding to Drho/rho
c             stackb  =  Returned coefficient corresponding to Dmu/mu
c             stackc  =  Returned coefficient corresponding to DVp/Vp
c             angles  =  Matrix of incident angles from ray tracing
c             astrt   =  Start angle for sum for angle-limited stack
c             aend    =  End angle for sum for angle-limited stack
c              np     =  Minimum number samples in the solution
c              rc     =  Correlation coeff.
c             iopt    =  computation option
c               c     =  Gardner coefficient
c              sa     =  flag true = average incident angles
c                             false = do not average
c             IERR    =  Error flag 
c                                                      
c     ERROR/RETURN CODES - ierr                 
c                          .ne. 0 = memory allocation error
c                                              
c***************************************************************
      subroutine solver(nsamp,ntrc, data, vsvpsqr,stacka, 
     : stackb,stackc, angles, astrt,aend, np, rc, iopt,C,sa,ierr)

#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c                                                            
      real data(*), K,C,vsvpsqr(*)
      real stacka(nsamp), stackb(nsamp),stackc(nsamp)
      real angles(*),astrt,aend, rc(*)
      real work3(1),vect3(1),work1(1),work5(1)
      real aw3(1),gw3(1),gw5(1),aw5(1)
      pointer (pw3,work3),(pv3,vect3)
      pointer (pw5,work5),(pw1,work1),(paw5,aw5)
      pointer (paw3,aw3),(pgw3,gw3), (pgw5,gw5)
      integer ierr,np,iopt
      logical sa
c +==========================================+
c | Need work matrices ntrc x 3 and ntrc x 2 |
c +==========================================+
      call sizefloat(isz)
      iget = 2*ntrc*3*isz
      ier = 0
      ierr=0
      istop = 0
      call galloc(pw3, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(pw1, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(pw5, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(paw3, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(paw5, iget,ier,istop)
      if(ier.ne.0)ierr=1

      iget=2*ntrc*ISZBYT
      call galloc(pv3, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(pgw3, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(pgw5, iget,ier,istop)
      if(ier.ne.0)ierr=1

      if(ierr.ne.0)return

      if(iopt.eq.1)then
       ncol = 2
       do i=1,nsamp
        call matrixB_2(data,angles,nsamp,ntrc,
     :  work3,vect3,work1,aw3,gw3,aw5,gw5,i,astrt,aend,ncol,np,
     :  C,sa)
        stacka(i)=gw5(1)
        stackb(i)=gw5(2)
        stackc(i)=0.
       end do
      elseif(iopt.eq.2)then
       ncol = 2
       do i=1,nsamp
        K = vsvpsqr(i)*4.
        call matrixV_2(data,angles,nsamp,ntrc,
     :  work3,vect3,work1,aw3,gw3,aw5,gw5,i,astrt,aend,ncol,np,K,c,sa)
        stacka(i)=gw5(1)
        stackb(i)=gw5(2)
        stackc(i)=0.
       end do
      elseif(iopt.eq.3)then
       ncol = 3
       do i=1,nsamp
        K = vsvpsqr(i)*4.
        call matrixV_3(data,angles,nsamp,ntrc,
     :  work3,vect3,work1,aw3,gw3,aw5,gw5,i,astrt,aend,ncol,np,K,sa)
        stacka(i)=gw5(1)
        stackb(i)=gw5(2)
        stackc(i)=gw5(3)
       end do
      elseif(iopt.eq.4)then
       ncol = 3
       do i=1,nsamp
        call matrixB_3(data,angles,nsamp,ntrc,
     :  work3,vect3,work1,aw3,gw3,aw5,gw5,i,astrt,aend,ncol,np,sa,cor)
        stacka(i)=gw5(1)
        stackb(i)=gw5(2)
        stackc(i)=gw5(3)
        rc(i)=cor
       end do
      elseif(iopt.eq.5)then
       ncol = 2
       do i=1,nsamp
        call matrixPS_2(data,angles,nsamp,ntrc,
     *  work3,vect3,work1,aw3,gw3,aw5,gw5,i,astrt,aend,ncol,np,K,c,sa)
        stacka(i)=gw5(1)
        stackb(i)=gw5(2)
        stackc(i)=0.
       end do
      elseif(iopt.eq.6)then
       ncol = 3
       do i=1,nsamp
        call matrixA(data,angles,nsamp,ntrc,
     :  work3,vect3,work1,aw3,gw3,aw5,gw5,i,astrt,aend,ncol,np,K,sa,cor)
        stacka(i)=gw5(1)
        stackb(i)=gw5(2)
        stackc(i)=gw5(3)
       end do
      else
       do i=1,nsamp
        stacka(i)=0.
        stackb(i)=0.
        stackc(i)=0.
       end do
      endif
      call gfree(pw3)
      call gfree(pw1)
      call gfree(pw5)
      call gfree(paw3)
      call gfree(paw5)
      call gfree(pv3)
      call gfree(pgw3)
      call gfree(pgw5)
      return
      end
