C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------

c     Program Changes:

c      - original written: March/95

c     Program Description:

c***********************************************************************
c    attrib --- A USP program to calculate attributes from angst data
c
c    Execute "attrib -h" for self documentation.
c    Execute "attrib -ha" for list of available recon attributes
c
c    attrib reads in a USP dataset created by program "angst", and
c    outputs a USP dataset containing traces derived from user selected
c    attributed calculations.
c
c
c    This code was written by W.D. Woodruff based on the USP
c    code template for 2d processing, February 1995
c
c    NOTE:
c    afp, the "Amoco Fortran Preprocessor", is required to compile
c    this module.
c
c
c***********************************************************************

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs, ire, argis

      real        dtsec
      real        tri ( SZLNHD )

      character   ntap*255, otap*255, name*6

      logical     verbos, query

c Program Specific 

      integer ifmt_RecNum,l_RecNum,ln_RecNum, RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum, TrcNum
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn, DstSgn
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer     angbeg, angend, anginc
      integer     attrnum, numangles, err1

      real    rtrpt1(SZLNHD), rtrpt2(SZLNHD), rtrpt3(SZLNHD)
      real  xdot

c Initialize variables

      data name/"ATTRIB"/

c give command line help if requested

      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0 )
      if ( query )then
         call help()
         stop
      endif

      if ( argis ( '-ha' ) .gt. 0 )then
            call helpatt()
            stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call gcmdln( angbeg, angend, anginc, ntap, otap, irs, ire, 
     :     numangles, attrnum, verbos )
 
c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'attrib: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c update historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)

c handle millisecond sample interval if present

      if ( nsi .gt. 32 ) then
         dtmsec = .001 * float(nsi)
         dtsec = real(nsi)/1000000.
      else
         dtmsec = float(nsi)
         dtsec = real(nsi)/1000.
      endif

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ntrc .ne. numangles ) then
         write(LERR,*)'attrib: your input dataset has ',ntrc
         write(LERR,*)'        traces and you have asked for'
         write(LERR,*)'        ',numangles,' to be processed'
         write(LERR,*)'FATAL'
         goto 999
      endif

      nreco = ire - irs + 1

c modify line header to reflect actual record configuration output
c NOTE: in this case the sample limits ist and iend are used to 
c       limit processing only.   All data samples are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', 1, LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( nsamp, nsi, ntrc, nrec, iform, angbeg, angend, 
     :     anginc, attrnum, ntap, otap, irs, ire )

c BEGIN PROCESSING 

c initialize memory
         
      call vclr ( rtrpt1, 1, nsamp )
      call vclr ( rtrpt2, 1, nsamp )
      call vclr ( rtrpt3, 1, nsamp )


c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
         DO KK = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c get required trace header information

            call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )

            call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER )

            call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

c process only live traces

            if ( StaCor .ne. 30000) then

c Put your subroutine here [remember to declare any arguments you need
c over and above those already declared]
c load trace portion of itr[] to real array tri[]

 
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )
c  move data from tri to wkarr1, wkarr2, or wkarr3
c     for attribute computation; save trace1 header for output
               if(KK .eq. 1) then
                  call vmov (tri, 1, rtrpt1, 1,  nsamp)
               elseif(KK .eq. 2) then
                  call vmov (tri, 1, rtrpt2, 1,  nsamp)
               elseif(KK .eq. 3) then
                  call vmov (tri, 1, rtrpt3, 1,  nsamp)
               endif
               
c
c     Check for invalid number of angle stacks from ANGST:
c	2p = 1 or 2 angle stacks from ANGST
c	3p = 3 angle stacks from ANGST
c

               call vclr ( tri, 1, nsamp )
	       err1 = 0

               if ( kk .eq. ntrc ) then
                  if((numangles .eq. 1) .or. (numangles .eq. 2)) then
                     call att2p (angbeg, angend, anginc, numangles, 
     :             attrnum,dtsec,nsamp,rtrpt1,rtrpt2,rtrpt3,tri,err1)
		     if (err1 .gt. 0) then
			write(LER ,*) ' FATAL'
			goto 999
		     endif
                  else if((numangles .eq. 3)) then
                     call att3p (angbeg, angend, anginc, numangles, 
     :             attrnum,dtsec,nsamp,rtrpt1,rtrpt2,rtrpt3,tri,err1)
		     if (err1 .gt. 0) then
			write(LER ,*) ' FATAL'
			goto 999
		     endif
                  else 
                     write(LERR,*)' '
            write(LERR,*) 'attrib:  Invalid number of angle buckets ('
                     write(LERR,*) numangles,') specified.'
                     write(LERR,*)' '
                     write(LER ,*) ' FATAL'
		     goto 999
                  endif
               
                  call vmov ( tri, 1, itr(ITHWP1), 1, nsamp )
                  call dotpr  (tri, 1, tri, 1, xdot, nsamp)
                  if (xdot .lt. 1.e-30) then
                     call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,
     1                    30000  , TRACEHEADER)
                  endif
               endif

            endif
 
         ENDDO

c write output data
            
            call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           1, TRACEHEADER )
            call wrtape (luout, itr, obytes)
 
c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'attrib: Normal Termination'
      write(LER,*)'attrib: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'attrib: ABNORMAL Termination'
      write(LER,*)'attrib: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine gcmdln(angbeg,angend,anginc,ntap,otap,
     1                  irs,ire,numangles,attrnum,verbos)

#include <f77/iounit.h>

      integer     angbeg, angend, anginc
      integer     numangles, attrnum, irs, ire
      integer     argis
      character   ntap*(*), otap*(*)
      logical     verbos
            call argi4 ( '-as', angbeg ,   0  ,  0    )
	    if(angbeg.le.0)angbeg = 0
            call argi4 ( '-ae', angend ,   0  ,  0    )
	    if(angend.le.0)angend = 0
            call argi4 ( '-ai', anginc ,   0  ,  0    )
	    if(anginc.le.0)anginc = 0
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-na', numangles ,   0  ,  0    )
	    if(numangles.le.0)numangles = 0
            call argi4 ( '-att', attrnum ,   0  ,  0    )
            verbos =   (argis('-V') .gt. 0)
            return
            end
c
c
c **** Subroutine verbal  ****
c prints out program input and output data
c
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1          angbeg,angend,anginc,attrnum,ntap,otap,irs,ire)
#include <f77/iounit.h>
      integer     nsamp, nsi, ntrc, nrec, irs, ire
      integer     angbeg, angend, anginc
      integer     attrnum
      character   ntap*(*), otap*(*)
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*)' '
            write(LERR,*)' input parameters '
            write(LERR,*) ' start angle =  ', angbeg
            write(LERR,*) ' end angle =  ', angend
            write(LERR,*) ' angle increment =  ', anginc
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name =  ', otap
            write(LERR,*) ' start record number =  ', irs
            write(LERR,*) ' last record number =  ', ire
            write(LERR,*) ' attribute number =  ', attrnum
            write(LERR,*)' '
            write(LERR,*)' '
      return
      end
      subroutine help()
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
      write(LER,*) ' '
      write(LER,*)
     :'attrib: Attribute calculator for angst data.'
      write(LER,*) ' '
      write(LER,*)
     :'Execute attrib by typing "attrib" and the program parameters.'
      write(LER,*)
     :'Note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
      write(LER,*)
     :'Enter the following parameters, or use the default values'
      write(LER,*)' '
        write(LER,*)
     :' -as [angbeg] (no default)         : Start Angle'
        write(LER,*)
     :' -ae [angend] (no default)         : End Angle'
        write(LER,*)
     :' -ai [anginc] (no default)         : Angle Increment'
        write(LER,*) ' '
        write(LER,*)
     :' -N [ntap]    (no default; stdin if not specified)'
        write(LER,*)
     :'                                   : input data file name'
        write(LER,*) ' '
        write(LER,*)
     :' -O [otap]    (no default; stdout if not specified)'
        write(LER,*)
     :'                                   : output data file name'
        write(LER,*) ' '
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)     : end record number'
        write(LER,*) ' '
        write(LER,*)
     :' -na[numangles] (1, 2 or 3)        : angle buckets from angst'
        write(LER,*)
     :' -att[attrnum]  (no default)       : attribute number'
        write(LER,*) ' '
        write(LER,*)
     :' -V                                : verbose printout'
        write(LER,*)
     :'usage:    attrib  -as[angbeg] -ae[angend] -ai[anginc] -N[ntap]'
        write(LER,*)
     :'    -O[otap] -rs[irs] -re[ire] -na[numangles] -att[attrnum] [-V]'
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*)
     :'Self doc:  attrib  -h'
        write(LER,*)
     :'Available list of attributes: attrib  -ha'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
c
c
c **** Subroutine help  ****
c prints out usage instructions
c
      subroutine helpatt()
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
      write(LER,*) ' '
      write(LER,*)
     :'attrib: Attribute calculator for angst data.'
      write(LER,*) ' '
      write(LER,*)
     :'The following recon attributes are currently available:'
      write(LER,*)' '
        write(LER,*)
     :'1) B0 Note: Needs a two or three angle bucket input from angst.'

        write(LER,*)
     :'2) B1 Note: Needs a two or three angle bucket input from angst.'
        write(LER,*)
     :'         with angles out to a minimum of 15 degrees.'

        write(LER,*)
     :'3) B2 Note: Needs a two or three angle bucket input from angst'
        write(LER,*)
     :'         with angles out to a minimum of 37 degrees.'

        write(LER,*)
     :'4) Bz=SIGN(B0)*B1 Note: Needs a two or three angle bucket input'
        write(LER,*)
     :'         from angst with angles out to a minimum of 15 degrees.'

        write(LER,*)
     :'5) Bp=B0*B1 Note: Needs a two or three angle bucket input'
        write(LER,*)
     :'         from angst with angles out to a minimum of 15 degrees.'

        write(LER,*)
     :'6) Br=B1/B0 Note: Needs a two or three angle bucket input'
        write(LER,*)
     :'         from angst with angles out to a minimum of 15 degrees.'

        write(LER,*)
     :'7) Middle angle stack - Near angle stack   Note: A two or'
        write(LER,*)
     :'         three angle bucket input from angst needed.'

        write(LER,*)
     :'8) Large angle stack - Near angle stack'
        write(LER,*)
     :'         Note: A three angle bucket input needed from angst.'

        write(LER,*)
     :'9) Large angle stack - Middle angle stack'
        write(LER,*)
     :'         Note: A three angle bucket input needed from angst.'

        write(LER,*)
     :'10) Zero crossing angle in degrees.   Note: A two or'
        write(LER,*)
     :'         three angle bucket input from angst needed.'

        write(LER,*)
     :'11) Restricted Gradient'
        write(LER,*)
     :'       Two angle buckets: EE(middle angle)-EE(small angle)'
        write(LER,*)
     :'       Three angle buckets: EE(large angle)-EE(small angle)'
        write(LER,*)
     :'         '

        write(LER,*)
     :'12) dVp/Vp   Note: Needs a two or three angle bucket input'
        write(LER,*)
     :'       from angst with angles out to a minimum of 37 degrees.'

        write(LER,*)
     :'13) dVs/Vs   Note: Needs a two or three angle bucket input'
        write(LER,*)
     :'       from angst with angles out to a minimum of 37 degrees.'

        write(LER,*)
     :'14) dRho/Rho  Note: Needs a two or three angle bucket input'
        write(LER,*)
     :'       from angst with angles out to a minimum of 37 degrees.'

        write(LER,*)
     :'15) dZp/Zp  Note: Needs a two angle bucket input'
        write(LER,*)
     :'       from angst with angles out to a maximum of 30 degrees.'

        write(LER,*)
     :'16) dZs/Zs  Note: Needs a two angle bucket input'
        write(LER,*)
     :'       from angst with angles out to a maximum of 30 degrees.'

        write(LER,*)
     :'17) d(Vp/Vs)/(Vp/Vs)  Note: Needs a two angle bucket input'
        write(LER,*)
     :'       from angst with angles out to a maximum of 30 degrees.'

        write(LER,*)
     :'18) dF    Shear Residual'
        write(LER,*)
     :'       '

        write(LER,*)
     :'19) 1/B2  Contact Event  Note: Needs a three angle bucket input'
        write(LER,*)
     :'       from angst with angles out to a minimum of 37 degrees.'

        write(LER,*)
     :'20) Energy Envelope(small angle)  Note: Needs at least one '
        write(LER,*)
     :'       angle bucket input from angst.'

        write(LER,*)
     :'21) Energy Envelope(mid angle)  Note: Needs at least two '
        write(LER,*)
     :'       angle buckets input from angst.'

        write(LER,*)
     :'22) Energy Envelope(large angle)  Note: Needs a three '
        write(LER,*)
     :'       angle bucket input from angst.'

        write(LER,*)
     :'23) Energy Envelope(mid angle) - Energy Envelope(small angle)'
        write(LER,*)
     :'       Note:  Needs a two angle bucket input from angst.'

        write(LER,*)
     :'24) Energy Envelope(large angle) - Energy Envelope(small angle)'
        write(LER,*)
     :'       Note:  Needs a three angle bucket input from angst.'

        write(LER,*)
     :'25) Enhanced Restricted Gradient.'
        write(LER,*)
     :'       (EE(large angle) - EE(small angle)) * EE(large angle)'
        write(LER,*)
     :'       Note:  Needs a three angle bucket input from angst.'

        write(LER,*)
     :'***************************************************************'
      return
      end
