C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w) = B0 + B1*sin^2(w)                                        *
c *    where                                                         *
c *     w  = incident angle                                          *
c *    Written by Richard Crider and Ganyuan Xia 4/99                * 
c ******************************************************************** c
      subroutine matrixB_2(data,angles,nsamp,ntrc,
     *work3,vect3,work1,aw3,gw3,aw5,gw5,idx,astrt,aend,ncol,np,
     :c,sa,stdev)
c                                                            
      real data(*)
      real angles(*)
      real work3(*),vect3(*),aw3(*),gw3(*),gw5(*),aw5(*)
      real work1(*),ztol
      integer iperm(3)
      logical sa

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      nrow=n
      n=0
      sumy=0.
      sumy2=0.
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
        m=n
        sine=sin(theta)
        sine=sine*sine
        tang=tan(theta)*tan(theta)
        work3(m)=1.
        if(c.ne.0.0)then
         work3(m)=(1.+(1./(1.+c))*tang*sine)
        endif
        m=m+nrow
        work3(m)=sine
        vect3(n)=y
        sumy = sumy+y
        sumy2 = sumy2+y*y
       endif
      end do
      if(n.ge.np)then
       stdev=sqrt((1./(n-1))*(sumy2 - (sumy*sumy)/n))
c +=================================================+
c | Form the normal equations and get the solution. |
c +=================================================+
c |   Get transpose of prediction matrix            |
c +=================================================+
       call rmtran(work3,nrow,work1,ncol,nrow,ncol)
c +=================================================+
c |   Multiply prediction matrix by transpose       |
c +=================================================+
       call rmmul(work1,work3,aw3,ncol,ncol,nrow)
c +=================================================+
c |   Multiply observation vector by transpose      |
c |   of prediction matrix.                         |
c +=================================================+
       call rmmul(work1,vect3,gw3,ncol,1,nrow)
c +===================================================+
c |   Get inverse of the product of prediction matrix |
c |   and its transpose.                              |
c +===================================================+
       ztol=1.0e-10
       call rmfuin(aw3,ncol,ncol,ztol,iperm,aw5,ncol,ierr)
c +=====================+
c | solve the equations |
c +=====================+
       call rmmul(aw5,gw3,gw5,ncol,1,ncol)
      else
       gw5(1)=0.
       gw5(2)=0.
       gw5(3)=0.
      endif
      return
      end
