C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine brms(t,v,nv,lx,dt,x)
C ******************************************************************** C
C *                                                                  * C
C *  Subroutine to create a trace-length expansion of a velocity     * C
C * function.  Inputs are:                                           * C
C *                                                                  * C
C *  TIME - R*4() - Vector of function times, in sec.                * C
C *  VEL  - R*4() - Vector of function velocities                    * C
C *  NVEL - I*4   - Number points in this velocity function          * C
C *  NS   - I*4   - Number of samples in the trace                   * C
C *  SR   - R*4   - Sample interval in sec.                          * C
C *                                                                  * C
C *  Output is                                                       * C
C *  V    - R*4() - Output velocity trace                            * C
C *                                                                  * C
C ******************************************************************** C
      REAL t(*),v(*),x(*),dt
      integer lx,nv,it(3000),next,prev
 
      do i=1,lx
       x(i)=0.
      end do
      do i=1,nv
       it(i)=t(i)/dt+1.
       if(it(i).gt.lx)it(i)=lx
      end do
      if(it(1).ge.1)then
       do i=1,it(1)
        x(i)=v(1)
       end do
      end if
      do i=2,nv
       next = it(i)
       prev = it(i-1)
       dv = v(i)-v(i-1)
       dvdt = dv/float(next-prev)
       do j=prev+1,next
        x(j)=x(j-1)+dvdt
       end do
      end do
      if(it(nv).lt.lx)then
       do i=it(nv)+1,lx
        x(i)=v(nv)
       end do
      end if
      return
      end
